/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;

public final class Data {
    public static final byte PERFRAME = 24;
    public static final byte TILESIZE = 48;
    public static final byte AS_NON = 0;
    public static final byte AS_APPEAR = 1;
    public static final byte POS_X = 0;
    public static final byte POS_Y = 1;
    public static final byte BIU_WANDOU = 0;
    public static final byte BIU_DIAN = 1;
    public static final byte BIU_YUMI = 2;
    public static final byte BIU_HUODOU = 3;
    public static final byte BIU_JIGUANG = 4;
    public static final byte BIU_YEZI = 5;
    public static final byte BIU_ICE = 6;
    public static final byte BIU_YELLOWSTAR = 7;
    public static final byte BIU_BLUESTAR = 8;
    public static final byte BIU_HUOZHU = 9;
    public static final byte BIU_LVQIU = 10;
    public static final byte BIU_FIRENOVA1 = 11;
    public static final byte BIU_FIRENOVA2 = 12;
    public static final byte BIU_FIRENOVA3 = 13;
    public static final byte BIU_ICENOVA1 = 14;
    public static final byte BIU_ICENOVA2 = 15;
    public static final byte BIU_ICENOVA3 = 16;
    public static final byte AT_SELF_ONLY = 0;
    public static final byte AT_SELF = 1;
    public static final byte AT_LINE = 2;
    public static final byte AT_LINE_THROW = 3;
    public static final byte AT_LINE_RANGE = 4;
    public static final byte AT_LINE_MORE = 5;
    public static final byte AT_LINK = 6;
    public static final byte AT_LINE_DEGREES = 7;
    public static final byte AT_LINE_THROUGH_DEGREES = 8;
    public static final byte AT_LINE_THROW_BOMB = 9;
    public static final byte AT_LINK_RANGE = 10;
    public static final byte EFF_DIAN = 0;
    public static final byte EFF_HIT = 1;
    public static final byte EFF_ICENOVA = 2;
    public static final byte EFF_FIRENOVA = 3;
    public static final byte EFF_ICE = 4;
    public static final byte EFF_JIGUANGHIT = 5;
    public static final byte EFF_JIGUANGSTART = 24;
    public static final byte EFF_JIGUANGSTART_H = 25;
    public static final byte EFF_HUOZHU = 9;
    public static final byte EFF_YELLOWSTAR = 10;
    public static final byte EFF_BLUESTAR = 11;
    public static final byte EFF_LVQIU = 12;
    public static final byte EFF_YUMI = 14;
    public static final byte EFF_FIRENOVAHIT = 15;
    public static final byte EFF_ICENOVAHIT = 16;
    public static final byte EFF_YEZI = 20;
    public static final byte BUFF_MAX = 8;
    public static final byte BUFFDATA_TYPE = 3;
    public static final byte BUFFDATA_VALUE = 0;
    public static final byte BUFFDATA_TIME = 1;
    public static final byte BUFFDATA_INTERVAL = 2;
    public static final byte BUFF_SLOW = 1;
    public static final byte BUFF_POISON = 2;
    public static final byte BUFF_HOLD = 3;
    public static final byte BUFF_FIRE = 4;
    public static final byte EVENT_TEACHRANK = 0;
    public static final byte EVENT_SPEAR = 1;
    public static final byte EVENT_MAGIC = 2;
    public static final byte EVENT_BOW = 3;
    public static final byte EVENT_BOOK = 5;
    public static final byte EVENT_WORD = 6;
    public static final byte EVENT_BUYEQUIP = 8;
    public static final byte EVENT_EQUIP = 9;
    public static final byte EVENT_BUYHERO = 10;
    public static final byte EVENT_TEAM = 11;
    public static final byte EVENT_TRAIN = 12;
    public static final byte EVENT_ENDLESS = 13;
    public static final byte EVENT_TRIALS = 14;
    public static final byte EVENT_FIRSTRANK = 15;
    public static final byte EVENT_ADDMONEY = 16;
    public static final byte EVENT_ADDHP = 17;
    public static final byte EVENT_RANK02 = 18;
    public static final byte EVENT_RANK03 = 19;
    public static final byte EVENT_RANK17 = 20;
    public static final byte EVENT_RANK07 = 21;
    public static final byte EVENT_HEROTEAM = 22;
    public static final byte EVENT_CHOOSEDIF = 23;
    static final short L_BG = 0;
    static final short L_ROLE = 1000;
    static final short L_BULLET = 1500;
    static final short L_EFECT = 2000;
    static final short L_FG = 3000;
    static final short L_MASK = 4000;
    static final short L_INTERFACE = 5000;
    static final short L_TALK = 6000;
    static final short L_INFO = 7000;
    static final short L_MAX = 8000;
    static short[][][] effectGroupScript;
    static byte[][][] spriteClipData;
    static byte[][][] spriteFrameData;
    static byte[][][][] spriteMotionData;
    static byte[][][] effectClipData;
    static byte[][][] effectFrameData;
    static byte[][][][] effectMotionData;
    static int[][] enenmyTDData;
    static short[][] unlockTower;
    static short[] rankTime;
    static final byte DK_DROPLEVEL = 0;
    static final byte DK_DROPODDS = 1;
    public static final byte B_SEASON_TO_MENU = 0;
    public static final byte B_MENU_TO_SEASON = 1;
    public static final byte B_SEASON_TO_HELP = 2;
    public static final byte B_SEASON_TO_LEFT = 3;
    public static final byte B_SEASON_TO_RIGHT = 4;
    public static final byte B_SEASON_TO_RANKCHOOSE = 5;
    public static final byte B_RANKCHOOSE_TO_RANK = 6;
    public static final byte B_MENU_MORE = 7;
    public static final byte B_MENU_MUSIC = 8;
    public static final byte B_MENU_SOUND = 9;
    public static final byte B_RANKCHOOSE_TO_LEFT = 10;
    public static final byte B_RANKCHOOSE_TO_RIGHT = 11;
    public static final byte B_RANKCHOOSE_TO_SEASON = 12;
    public static final byte B_RANKCHOOSE_TO_HELP = 13;
    public static final byte B_RANKCHOOSE_TO_START = 14;
    public static final byte B_MENU_CHOOSEBOSS = 15;
    public static final byte B_CHOOSEBOSS_LEFT = 16;
    public static final byte B_CHOOSEBOSS_RIGHT = 17;
    public static final byte B_CHOOSEBOSS_HELP = 18;
    public static final byte B_CHOOSEBOSS_RANK = 19;
    public static final byte B_CHOOSEBOSS_MENU = 20;
    public static final byte B_MENU_HELP = 21;
    public static final byte B_MENU_ABOUT = 22;
    public static final byte B_HELP_MENU = 23;
    public static final byte B_HELP_LEFT = 24;
    public static final byte B_HELP_RIGHT = 25;
    public static final byte B_RANK_MIDMENU = 28;
    public static final byte B_RANK_SPEED = 29;
    public static final byte B_RANK_STOP = 30;
    public static final byte B_RANK_SHOP = 31;
    public static final byte B_ABOUT_MENU = 32;
    public static final byte B_MENU_STEP = 33;
    public static final byte B_SOUND_OPEN = 34;
    public static final byte B_SOUND_CLOSE = 35;
    public static final byte B_MENU_EXIT = 36;
    public static final byte B_RANK_SHOP2 = 37;
    public static final byte B_SEASON_TO_RANKCHOOSE2 = 38;
    public static final byte B_SEASON_TO_RANKCHOOSE3 = 39;
    public static final byte B_SEASON_TO_RANKCHOOSE4 = 40;
    public static final byte B_RANKCHOOSE_TO_RANK2 = 41;
    public static final byte B_RANKCHOOSE_TO_RANK3 = 42;
    public static final byte B_RANKCHOOSE_TO_RANK4 = 43;
    public static final byte B_RANKCHOOSE_TO_RANK5 = 44;
    public static final byte B_RANKCHOOSE_TO_RANK6 = 45;
    public static final byte B_RANKCHOOSE_TO_RANK7 = 46;
    public static final byte B_RANKCHOOSE_TO_RANK8 = 47;
    public static final byte B_RANKCHOOSE_TO_RANK9 = 48;
    public static final byte B_MORE_MENU = 49;
    public static final byte B_MORE_DOWNLOAD = 50;
    public static final byte B_MORE_LEFT = 51;
    public static final byte B_MORE_RIGHT = 52;
    public static final byte B_SURE = 53;
    public static final byte B_RETURN = 54;
    public static final byte B_STOP = 55;
    public static final byte B_SPEED = 56;
    public static final byte B_MIDMENU = 57;
    public static final byte B_SHOP = 58;
    public static final byte B_MENU_LEFT = 59;
    public static final byte B_MENU_RIGHT = 60;
    public static final byte B_MENU = 61;
    public static final byte B_HELP_PAGE_LEFT = 62;
    public static final byte B_HELP_PAGE_RIGHT = 63;
    static short chooseSeansonImageW;
    static short chooseSeansonImageH;
    static short chooseRankImageW;
    static short chooseRankImageH;
    static short[][] buttonData;
    static byte[][][] headClipData;
    static byte[][][] headFrameData;
    static byte[][][][] headMotionData;
    static String[] files;
    static int[] offsetArray;
    static final byte DATA_CLIP = 0;
    static final byte DATA_FRAME = 1;
    static final byte DATA_MOTION = 2;
    static final byte DATA_OFFSET = 3;
    static short curMapFileName;

    private static void freeData(Object[] obj) {
        if (obj == null) {
            return;
        }
        int i = 0;
        while (i < obj.length) {
            obj[i] = null;
            ++i;
        }
    }

    static void freeSpriteData() {
        Data.freeData((Object[])spriteClipData);
        Data.freeData((Object[])spriteFrameData);
        Data.freeData((Object[])spriteMotionData);
    }

    static void freeEffectData() {
        Data.freeData((Object[])effectClipData);
        Data.freeData((Object[])effectFrameData);
        Data.freeData((Object[])effectMotionData);
    }

    static void loadSpriteData() throws IOException {
        DataInputStream is = Tools.openFile("/data/sprite.pak");
        try {
            Data.openPack(is);
            if (spriteClipData == null) {
                int len = Data.getPackLen(files);
                spriteClipData = new byte[len][][];
                spriteFrameData = new byte[len][][];
                spriteMotionData = new byte[len][][][];
            }
            String[] sprite = new String[spriteClipData.length];
            int i = 0;
            while (i < sprite.length) {
                sprite[i] = i + "";
                ++i;
            }
            int[] oIndex = Data.strOrder(files, sprite);
            int skip = 0;
            int i2 = 0;
            while (i2 < oIndex.length) {
                int index = oIndex[i2];
                int pos = Integer.parseInt(files[index]);
                int offset = index == 0 ? 0 : offsetArray[index - 1];
                is.skip(offset - skip);
                Object[] obj = Data.getSpecialData(is);
                Data.spriteClipData[pos] = (byte[][])obj[0];
                Data.spriteFrameData[pos] = (byte[][])obj[1];
                Data.spriteMotionData[pos] = (byte[][][])obj[2];
                if (pos == 0) {
                    // empty if block
                }
                skip = offsetArray[index];
                ++i2;
            }
            is.close();
        }
        catch (Exception ex) {
            System.out.println("read sprite.pak error!");
            ex.printStackTrace();
        }
        files = null;
        offsetArray = null;
    }

    static void loadEffData() throws IOException {
        DataInputStream is = Tools.openFile("/data/effect.pak");
        try {
            Data.openPack(is);
            if (effectClipData == null) {
                int len = Data.getPackLen(files);
                effectClipData = new byte[len][][];
                effectFrameData = new byte[len][][];
                effectMotionData = new byte[len][][][];
            }
            int i = 0;
            while (i < files.length) {
                Object[] obj = Data.getSpecialData(is);
                int index = Integer.parseInt(files[i]);
                Data.effectClipData[index] = (byte[][])obj[0];
                Data.effectFrameData[index] = (byte[][])obj[1];
                Data.effectMotionData[index] = (byte[][][])obj[2];
                ++i;
            }
            is.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        files = null;
        offsetArray = null;
    }

    static void loadHeadData(String[] sprite) throws IOException {
        DataInputStream is = Tools.openFile("data/head.pak");
        try {
            Data.openPack(is);
            if (headClipData == null) {
                int len = Data.getPackLen(files);
                headClipData = new byte[len][][];
                headFrameData = new byte[len][][];
                headMotionData = new byte[len][][][];
            }
            int[] oIndex = Data.strOrder(files, sprite);
            int skip = 0;
            int i = 0;
            while (i < oIndex.length) {
                int index = oIndex[i];
                int pos = Integer.parseInt(files[index]);
                int offset = index == 0 ? 0 : offsetArray[index - 1];
                is.skip(offset - skip);
                Object[] obj = Data.getSpecialData(is);
                Data.headClipData[pos] = (byte[][])obj[0];
                Data.headFrameData[pos] = (byte[][])obj[1];
                Data.headMotionData[pos] = (byte[][][])obj[2];
                skip = offsetArray[index];
                ++i;
            }
            is.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        files = null;
        offsetArray = null;
    }

    static void loadDB() throws IOException {
        DataInputStream is = Tools.openFile("/data/db.pak");
        try {
            Data.openPack(is);
            int i = 0;
            while (i < files.length) {
                if (files[i].equals("unlockTower")) {
                    Data.initUnlockTower(is);
                } else if (files[i].equals("deck")) {
                    Data.initDeckData(is);
                } else if (files[i].equals("buff")) {
                    Data.initBuffData(is);
                } else if (files[i].equals("tower")) {
                    Data.initSoldier(is);
                } else if (files[i].equals("bullet")) {
                    Data.initBulletData(is);
                } else if (files[i].equals("enemyTD")) {
                    Data.initEnemyTDData(is);
                } else if (!(files[i].equals("enemyTrials") || files[i].equals("trialsRankInfo") || files[i].equals("endLessEmyData") || files[i].equals("rankInfo"))) {
                    int offset = i == 0 ? 0 : offsetArray[i - 1];
                    is.skip(offsetArray[i] - offset);
                }
                ++i;
            }
            is.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        files = null;
        offsetArray = null;
    }

    public static int openPack(DataInputStream is) throws Exception {
        char mark = (char)is.readShort();
        if (mark != 'A') {
            System.out.println("file format error");
            return -1;
        }
        int len = is.readShort();
        files = new String[len];
        offsetArray = new int[len];
        int i = 0;
        while (i < len) {
            int nameLen = is.read();
            byte[] contentBuff = new byte[nameLen];
            is.read(contentBuff);
            Data.files[i] = new String(contentBuff, "UTF-8");
            ++i;
        }
        int i2 = 0;
        while (i2 < len) {
            Data.offsetArray[i2] = is.readInt();
            ++i2;
        }
        return len;
    }

    static int getPackLen(String[] names) {
        int max = 0;
        int i = 0;
        while (i < names.length) {
            int v = Integer.parseInt(names[i]);
            if (v > max) {
                max = v;
            }
            ++i;
        }
        return max + 1;
    }

    static int[] strOrder(String[] modle, String[] str) {
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < str.length) {
            int j = 0;
            while (j < modle.length) {
                if (Integer.parseInt(modle[j]) == Integer.parseInt(str[i])) {
                    v.addElement("" + j);
                }
                ++j;
            }
            ++i;
        }
        int[] index = new int[v.size()];
        int i2 = 0;
        while (i2 < index.length) {
            index[i2] = Integer.parseInt(v.elementAt(i2).toString());
            ++i2;
        }
        v = null;
        int i3 = 0;
        while (i3 < index.length) {
            int j = i3 + 1;
            while (j < index.length) {
                if (index[i3] > index[j]) {
                    index[i3] = index[i3] ^ index[j];
                    index[j] = index[i3] ^ index[j];
                    index[i3] = index[i3] ^ index[j];
                }
                ++j;
            }
            ++i3;
        }
        return index;
    }

    public static int searchFile(DataInputStream is, String name) {
        try {
            Data.openPack(is);
            int index = -1;
            int i = 0;
            while (i < files.length) {
                if (files[i].equals(name)) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index == -1) {
                return -1;
            }
            int offset = index == 0 ? 0 : offsetArray[index - 1];
            int len = offsetArray[index] - offset;
            is.skip(offset);
            return len;
        }
        catch (Exception ex1) {
            return -1;
        }
    }

    public static Object[] getSpecialData(DataInputStream is) throws Exception {
        int len = is.readByte();
        Object[] obj = new Object[4];
        int i = 0;
        while (i < len) {
            char flag = is.readChar();
            switch (flag) {
                case 'c': {
                    obj[0] = Data.readClipData(is);
                    break;
                }
                case 'f': {
                    obj[1] = Data.readFrameData(is);
                    break;
                }
                case 'm': {
                    obj[2] = Data.readMotionData(is);
                    break;
                }
                case 'o': {
                    obj[3] = Data.readClipData(is);
                }
            }
            ++i;
        }
        return obj;
    }

    static byte[][] readClipData(DataInputStream is) {
        byte[][] clip = null;
        int clipLen = 0;
        int perlen = 0;
        try {
            byte mark = is.readByte();
            perlen = mark == 0 ? 4 : 8;
            clipLen = is.readShort();
            clip = new byte[clipLen][perlen];
            int i = 0;
            while (i < clipLen) {
                int j = 0;
                while (j < perlen) {
                    clip[i][j] = is.readByte();
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("read ClipData error!");
            e.printStackTrace();
        }
        return clip;
    }

    static byte[][] readFrameData(DataInputStream is) {
        byte[][] frame = null;
        try {
            int len = is.readByte();
            frame = new byte[len][];
            int i = 0;
            while (i < len) {
                int gLen = (is.readByte() - 4) * 5 + 4;
                frame[i] = new byte[gLen];
                int j = 0;
                while (j < gLen) {
                    frame[i][j] = is.readByte();
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("read frameData error!");
            e.printStackTrace();
        }
        return frame;
    }

    static byte[][][] readMotionData(DataInputStream is) {
        byte[][][] motion = null;
        int motionLen = 0;
        try {
            motionLen = is.readByte();
            motion = new byte[20][][];
            int i = 0;
            while (i < motionLen) {
                byte st = is.readByte();
                int zs = is.readByte();
                motion[st] = new byte[zs][7];
                int j = 0;
                while (j < zs) {
                    int m = 0;
                    while (m < 7) {
                        motion[st][j][m] = is.readByte();
                        ++m;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("read motionData error!");
            e.printStackTrace();
        }
        return motion;
    }

    static short[][] readArray(String fileName, String name) throws IOException {
        DataInputStream is = Tools.openFile(fileName);
        if (is == null) {
            return null;
        }
        int fileLen = Data.searchFile(is, name);
        if (fileLen == -1) {
            return null;
        }
        short[][] dat = null;
        try {
            int len = is.readShort();
            dat = new short[len][];
            int i = 0;
            while (i < len) {
                int gLen = is.readByte();
                dat[i] = new short[gLen];
                int j = 0;
                while (j < gLen) {
                    dat[i][j] = is.readShort();
                    ++j;
                }
                ++i;
            }
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dat;
    }

    static short[][] readArray(String filePath) throws IOException {
        DataInputStream dis = Tools.openFile(filePath);
        try {
            if (dis == null) {
                return null;
            }
            int p0 = dis.readByte();
            int p1 = dis.readByte();
            short[][] temp = new short[p0][p1];
            int i = 0;
            while (i < p0) {
                int j = 0;
                while (j < p1) {
                    temp[i][j] = dis.readShort();
                    ++j;
                }
                ++i;
            }
            dis.close();
            return temp;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private static void initUnlockTower(DataInputStream dis) {
        try {
            byte[] strBuff = null;
            short len = dis.readShort();
            unlockTower = new short[len][];
            rankTime = new short[len];
            int i = 0;
            while (i < unlockTower.length) {
                byte rankId = dis.readByte();
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                Data.unlockTower[rankId] = Variable.parseShortArray(new String(strBuff, "UTF-8"), ",");
                Data.rankTime[rankId] = dis.readShort();
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void initDeckData(DataInputStream dis) {
        try {
            byte[] strBuff = null;
            short len = dis.readShort();
            Engine.deck = new Deck[len];
            short i = 0;
            while (i < len) {
                Engine.deck[i] = new Deck();
                Engine.deck[i].hp = dis.readShort();
                Engine.deck[i].getMoney = dis.readShort();
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                Engine.deck[i].dropLevel = Variable.parseByteArray(new String(strBuff, "UTF-8"), ",");
                Engine.deck[i].dropOdds = dis.readByte();
                i = (short)(i + 1);
            }
        }
        catch (Exception e) {
            System.out.println("initDeckData data error!");
            e.printStackTrace();
        }
    }

    private static void initBuffData(DataInputStream dis) {
        try {
            byte[] strBuff = null;
            short len = dis.readShort();
            Engine.buffData = new short[len][];
            int i = 0;
            while (i < Engine.buffData.length) {
                Engine.buffData[i] = new short[4];
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                Engine.buffData[i][3] = dis.readByte();
                Engine.buffData[i][0] = dis.readShort();
                Engine.buffData[i][1] = dis.readShort();
                Engine.buffData[i][2] = dis.readShort();
                i = (short)(i + 1);
            }
        }
        catch (Exception e) {
            System.out.println("initBuffData data error!");
        }
    }

    static void initBulletData(DataInputStream dis) {
        try {
            byte[] strBuff = null;
            short len = dis.readShort();
            Engine.bullet = new Bullet[len];
            int i = 0;
            while (i < Engine.bullet.length) {
                Engine.bullet[i] = new Bullet();
                Engine.bullet[i].type = (short)i;
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                Engine.bullet[i].name = new String(strBuff, "UTF-8");
                Engine.bullet[i].imgIndex = dis.readShort();
                Engine.bullet[i].atkType = dis.readByte();
                Engine.bullet[i].speed = dis.readByte();
                Engine.bullet[i].range = dis.readShort();
                i = (short)(i + 1);
            }
        }
        catch (Exception e) {
            System.out.println("initBulletData data error!");
        }
    }

    static void initSoldier(DataInputStream dis) {
        try {
            short len = dis.readShort();
            byte[] strBuff = null;
            Engine.soldier = new Tower[len];
            int i = 0;
            while (i < Engine.soldier.length) {
                Engine.soldier[i] = new Tower();
                Engine.soldier[i].type = i;
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                Engine.soldier[i].name = new String(strBuff, "UTF-8");
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                Engine.soldier[i].info = new String(strBuff, "UTF-8");
                Engine.soldier[i].level = dis.readByte();
                Engine.soldier[i].mode = dis.readShort();
                Engine.soldier[i].upgrade = dis.readShort();
                Engine.soldier[i].buffId = dis.readByte();
                Engine.soldier[i].biuIndex = dis.readByte();
                Engine.soldier[i].flashMode = dis.readByte();
                Engine.soldier[i].attack = dis.readShort();
                Engine.soldier[i].aspe = dis.readShort();
                Engine.soldier[i].range = dis.readShort();
                Engine.soldier[i].priceCreate = dis.readShort();
                Engine.soldier[i].priceSell = dis.readShort();
                Engine.soldier[i].dropLevel = dis.readByte();
                Engine.soldier[i].icon = dis.readByte();
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                String s = new String(strBuff, "UTF-8");
                String[] score = Variable.splitString(s, ",");
                if (score.length == 3) {
                    Engine.soldier[i].atkPow = Byte.parseByte(score[0]);
                    Engine.soldier[i].rangePow = Byte.parseByte(score[1]);
                    Engine.soldier[i].speedPow = Byte.parseByte(score[2]);
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Soldier data error!");
            e.printStackTrace();
        }
    }

    static void initEnemyTDData(DataInputStream dis) {
        try {
            byte[] strBuff = null;
            short len = dis.readShort();
            int ENEMYINFO = 9;
            enenmyTDData = new int[len][9];
            int i = 0;
            while (i < enenmyTDData.length) {
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                Data.enenmyTDData[i][0] = dis.readInt();
                Data.enenmyTDData[i][1] = dis.readShort();
                Data.enenmyTDData[i][2] = dis.readShort();
                Data.enenmyTDData[i][3] = dis.readShort();
                Data.enenmyTDData[i][4] = dis.readShort();
                Data.enenmyTDData[i][5] = dis.readShort();
                Data.enenmyTDData[i][6] = dis.readByte();
                Data.enenmyTDData[i][7] = dis.readByte();
                Data.enenmyTDData[i][8] = dis.readByte();
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Soldier data error!");
        }
    }

    private static void printEnemyTDData() {
        int i = 0;
        while (i < enenmyTDData.length) {
            System.out.print("enenmyTDData[" + i + "] : ");
            int j = 0;
            while (j < enenmyTDData[i].length) {
                System.out.print(enenmyTDData[i][j] + ",");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public static short[] getMIndex() throws IOException {
        short[] tileIndices = null;
        DataInputStream dis = Tools.openFile("/data/tileIndices.dat");
        try {
            int len = dis.readShort();
            short mapName = -1;
            int curOffset = 0;
            short offset = 0;
            int arrayLen = 0;
            int i = 0;
            while (i < len) {
                mapName = dis.readShort();
                if (curMapFileName == mapName) {
                    curOffset = dis.readShort();
                    arrayLen = curOffset - offset;
                } else {
                    offset = dis.readShort();
                }
                ++i;
            }
            dis.skip((curOffset - arrayLen) * 2);
            tileIndices = new short[arrayLen];
            int i2 = 0;
            while (i2 < arrayLen) {
                tileIndices[i2] = dis.readShort();
                ++i2;
            }
            dis.close();
        }
        catch (Exception ex) {
            System.out.println("tileIndices error!!!!!");
            ex.printStackTrace();
        }
        return tileIndices;
    }

    static {
        chooseSeansonImageW = (short)101;
        chooseSeansonImageH = (short)128;
        chooseRankImageW = (short)75;
        chooseRankImageH = (short)75;
        buttonData = new short[][]{{0, 0, 50, 50, 0}, {115, 270, 167, 50, 0}, {190, 0, 50, 50, 0}, {0, 147, 55, 60, 10}, {185, 147, 55, 60, 10}, {69, 119, 101, 129, 20, 2}, {(short)(GCanvas.rankX - GCanvas.imageRankW / 2), (short)(GCanvas.rankY - GCanvas.imageRankH / 2), chooseRankImageW, chooseRankImageH, 0}, {502, 265, 51, 51, 0}, {185, 55, 55, 40, 0}, {185, 95, 55, 40, 0}, {10, 150, 50, 50, 10}, {420, 150, 50, 50, 10}, {0, 0, 50, 50, 0}, {190, 0, 50, 50, 0}, {180, 260, 118, 46, 0}, {308, 270, 150, 40, 0}, {0, 148, 48, 60, 0}, {192, 148, 48, 60, 0}, {190, 0, 50, 50, 0}, {50, 138, 139, 113, 0}, {0, 0, 50, 50, 0}, {185, 95, 55, 40, 0}, {185, 135, 55, 40, 0}, {0, 0, 50, 50, 0}, {10, 150, 50, 50, 0}, {420, 150, 50, 50, 0}, {709, 283, 89, 58, 0}, {709, 347, 89, 60, 0}, {435, 277, 40, 40, 0}, {353, 277, 40, 40, 0}, {394, 277, 40, 40, 0}, {0, 0, 40, 80, 0}, {0, 0, 50, 50, 0}, {185, 0, 55, 55, 0}, {0, 270, 100, 50, 0}, {140, 270, 100, 50, 0}, {0, 0, 50, 50, 0}, {0, 270, 115, 50, 0}, {(short)(GCanvas.seansonX + GCanvas.imageSeansonW), 140, chooseSeansonImageW, chooseSeansonImageH, 2}, {(short)(GCanvas.seansonX + GCanvas.imageSeansonW * 2), 140, chooseSeansonImageW, chooseSeansonImageH, 2}, {(short)(GCanvas.seansonX + GCanvas.imageSeansonW * 3), 140, chooseSeansonImageW, chooseSeansonImageH, 2}, {(short)(GCanvas.rankX - GCanvas.imageRankW / 2 + GCanvas.imageRankW), (short)(GCanvas.rankY - GCanvas.imageRankH / 2), chooseRankImageW, chooseRankImageH, 0}, {(short)(GCanvas.rankX - GCanvas.imageRankW / 2 + 2 * GCanvas.imageRankW), (short)(GCanvas.rankY - GCanvas.imageRankH / 2), chooseRankImageW, chooseRankImageH, 0}, {(short)(GCanvas.rankX - GCanvas.imageRankW / 2 + 0 * GCanvas.imageRankW), (short)(GCanvas.rankY + GCanvas.imageRankH / 2), chooseRankImageW, chooseRankImageH, 0}, {(short)(GCanvas.rankX - GCanvas.imageRankW / 2 + 1 * GCanvas.imageRankW), (short)(GCanvas.rankY + GCanvas.imageRankH / 2), chooseRankImageW, chooseRankImageH, 0}, {(short)(GCanvas.rankX - GCanvas.imageRankW / 2 + 2 * GCanvas.imageRankW), (short)(GCanvas.rankY + GCanvas.imageRankH / 2), chooseRankImageW, chooseRankImageH, 0}, {(short)(GCanvas.rankX - GCanvas.imageRankW / 2 + 0 * GCanvas.imageRankW), (short)(GCanvas.rankY + GCanvas.imageRankH / 2 + GCanvas.imageRankH), chooseRankImageW, chooseRankImageH, 0}, {(short)(GCanvas.rankX - GCanvas.imageRankW / 2 + 1 * GCanvas.imageRankW), (short)(GCanvas.rankY + GCanvas.imageRankH / 2 + GCanvas.imageRankH), chooseRankImageW, chooseRankImageH, 0}, {(short)(GCanvas.rankX - GCanvas.imageRankW / 2 + 2 * GCanvas.imageRankW), (short)(GCanvas.rankY + GCanvas.imageRankH / 2 + GCanvas.imageRankH), chooseRankImageW, chooseRankImageH, 0}, {180, 270, 60, 50, 0}, {0, 270, 60, 50, 0}, {0, 220, 60, 40, 0}, {180, 220, 60, 40, 0}, {0, 280, 100, 40, 0}, {140, 280, 100, 40, 0}, {120, 0, 60, 60, 0}, {180, 0, 60, 60, 0}, {0, 260, 60, 60, 0}, {180, 260, 60, 60, 0}, {0, 260, 45, 60, 0}, {195, 260, 45, 60, 0}, {46, 260, 148, 60, 0}, {58, 230, 50, 50, 0}, {127, 230, 50, 50, 0}};
    }
}

