/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class Deck {
    int type;
    int index;
    int objIndex;
    short defense;
    int hpMax;
    int hp;
    int getMoney;
    byte[] dropLevel;
    byte dropOdds;
    short imgIndex;
    short x;
    short y;
    short addX;
    short addY;
    short w;
    short h;
    byte trans;
    int drawLevel;
    boolean visible;
    int hitX;
    int hitY;
    int offRange;
    int alf;
    int alfTime;
    int[][] buff = new int[8][3];
    private int deadIndex = -1;
    private int deadMottion = 3;
    private int deadIndexMax = 8;
    private boolean isGetMoney;
    int showHpTime;

    Deck() {
    }

    void init(int index) {
        this.index = index;
        this.hitX = this.x + this.w / 2;
        this.hitY = this.y - this.h / 2;
        this.offRange = this.w / 2;
        this.visible = true;
        this.initDeckProperty(this.type);
    }

    void initDeckProperty(int type) {
        if (type >= Engine.deck.length) {
            System.out.println("Deck[initDeckProperty]:no info ! type = " + type);
            return;
        }
        int hpRatio = Rank.deckHp <= 0 ? 100 : (int)Rank.deckHp;
        this.hpMax = this.hp = Engine.deck[type].hp * hpRatio / 100;
        this.getMoney = Engine.deck[type].getMoney;
        this.dropLevel = Engine.deck[type].dropLevel;
        this.dropOdds = Engine.deck[type].dropOdds;
    }

    void run() {
        this.runARGB();
        this.runBuff();
        this.checkDead();
    }

    void paint() {
        this.drawHpLine(this.y + 1000);
        this.drawBuff();
        this.drawSelected(3000);
        this.drawDeadFlash(this.y + 2000);
        if (this.visible) {
            Tools.addImage(2, (int)this.imgIndex, this.x + this.addX, this.y + this.addY, this.alf, (byte)2, this.trans, this.drawLevel);
        }
    }

    void initDeadFlash(boolean isGetMoney) {
        this.deadIndex = 0;
        this.isGetMoney = isGetMoney;
    }

    void drawDeadFlash(int lev) {
        if (this.deadIndex == -1) {
            return;
        }
        if (this.deadIndex > this.deadIndexMax) {
            this.deadIndex = -1;
            return;
        }
        int alf = 0;
        if (this.deadIndex >= 5) {
            alf = Tools.ALPHA[(this.deadIndexMax - this.deadIndex) * 20 / (this.deadIndexMax - 5)];
        }
        int index = Math.min(this.deadMottion, this.deadIndex);
        Tools.addImage(0, 50, this.hitX, this.hitY, index * 84, 0, 84, 84, alf, (byte)4, (byte)0, lev);
        if (this.isGetMoney) {
            this.drawGetMoney(this.getMoney, this.hitX, this.hitY - index * 5 - 15, alf, lev);
        }
        ++this.deadIndex;
    }

    void drawGetMoney(int money, int x, int y, int alf, int lev) {
        y = Math.max(0, y - 20);
        Tools.addImage(0, 51, x, y, alf, (byte)3, (byte)0, lev);
        Tools.addNum(money, 0, 2, x + 9, y + 7, 10, -1, alf, (byte)3, lev);
    }

    boolean isDead() {
        return this.hp <= 0;
    }

    void checkDead() {
        if (this.hp <= 0 && this.visible) {
            Rank.money += this.getMoney;
            this.initDeadFlash(true);
            this.setDead();
            this.dropTower();
        }
    }

    void setDead() {
        ++Rank.curDeck;
        this.hp = 0;
        this.visible = false;
        this.buff = null;
        this.clearSelected(this.index);
    }

    void clearSelected(int index) {
        if (this.isFocus()) {
            Rank.focus = (short)-1;
            Rank.focusType = 0;
        }
    }

    boolean isFocus() {
        return Rank.focusType == 2 && Rank.focus == this.index;
    }

    void drawSelected(int lev) {
        if (this.visible && this.isFocus()) {
            int sy = Math.max(this.y - this.h - (this.showHpTime > 0 ? 27 : 17), Map.setOffY);
            Tools.addGridImage(0, 23, this.x + this.w / 2, sy, 4, 1, GCanvas.gameTime / 3 % 4, 0, (byte)3, (byte)0, lev);
        }
    }

    void addBuff(short buffType, short buffVaule, short buffTime, short interval) {
        if (!this.canAddBuff(buffType, buffVaule)) {
            return;
        }
        this.buff[buffType][0] = buffVaule;
        this.buff[buffType][1] = (short)(buffTime * 24 + this.getCoverBuffTime(buffType));
        this.buff[buffType][2] = interval;
        this.setARGB(buffType);
    }

    int getCoverBuffTime(int buffType) {
        if (this.buff[buffType][1] > 0 && this.buff[buffType][2] > 0) {
            return this.buff[buffType][1] % this.buff[buffType][2];
        }
        return 0;
    }

    boolean canAddBuff(int buffType, int buffVaule) {
        return this.visible && this.buff != null && (this.buff[buffType][1] <= 0 || this.buff[buffType][0] <= buffVaule);
    }

    void runBuff() {
        if (Rank.isPause() || this.isDead() || this.buff == null) {
            return;
        }
        int i = 0;
        while (i < this.buff.length) {
            if (this.buff[i][1] > 0) {
                int[] nArray = this.buff[i];
                nArray[1] = nArray[1] - Rank.gameSpeed;
                int interval = this.buff[i][2];
                switch (i) {
                    case 2: {
                        if (this.buff[i][1] % interval >= Rank.gameSpeed) break;
                        this.hp -= this.buff[i][0];
                    }
                }
            }
            ++i;
        }
    }

    void drawBuff() {
        if (this.isDead() || this.buff == null) {
            return;
        }
        if (this.buff[4][1] > 0) {
            Tools.addGridImage(0, 15, this.hitX, this.hitY, 6, 1, GCanvas.gameTime % 6, 0, (byte)4, (byte)0, this.y + 1000);
        }
        int i = 0;
        while (i < this.buff.length) {
            if (this.buff[i][1] > 0) {
                switch (i) {
                    case 4: {
                        Tools.addGridImage(0, 15, this.hitX, this.hitY, 6, 1, GCanvas.gameTime % 6, 0, (byte)4, (byte)0, this.y + 1000);
                        break;
                    }
                    case 2: {
                        Tools.addGridImage(0, 17, this.hitX, this.hitY, 1, 2, 0, GCanvas.gameTime / 3 % 2, (byte)4, (byte)0, this.y + 1000);
                    }
                }
            }
            ++i;
        }
    }

    void drawHpLine(int lev) {
        if (--this.showHpTime <= 0) {
            return;
        }
        if (this.visible && this.hp > 0 && this.hp < this.hpMax) {
            Tools.addRect(this.x + this.w / 2 - 20, Math.max(0, this.y - this.h - 8), 40, 8, true, (byte)0, -16777216, lev);
            Tools.addRect(this.x + this.w / 2 - 18, Math.max(2, this.y - this.h - 6), 38 * this.hp / this.hpMax, 4, true, (byte)0, -16711936, lev);
        }
    }

    void setARGB(int buffType) {
        switch (buffType) {
            case 2: {
                break;
            }
        }
    }

    void runARGB() {
        if (this.alfTime > 0) {
            this.alfTime -= Rank.gameSpeed;
        } else if (this.alf != 0) {
            this.alf = 0;
        }
    }

    void hurt(int vaule, int eftType, int hitSound, int buffId) throws Exception {
        if (!this.visible) {
            return;
        }
        this.hp -= vaule;
        this.showHpTime = 96;
        if (eftType > -1) {
            Effect.addEffect(this.hitX, this.hitY, eftType, 0, 2000);
        }
        if (hitSound != -1) {
            GCanvas.sound.playMusicFromSoundPool(hitSound);
        }
        if (this.hp > 0) {
            if (buffId > 0) {
                this.addBuff(Engine.buffData[buffId][3], Engine.buffData[buffId][0], Engine.buffData[buffId][1], Engine.buffData[buffId][2]);
            }
        } else if (this.visible) {
            Rank.money += this.getMoney;
            this.initDeadFlash(true);
            this.setDead();
            this.checkClearDeck();
            this.dropTower();
        }
    }

    void checkClearDeck() {
        int i = 0;
        while (i < Rank.deck.length) {
            if (!Rank.deck[i].isDead()) {
                return;
            }
            ++i;
        }
        Rank.initClearDeck();
    }

    void dropTower() {
        Vector dropList = this.getDropList();
        int[][] dropPos = this.getDropPos();
        int i = 0;
        while (i < dropPos.length) {
            boolean isDrop;
            boolean bl = isDrop = Tools.nextInt(99) < this.dropOdds;
            if (isDrop) {
                int dropIndex = ((Utils)dropList.elementAt((int)Tools.nextInt((int)(dropList.size() - 1)))).i;
                Rank.createTowerIndex = Rank.getEmptyTowerIndex();
                Rank.createTower(Rank.createTowerIndex, dropIndex, (byte)-1, dropPos[i][0], dropPos[i][1]);
            }
            ++i;
        }
    }

    private int[][] getDropPos() {
        int col = this.w / Map.tileWidth;
        int row = this.h / Map.tileHight;
        int dropCount = col * row;
        int[][] dropPos = new int[dropCount][2];
        int i = 0;
        while (i < dropPos.length) {
            dropPos[i][0] = this.x + Map.tileWidth / 2 + i % col * Map.tileWidth;
            dropPos[i][1] = this.y - this.h + Map.tileHight / 2 + i / col * Map.tileHight;
            ++i;
        }
        return dropPos;
    }

    public Vector getDropList() {
        Vector<Utils> list = new Vector<Utils>();
        int i = 0;
        while (i < this.dropLevel.length) {
            byte dl = this.dropLevel[i];
            int j = 0;
            while (j < Engine.soldier.length) {
                if (Engine.soldier[j].dropLevel == dl) {
                    list.addElement(new Utils(j));
                }
                ++j;
            }
            ++i;
        }
        return list;
    }
}

