/*
 * Decompiled with CFR 0.152.
 */
package com.game5a.action;

import com.game5a.action.ActionData;
import com.game5a.action.FrameData;
import com.game5a.common.GZIP;
import com.game5a.common.Rectangle;
import com.game5a.common.Tool;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ActionSet {
    public static final String STR_ACTION_FILE = ".a2";
    public byte imageNum;
    public short[] rectNum;
    public Rectangle[][] imageRects;
    public short frameNum;
    public FrameData[] frameDatas;
    public short actionNum;
    public ActionData[] actionDatas;
    public int footWidth;
    public int footHeight;
    public Image[] images;

    public static ActionSet createActionSet(String actionFile, String[] imageFiles) {
        Image[] imgs = new Image[imageFiles.length];
        for (int i2 = 0; i2 < imageFiles.length; ++i2) {
            imgs[i2] = Tool.createImage(imageFiles[i2]);
        }
        return ActionSet.createActionSet(actionFile, imgs);
    }

    public static ActionSet createActionSet(byte[] gdata, Image[] imgs) {
        try {
            byte[] data = GZIP.inflate(gdata);
            ByteArrayInputStream bin = new ByteArrayInputStream(data);
            return ActionSet.createActionSet(bin, imgs);
        }
        catch (Exception e2) {
            Tool.reportException(e2);
            return null;
        }
    }

    public static ActionSet createActionSet(String actionFile, Image[] imgs) {
        try {
            System.out.println("loading actionFile = " + actionFile);
            InputStream in = "".getClass().getResourceAsStream(actionFile);
            byte[] gdata = Tool.getBytesFromInput(in);
            return ActionSet.createActionSet(gdata, imgs);
        }
        catch (Exception e2) {
            Tool.reportException(e2);
            return null;
        }
    }

    private static ActionSet createActionSet(InputStream in, Image[] imgs) throws Exception {
        int j2;
        int i2;
        ActionSet actset = new ActionSet();
        DataInputStream din = new DataInputStream(in);
        actset.imageNum = din.readByte();
        if (actset.imageNum != imgs.length) {
            throw new Exception("Action Image Num Error");
        }
        actset.rectNum = new short[actset.imageNum];
        actset.imageRects = new Rectangle[actset.imageNum][];
        for (i2 = 0; i2 < actset.imageNum; ++i2) {
            actset.rectNum[i2] = din.readShort();
            actset.imageRects[i2] = new Rectangle[actset.rectNum[i2]];
            for (int j3 = 0; j3 < actset.rectNum[i2]; ++j3) {
                actset.imageRects[i2][j3] = new Rectangle();
                actset.imageRects[i2][j3].x = din.readShort();
                actset.imageRects[i2][j3].y = din.readShort();
                actset.imageRects[i2][j3].width = din.readByte() & 0xFF;
                actset.imageRects[i2][j3].height = din.readByte() & 0xFF;
            }
        }
        actset.frameNum = din.readShort();
        actset.frameDatas = new FrameData[actset.frameNum];
        for (i2 = 0; i2 < actset.frameNum; ++i2) {
            short frameRectNum = (short)(din.readByte() & 0xFF);
            actset.frameDatas[i2] = new FrameData(frameRectNum);
            FrameData fd = actset.frameDatas[i2];
            for (j2 = 0; j2 < fd.rectNum; ++j2) {
                fd.imgID[j2] = din.readByte();
                fd.rectID[j2] = din.readShort();
                fd.drawType[j2] = din.readByte();
                fd.rectDX[j2] = din.readShort();
                fd.rectDY[j2] = din.readShort();
            }
            if (din.readBoolean()) {
                fd.atkRect.x = din.readShort();
                fd.atkRect.y = din.readShort();
                fd.atkRect.width = din.readShort();
                fd.atkRect.height = din.readShort();
            }
            if (din.readBoolean()) {
                fd.bodyRect.x = din.readShort();
                fd.bodyRect.y = din.readShort();
                fd.bodyRect.width = din.readShort();
                fd.bodyRect.height = din.readShort();
            }
            fd.edgeRect.x = din.readShort();
            fd.edgeRect.y = din.readShort();
            fd.edgeRect.width = din.readShort();
            fd.edgeRect.height = din.readShort();
        }
        actset.footWidth = din.readByte() & 0xFF;
        actset.footHeight = din.readByte() & 0xFF;
        actset.actionNum = din.readShort();
        actset.actionDatas = new ActionData[actset.actionNum];
        for (i2 = 0; i2 < actset.actionNum; ++i2) {
            short fn = (short)(din.readByte() & 0xFF);
            actset.actionDatas[i2] = new ActionData(fn);
            ActionData ad = actset.actionDatas[i2];
            for (j2 = 0; j2 < ad.frameNum; ++j2) {
                ad.frameID[j2] = din.readShort();
                ad.vX[j2] = din.readShort();
                ad.vY[j2] = din.readShort();
                byte aFlag = din.readByte();
                ad.bAttackFrame[j2] = aFlag >> 1 > 0;
                ad.bAttackedFrame[j2] = (aFlag & 1) > 0;
            }
            ad.bAcc = din.readBoolean();
        }
        din.close();
        in.close();
        actset.images = imgs;
        return actset;
    }

    public void setImage(int index, Image img) {
        this.images[index] = img;
    }

    public void drawFrame(Graphics g2, FrameData fd, int footX, int footY, boolean bMirror) {
        if (fd != null) {
            for (int i2 = 0; i2 < fd.rectNum; ++i2) {
                byte iId = fd.imgID[i2];
                short rId = fd.rectID[i2];
                if (iId >= this.imageNum || rId >= this.rectNum[iId]) continue;
                Rectangle rct = this.imageRects[iId][rId];
                int rdx = fd.rectDX[i2];
                int drawType = fd.drawType[i2];
                if (bMirror) {
                    rdx = -fd.rectDX[i2] - rct.width + this.footWidth;
                    drawType = Tool.getMirrorTransType(fd.drawType[i2]);
                }
                Tool.drawRegion(g2, this.images[iId], rct.x, rct.y, rct.width, rct.height, drawType, footX + rdx, footY + fd.rectDY[i2]);
            }
        }
    }

    public void drawFrame(Graphics g2, int frameID, int footX, int footY, boolean bMirror) {
        FrameData fd = this.frameDatas[frameID];
        this.drawFrame(g2, fd, footX, footY, bMirror);
    }

    public void drawFrame(Graphics g2, int actIndex, int frameIndex, int footX, int footY, boolean bMirror) {
        if (actIndex < 0) {
            actIndex = 0;
        } else if (actIndex >= this.actionDatas.length) {
            actIndex = this.actionDatas.length - 1;
        }
        if (frameIndex < 0) {
            frameIndex = 0;
        } else if (frameIndex >= this.actionDatas[actIndex].frameID.length) {
            frameIndex = this.actionDatas[actIndex].frameID.length - 1;
        }
        FrameData fd = this.frameDatas[this.actionDatas[actIndex].frameID[frameIndex]];
        this.drawFrame(g2, fd, footX, footY, bMirror);
    }

    public void drawFrameCycle(Graphics g2, int actIndex, int drawTimes, int footX, int footY, boolean bMirror) {
        if (actIndex < 0) {
            actIndex = 0;
        } else if (actIndex >= this.actionDatas.length) {
            actIndex = this.actionDatas.length - 1;
        }
        drawTimes = Math.abs(drawTimes) % this.actionDatas[actIndex].frameID.length;
        FrameData fd = this.frameDatas[this.actionDatas[actIndex].frameID[drawTimes]];
        this.drawFrame(g2, fd, footX, footY, bMirror);
    }

    public Rectangle getBodyRect(FrameData fd, boolean bMirror) {
        Rectangle rect = new Rectangle(fd.bodyRect);
        if (bMirror) {
            rect.x = -rect.x - rect.width + this.footWidth;
        }
        return rect;
    }

    public Rectangle getAttackRect(FrameData fd, boolean bMirror) {
        Rectangle rect = new Rectangle(fd.atkRect);
        if (bMirror) {
            rect.x = -rect.x - rect.width + this.footWidth;
        }
        return rect;
    }

    public Rectangle getEdgeRect(FrameData fd, boolean bMirror) {
        Rectangle rect = new Rectangle(fd.edgeRect);
        if (bMirror) {
            rect.x = -rect.x - rect.width + this.footWidth;
        }
        return rect;
    }

    public int getWidthOfAction(int actionIndex) {
        return this.getWidthOfAction(this.actionDatas[actionIndex]);
    }

    public int getWidthOfAction(ActionData actionData) {
        int mw = 0;
        for (int i2 = 0; i2 < actionData.frameNum; ++i2) {
            FrameData fd = this.frameDatas[actionData.frameID[i2]];
            if (fd.edgeRect.width <= mw) continue;
            mw = fd.edgeRect.width;
        }
        return mw;
    }
}

