/*
 * Decompiled with CFR 0.152.
 */
package com.game5a.client;

import com.game5a.client.Game;
import com.game5a.client.MapElement;
import com.game5a.common.Tool;
import javax.microedition.lcdui.Graphics;

public class Bubble
extends MapElement {
    public static final int BUBBLE_DEAD_Y = 0;
    int frameIndex;
    int stepX;
    int stepY;
    int nextStepTime;
    int stepTimes;
    public boolean bDead;

    public Bubble(int fIndex, int mx, int my) {
        this.frameIndex = fIndex;
        this.mapX = mx;
        this.mapY = my;
        this.getNextStep();
    }

    public void getNextStep() {
        this.stepX = Tool.getNextRnd(-1, 2);
        this.stepY = Tool.getNextRnd(0, 2);
        this.nextStepTime = Tool.getNextRnd(20, 40);
        this.stepTimes = 0;
    }

    public void cycle() {
        if (this.bDead) {
            return;
        }
        if (this.mapY < 0) {
            this.bDead = true;
            return;
        }
        if (this.stepY > 0 || Tool.countTimes % 2 == 0) {
            --this.mapY;
        }
        this.mapX += this.stepX;
        ++this.stepTimes;
        if (this.stepTimes > this.nextStepTime) {
            this.getNextStep();
        }
    }

    public void draw(Graphics g2, int viewMapX, int viewMapY, int dx, int dy) {
        if (this.bDead) {
            return;
        }
        int drawX = this.mapX - viewMapX + dx;
        int drawY = this.mapY - viewMapY + dy;
        int fw = Game.bubbleImg.getWidth() / 3;
        int fh = Game.bubbleImg.getHeight();
        Tool.drawTile(g2, Game.bubbleImg, this.frameIndex, fw, fh, this.type, drawX, drawY);
    }

    public boolean isInScreen(int viewMapX, int viewMapY, int viewWidth, int viewHeight) {
        return false;
    }
}

