/*
 * Decompiled with CFR 0.152.
 */
package com.game5a.client;

import com.game5a.client.Game;
import com.game5a.client.MapSprite;
import com.game5a.client.data.NpcData;
import com.game5a.client.data.PetData;

public class Pet {
    int ag = 0;
    int growh = 0;
    public PetData data;
    public byte fightHeadID;
    public byte attackID;
    public static byte MOVE_LENGTH = (byte)30;
    public static short[] raise = new short[]{100, 200, 300, 1000, 1200, 1400, 2000, 2500, 3000, 5000, 6000, 7000};

    public Pet(PetData petData) {
        this.data = petData;
        this.initData();
    }

    public int UpLevel(short num) {
        this.data.nowRaise += num;
        int i2 = 0;
        while (this.data.nowRaise >= this.data.raiseNumber) {
            this.data.nowRaise -= this.data.raiseNumber;
            if (this.data.level < this.data.LEVELMAX) {
                this.data.level = (byte)(this.data.level + 1);
                this.data.attackMax = (short)(this.data.attackMax + this.getAttckGrowth());
                this.levelGrow();
                this.data.raiseNumber = this.data.level == 120 ? raise[11] : raise[this.data.level / 10];
            }
            this.refreshNature();
            ++i2;
        }
        return i2;
    }

    public boolean UpLevel() {
        if (this.data.level <= this.data.LEVELMAX) {
            this.data.level = (byte)(this.data.level + 1);
            this.data.attackMax = (short)(this.data.attackMax + this.getAttckGrowth());
            this.levelGrow();
            if (this.data.level < this.data.LEVELMAX) {
                this.data.raiseNumber = raise[this.data.level / 11];
            }
        }
        this.refreshNature();
        return true;
    }

    public void refreshNature() {
        this.data.raiseNumber = this.data.level >= this.data.LEVELMAX ? raise[this.data.level / 10 - 1] : raise[this.data.level / 10];
    }

    public int getAttckGrowth() {
        int temp;
        this.data.attackgrowth = temp = (this.data.sortID + 13) * (1 + this.data.level / 30);
        return this.data.attackgrowth;
    }

    public void initData() {
        this.fightHeadID = this.data.fightHeadID;
        this.attackID = this.data.attackID;
        if (this.data.sortID == 0) {
            this.data.upBuffResist = 25;
        } else if (this.data.sortID == 1) {
            this.data.upSkillDam = 10;
        } else if (this.data.sortID == 2) {
            this.data.upSpeed = 1;
        }
        this.data.nowRaise = 0;
        this.data.level = 0;
        this.data.attackMax = (short)120;
        this.refreshNature();
    }

    public void levelGrow() {
        byte agile;
        this.data.agile = agile = (byte)((byte)(this.data.level / 10) + 2);
        int upBuffResist = this.data.level / 31;
        if (this.data.sortID == 0) {
            this.data.upBuffResist = 25 + 25 * upBuffResist;
            if (upBuffResist > 2) {
                upBuffResist = 2;
            }
            this.data.attackID = (byte)(4 + upBuffResist);
        } else if (this.data.sortID == 1) {
            this.data.upSkillDam = 10 + 10 * upBuffResist;
            if (upBuffResist > 2) {
                upBuffResist = 2;
            }
            this.data.attackID = (byte)(7 + upBuffResist);
        } else if (this.data.sortID == 2) {
            this.data.upSpeed = 1 + upBuffResist;
            if (upBuffResist > 2) {
                upBuffResist = 2;
            }
            this.data.attackID = (byte)(10 + upBuffResist);
        }
    }

    public static int[] GetMapPetCoord() {
        int[] xy = new int[2];
        switch (Game.instance.role.curDir) {
            case 0: {
                xy[1] = 5 + Game.roleTeam.size() * 23;
                break;
            }
            case 1: {
                xy[1] = -(5 + Game.roleTeam.size() * 23);
                break;
            }
            case 2: {
                xy[0] = 5 + Game.roleTeam.size() * 23;
                break;
            }
            case 3: {
                xy[0] = -(5 + Game.roleTeam.size() * 23);
            }
        }
        return xy;
    }

    public static void setMapPet(int npcID) {
        int[] xy = Pet.GetMapPetCoord();
        Pet pt = (Pet)Game.bagFire.elementAt(npcID);
        NpcData npcda = Game.npcDatas[pt.data.npcID];
        if (Game.mapPet == null) {
            Game.mapPet = new MapSprite(-20, npcda, Game.instance.role.mapX + xy[0], Game.instance.role.mapY + xy[1], Game.instance.role.curDir);
            Game.instance.addMapElement(Game.mapPet);
            Game.mapPet.recodrdID = Game.instance.petRecodrdID;
            if (Game.instance.role.bFly) {
                Game.mapPet.bDisappear = true;
            }
        } else {
            Game.mapPet.freeRes();
            Game.mapPet.loadRes(npcda);
            Game.mapPet.recodrdID = Game.instance.petRecodrdID;
        }
    }

    public String toDescribe() {
        String str = "";
        if (this.data.upBuffResist > 0) {
            str = str + "\u5f02\u5e38\u6297\u6027" + this.data.upBuffResist + "%" + "(" + "\u6bcf\u9636\u589e\u52a025%" + ")";
        } else if (this.data.upSkillDam > 0) {
            str = str + "\u6280\u80fd\u52a0\u6210" + this.data.upSkillDam + "%" + "(" + "\u6bcf\u9636\u589e\u52a010%" + ")";
        } else if (this.data.upSpeed > 0) {
            str = str + "\u901f\u5ea6\u589e\u52a0" + this.data.upSpeed + "\u70b9" + "(" + "\u6bcf\u9636\u589e\u52a01\u70b9" + ")";
        }
        return str;
    }
}

