/*
 * Decompiled with CFR 0.152.
 */
package com.game5a.client;

import com.game5a.client.Game;
import com.game5a.client.Item;
import com.game5a.client.data.RareEquipData;

public class RareEquip {
    public RareEquipData data;
    public static final byte LV_MAX = 99;
    public static final int LIFE_MAX = 99999;
    public static final int PROPERTY_MAX = 9999;
    public static final byte CHARACTER_MAX = 3;
    public int level;
    public int hp;
    public int hpMax;
    public int sp;
    public int spMax;
    public int attack;
    public int attackMax;
    public int def;
    public int crit;
    public int miss;
    public int curExp;
    public int nextExp;
    public int pilferage;
    public int targetNum;
    public int agile;
    public int upBuffResist;
    public int upSkillDam;
    public int upSpeed;
    public int quality;
    public byte petID;
    public short angerID;
    public byte fightHeadID;

    public RareEquip(RareEquipData rareData) {
        this.data = rareData;
        this.initData();
        this.setLevel(1);
        this.setQuality(1);
    }

    public void initData() {
        this.level = 1;
        this.hp = this.data.hp;
        this.hpMax = this.data.hp;
        this.sp = 0;
        this.spMax = 300;
        this.attack = this.data.attack;
        this.attackMax = this.data.attackMax;
        this.def = this.data.defend;
        this.crit = this.data.doubleHurt;
        this.miss = this.data.miss;
        this.targetNum = this.data.targetNum;
        this.agile = this.data.agile;
        this.quality = 1;
        this.pilferage = this.data.pilferage;
        this.upBuffResist = this.data.buffResist;
        this.upSkillDam = this.data.skillHarm;
        this.upSpeed = this.data.speed;
        this.petID = this.data.petID;
        this.angerID = this.data.angerID;
        this.fightHeadID = this.data.fightHeadID;
    }

    public boolean itemUseToMe(Item item) {
        int hp = item.data.addHpValue + item.data.addHpRate * this.hpMax / 100;
        this.addHp(hp);
        short sp = item.data.addsp;
        this.addSp(sp);
        return Game.bag.addItem(item.data, -1) > 0;
    }

    public void addHp(int value) {
        this.hp += value;
        if (this.hp > this.hpMax) {
            this.hp = this.hpMax;
        }
    }

    public void addSp(int value) {
        this.sp += value;
        if (this.sp > 300) {
            this.sp = 300;
        }
    }

    public void setQuality(int lv) {
        int level = lv - this.quality;
        this.quality = lv > 3 ? 3 : lv;
        this.targetNum = this.data.targetNum + level * this.data.targetNumGrowUp;
        this.pilferage = this.data.pilferage + level * this.data.pilferageGrowUp;
        this.upBuffResist = this.data.buffResist + level * this.data.buffResistGrowUp;
        this.upSkillDam = this.data.skillHarm + level * this.data.skillHarmGrowUp;
        this.upSpeed = this.data.speed + level * this.data.speedGrowUp;
    }

    public int getQuality_targetNum(int lv) {
        int level = lv - this.quality;
        return this.targetNum + level * this.data.targetNumGrowUp;
    }

    public int getQuality_pilferage(int lv) {
        int level = lv - this.quality;
        return this.pilferage + level * this.data.pilferageGrowUp;
    }

    public int getQuality_buffResist(int lv) {
        int level = lv - this.quality;
        return this.upBuffResist + level * this.data.buffResistGrowUp;
    }

    public int getQuality_skillHarm(int lv) {
        int level = lv - this.quality;
        return this.upSkillDam + level * this.data.skillHarmGrowUp;
    }

    public int getQuality_upSpeed(int lv) {
        int level = lv - this.quality;
        return this.upSpeed + level * this.data.speedGrowUp;
    }

    public void setLevel(int lev) {
        if (this.bLevelMax()) {
            this.level = 99;
            this.curExp = 1;
            this.nextExp = 99;
            return;
        }
        int bfLevel = this.level;
        this.level = lev;
        if (this.level == 1) {
            this.curExp = 0;
            this.nextExp = this.level * this.level + 3;
        } else {
            for (int i2 = 1; i2 <= this.level - bfLevel; ++i2) {
                int upLevel = bfLevel + i2;
                int percent = this.getPerCent(upLevel);
                this.refreshGrowUp(upLevel);
                this.curExp -= this.nextExp;
                this.nextExp = upLevel * upLevel + percent;
            }
        }
        this.curExp = this.curExp > 0 ? this.curExp : 0;
        this.agile = this.data.agile + this.level / 15;
    }

    public void setCharacterLevel(int lev) {
        if (this.bLevelterMax()) {
            return;
        }
        this.targetNum += this.data.targetNumGrowUp;
        this.pilferage += this.data.pilferageGrowUp;
        this.upBuffResist += this.data.buffResistGrowUp;
        this.upSkillDam += this.data.skillHarmGrowUp;
        this.upSpeed += this.data.speedGrowUp;
        this.quality = lev;
    }

    public void refreshGrowUp(int lv) {
        this.hp = this.hpMax = this.hpMax + (lv + this.data.hpGrowUp) - lv / 2;
        int upAtt = 1 + lv / this.data.attackGrowUp + 20;
        this.attack += upAtt;
        this.attackMax += upAtt;
        int upDef = 1 + lv / this.data.defendGrowUp + 10;
        this.def += upDef;
    }

    public boolean bLevelterMax() {
        return this.quality >= 3;
    }

    public boolean bLevelMax() {
        return this.level >= 99;
    }

    public void addExp(int exp) {
        this.curExp += exp;
    }

    public void fullStatus() {
        this.hp = this.hpMax;
    }

    public boolean bLevelUp() {
        return this.curExp >= this.nextExp;
    }

    public void addLevel(int lv) {
        this.setLevel(this.level + lv);
    }

    public int getLevelNum() {
        int nExp = this.nextExp;
        int lv = this.level;
        int i2 = 0;
        for (int exp = this.curExp; exp >= nExp; exp -= nExp) {
            ++i2;
            int percent = this.getPerCent(++lv);
            nExp = lv * lv + percent;
        }
        return i2;
    }

    private int getPerCent(int level) {
        int per = 0;
        per = level <= 9 ? 3 : (level >= 10 && level < 30 ? 30 : (level >= 30 && level < 50 ? 300 : (level >= 50 && level < 70 ? 3000 : 7000)));
        return per;
    }
}

