/*
 * Decompiled with CFR 0.152.
 */
package com.game5a.common;

import com.game5a.common.Tool;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Image;

public class ResPak {
    private Hashtable resCache = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResPak(String packName) {
        InputStream in = null;
        FilterInputStream din = null;
        try {
            in = this.getClass().getResourceAsStream(packName);
            din = new DataInputStream(in);
            int resCount = ((DataInputStream)din).readInt();
            for (int i2 = 0; i2 < resCount; ++i2) {
                String resName = ((DataInputStream)din).readUTF();
                int resDataLen = ((DataInputStream)din).readInt();
                byte[] resData = new byte[resDataLen];
                ((DataInputStream)din).read(resData, 0, resDataLen);
                this.resCache.put(resName, resData);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            try {
                if (din != null) {
                    din.close();
                    din = null;
                }
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
            try {
                if (in != null) {
                    in.close();
                    in = null;
                }
            }
            catch (Exception e4) {
                e4.printStackTrace();
            }
        }
    }

    public boolean hasRes(String resName) {
        return this.resCache.containsKey(resName);
    }

    public byte[] getBytes(String resName) {
        if (this.resCache.containsKey(resName)) {
            return (byte[])this.resCache.get(resName);
        }
        return null;
    }

    public Image loadImage(String resName) {
        if (this.resCache.containsKey(resName)) {
            byte[] resData = (byte[])this.resCache.get(resName);
            return Image.createImage((byte[])resData, (int)0, (int)resData.length);
        }
        return null;
    }

    public String loadString(String resName) {
        if (this.resCache.containsKey(resName)) {
            byte[] resData = (byte[])this.resCache.get(resName);
            return Tool.toUTF(resData, 0, resData.length);
        }
        return null;
    }
}

