/*
 * Decompiled with CFR 0.152.
 */
package com.game5a.common;

import com.game5a.common.XFont;
import com.game5a.common.styledtext.Style;
import com.game5a.common.styledtext.StyledText;
import javax.microedition.lcdui.Graphics;

public class ScrollStyledText {
    StyledText text;
    int width;
    int height;
    int lineHeight;
    int drawDy;
    int scrollStep;
    byte alignType;
    XFont xFont;
    boolean bScroll;
    private int stayTimes;
    static final int STAY_TIMES_MAX = 10;
    private byte endType;
    public static final byte END_TYPE_NULL = 0;
    public static final byte END_TYPE_TOP = 1;
    public static final byte END_TYPE_BOTTOM = 2;
    public static final byte END_TYPE_MIDDLE = 3;

    public ScrollStyledText(String str, int w2, XFont fn, Style style, byte align) {
        if (str == null) {
            return;
        }
        this.width = w2;
        this.xFont = fn;
        this.alignType = align;
        this.text = new StyledText(str, this.width, this.xFont, style, null);
    }

    public void setScrollParam(int h2, int lh, int step) {
        this.height = h2;
        this.lineHeight = lh;
        this.scrollStep = step;
        this.drawDy = 0;
        this.stayTimes = 0;
        this.bScroll = this.lineHeight * this.text.getLineNum() > this.height;
    }

    public void setEndType(byte type) {
        this.endType = type;
    }

    public void setBottom(int step) {
        this.drawDy = this.height;
        this.scrollStep = step;
        this.bScroll = true;
    }

    public int getLineNum() {
        return this.text.getLineNum();
    }

    public void cycle() {
        if (this.bScroll) {
            ++this.stayTimes;
            if (this.stayTimes > 10) {
                this.drawDy -= this.scrollStep;
                int totalH = this.lineHeight * this.text.getLineNum();
                switch (this.endType) {
                    case 0: {
                        if (this.drawDy > -totalH) break;
                        this.drawDy = this.height;
                        break;
                    }
                    case 1: {
                        if (this.drawDy > -totalH) break;
                        this.bScroll = false;
                        break;
                    }
                    case 2: {
                        if (this.drawDy > -totalH + this.height) break;
                        this.bScroll = false;
                        break;
                    }
                    case 3: {
                        if (this.drawDy > -totalH + (this.height >> 1)) break;
                        this.bScroll = false;
                        break;
                    }
                }
            }
        }
    }

    public void start() {
        this.bScroll = true;
    }

    public void stop() {
        this.drawDy = 0;
        this.stayTimes = 0;
        this.bScroll = false;
    }

    public void pause() {
        this.bScroll = false;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void draw(Graphics g2, int x2, int y2) {
        int endIndex;
        g2.setClip(x2 - 1, y2, this.width + 2, this.height);
        int startIndex = -this.drawDy / this.lineHeight;
        if (startIndex < 0) {
            startIndex = 0;
        }
        if ((endIndex = (this.height - this.drawDy) / this.lineHeight + 1) >= this.text.getLineNum()) {
            endIndex = this.text.getLineNum() - 1;
        }
        int dx = 0;
        int dy = 0;
        for (int i2 = startIndex; i2 <= endIndex; ++i2) {
            dx = x2;
            dy = y2 + this.lineHeight * i2 + this.drawDy;
            if (this.alignType == 0) {
                dx = x2 + (this.width - this.text.getLineWidth(i2) >> 1);
            } else if (this.alignType == 2) {
                dx = x2 + (this.width - this.text.getLineWidth(i2));
            }
            this.text.drawLine(g2, i2, dx, dy);
        }
    }
}

