/*
 * Decompiled with CFR 0.152.
 */
package com.game5a.common;

import com.game5a.common.Tool;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class Sound {
    private Player player;
    public static final String WAVE = "audio/x-wav";
    public static final String MIDI = "audio/midi";
    public static final int INIT_VOLUME = 100;
    public String soundFile;

    public Sound(String file, String type, boolean bLoop) {
        this.setSound(file, type, bLoop);
    }

    public void setSound(String file, String type, boolean bLoop) {
        System.out.println("Load music: " + file);
        this.soundFile = file;
        this.close();
        try {
            InputStream in = "".getClass().getResourceAsStream(file);
            this.player = Manager.createPlayer((InputStream)in, (String)type);
            this.player.realize();
            if (bLoop) {
                this.player.setLoopCount(-1);
            } else {
                this.player.setLoopCount(1);
            }
            this.player.prefetch();
            in.close();
            in = null;
        }
        catch (Exception e2) {
            Tool.reportException(e2);
        }
    }

    public void start() {
        if (this.player == null) {
            return;
        }
        try {
            this.player.start();
        }
        catch (Exception e2) {
            Tool.reportException(e2);
        }
    }

    public void stop() {
        if (this.player == null) {
            return;
        }
        try {
            this.player.stop();
        }
        catch (Exception e2) {
            Tool.reportException(e2);
        }
        this.setMediaTime(0L);
    }

    public void deallocate() {
        if (this.player == null) {
            return;
        }
        try {
            if (this.player.getState() == 400) {
                this.player.stop();
            }
            this.player.deallocate();
        }
        catch (Exception e2) {
            Tool.reportException(e2);
        }
    }

    public void close() {
        if (this.player == null) {
            return;
        }
        try {
            this.setVolume(0);
            if (this.player.getState() == 400) {
                this.player.stop();
            }
            this.player.deallocate();
            this.player.close();
            this.player = null;
        }
        catch (Exception e2) {
            Tool.reportException(e2);
        }
    }

    public void setMediaTime(long mt) {
        try {
            if (this.player.getState() != 100 && this.player.getState() != 0) {
                this.player.setMediaTime(mt);
            }
        }
        catch (Exception e2) {
            Tool.reportException(e2);
        }
    }

    public boolean isStarted() {
        return this.player.getState() == 400;
    }

    public boolean isPrefetched() {
        return this.player.getState() == 300;
    }

    public boolean isRealized() {
        return this.player.getState() == 200;
    }

    public void setVolume(int vol) {
        VolumeControl volume = (VolumeControl)this.player.getControl("VolumeControl");
        if (volume != null) {
            volume.setLevel(vol);
        }
    }
}

