/*
 * Decompiled with CFR 0.152.
 */
package com.game5a.common.styledtext;

import com.game5a.common.XFont;

public class Style {
    public byte type;
    public static final byte TYPE_END = 0;
    public static final byte TYPE_COLOR = 1;
    public static final byte TYPE_ICON = 2;
    public static final char[] STYLE_FLAGS = new char[]{'/', 'c', 'i'};
    public static final char STYLE_BEGIN_CHAR = '<';
    public static final char STYLE_END_CHAR = '>';
    public int fontColor;
    public int backColor;
    public byte fontType;
    public int iconID;
    public static int DefaultFontColor = 0xFFFFFF;
    public static int DefaultBackColor = 0;
    public static byte DefaultFontType = 0;
    private static final String ERROR_SYNTAX = "syntax error: ";

    public Style() {
        this.type = 1;
        this.fontColor = DefaultFontColor;
        this.backColor = DefaultBackColor;
        this.fontType = DefaultFontType;
    }

    public Style(int fc, int bc, byte fnType) {
        this.type = 1;
        this.fontColor = fc;
        this.backColor = bc;
        this.fontType = fnType;
    }

    public Style(int icID) {
        this.type = (byte)2;
        this.iconID = icID;
    }

    public static void setDefault(int clr0, int clr1, byte fType) {
        DefaultFontColor = clr0;
        DefaultBackColor = clr1;
        DefaultFontType = fType;
    }

    public static Style createStyle(String str) {
        try {
            Style style = new Style();
            str = str.toLowerCase();
            char fistChar = str.charAt(0);
            if (fistChar == STYLE_FLAGS[0]) {
                style.type = 0;
                if (str.length() != 2) {
                    throw new Exception(ERROR_SYNTAX + str);
                }
                if (str.charAt(1) != STYLE_FLAGS[1]) {
                    throw new Exception(ERROR_SYNTAX + str);
                }
                return style;
            }
            if (fistChar == STYLE_FLAGS[1]) {
                style.type = 1;
                int index = str.indexOf(61);
                if (index < 0) {
                    throw new Exception("syntax error: without '='");
                }
                String cStr = str.substring(index + 1);
                String[] cStrs = XFont.getStringArray(cStr, ',');
                if (cStrs == null) {
                    throw new Exception(ERROR_SYNTAX + str);
                }
                if (cStrs.length == 0 || cStrs.length > 3) {
                    throw new Exception(ERROR_SYNTAX + str);
                }
                if (cStrs[0].trim().length() > 0) {
                    style.fontColor = Integer.parseInt(cStrs[0], 16);
                }
                if (cStrs.length > 1 && cStrs[1].trim().length() > 0) {
                    style.backColor = Integer.parseInt(cStrs[1], 16);
                }
                if (cStrs.length > 2 && cStrs[2].trim().length() > 0) {
                    style.fontType = Byte.parseByte(cStrs[2]);
                }
                return style;
            }
            if (fistChar == STYLE_FLAGS[2]) {
                style.type = (byte)2;
                int index = str.indexOf(61);
                if (index < 0) {
                    throw new Exception("syntax error: without '='");
                }
                String cStr = str.substring(index + 1);
                if (cStr.trim().length() > 0) {
                    style.iconID = Integer.parseInt(cStr);
                }
                return style;
            }
            return null;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static boolean isFlag(char ch) {
        for (int i2 = 0; i2 < STYLE_FLAGS.length; ++i2) {
            if (ch != STYLE_FLAGS[i2]) continue;
            return true;
        }
        return false;
    }

    public static int getFlagID(char ch) {
        for (int i2 = 0; i2 < STYLE_FLAGS.length; ++i2) {
            if (ch != STYLE_FLAGS[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static String getText(Style style, String str) {
        StringBuffer strB = new StringBuffer();
        strB.append('<');
        strB.append(STYLE_FLAGS[style.type]);
        strB.append('=');
        if (style.type == 1) {
            strB.append(Integer.toHexString(style.fontColor));
            strB.append(',');
            strB.append(Integer.toHexString(style.backColor));
            strB.append(',');
            strB.append(style.fontType);
        } else if (style.type == 2) {
            strB.append(style.iconID);
        }
        strB.append('>');
        if (style.type == 1) {
            strB.append(str);
            strB.append('<');
            strB.append(STYLE_FLAGS[0]);
            strB.append(STYLE_FLAGS[1]);
            strB.append('>');
        }
        return strB.toString();
    }

    public String toString() {
        StringBuffer strB = new StringBuffer();
        strB.append('<');
        strB.append(STYLE_FLAGS[this.type]);
        if (this.type == 0) {
            strB.append(STYLE_FLAGS[1]);
        } else if (this.type == 1) {
            strB.append('=');
            strB.append(Integer.toHexString(this.fontColor));
            strB.append(',');
            strB.append(Integer.toHexString(this.backColor));
            strB.append(',');
            strB.append(this.fontType);
        } else if (this.type == 2) {
            strB.append('=');
            strB.append(this.iconID);
        }
        strB.append('>');
        return strB.toString();
    }
}

