/*
 * Decompiled with CFR 0.152.
 */
package com.game5a.fight2;

import com.game5a.action.ActionSet;
import com.game5a.client.Enemy;
import com.game5a.client.Equip;
import com.game5a.client.Game;
import com.game5a.client.GameMenu;
import com.game5a.client.GameRectPack;
import com.game5a.client.Item;
import com.game5a.client.RareEquip;
import com.game5a.client.Role;
import com.game5a.client.data.DropData;
import com.game5a.client.data.EnemyData;
import com.game5a.client.data.EquipData;
import com.game5a.client.data.ItemData;
import com.game5a.client.data.SkillData;
import com.game5a.common.Common;
import com.game5a.common.ScrollStyledText;
import com.game5a.common.Tool;
import com.game5a.common.XList;
import com.game5a.common.styledtext.Style;
import com.game5a.fight2.FightSkill2;
import com.game5a.fight2.FightSprite2;
import com.game5a.fight2.Particle;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Fight2 {
    public static final String[] STR_ROLE_MENU = new String[]{"\u653b\u51fb", "\u9b54\u6cd5", "\u7269\u54c1", "\u5546\u5e97", "\u9003\u8dd1", "\u706d"};
    public static final String[] STR_EQUIP_MENU = new String[]{"\u653b\u51fb", "\u7269\u54c1", "\u5546\u5e97", "\u9003\u8dd1", "\u706d"};
    public static final String STR_KILL = "\u8bf7\u4f7f\u7528\u201c\u7edd\u201d\u6765\u6d88\u706d\u654c\u4eba\u3002";
    public static final String STR_ATTACK = "\u653b\u51fb";
    public static final String STR_USEING = "\u4f7f\u7528\u4e86";
    public static final String STR_CRIT = "\u4f1a\u5fc3\u4e00\u51fb";
    public static final String STR_ON_MP = "\u771f\u6c14\u4e0d\u8db3\uff01";
    public static final String STR_ON_SP = "\u5929\u529b\u4e0d\u8db3\uff01";
    public static final String STR_ON_SP_BUY = "\u5929\u529b\u4e0d\u8db3\uff01\u662f\u5426\u8d2d\u4e70\uff1f";
    public static final String STR_ON_MONEY = "\u91d1\u94b1\u4e0d\u8db3\uff01";
    public static final String STR_ON_HAVE_SKILL = "\u60a8\u8fd8\u6ca1\u6709\u5b66\u4f1a\u6280\u80fd\uff01";
    public static final String STR_ON_HAVE_SP = "\u60a8\u8fd8\u4e0d\u80fd\u4f7f\u7528\u5929\u529b\u6280\u80fd\uff01";
    public static final String STR_ON_HAVE_ITEM = "\u60a8\u6ca1\u6709\u53ef\u4ee5\u4f7f\u7528\u7684\u7269\u54c1\uff01";
    public static final String STR_RARE_SKILL = "\u795e\u5668\u6ca1\u6709\u6280\u80fd\u53ef\u4ee5\u4f7f\u7528\uff01";
    public static final String STR_GET_MONEY = "\u83b7\u5f97\u91d1\u94b1";
    public static final String STR_GET_EXP = "\u83b7\u5f97\u7ecf\u9a8c";
    public static final String STR_LVUP_TO = "\u63d0\u5347\u81f3";
    public static final String STR_LV = "\u7ea7";
    public static final String STR_GET = "\u83b7\u5f97";
    public static final String STR_LEN = "\u4e60\u5f97";
    public static final String STR_ON_STEAL = "\u4ec0\u4e48\u90fd\u6ca1\u6709\u5077\u5230";
    public static final String STR_GAME_OVER = "\u961f\u4f0d\u5168\u706d!";
    public static final String STR_FLEE_WIN = "\u4f7f\u7528\u4e86\u98ce\u884c\u4e39\u9003\u8dd1\u6210\u529f\uff01";
    public static final String STR_NO_FLEE = "\u672c\u6b21\u6218\u6597\u65e0\u6cd5\u9003\u8dd1\uff01";
    public static final String STR_BUT_FLEE = "\u8bf7\u5230\u5546\u5e97\u8d2d\u4e70\u98ce\u884c\u4e39";
    public static final String STR_NO_EXPOSE = "\u529f\u80fd\u672a\u5f00\u542f\uff01";
    public static String[] strLvName = new String[]{"\u5fa1\u5e08", "\u5929\u5e08", "\u5929\u5c0a", "\u5929\u5b97", "\u5929\u7cbe", "\u5929\u865a", "\u5929\u9053", "\u5929\u738b", "\u5929\u5e1d", "\u5929\u795e"};
    public static final String[] STR_YES_NO = new String[]{"\u662f", "\u5426"};
    ScrollStyledText itemDescribe;
    public static final byte TITLE_HEIGHT = 16;
    public static final int BACK_COLOUR = 4270867;
    public static final int[] RECT_STYLR_YELLOW = new int[]{12563239, 14932035};
    public static final int[] RECT_STYLR_BLACKBULL = new int[]{11351, 933745};
    public static final Style STYLE_DROP_TEXT = new Style(0xFFFFFF, 0, 1);
    public static final int[] ROLE_HP_COLOUR = new int[]{0xFF6666, 0xFF0000};
    public static final int[] ROLE_MP_COLOUR = new int[]{0x3333FF, 255};
    public static final int[] ROLE_SP_COLOUR = new int[]{0xFFCC00, 0xF6FF00, 0xFFCC00, 16028972};
    public boolean isUpRank = false;
    public int[] UpRankTeam = new int[]{-1, -1, -1};
    public static final byte ITEM_ICON_NUM = 10;
    public static final int[] QUALITY_COLOUR = new int[]{0xFFFFFF, 385536, 8388783, 0xFF6600};
    public static final String[] STR_ITEM_COLOUR = new String[]{"<c=ffffff,000000,1>", "<c=05e200,000000,1>", "<c=8000af,000000,1>", "<c=ff6600,000000,1>"};
    public static final Style STYLE_NATURE_ITEM = new Style(0xFFFFFF, 0, 0);
    public boolean bGod;
    public boolean bFightOver = true;
    public boolean bMustLose;
    public byte fightResult;
    public static byte FIGHT_WIN = 0;
    public static byte FIGHT_LOSE = 1;
    public boolean noFlee;
    public String fightOverScript;
    public static String str_steal;
    public static int stealTime;
    public static final short NUM_AGILE_WIDTH = 260;
    public static boolean bfgMess;
    public byte state;
    public static final byte STATE_LOAD = 0;
    public static final byte STATE_MESSAGE = 1;
    public static final byte STATE_WAIT = 2;
    public static final byte STATE_ROLE_ACT = 3;
    public static final byte STATE_ENEMY_ACT = 4;
    public static final byte STATE_PET_ACT = 5;
    public static final byte STATE_RESULT = 6;
    byte subState;
    public static final byte SUBSTATE_CYCLE_BUFF = 0;
    public static final byte SUBSTATE_WAIT_ORDER = 1;
    public static final byte SUBSTATE_SELECT_TARGET = 2;
    public static final byte SUBSTATE_SELECT_SKILL = 3;
    public static final byte SUBSTATE_SELECT_SP = 4;
    public static final byte SUBSTATE_SELECT_PROP = 5;
    public static final byte SUBSTATE_EXECUTE_ORDER = 6;
    public static int gameWidth;
    public static int gameHeight;
    public static int uiWidth;
    public static int uiHeight;
    private int[] roleCoord;
    private int[] enemyCoord;
    private int[] sp_PosY;
    private int[] sp_index;
    private int[] hd_PosX;
    private int[] hd_index;
    public FightSprite2[] roleTeam;
    FightSprite2[] enemyTeam;
    FightSprite2[] aimSprite;
    Vector sprites = new Vector();
    private Role[] roleSet;
    private Enemy[] enemySet;
    private static FightSprite2 activateRole;
    private static FightSprite2 activateEnemy;
    private int roleNum;
    FightSprite2 rareEquipPet;
    int[] petCoord;
    int selectTarIndex;
    int[] selectTarList;
    public boolean bPoison;
    public int poisonTime;
    public static final byte POI_NONE = 10;
    public static Hashtable resCacheFight;
    public static final byte SKILL_SHOW_MAX = 5;
    public static final short SKILL_UI_WIDTH = 176;
    public static FightSkill2 skill;
    SkillData fightSkill;
    private XList skillList;
    private int skillIndex;
    public static final byte ITEM_ROW = 4;
    public static final byte ITEM_RANK = 5;
    private Vector items;
    private Item naItem;
    GameRectPack itemPack;
    private int useItemTime;
    private int fleeTime;
    public String screenPrompt;
    public static final byte SCREEN_NONE = 0;
    public static final byte SCREEN_FILL_DOWN = 1;
    public static final byte SCREEN_FILL_TOP = 2;
    public static final byte SCREEN_SHAKE = 3;
    public static final byte SCREEN_BORDER = 4;
    public static byte downFillType;
    public static byte topFillType;
    public static int screenColour;
    public static int shakeX;
    public static int shakeY;
    public static int[] shakeVale;
    public static byte shakeTime;
    public static final byte SHAKE_TOTAL_TIME = 4;
    public static byte shineType;
    public static byte shineTime;
    public static final byte SHINE_TOTAL_TIME = 4;
    public static final byte NUM_HURT = 1;
    public static final byte NUM_HP = 2;
    public static final byte NUM_MP = 3;
    public static final byte NUM_CRIT = 4;
    private int dropMoney;
    public int dropExp;
    private Vector dropItem = new Vector();
    private Vector dropEquip = new Vector();
    byte fgOverState;
    public String strDropItem = "";
    private static final byte FG_OVER_EXP = 0;
    private static final byte FG_OVER_PROP = 1;
    ScrollStyledText dropList;
    private int dropH;
    Image img_fightIcon;
    public static Image imgFightBack;
    public static Image img_bloodNum;
    public static Image img_hpNum;
    public static Image img_mpNum;
    public static Image img_critNum;
    public static Image img_critFont;
    Image img_screenShine;
    public static Image[] img_leaf;
    Image img_fightMenu;
    Image img_agileBack;
    Image img_fightOption;
    Image img_targetIcon;
    private Image img_scrollBar;
    private Image img_skillIcon;
    private Image img_menuNameBack;
    private ActionSet titleAs;
    private Image img_num_w;
    private Image img_xiegang_w;
    private Image[] img_head;
    public static ActionSet dropAs;
    private Image img_itemBack;
    private Image img_itemIcon;
    private Image img_selectIcon;
    private Image img_buff;
    int loadingTime;
    public static int[] smType;
    public static int[] smCounter;
    public static int[] smX;
    public static int[] smY;
    public static int[] smVX;
    public static int[] smVY;
    public static int[] smGravity;
    public static int[] smAlpha;
    public static int[] smDps;
    public static byte smDir;
    public static byte smID;

    public void gotoFight(Role[] rTeam, Enemy[] eTeam) {
        this.roleSet = rTeam;
        this.enemySet = eTeam;
        this.fgOverState = 0;
        this.bGod = false;
        Game.bdrawFight = false;
        FightSkill2.bRelease[0] = false;
        FightSkill2.bRelease[1] = false;
        FightSkill2.bRelease[2] = false;
        if (Role.bRareEquip()) {
            FightSprite2.setFightBuff(Role.pet);
            this.roleNum = this.roleSet.length;
        } else {
            this.roleNum = this.roleSet.length;
        }
        this.selectTarIndex = 0;
        this.bFightOver = false;
        this.loadingTime = 0;
        Fight2.clearnShowNum();
        this.setState((byte)0);
    }

    private void cycleLoading() {
        switch (this.loadingTime) {
            case 0: 
            case 1: {
                resCacheFight.clear();
                gameWidth = 320;
                gameHeight = 240;
                uiWidth = 176;
                uiHeight = 208;
                shakeX = 0;
                shakeY = 0;
                break;
            }
            case 2: {
                this.roleTeam = new FightSprite2[this.roleNum];
                this.initRoleCoord();
                for (int i2 = 0; i2 < this.roleSet.length; ++i2) {
                    this.roleTeam[i2] = new FightSprite2(this.roleSet[i2], this.roleCoord[i2 * 2], this.roleCoord[i2 * 2 + 1]);
                    if (this.roleTeam[i2].type != 0) continue;
                    this.sprites.addElement(this.roleTeam[i2]);
                }
                break;
            }
            case 3: {
                this.enemyTeam = new FightSprite2[this.enemySet.length];
                this.initEnemyCoord();
                for (int i3 = 0; i3 < this.enemyTeam.length; ++i3) {
                    this.enemyTeam[i3] = new FightSprite2(this.enemySet[i3], this.enemyCoord[i3 * 2], this.enemyCoord[i3 * 2 + 1], this.roleSet[0].level);
                    this.sprites.addElement(this.enemyTeam[i3]);
                }
                break;
            }
            case 4: {
                for (int i4 = 0; i4 < this.roleTeam.length; ++i4) {
                    if (this.roleTeam[i4] == null) continue;
                    this.roleTeam[i4].loadRoleSkill();
                }
                break;
            }
            case 5: {
                for (int i5 = 0; i5 < this.enemyTeam.length; ++i5) {
                    this.enemyTeam[i5].loadEnemySkill();
                }
                this.getDrop();
                this.enemySet = null;
                break;
            }
            case 6: {
                if (Role.bRareEquip()) {
                    this.rareEquipPet = new FightSprite2(Role.pet, this.petCoord[0], this.petCoord[1]);
                    this.rareEquipPet.loadPetSkill();
                    this.sprites.addElement(this.rareEquipPet);
                }
                this.setheadRand();
                this.sp_PosY = new int[this.sprites.size()];
                this.sp_index = new int[this.sprites.size()];
                this.hd_PosX = new int[this.sprites.size()];
                this.hd_index = new int[this.sprites.size()];
                break;
            }
            case 7: {
                this.img_fightIcon = Game.instance.resPak.loadImage("/fighticon" + Game.IMG_TYPE);
                this.img_skillIcon = Game.instance.resPak.loadImage("/jineng" + Game.IMG_TYPE);
                this.img_scrollBar = Game.instance.resPak.loadImage("/bar" + Game.IMG_TYPE);
                this.img_menuNameBack = Game.instance.resPak.loadImage("/biao" + Game.IMG_TYPE);
                Image[] titleimgs = new Image[]{Game.instance.resPak.loadImage("/biaoti" + Game.IMG_TYPE)};
                byte[] data = Game.instance.resPak.getBytes("/biaoti.a2");
                this.titleAs = ActionSet.createActionSet(data, titleimgs);
                this.img_num_w = Game.instance.resPak.loadImage("/num_white" + Game.IMG_TYPE);
                this.img_xiegang_w = Game.instance.resPak.loadImage("/xiegang_w" + Game.IMG_TYPE);
                this.img_head = new Image[this.roleNum];
                for (int i6 = 0; i6 < this.img_head.length; ++i6) {
                    int id = 0;
                    id = this.roleTeam[i6].type == 0 ? this.roleTeam[i6].player.sortID : 3;
                    this.img_head[i6] = Game.instance.resPak.loadImage("/z_" + id + Game.IMG_TYPE);
                }
                this.img_itemBack = Game.instance.resPak.loadImage("/itemback" + Game.IMG_TYPE);
                this.img_itemIcon = Game.instance.resPak.loadImage("/yao" + Game.IMG_TYPE);
                this.img_selectIcon = Game.instance.resPak.loadImage("/xiaojian" + Game.IMG_TYPE);
                break;
            }
            case 8: {
                String actionFile;
                Image[] imgs = new Image[7];
                if (FightSprite2.fightLightAs == null) {
                    actionFile = Game.ACTION_PATH + "eff_qun" + ".a2";
                    imgs[0] = Tool.createImage(Game.ACTION_PATH + "zhongdupaopao" + Game.IMG_TYPE);
                    imgs[1] = Tool.createImage(Game.ACTION_PATH + "xiaoemo" + Game.IMG_TYPE);
                    imgs[2] = Tool.createImage(Game.ACTION_PATH + "hunshui" + Game.IMG_TYPE);
                    imgs[3] = Tool.createImage(Game.ACTION_PATH + "xuanyun2" + Game.IMG_TYPE);
                    imgs[4] = Tool.createImage(Game.ACTION_PATH + "zi1" + Game.IMG_TYPE);
                    imgs[5] = Tool.createImage(Game.ACTION_PATH + "eff_qun" + Game.IMG_TYPE);
                    imgs[6] = Tool.createImage(Game.ACTION_PATH + "eff19" + Game.IMG_TYPE);
                    FightSprite2.fightLightAs = ActionSet.createActionSet(actionFile, imgs);
                }
                this.img_buff = Game.instance.resPak.loadImage("/biao2" + Game.IMG_TYPE);
                actionFile = Game.ACTION_PATH + "bianhua1" + ".a2";
                imgs = new Image[]{Tool.createImage(Game.ACTION_PATH + "xiaodongwu" + Game.IMG_TYPE), Tool.createImage(Game.ACTION_PATH + "yun" + Game.IMG_TYPE)};
                FightSprite2.sheepAs = ActionSet.createActionSet(actionFile, imgs);
                actionFile = Game.ACTION_PATH + "bianhua2" + ".a2";
                imgs[0] = Tool.createImage(Game.ACTION_PATH + "xiaodongwu" + Game.IMG_TYPE);
                imgs[1] = Tool.createImage(Game.ACTION_PATH + "yun" + Game.IMG_TYPE);
                FightSprite2.pigAs = ActionSet.createActionSet(actionFile, imgs);
                actionFile = Game.ACTION_PATH + "bianhua3" + ".a2";
                imgs[0] = Tool.createImage(Game.ACTION_PATH + "xiaodongwu" + Game.IMG_TYPE);
                imgs[1] = Tool.createImage(Game.ACTION_PATH + "yun" + Game.IMG_TYPE);
                FightSprite2.tortoiseAs = ActionSet.createActionSet(actionFile, imgs);
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                this.img_fightOption = Tool.createImage(Game.IMG_PATH + "z_l" + Game.IMG_TYPE);
                this.img_targetIcon = Tool.createImage(Game.IMG_PATH + "targeticon" + Game.IMG_TYPE);
                break;
            }
            case 11: {
                img_critNum = Tool.createImage(Game.IMG_PATH + "bao_s" + Game.IMG_TYPE);
                img_critFont = Tool.createImage(Game.IMG_PATH + "bao" + Game.IMG_TYPE);
                img_bloodNum = Tool.createImage(Game.IMG_PATH + "huang" + Game.IMG_TYPE);
                img_hpNum = Tool.createImage(Game.IMG_PATH + "lv" + Game.IMG_TYPE);
                img_mpNum = Tool.createImage(Game.IMG_PATH + "lan" + Game.IMG_TYPE);
                break;
            }
            case 12: {
                this.img_screenShine = Tool.createImage(Game.IMG_PATH + "screenshine" + Game.IMG_TYPE);
                this.img_fightMenu = Tool.createImage(Game.IMG_PATH + "z_h" + Game.IMG_TYPE);
                this.img_agileBack = Tool.createImage(Game.IMG_PATH + "minjiebeijing" + Game.IMG_TYPE);
                break;
            }
            case 13: {
                String asFile = Game.ACTION_PATH + "si" + ".a2";
                Image[] dropimgs = new Image[]{Tool.createImage(Game.ACTION_PATH + "yan1" + Game.IMG_TYPE)};
                dropAs = ActionSet.createActionSet(asFile, dropimgs);
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                break;
            }
            case 20: {
                if (bfgMess) {
                    this.setState((byte)1);
                    break;
                }
                this.setState((byte)2);
            }
        }
        ++this.loadingTime;
    }

    private void clearRes() {
        this.img_fightIcon = null;
        img_bloodNum = null;
        this.img_screenShine = null;
        img_leaf = null;
        this.img_fightMenu = null;
        this.img_agileBack = null;
        this.img_fightOption = null;
        this.img_targetIcon = null;
        this.img_scrollBar = null;
        this.img_skillIcon = null;
        this.img_menuNameBack = null;
        this.titleAs = null;
        this.img_num_w = null;
        this.img_xiegang_w = null;
        img_hpNum = null;
        img_mpNum = null;
        img_critNum = null;
        img_critFont = null;
        img_leaf = null;
        this.img_num_w = null;
        this.img_head = null;
        dropAs = null;
        this.img_itemBack = null;
        this.img_itemIcon = null;
        this.img_selectIcon = null;
    }

    private void initRoleCoord() {
        switch (this.roleNum) {
            case 1: {
                this.roleCoord = new int[2];
                this.roleCoord[0] = gameWidth - 45;
                this.roleCoord[1] = 130;
                break;
            }
            case 2: {
                this.roleCoord = new int[4];
                this.roleCoord[0] = gameWidth - 60;
                this.roleCoord[1] = 100;
                this.roleCoord[2] = gameWidth - 60;
                this.roleCoord[3] = 170;
                break;
            }
            case 3: {
                this.roleCoord = new int[6];
                this.roleCoord[0] = gameWidth - 60;
                this.roleCoord[1] = 137;
                this.roleCoord[2] = gameWidth - 45;
                this.roleCoord[3] = 170;
                this.roleCoord[4] = gameWidth - 60;
                this.roleCoord[5] = 100;
            }
        }
        this.petCoord = new int[2];
        this.petCoord[0] = gameWidth - 30;
        this.petCoord[1] = 100;
    }

    private void initEnemyCoord() {
        switch (this.enemyTeam.length) {
            case 1: {
                this.enemyCoord = new int[2];
                this.enemyCoord[0] = 45;
                this.enemyCoord[1] = 130;
                break;
            }
            case 2: {
                this.enemyCoord = new int[4];
                this.enemyCoord[0] = 60;
                this.enemyCoord[1] = 100;
                this.enemyCoord[2] = 60;
                this.enemyCoord[3] = 170;
                break;
            }
            case 3: {
                this.enemyCoord = new int[6];
                this.enemyCoord[0] = 60;
                this.enemyCoord[1] = 110;
                this.enemyCoord[2] = 45;
                this.enemyCoord[3] = 137;
                this.enemyCoord[4] = 60;
                this.enemyCoord[5] = 170;
            }
        }
    }

    public void initTargetList(int num) {
        this.selectTarList = new int[num];
        for (int i2 = 0; i2 < this.selectTarList.length; ++i2) {
            this.selectTarList[i2] = i2;
        }
    }

    public void initSkill(FightSprite2 role) {
        SkillData data;
        int i2;
        Vector skills = role.player.skills;
        role.player.sp_skill.removeAllElements();
        role.player.mp_skill.removeAllElements();
        if (!skills.isEmpty()) {
            for (i2 = 0; i2 < skills.size(); ++i2) {
                data = (SkillData)skills.elementAt(i2);
                if (data.spUsed > 0) {
                    role.player.sp_skill.addElement(data);
                    continue;
                }
                role.player.mp_skill.addElement(data);
            }
        }
        if (!role.player.gemSkills.isEmpty()) {
            skills = role.player.gemSkills;
            for (i2 = 0; i2 < skills.size(); ++i2) {
                data = (SkillData)skills.elementAt(i2);
                System.out.println(data.name);
                if (data.spUsed > 0) {
                    role.player.sp_skill.addElement(data);
                    continue;
                }
                role.player.mp_skill.addElement(data);
            }
        }
    }

    public boolean initSkillList(FightSprite2 role) {
        this.initSkill(role);
        Vector skills = role.player.mp_skill;
        if (!skills.isEmpty()) {
            Object[] rStrs = new String[skills.size()];
            for (int i2 = 0; i2 < skills.size(); ++i2) {
                SkillData data = (SkillData)skills.elementAt(i2);
                rStrs[i2] = data.toString();
            }
            int line = rStrs.length;
            int ih = 16;
            int showMax = line > 5 ? 5 : line;
            this.skillList = new XList(rStrs, 176, ih, showMax, Common.dotFont);
            this.skillIndex = Fight2.activateRole.skillIndex;
            this.skillList.setFocusIndex(this.skillIndex);
            this.getFocusSkill(this.skillIndex);
            this.upDataSkillDescribe(this.fightSkill);
            return true;
        }
        return false;
    }

    public boolean initSpList(FightSprite2 role) {
        Vector<SkillData> skills = null;
        if (role.type == 0) {
            this.initSkill(role);
            skills = role.player.sp_skill;
        } else if (role.type == 2) {
            skills = new Vector<SkillData>();
            short angerID = role.rEquip.angerID;
            skills.addElement(Game.skillDatas[angerID]);
        }
        if (!skills.isEmpty()) {
            Object[] rStrs = new String[skills.size()];
            for (int i2 = 0; i2 < skills.size(); ++i2) {
                SkillData data = (SkillData)skills.elementAt(i2);
                rStrs[i2] = data.toString();
            }
            int line = rStrs.length;
            int ih = 16;
            int showMax = line > 5 ? 5 : line;
            this.skillList = new XList(rStrs, 176, ih, showMax, Common.dotFont);
            this.skillIndex = 0;
            this.getFocusSp(this.skillIndex);
            this.upDataSkillDescribe(this.fightSkill);
            return true;
        }
        return false;
    }

    public boolean initItem() {
        this.items = Game.bag.getFightItem();
        if (this.items.isEmpty()) {
            return false;
        }
        this.itemPack = new GameRectPack(this.items.size(), 4, 5);
        this.upDataBagItem();
        return true;
    }

    public void upDataItemDescribe(Item item) {
        byte colourID = item.data.quality;
        int sw = 170;
        int ih = 17;
        this.itemDescribe = new ScrollStyledText(STR_ITEM_COLOUR[colourID] + item.data.name + "</c>" + item.toDescribe(), sw, Common.dotFont, STYLE_NATURE_ITEM, 1);
        this.itemDescribe.setScrollParam(51, ih, 1);
    }

    public void upDataBagItem() {
        Vector item = this.items;
        this.itemPack.upDataSize(item.size());
        if (!item.isEmpty()) {
            this.naItem = (Item)item.elementAt(this.itemPack.getFocusIndex());
            this.upDataItemDescribe(this.naItem);
        } else {
            this.itemDescribe = null;
        }
    }

    public void useEndItem() {
        this.useItemTime = 12;
        FightSprite2 role = this.roleTeam[this.selectTarIndex];
        int hp = this.naItem.data.addHpValue + this.naItem.data.addHpRate * role.hpMax / 100;
        int mp = this.naItem.data.addMpValue + this.naItem.data.addMpRate * role.mpMax / 100;
        if (this.naItem.data.relive && role.bDie) {
            role.bDie = false;
            role.clearDeBuff();
            role.initActivate();
            role.act(0);
        }
        if (hp > 0 && !role.bDie) {
            role.addHp(hp);
            Fight2.setShowNum((byte)2, hp, role);
        }
        if (mp > 0 && !role.bDie) {
            role.addMp(mp);
            Fight2.setShowNum((byte)3, mp, role);
        }
        if (this.naItem.data.abnormal) {
            role.clearDeBuff();
            role.initActivate();
        }
        role.setDeBuff((byte)10, (byte)0);
        Game.bag.addItem(this.naItem.data, -1);
    }

    public void upDataSkillDescribe(SkillData data) {
        int sw = 170;
        int ih = 17;
        this.itemDescribe = new ScrollStyledText(data.toDescribe(false), sw, Common.dotFont, STYLE_NATURE_ITEM, 1);
        this.itemDescribe.setScrollParam(62, ih, 1);
    }

    public void free() {
        this.aimSprite = null;
    }

    public void cycle() {
        switch (this.state) {
            case 0: {
                this.cycleLoading();
                break;
            }
            case 1: 
            case 2: {
                this.processCycleFight();
                if (this.state == 1) {
                    if (bfgMess) break;
                    this.setState((byte)2);
                    break;
                }
                if (this.state != 2) break;
                this.processCycleAgile();
                break;
            }
            case 3: {
                this.processCycleFight();
                this.cycleRoleSet();
                break;
            }
            case 4: {
                this.processCycleFight();
                this.cycleEnemySet();
                break;
            }
            case 5: {
                this.processCycleFight();
                this.cyclePetSet();
                break;
            }
            case 6: {
                this.processCycleFight();
                if (this.dropList != null) {
                    this.dropList.cycle();
                }
                if (this.fightResult != FIGHT_LOSE) break;
                this.fightOver();
                break;
            }
        }
        Fight2.cycleFillScreen();
        this.cycleScreenPrompt();
    }

    private void processCycleAgile() {
        block5: for (int i2 = 0; i2 < this.sprites.size(); ++i2) {
            FightSprite2 fsprite = (FightSprite2)this.sprites.elementAt(i2);
            if (!this.processAgile(fsprite)) continue;
            switch (fsprite.type) {
                case 0: {
                    this.bPoison = false;
                    activateRole = fsprite;
                    if (this.isFightLose()) {
                        this.setFightLose();
                        continue block5;
                    }
                    this.setState((byte)3);
                    this.setSubState((byte)0);
                    continue block5;
                }
                case 3: {
                    this.setState((byte)5);
                    this.setSubState((byte)1);
                    continue block5;
                }
                case 1: {
                    this.bPoison = false;
                    activateEnemy = fsprite;
                    this.setState((byte)4);
                    this.setSubState((byte)0);
                }
            }
        }
    }

    private boolean processAgile(FightSprite2 spr) {
        if (spr.curAttackTime < 100) {
            spr.curAttackTime += spr.agile;
            if (spr.bDie) {
                spr.curAttackTime = 0;
                return false;
            }
            spr.headPosX = spr.curAttackTime * 224 / 100;
            return false;
        }
        return true;
    }

    private void processCycleFight() {
        if (this.bFightOver) {
            return;
        }
        for (int i2 = 0; i2 < this.sprites.size(); ++i2) {
            FightSprite2 fsprite = (FightSprite2)this.sprites.elementAt(i2);
            this.sp_PosY[i2] = fsprite.finalPosY;
            this.sp_index[i2] = i2;
            this.hd_PosX[i2] = fsprite.headPosX;
            this.hd_index[i2] = i2;
            fsprite.cycle();
        }
        this.quickSort(this.sp_PosY, this.sp_index);
        this.quickSortHead(this.hd_PosX, this.hd_index);
        Fight2.cycleShowNum();
        skill.cycle();
        skill.magicForceAttack();
    }

    private void processEnemyAI(FightSprite2 enemy) {
        byte skillFireOdds;
        if (enemy.bDie) {
            this.selectTarIndex = 0;
            this.setState((byte)2);
        }
        EnemyData data = enemy.enemyData;
        int hpNum = data.skillFireHp.length;
        int attType = 0;
        for (int i2 = 0; i2 < hpNum; ++i2) {
            byte hpPercent = data.skillFireHp[i2];
            if (enemy.hp >= enemy.hpMax * hpPercent / 100) continue;
            attType = i2;
        }
        int useSkillOdd = Tool.getNextRnd(0, 100);
        if (useSkillOdd < (skillFireOdds = data.skillFireOdds[attType])) {
            byte dataID = 0;
            int p2 = Tool.getOddsResult(data.skillOdds[attType], true);
            dataID = data.skillIDs[attType][p2];
            SkillData skData = Game.skillDatas[dataID];
            byte tarNum = skData.targetNum;
            FightSprite2[] tarTeam = null;
            switch (skData.type) {
                case 1: {
                    if (tarNum == 1) {
                        do {
                            int attID = Tool.getNextRnd(0, this.enemyTeam.length);
                            tarTeam = new FightSprite2[]{this.enemyTeam[attID]};
                        } while (tarTeam[0].bDie);
                        break;
                    }
                    tarTeam = this.enemyTeam;
                    break;
                }
                case 0: 
                case 2: {
                    if (tarNum == 1) {
                        do {
                            int attID = Tool.getNextRnd(0, this.roleTeam.length);
                            tarTeam = new FightSprite2[]{this.roleTeam[attID]};
                        } while (tarTeam[0].bDie);
                        tarTeam = this.getRoleTeam();
                        break;
                    }
                    tarTeam = this.getRoleTeam();
                }
            }
            enemy.setTarget(tarTeam);
            skill.releaseSkill(skData, enemy);
            Fight2.activateEnemy.order = (byte)2;
            this.setSubState((byte)6);
        } else {
            this.setAimEnemySet((byte)1);
            enemy.act(2);
        }
        this.setSubState((byte)6);
    }

    private void petAI() {
        if (this.rareEquipPet.isReleaseSkill()) {
            byte skillID = this.rareEquipPet.petData.attackID;
            SkillData data = Game.skillDatas[skillID];
            byte tarNum = data.targetNum;
            FightSprite2[] tarTeam = null;
            switch (data.type) {
                case 0: 
                case 2: {
                    int i2;
                    if (tarNum == 1) {
                        do {
                            int attID = Tool.getNextRnd(0, this.enemyTeam.length);
                            tarTeam = new FightSprite2[]{this.enemyTeam[attID]};
                        } while (tarTeam[0].bDie);
                        break;
                    }
                    int counter = 0;
                    for (i2 = 0; i2 < this.enemyTeam.length; ++i2) {
                        if (this.enemyTeam[i2].bDie) continue;
                        ++counter;
                    }
                    tarTeam = new FightSprite2[counter];
                    block6: for (i2 = 0; i2 < this.enemyTeam.length; ++i2) {
                        if (this.enemyTeam[i2].bDie) continue;
                        for (int j2 = 0; j2 < tarTeam.length; ++j2) {
                            if (tarTeam[j2] != null) continue;
                            tarTeam[j2] = this.enemyTeam[i2];
                            continue block6;
                        }
                    }
                    break;
                }
                case 1: {
                    int i3;
                    if (tarNum == 1) {
                        do {
                            int attID = Tool.getNextRnd(0, this.roleTeam.length);
                            tarTeam = new FightSprite2[]{this.roleTeam[attID]};
                        } while (tarTeam[0].bDie);
                        break;
                    }
                    int counter = 0;
                    for (i3 = 0; i3 < this.roleTeam.length; ++i3) {
                        if (this.roleTeam[i3].bDie) continue;
                        ++counter;
                    }
                    tarTeam = new FightSprite2[counter];
                    block10: for (i3 = 0; i3 < this.roleTeam.length; ++i3) {
                        if (this.roleTeam[i3].bDie) continue;
                        for (int j3 = 0; j3 < tarTeam.length; ++j3) {
                            if (tarTeam[j3] != null) continue;
                            tarTeam[j3] = this.roleTeam[i3];
                            continue block10;
                        }
                    }
                    break;
                }
            }
            this.rareEquipPet.setTarget(tarTeam);
            skill.releaseSkill(data, this.rareEquipPet);
            this.setSubState((byte)6);
        }
    }

    private void setWaitOrder(byte ord) {
        switch (ord) {
            case 1: {
                if (this.getEnemyTeamActive() > Fight2.activateRole.targetNum) {
                    this.initTargetList(Fight2.activateRole.targetNum);
                } else {
                    this.initTargetList(this.getEnemyTeamActive());
                }
                if (Fight2.activateRole.targetNum == 1 || this.getEnemyTeamActive() == 1) {
                    this.detectionEnemyIndex(false);
                } else {
                    this.detectionEnemyList(false);
                }
                this.setAimRoleSet(ord);
                this.setSubState((byte)2);
                break;
            }
            case 2: {
                if (Fight2.activateRole.type == 2) {
                    Game.instance.showMessage(STR_RARE_SKILL, (byte)0, (byte)0, false);
                    break;
                }
                if (this.initSkillList(activateRole)) {
                    this.setSubState((byte)3);
                    break;
                }
                Game.instance.showMessage(STR_ON_HAVE_SKILL, (byte)0, (byte)0, false);
                break;
            }
            case 3: {
                if (this.initItem()) {
                    this.setSubState((byte)5);
                    break;
                }
                Game.instance.showMessage(STR_ON_HAVE_ITEM, (byte)0, (byte)0, false);
                break;
            }
            case 4: {
                Game.gameMenu.initShop(11, true);
                Game.preGameMenuState = Game.state;
                Game.state = (byte)8;
                break;
            }
            case 5: {
                if (Game.bag.getItemNum(Game.getItemData(11)) > 0) {
                    if (!this.noFlee) {
                        Game.instance.showMessage(STR_FLEE_WIN, (byte)0, (byte)0, false);
                        for (int i2 = 0; i2 < this.roleTeam.length; ++i2) {
                            if (this.roleTeam[i2].type == 2) continue;
                            this.roleTeam[i2].setNature();
                        }
                        this.fleeTime = 10;
                        Game.bag.addItem(Game.getItemData(11), -1);
                        this.setSubState((byte)6);
                        break;
                    }
                    Game.instance.showMessage(STR_NO_FLEE, (byte)0, (byte)0, false);
                    break;
                }
                Game.instance.showMessage(STR_BUT_FLEE, (byte)0, (byte)0, false);
                break;
            }
            case 0: {
                if (this.initSpList(activateRole)) {
                    this.setSubState((byte)4);
                    break;
                }
                Game.instance.showMessage(STR_ON_HAVE_SP, (byte)0, (byte)0, false);
            }
        }
    }

    public void godMode() {
        int douqi = 20000;
        if (Game.bDouQiReduce) {
            douqi = 10000;
        }
        if (Game.bag.yuanShen >= douqi) {
            Game.bag.addDouQi(-20000);
            for (int i2 = 0; i2 < this.enemyTeam.length; ++i2) {
                if (this.enemyTeam[i2].hp <= 0) continue;
                this.enemyTeam[i2].setHurt = this.enemyTeam[i2].hp;
            }
            activateRole.setTarget(this.enemyTeam);
            skill.releaseSkill(Game.skillDatas[0], activateRole);
            this.setSubState((byte)6);
            Game.keyKillall = false;
        } else {
            Game.instance.showMessage(STR_ON_SP, (byte)0, (byte)2, false);
        }
    }

    private void setRoleOrder(byte ord) {
        if (activateRole == null) {
            return;
        }
        int tagerNum = 0;
        switch (ord) {
            case 1: {
                tagerNum = Fight2.activateRole.targetNum;
                if (tagerNum == 1 || this.getEnemyTeamActive() == 1) {
                    if (Game.isUpPressed()) {
                        --this.selectTarIndex;
                        this.detectionEnemyIndex(true);
                        this.setAimRoleSet(ord);
                        break;
                    }
                    if (Game.isDownPressed()) {
                        ++this.selectTarIndex;
                        this.detectionEnemyIndex(false);
                        this.setAimRoleSet(ord);
                        break;
                    }
                    if (Game.isOkPressed() || Common.isKeyPressed(9, true)) {
                        this.setActivate(ord);
                        this.setSubState((byte)6);
                        break;
                    }
                    if (!Common.isKeyPressed(10, true)) break;
                    this.selectTarIndex = 0;
                    this.setSubState((byte)1);
                    break;
                }
                if (Game.isUpPressed()) {
                    this.setTarList(-1);
                    this.detectionEnemyList(true);
                    this.setAimRoleSet(ord);
                    break;
                }
                if (Game.isDownPressed()) {
                    this.setTarList(1);
                    this.detectionEnemyList(false);
                    this.setAimRoleSet(ord);
                    break;
                }
                if (Game.isOkPressed() || Common.isKeyPressed(9, true)) {
                    this.setActivate(ord);
                    this.setSubState((byte)6);
                    break;
                }
                if (!Common.isKeyPressed(10, true)) break;
                this.selectTarIndex = 0;
                this.setSubState((byte)1);
                break;
            }
            case 0: 
            case 2: {
                tagerNum = this.fightSkill.targetNum;
                if (tagerNum == 1 || this.getEnemyTeamActive() == 1) {
                    if (Game.isUpPressed()) {
                        --this.selectTarIndex;
                        if (this.fightSkill.type == 1) {
                            this.detectionRoleIndex(true);
                        } else {
                            this.detectionEnemyIndex(true);
                        }
                        this.setAimRoleSet(ord);
                        break;
                    }
                    if (Game.isDownPressed()) {
                        ++this.selectTarIndex;
                        if (this.fightSkill.type == 1) {
                            this.detectionRoleIndex(false);
                        } else {
                            this.detectionEnemyIndex(false);
                        }
                        this.setAimRoleSet(ord);
                        break;
                    }
                    if (Game.isOkPressed() || Common.isKeyPressed(9, true)) {
                        activateRole.loseMp(this.fightSkill.mpUsed);
                        activateRole.loseSp(this.fightSkill.spUsed);
                        Game.bag.addMoney(-this.fightSkill.moneyUsed);
                        this.setActivate(ord);
                        this.setSubState((byte)6);
                        break;
                    }
                    if (!Common.isKeyPressed(10, true)) break;
                    this.selectTarIndex = 0;
                    this.setSubState((byte)1);
                    break;
                }
                if (Game.isUpPressed()) {
                    this.setTarList(-1);
                    if (this.fightSkill.type == 1) {
                        this.detectionRoleList(true);
                    } else {
                        this.detectionEnemyList(true);
                    }
                    this.setAimRoleSet(ord);
                    break;
                }
                if (Game.isDownPressed()) {
                    this.setTarList(1);
                    if (this.fightSkill.type == 1) {
                        this.detectionRoleList(false);
                    } else {
                        this.detectionEnemyList(false);
                    }
                    this.setAimRoleSet(ord);
                    break;
                }
                if (Game.isOkPressed() || Common.isKeyPressed(9, true)) {
                    activateRole.loseMp(this.fightSkill.mpUsed);
                    activateRole.loseSp(this.fightSkill.spUsed);
                    Game.bag.addMoney(-this.fightSkill.moneyUsed);
                    this.setActivate(ord);
                    this.setSubState((byte)6);
                    System.out.println("3333333333333333333333333333333333333333");
                    break;
                }
                if (!Common.isKeyPressed(10, true)) break;
                this.selectTarIndex = 0;
                this.setSubState((byte)1);
                break;
            }
            case 3: {
                if (Game.isUpPressed()) {
                    this.selectTarIndex = this.select((byte)this.selectTarIndex, this.roleTeam.length - 1, -1);
                    this.setAimRoleSet(ord);
                    break;
                }
                if (Game.isDownPressed()) {
                    this.selectTarIndex = this.select((byte)this.selectTarIndex, this.roleTeam.length - 1, 1);
                    this.setAimRoleSet(ord);
                    break;
                }
                if (Game.isOkPressed() || Common.isKeyPressed(9, true)) {
                    if (Fight2.activateRole.target[0].bDie && !this.naItem.data.relive) {
                        Game.instance.showMessage("\u76ee\u6807\u5df2\u6b7b\u4ea1", (byte)0, (byte)0, false);
                        break;
                    }
                    if (this.naItem.data.sortID >= 12 && this.naItem.data.sortID <= 15) {
                        Game.instance.showMessage("\u6218\u6597\u4e2d\u4e0d\u80fd\u670d\u7528\u5c5e\u6027\u836f", (byte)0, (byte)0, false);
                        break;
                    }
                    this.setActivate(ord);
                    this.setSubState((byte)6);
                    break;
                }
                if (!Common.isKeyPressed(10, true)) break;
                this.setSubState((byte)1);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
        }
    }

    private void cycleRoleExeCuteOrder() {
        if (activateRole == null) {
            return;
        }
        switch (Fight2.activateRole.order) {
            case 1: {
                if (!activateRole.bAttackOver()) break;
                activateRole.upDataTargetBuff();
                activateRole.initActivate();
                this.upDataRoleDie();
                this.upDataEnemyDie();
                if (this.isFightWin()) {
                    this.setFightWin();
                    this.setState((byte)6);
                    break;
                }
                this.selectTarIndex = 0;
                this.setState((byte)2);
                break;
            }
            case 0: 
            case 2: 
            case 6: {
                if (activateRole.isReleaseSkill()) {
                    skill.releaseSkill(this.fightSkill, activateRole);
                    break;
                }
                if (!activateRole.bAttackOver()) break;
                activateRole.initActivate();
                this.upDataRoleDie();
                this.upDataEnemyDie();
                if (this.isFightWin()) {
                    this.setFightWin();
                    this.setState((byte)6);
                    break;
                }
                this.selectTarIndex = 0;
                this.setState((byte)2);
                break;
            }
            case 3: {
                if (activateRole.isReleaseSkill()) {
                    this.useEndItem();
                    break;
                }
                if (this.useItemTime <= 0) break;
                --this.useItemTime;
                if (this.useItemTime > 0) break;
                if (this.naItem.data.flee) {
                    this.fightResult = FIGHT_WIN;
                    this.fightOver();
                    break;
                }
                if (!this.naItem.data.bRound) {
                    this.setState((byte)3);
                    this.setSubState((byte)1);
                    break;
                }
                this.selectTarIndex = 0;
                activateRole.initActivate();
                this.setState((byte)2);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                if (this.fleeTime <= 0) break;
                --this.fleeTime;
                if (this.fleeTime > 0) break;
                this.fightResult = FIGHT_WIN;
                this.fightOver();
            }
        }
        this.setFightLose();
    }

    private void cycleEnemyExeCuteOrder() {
        if (activateEnemy == null) {
            return;
        }
        switch (Fight2.activateEnemy.order) {
            case 1: 
            case 2: {
                if (!activateEnemy.bAttackOver()) break;
                activateEnemy.upDataTargetBuff();
                activateEnemy.initActivate();
                this.upDataRoleDie();
                this.setState((byte)2);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
        }
        this.setFightLose();
    }

    public void cycleScreenPrompt() {
        --stealTime;
        block0 : switch (this.state) {
            case 2: {
                this.screenPrompt = "";
                break;
            }
            case 3: {
                if (activateRole == null) {
                    return;
                }
                switch (Fight2.activateRole.order) {
                    case 1: {
                        switch (this.subState) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                this.screenPrompt = Fight2.activateRole.name;
                                break;
                            }
                            case 6: {
                                this.screenPrompt = Fight2.activateRole.bCrit ? STR_CRIT : Fight2.activateRole.name + STR_ATTACK;
                            }
                        }
                        break block0;
                    }
                    case 2: {
                        switch (this.subState) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                this.screenPrompt = Fight2.activateRole.name;
                                break;
                            }
                            case 6: {
                                this.screenPrompt = Fight2.activateRole.name + STR_USEING + this.fightSkill.name;
                            }
                        }
                        break block0;
                    }
                    case 3: {
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                    case 5: {
                        break block0;
                    }
                }
                break;
            }
            case 4: {
                if (activateEnemy == null) {
                    return;
                }
                switch (Fight2.activateEnemy.order) {
                    case 1: {
                        switch (this.subState) {
                            case 0: 
                            case 1: 
                            case 2: {
                                this.screenPrompt = Fight2.activateEnemy.enemyData.name;
                                break block0;
                            }
                            case 6: {
                                if (Fight2.activateEnemy.bCrit) {
                                    this.screenPrompt = STR_CRIT;
                                    break block0;
                                }
                                this.screenPrompt = Fight2.activateEnemy.enemyData.name + STR_ATTACK;
                            }
                        }
                        break block0;
                    }
                    case 2: {
                        this.screenPrompt = Fight2.activateEnemy.enemyData.name + STR_ATTACK;
                        break block0;
                    }
                    case 3: {
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                    case 5: {
                        break block0;
                    }
                }
            }
        }
        if (str_steal != null && stealTime <= 0) {
            str_steal = null;
        }
    }

    public void setAimRoleSet(byte ord) {
        switch (ord) {
            case 1: {
                int num = 0;
                num = this.getEnemyTeamActive() > Fight2.activateRole.targetNum ? Fight2.activateRole.targetNum : this.getEnemyTeamActive();
                this.aimSprite = this.getAimRoleSet(ord, num);
                activateRole.setTarget(this.aimSprite);
                break;
            }
            case 0: 
            case 2: {
                int num = 0;
                if (this.fightSkill.type == 0 || this.fightSkill.type == 2) {
                    num = this.getEnemyTeamActive() > this.fightSkill.targetNum ? (int)this.fightSkill.targetNum : this.getEnemyTeamActive();
                } else if (this.fightSkill.type == 1) {
                    num = this.getRoleTeamActive() > this.fightSkill.targetNum ? (int)this.fightSkill.targetNum : this.getRoleTeamActive();
                }
                this.aimSprite = this.getAimRoleSet(ord, num);
                activateRole.setTarget(this.aimSprite);
                break;
            }
            case 3: {
                this.aimSprite = this.getAimRoleSet(ord, 1);
                activateRole.setTarget(this.aimSprite);
                break;
            }
        }
    }

    public void setAimEnemySet(byte ord) {
        this.aimSprite = this.getAimEnemySet(ord);
        Fight2.activateEnemy.order = ord;
        activateEnemy.setTarget(this.aimSprite);
    }

    public void upDataEnemyDie() {
        for (int i2 = 0; i2 < this.enemyTeam.length; ++i2) {
            if (this.enemyTeam[i2].hp > 0) continue;
            if (!this.enemyTeam[i2].bDie) {
                if (this.enemyTeam[i2].kind == 1) {
                    this.enemyTeam[i2].act(8);
                    this.enemyTeam[i2].bShow = true;
                } else if (this.enemyTeam[i2].dropSign) {
                    this.enemyTeam[i2].dropPars = new Particle(dropAs, 1, this.enemyTeam[i2].finalPosX, this.enemyTeam[i2].finalPosY, 0, 0, false);
                    this.enemyTeam[i2].bShow = false;
                } else {
                    this.enemyTeam[i2].dropPars = new Particle(dropAs, 0, this.enemyTeam[i2].finalPosX, this.enemyTeam[i2].finalPosY, 0, 0, false);
                    this.enemyTeam[i2].bShow = false;
                }
            }
            this.enemyTeam[i2].bDie = true;
            this.enemyTeam[i2].curAttackTime = 0;
            this.enemyTeam[i2].clearDeBuff();
        }
    }

    public void upDataRoleDie() {
        for (int i2 = 0; i2 < this.roleTeam.length; ++i2) {
            if (this.roleTeam[i2].hp > 0) continue;
            this.roleTeam[i2].bDie = true;
            this.roleTeam[i2].curAttackTime = 0;
            this.roleTeam[i2].clearDeBuff();
        }
    }

    public void setActivate(byte ord) {
        if (activateRole == null) {
            return;
        }
        FightSprite2 role = activateRole;
        FightSprite2[] target = role.target;
        switch (ord) {
            case 1: {
                if (target == null) {
                    return;
                }
                if (role.type == 0) {
                    if (target.length > 1) {
                        role.spriteAttMove(160, 120);
                    } else {
                        role.spriteAttMove(target[0].finalPosX, target[0].finalPosY);
                    }
                }
                if (role.isOneKill(target[0])) {
                    role.setDeBuff((byte)6, (byte)0);
                    role.act(7);
                    if (!target[0].bBoss) break;
                    target[0].setDeBuff((byte)11, (byte)0);
                    break;
                }
                if (role.isCrit()) {
                    role.setDeBuff((byte)7, (byte)0);
                    role.act(6);
                    break;
                }
                if (role.kind == 1) {
                    role.act(9);
                    break;
                }
                role.act(1);
                break;
            }
            case 0: 
            case 2: 
            case 3: {
                role.act(5);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
        }
    }

    public int getEnemyTeamActive() {
        int num = 0;
        for (int i2 = 0; i2 < this.enemyTeam.length; ++i2) {
            if (!this.enemyTeam[i2].bDie) continue;
            ++num;
        }
        return this.enemyTeam.length - num;
    }

    public int getRoleTeamActive() {
        if (this.roleTeam == null) {
            return 99;
        }
        int num = 0;
        for (int i2 = 0; i2 < this.roleTeam.length; ++i2) {
            if (!this.roleTeam[i2].bDie) continue;
            ++num;
        }
        return this.roleTeam.length - num;
    }

    public FightSprite2[] getRoleTeam() {
        if (this.roleTeam == null) {
            return null;
        }
        Vector<FightSprite2> roles = new Vector<FightSprite2>();
        for (int i2 = 0; i2 < this.roleTeam.length; ++i2) {
            if (this.roleTeam[i2].bDie) continue;
            roles.addElement(this.roleTeam[i2]);
        }
        FightSprite2[] player = new FightSprite2[roles.size()];
        for (int i3 = 0; i3 < player.length; ++i3) {
            player[i3] = (FightSprite2)roles.elementAt(i3);
        }
        return player;
    }

    public boolean isFightWin() {
        int dieNum = 0;
        for (int i2 = 0; i2 < this.enemyTeam.length; ++i2) {
            if (!this.enemyTeam[i2].bDie) continue;
            ++dieNum;
        }
        if (dieNum >= this.enemyTeam.length) {
            this.screenPrompt = null;
            this.fightResult = FIGHT_WIN;
            return true;
        }
        return false;
    }

    public boolean isFightLose() {
        int dieNum = 0;
        for (int i2 = 0; i2 < this.roleTeam.length; ++i2) {
            if (!this.roleTeam[i2].bDie) continue;
            ++dieNum;
        }
        if (dieNum >= this.roleTeam.length) {
            this.screenPrompt = null;
            this.fightResult = FIGHT_LOSE;
            return true;
        }
        return false;
    }

    public void setFightWin() {
        if (this.fgOverState == 0) {
            int num = 0;
            for (int i2 = 0; i2 < this.roleTeam.length; ++i2) {
                Role role = this.roleTeam[i2].player;
                if (role.level < 99) continue;
                ++num;
            }
            if (num == this.roleTeam.length) {
                this.dropExp = 0;
            }
            String drop = "\u83b7\u5f97\u7ecf\u9a8c\n" + this.dropExp + "\n" + STR_GET_MONEY + "\n" + this.dropMoney;
            boolean isLv = true;
            if (isLv) {
                drop = drop + "\n";
            }
            int[] roleUpLv = new int[this.roleTeam.length];
            for (int i3 = 0; i3 < this.roleTeam.length; ++i3) {
                if (this.roleTeam[i3].type == 0) {
                    Role role = this.roleTeam[i3].player;
                    boolean bLvUp = false;
                    this.roleTeam[i3].setNature();
                    role.learnSkills.removeAllElements();
                    this.UpRankTeam[i3] = -1;
                    if (this.roleTeam[i3].bDie && !this.bGod || role.level >= 99) continue;
                    role.addExp(this.dropExp);
                    if (role.bLevelUp()) {
                        bLvUp = true;
                    }
                    if (this.bGod) {
                        bLvUp = true;
                    }
                    if (!bLvUp) continue;
                    roleUpLv[i3] = role.level;
                    isLv = false;
                    role.addLevel(role.getLevelNum(), false);
                    role.getLvLearnSkill();
                    role.checkSkillToLearn();
                    role.fullStatus();
                    int lv = role.level % 10;
                    drop = lv != 0 ? drop + "\n" + role.data.name + STR_LVUP_TO + "\n<c=7cfa00,000000,1>" + lv + "\u661f" + strLvName[role.level / 10] + "</c>" : drop + "\n" + role.data.name + STR_LVUP_TO + "\n<c=7cfa00,000000,1>" + strLvName[role.level / 10] + "</c>";
                    if (!role.learnSkills.isEmpty()) {
                        for (int j2 = 0; j2 < role.learnSkills.size(); ++j2) {
                            SkillData data = (SkillData)role.learnSkills.elementAt(j2);
                            drop = drop + "\n<c=7cfa00,000000,1>" + role.data.name + "</c>" + STR_LEN + data.toString();
                        }
                    }
                    if (role.level < 10) continue;
                    if (roleUpLv[i3] < 10) {
                        this.isUpRank = true;
                        this.UpRankTeam[i3] = role.ID;
                        continue;
                    }
                    int nLv = role.level / 10;
                    if (nLv <= roleUpLv[i3] / 10) continue;
                    this.isUpRank = true;
                    this.UpRankTeam[i3] = role.ID;
                    continue;
                }
                this.roleTeam[i3].setRareEquipNature();
                boolean bLvUp = false;
                RareEquip equip = this.roleTeam[i3].rEquip;
                if (equip.level < 99) {
                    equip.addExp(this.dropExp);
                }
                if (equip.bLevelUp()) {
                    bLvUp = true;
                }
                if (this.bGod) {
                    bLvUp = true;
                }
                if (!bLvUp) continue;
                isLv = false;
                equip.addLevel(equip.getLevelNum());
                equip.fullStatus();
                drop = drop + "\n" + equip.data.name + STR_LVUP_TO + equip.level + STR_LV;
            }
            if (isLv) {
                drop = drop.substring(0, drop.length() - 1);
            }
            int ih = 16;
            this.dropList = new ScrollStyledText(drop, uiWidth - 20, Common.dotFont, STYLE_DROP_TEXT, 0);
            this.dropH = this.dropList.getLineNum() * ih + 20;
            int step = 0;
            this.dropList.setScrollParam(this.dropH, ih, step);
        } else {
            String drop = "";
            if (this.strDropItem.length() > 0) {
                drop = STR_GET + this.strDropItem;
            }
            if (drop.length() <= 0) {
                this.dropIng();
                this.fightOver();
                return;
            }
            int ih = 16;
            this.dropList = new ScrollStyledText(drop, uiWidth - 20, Common.dotFont, STYLE_DROP_TEXT, 0);
            this.dropH = this.dropList.getLineNum() * ih + 20;
            this.dropList.setScrollParam(this.dropH, ih, 0);
        }
    }

    public void getDrop() {
        int i2;
        this.dropMoney = 0;
        this.dropExp = 0;
        this.dropItem.removeAllElements();
        this.dropEquip.removeAllElements();
        this.strDropItem = "";
        boolean bTaskItem = false;
        for (i2 = 0; i2 < this.enemySet.length; ++i2) {
            int odds;
            int j2;
            DropData data = this.enemySet[i2].dropData;
            int dropMy = data.moneyMin;
            if (data.moneyPercent > 0) {
                int dropMoneyMax = data.moneyMin + data.moneyPercent;
                dropMy = Tool.getNextRnd(dropMy, dropMoneyMax);
            }
            this.dropMoney += dropMy;
            int exp = Tool.getNextRnd(data.expMin, data.expMin + data.expPercent);
            this.dropExp += exp;
            boolean bDrop = false;
            for (j2 = 0; j2 < data.itemOdds.length; ++j2) {
                odds = Tool.getNextRnd(0, 100);
                if (odds > data.itemOdds[j2]) continue;
                bDrop = true;
                if (Game.getItemData((int)data.itemIDs[j2]).type != 2) {
                    this.addDropItem(Game.getItemData(data.itemIDs[j2]), 1);
                    continue;
                }
                if (bTaskItem) continue;
                this.addDropItem(Game.getItemData(data.itemIDs[j2]), 1);
                bTaskItem = true;
            }
            for (j2 = 0; j2 < data.equipOdds.length; ++j2) {
                odds = Tool.getNextRnd(0, 100);
                if (odds > data.equipOdds[j2]) continue;
                bDrop = true;
                this.addDropEquip(Game.getEquipData(data.equipIDs[j2]), 1);
            }
            this.enemyTeam[i2].dropSign = bDrop;
        }
        if (Game.bDoubleMoney) {
            this.dropMoney *= 2;
        }
        if (Game.bDoubleExp) {
            this.dropExp *= 2;
        }
        for (i2 = 0; i2 < this.dropItem.size(); ++i2) {
            Item item = (Item)this.dropItem.elementAt(i2);
            this.strDropItem = this.strDropItem + "\n" + item.toString();
        }
        for (i2 = 0; i2 < this.dropEquip.size(); ++i2) {
            Equip equip = (Equip)this.dropEquip.elementAt(i2);
            this.strDropItem = this.strDropItem + "\n" + equip.toString();
        }
    }

    public int addDropItem(ItemData itemData, int num) {
        if (itemData == null) {
            return 0;
        }
        if (num == 0) {
            return 0;
        }
        num = this.IsCanDrop(itemData.sortID, num);
        boolean bHas = false;
        for (int i2 = 0; i2 < this.dropItem.size(); ++i2) {
            Item it = (Item)this.dropItem.elementAt(i2);
            if (it.data.sortID != itemData.sortID) continue;
            it.number += num;
            if (it.number <= 0) {
                this.dropItem.removeElementAt(i2);
                return 0;
            }
            bHas = true;
            return it.number;
        }
        if (num > 0 && !bHas) {
            this.dropItem.addElement(new Item(itemData, num));
            return num;
        }
        return 0;
    }

    public int IsCanDrop(int sortID, int itemNum) {
        int num = itemNum;
        switch (sortID) {
            case 102: {
                if (itemNum + Game.getItemNum(sortID) <= 10) break;
                num = 10 - Game.getItemNum(sortID);
                break;
            }
            case 108: {
                if (itemNum + Game.getItemNum(sortID) <= 30) break;
                num = 30 - Game.getItemNum(sortID);
                break;
            }
            case 110: {
                if (itemNum + Game.getItemNum(sortID) <= 20) break;
                num = 20 - Game.getItemNum(sortID);
                break;
            }
            case 118: {
                if (itemNum + Game.getItemNum(sortID) <= 50) break;
                num = 50 - Game.getItemNum(sortID);
                break;
            }
            case 126: {
                if (itemNum + Game.getItemNum(sortID) <= 70) break;
                num = 70 - Game.getItemNum(sortID);
            }
        }
        return num;
    }

    public int addDropEquip(EquipData equipData, int num) {
        int i2;
        if (equipData == null) {
            return 0;
        }
        if (num == 0) {
            return 0;
        }
        for (i2 = 0; i2 < this.dropEquip.size(); ++i2) {
            Equip it = (Equip)this.dropEquip.elementAt(i2);
            if (it.data.sortID != equipData.sortID || num > 0) continue;
            this.dropEquip.removeElementAt(i2);
            return 0;
        }
        for (i2 = 0; i2 < num; ++i2) {
            this.dropEquip.addElement(new Equip(equipData));
        }
        return 0;
    }

    private void dropIng() {
        int i2;
        Game.bag.money += this.dropMoney;
        System.err.println("drop");
        for (i2 = 0; i2 < this.dropItem.size(); ++i2) {
            Item item = (Item)this.dropItem.elementAt(i2);
            Game.bag.addItem(item.data, item.number);
        }
        for (i2 = 0; i2 < this.dropEquip.size(); ++i2) {
            Equip equip = (Equip)this.dropEquip.elementAt(i2);
            Game.bag.addEquip(equip, 1);
        }
    }

    private void setFightLose() {
        if (this.getRoleTeamActive() == 0) {
            if (Game.bBuyMust && !this.bMustLose) {
                Game.instance.gotoSmsUI((byte)3);
            } else {
                this.fightResult = FIGHT_LOSE;
                this.setState((byte)6);
                Game.instance.showMessage(STR_GAME_OVER, (byte)0, (byte)0, false);
            }
        }
    }

    public void fightRevive() {
        int i2;
        int[] roleHeadRand = new int[5];
        for (int i3 = 0; i3 < roleHeadRand.length; ++i3) {
            roleHeadRand[i3] = i3 * 10 + 50;
        }
        int roleTime = 0;
        for (i2 = 0; i2 < roleHeadRand.length; ++i2) {
            int id = Tool.getNextRnd(0, roleHeadRand.length - 1 - roleTime);
            int temp = roleHeadRand[id];
            roleHeadRand[id] = roleHeadRand[i2];
            roleHeadRand[i2] = temp;
            ++roleTime;
        }
        for (i2 = 0; i2 < this.roleTeam.length; ++i2) {
            this.roleTeam[i2].curAttackTime = roleHeadRand[i2];
        }
        for (i2 = 0; i2 < this.roleTeam.length; ++i2) {
            this.roleTeam[i2].revive();
        }
        System.out.println("\u72b6\u6001=" + this.state);
        System.out.println("\u5b50\u72b6\u6001=" + this.subState);
    }

    public void handleKey() {
        switch (this.state) {
            case 0: {
                break;
            }
            case 1: {
                Game.instance.fgMessHandleKey();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.roleHandleKey();
                break;
            }
            case 4: {
                break;
            }
            case 6: {
                this.resultHandleKey();
                break;
            }
        }
        Common.clearKeyStates();
    }

    private void roleHandleKey() {
        if (activateRole == null) {
            return;
        }
        int orderMax = Fight2.activateRole.orderList.length;
        byte order = Fight2.activateRole.order;
        switch (this.subState) {
            case 0: {
                break;
            }
            case 1: {
                if (Game.isUpPressed()) {
                    Fight2.activateRole.order = this.select(order, orderMax - 1, -1);
                    break;
                }
                if (Game.isDownPressed()) {
                    Fight2.activateRole.order = this.select(order, orderMax - 1, 1);
                    break;
                }
                if (!Game.isOkPressed() && !Common.isKeyPressed(9, true)) break;
                if (Game.keyKillall) {
                    if (order == 0) {
                        this.setWaitOrder(Fight2.activateRole.orderList[order]);
                        break;
                    }
                    Fight2.activateRole.order = 0;
                    order = 0;
                    Game.instance.showMessage(STR_KILL, (byte)0, (byte)0, false);
                    break;
                }
                this.setWaitOrder(Fight2.activateRole.orderList[order]);
                break;
            }
            case 2: {
                this.setRoleOrder(order);
                break;
            }
            case 3: {
                this.skillList.handleKey();
                this.skillIndex = this.skillList.getFocusIndex();
                this.getFocusSkill(this.skillIndex);
                this.upDataSkillDescribe(this.fightSkill);
                if (Game.isOkPressed() || Common.isKeyPressed(9, true)) {
                    boolean bUse = false;
                    int mp = Fight2.activateRole.mp;
                    int money = Game.bag.money;
                    if (this.fightSkill.mpUsed > 0) {
                        if (mp >= this.fightSkill.mpUsed) {
                            bUse = true;
                        } else {
                            Game.instance.showMessage(STR_ON_MP, (byte)0, (byte)0, false);
                        }
                    } else if (money >= this.fightSkill.moneyUsed) {
                        bUse = true;
                    } else {
                        Game.instance.showMessage(STR_ON_MONEY, (byte)0, (byte)0, false);
                    }
                    if (!bUse) break;
                    this.itemDescribe = null;
                    this.selectTarIndex = 0;
                    Fight2.activateRole.skillIndex = this.skillIndex;
                    if (this.fightSkill.type == 0 || this.fightSkill.type == 2) {
                        if (this.getEnemyTeamActive() > this.fightSkill.targetNum) {
                            this.initTargetList(this.fightSkill.targetNum);
                        } else {
                            this.initTargetList(this.getEnemyTeamActive());
                        }
                        if (this.fightSkill.targetNum == 1 || this.getEnemyTeamActive() == 1) {
                            this.detectionEnemyIndex(false);
                        } else {
                            this.detectionEnemyList(false);
                        }
                    } else if (this.fightSkill.type == 1) {
                        if (this.getRoleTeamActive() > this.fightSkill.targetNum) {
                            this.initTargetList(this.fightSkill.targetNum);
                        } else {
                            this.initTargetList(this.getRoleTeamActive());
                        }
                        if (this.fightSkill.targetNum == 1 || this.getRoleTeamActive() == 1) {
                            this.detectionRoleIndex(false);
                        } else {
                            this.detectionRoleList(false);
                        }
                    }
                    this.setAimRoleSet(order);
                    this.setSubState((byte)2);
                    break;
                }
                if (!Common.isKeyPressed(10, true)) break;
                this.itemDescribe = null;
                this.setSubState((byte)1);
                break;
            }
            case 4: {
                this.skillList.handleKey();
                this.skillIndex = this.skillList.getFocusIndex();
                this.getFocusSp(this.skillIndex);
                this.upDataSkillDescribe(this.fightSkill);
                if (Game.isOkPressed() || Common.isKeyPressed(9, true)) {
                    boolean bUse = false;
                    int sp = Game.bag.yuanShen;
                    int sdUsed = this.fightSkill.spUsed;
                    if (Game.bDouQiReduce) {
                        sdUsed /= 2;
                    }
                    if (this.fightSkill.spUsed > 0) {
                        if (sp >= sdUsed) {
                            bUse = true;
                            if (this.fightSkill.type == 1 && FightSkill2.bRelease[this.fightSkill.sortID - 1]) {
                                bUse = false;
                                Game.instance.showMessage("\u5df2\u7ecf\u91ca\u653e\u8fc7", (byte)0, (byte)0, false);
                            }
                        } else if (Game.bBuyMust) {
                            try {
                                Game.bdrawFight = true;
                                Game.instance.showChoice(STR_ON_SP_BUY, STR_YES_NO, true);
                            }
                            catch (Exception e2) {
                                e2.printStackTrace();
                            }
                        } else {
                            Game.instance.showMessage(STR_ON_SP, (byte)0, (byte)0, false);
                        }
                    }
                    if (!bUse) break;
                    this.itemDescribe = null;
                    this.selectTarIndex = 0;
                    if (this.fightSkill.type == 0 || this.fightSkill.type == 2) {
                        if (this.fightSkill.sortID == 0) {
                            this.godMode();
                        } else {
                            if (this.getEnemyTeamActive() > this.fightSkill.targetNum) {
                                this.initTargetList(this.fightSkill.targetNum);
                            } else {
                                this.initTargetList(this.getEnemyTeamActive());
                            }
                            if (this.fightSkill.targetNum == 1 || this.getEnemyTeamActive() == 1) {
                                this.detectionEnemyIndex(false);
                            } else {
                                this.detectionEnemyList(false);
                            }
                        }
                    } else if (this.fightSkill.type == 1) {
                        if (this.getRoleTeamActive() > this.fightSkill.targetNum) {
                            this.initTargetList(this.fightSkill.targetNum);
                        } else {
                            this.initTargetList(this.getRoleTeamActive());
                        }
                        if (this.fightSkill.targetNum == 1 || this.getRoleTeamActive() == 1) {
                            this.detectionRoleIndex(false);
                        } else {
                            this.detectionRoleList(false);
                        }
                    }
                    if (this.fightSkill.sortID == 0) break;
                    this.setAimRoleSet(order);
                    this.setSubState((byte)2);
                    break;
                }
                if (!Common.isKeyPressed(10, true)) break;
                this.itemDescribe = null;
                this.setSubState((byte)1);
                break;
            }
            case 5: {
                this.itemPack.handleKey();
                this.upDataBagItem();
                if (Game.isOkPressed() || Common.isKeyPressed(9, true)) {
                    if (this.naItem.data.flee) {
                        if (!this.noFlee) {
                            Game.instance.showMessage(STR_FLEE_WIN, (byte)0, (byte)0, false);
                            for (int i2 = 0; i2 < this.roleTeam.length; ++i2) {
                                if (this.roleTeam[i2].type == 2) continue;
                                this.roleTeam[i2].setNature();
                            }
                            this.useItemTime = 10;
                            this.setSubState((byte)6);
                            break;
                        }
                        Game.instance.showMessage(STR_NO_FLEE, (byte)0, (byte)0, false);
                        break;
                    }
                    this.setAimRoleSet(order);
                    this.setSubState((byte)2);
                    break;
                }
                if (!Common.isKeyPressed(10, true)) break;
                this.setSubState((byte)1);
                break;
            }
        }
    }

    private void resultHandleKey() {
        if (this.fightResult == FIGHT_WIN && (Game.isOkPressed() || Common.isKeyPressed(9, true))) {
            if (this.fgOverState == 0) {
                this.fgOverState = 1;
                this.setFightWin();
            } else {
                this.dropIng();
                this.fightOver();
            }
        }
    }

    public void draw(Graphics g2) {
        switch (this.state) {
            case 0: {
                Common.fillUIRect(g2, 0);
                int clipW = Game.instance.img_loading1.getWidth();
                int clipH = Game.instance.img_loading1.getHeight();
                int dx = 320 - clipW;
                int dy = 240 - clipH;
                g2.setClip(dx, dy, clipW, this.loadingTime * clipH / 20);
                g2.drawImage(Game.instance.img_loading1, dx, dy, 0);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.drawFight(g2);
                skill.draw(g2);
                this.drawPrompt(g2);
                this.drawRoleUI(g2);
                if (this.state == 3) {
                    this.drawRoleSet(g2);
                    break;
                }
                if (this.state == 1) {
                    Game.instance.drawFgMess(g2);
                    break;
                }
                if (this.state != 6 || this.fightResult != FIGHT_WIN) break;
                this.drawDrop(g2, (gameWidth - uiWidth) / 2, (gameHeight - this.dropH) / 2);
                break;
            }
        }
    }

    private void drawPrompt(Graphics g2) {
        if (this.screenPrompt == null) {
            return;
        }
        int temp = 35;
        Common.setUIClip(g2);
        Tool.fillAlphaRect(g2, -2013265920, 0, 34, gameWidth, 15);
        if (str_steal != null) {
            Common.dotFont.drawString(g2, str_steal, (gameWidth - Common.dotFont.stringWidth(str_steal)) / 2, temp, -1, 0, (byte)1);
        } else {
            Common.dotFont.drawString(g2, this.screenPrompt, (gameWidth - Common.dotFont.stringWidth(this.screenPrompt)) / 2, temp, -1, 0, (byte)1);
        }
    }

    private void drawFight(Graphics g2) {
        Common.setUIClip(g2);
        Common.fillUIRect(g2, 0);
        Tool.drawImage(g2, imgFightBack, shakeX + (gameWidth - imgFightBack.getWidth()) / 2, shakeY + (gameHeight - imgFightBack.getHeight()) / 2, 0);
        this.drawFillScreenDown(g2);
        for (int i2 = 0; i2 < this.sprites.size(); ++i2) {
            FightSprite2 sprite = (FightSprite2)this.sprites.elementAt(this.sp_index[i2]);
            sprite.draw(g2);
        }
        this.drawFillScreenTop(g2);
        this.drawProcessBuff(g2);
        Fight2.drawShowNum(g2);
        this.drawAgileBar(g2, (gameWidth - 260) / 2, 17);
    }

    private void drawRoleSet(Graphics g2) {
        int x2 = (gameWidth - uiWidth) / 2;
        int y2 = (gameHeight - uiHeight) / 2;
        switch (this.subState) {
            case 0: {
                break;
            }
            case 1: {
                int FIGHT_MENU_W = 102;
                int FIGHT_MENU_H = 174;
                this.drawFightMenu(g2, (gameWidth - FIGHT_MENU_W) / 2, (gameHeight - FIGHT_MENU_H) / 2 - 20);
                break;
            }
            case 2: {
                this.drawSelectTarget(g2);
                break;
            }
            case 3: 
            case 4: {
                this.drawSkill(g2, x2, y2);
                break;
            }
            case 5: {
                this.drawItem(g2, x2, y2);
                break;
            }
        }
    }

    private void drawRoleUI(Graphics g2) {
        Common.setUIClip(g2);
        int headW = 68;
        int headH = 67;
        int iw = (gameWidth - 3 * headW) / 4;
        int hpW = 43;
        int headx = 14;
        boolean buffX = false;
        int drawX = (gameWidth - 3 * headW) / 4 + 11;
        headx = 30;
        int dy = gameHeight - headH - 1;
        drawX = (gameWidth - 3 * headW) / 4 + 7;
        for (int i2 = 0; i2 < this.roleTeam.length; ++i2) {
            Common.setUIClip(g2);
            Tool.drawImage(g2, this.img_head[i2], headx + i2 * (iw + headW), dy, 0);
            int hp = this.roleTeam[i2].hp;
            int hpMax = this.roleTeam[i2].hpMax;
            int mp = this.roleTeam[i2].mp;
            int mpMax = this.roleTeam[i2].mpMax;
            this.drawUiRect(g2, drawX + i2 * (iw + headW) + 9, dy + 52, hp * hpW / hpMax, ROLE_HP_COLOUR);
            this.drawUiRect(g2, drawX + i2 * (iw + headW) + 9, dy + 64, mp * hpW / mpMax, ROLE_MP_COLOUR);
            Tool.drawImage(g2, this.img_xiegang_w, drawX + i2 * (iw + headW) + hpW / 2 + 5, dy + 43, 0);
            Tool.drawImage(g2, this.img_xiegang_w, drawX + i2 * (iw + headW) + hpW / 2 + 5, dy + 55, 0);
            int hpLegth = ("" + hp).length() * 6 - (("" + hp).length() - 1);
            GameMenu.drawImageNum(g2, this.img_num_w, hp, drawX + i2 * (iw + headW) + hpW / 2 + 5 - hpLegth, dy + 43);
            GameMenu.drawImageNum(g2, this.img_num_w, hpMax, drawX + i2 * (iw + headW) + hpW / 2 + 10, dy + 43);
            int mpLegth = ("" + mp).length() * 6 - (("" + mp).length() - 1);
            GameMenu.drawImageNum(g2, this.img_num_w, mp, drawX + i2 * (iw + headW) + hpW / 2 + 5 - mpLegth, dy + 55);
            GameMenu.drawImageNum(g2, this.img_num_w, mpMax, drawX + i2 * (iw + headW) + hpW / 2 + 10, dy + 55);
            int imgh = this.img_buff.getHeight();
            Common.setUIClip(g2);
            int buff1W = 15;
            int buff2W = 10;
            int buff2id = 6;
            int tempX = 0;
            int tempY = 0;
            if (this.roleTeam[i2].speedRound > 0 || this.roleTeam[i2].speedRound == -1) {
                Tool.drawTile(g2, this.img_buff, 2, buff1W, imgh, 0, headx + i2 * (iw + headW) - 18 + tempX, dy + 5 + (imgh + 2) * 2);
                Tool.drawTile(g2, this.img_buff, buff2id, buff2W, imgh, 0, headx + i2 * (iw + headW) - 18 + tempX, dy + 11 + (imgh + 2) * 2 + Tool.countTimes % 4 / 3 + tempY);
            }
            if (this.roleTeam[i2].attRound > 0) {
                Tool.drawTile(g2, this.img_buff, 0, buff1W, imgh, 0, headx + i2 * (iw + headW) - 18 + tempX, dy + 5);
                Tool.drawTile(g2, this.img_buff, buff2id, buff2W, imgh, 0, headx + i2 * (iw + headW) - 18 + tempX, dy + 11 + Tool.countTimes % 4 / 3 + tempY);
            }
            if (this.roleTeam[i2].defRound > 0) {
                Tool.drawTile(g2, this.img_buff, 1, buff1W, imgh, 0, headx + i2 * (iw + headW) - 18 + tempX, dy + 5 + (imgh + 2));
                Tool.drawTile(g2, this.img_buff, buff2id, buff2W, imgh, 0, headx + i2 * (iw + headW) - 18 + tempX, dy + (imgh + 2) + 11 + Tool.countTimes % 4 / 3 + tempY);
            }
            if (this.roleTeam[i2].critRound <= 0) continue;
            Tool.drawTile(g2, this.img_buff, 3, buff1W, imgh, 0, headx + i2 * (iw + headW) - 18 + tempX, dy + 5 + (imgh + 2) * 3);
            Tool.drawTile(g2, this.img_buff, buff2id, buff2W, imgh, 0, headx + i2 * (iw + headW) - 18 + tempX, dy + (imgh + 2) * 3 + 11 + Tool.countTimes % 4 / 3 + tempY);
        }
    }

    public void drawUiRect(Graphics g2, int x2, int y2, int w2, int[] colour) {
        g2.setColor(colour[0]);
        g2.fillRect(x2, y2, w2, 1);
        g2.setColor(colour[1]);
        g2.fillRect(x2, y2 + 1, w2, 1);
    }

    private void drawRoleUI_Small(Graphics g2) {
        Common.setUIClip(g2);
        int headW = 65;
        int headH = 67;
        int iw = (gameWidth - 3 * headW) / 3;
        int hpW = 43;
        int drawX = (gameWidth - 3 * headW) / 4 + 7;
        for (int i2 = 0; i2 < this.roleTeam.length; ++i2) {
            int mpLegth;
            int hpLegth;
            Common.setUIClip(g2);
            Tool.drawImage(g2, this.img_head[i2], 43 + i2 * headW, gameHeight - headH, 0);
            int hp = this.roleTeam[i2].hp;
            int hpMax = this.roleTeam[i2].hpMax;
            int mp = this.roleTeam[i2].mp;
            int mpMax = this.roleTeam[i2].mpMax;
            if (this.roleTeam[i2].type == 0) {
                this.drawUiRectSmall(g2, drawX + i2 * (iw + headW) + 4, gameHeight - headH + 67 - 28, hp * hpW / hpMax, ROLE_HP_COLOUR);
                this.drawUiRectSmall(g2, drawX + i2 * (iw + headW) + 4, gameHeight - headH + 74 - 28, mp * hpW / mpMax, ROLE_MP_COLOUR);
                Tool.drawImage(g2, this.img_xiegang_w, drawX + i2 * (iw + headW) + hpW / 2 + 2, gameHeight - headH + 62 - 28, 0);
                Tool.drawImage(g2, this.img_xiegang_w, drawX + i2 * (iw + headW) + hpW / 2 + 2, gameHeight - headH + 69 - 28, 0);
                Tool.drawImage(g2, this.img_xiegang_w, drawX + i2 * (iw + headW) + hpW / 2 + 2, gameHeight - headH + 77 - 28, 0);
                hpLegth = ("" + hp).length() * 6 - (("" + hp).length() - 1);
                GameMenu.drawImageNum(g2, this.img_num_w, hp, drawX + i2 * (iw + headW) + hpW / 2 + 2 - hpLegth, gameHeight - headH + 62 - 28);
                GameMenu.drawImageNum(g2, this.img_num_w, hpMax, drawX + i2 * (iw + headW) + hpW / 2 + 7, gameHeight - headH + 62 - 28);
                mpLegth = ("" + mp).length() * 6 - (("" + mp).length() - 1);
                GameMenu.drawImageNum(g2, this.img_num_w, mp, drawX + i2 * (iw + headW) + hpW / 2 + 2 - mpLegth, gameHeight - headH + 69 - 28);
                GameMenu.drawImageNum(g2, this.img_num_w, mpMax, drawX + i2 * (iw + headW) + hpW / 2 + 7, gameHeight - headH + 69 - 28);
                continue;
            }
            if (this.roleTeam[i2].type != 2) continue;
            this.drawUiRectSmall(g2, drawX + i2 * (iw + headW) + 4, gameHeight - headH + 67 - 28, hp * hpW / hpMax, ROLE_HP_COLOUR);
            Tool.drawImage(g2, this.img_xiegang_w, drawX + i2 * (iw + headW) + hpW / 2 + 2, gameHeight - headH + 62 - 28, 0);
            Tool.drawImage(g2, this.img_xiegang_w, drawX + i2 * (iw + headW) + hpW / 2 + 2, gameHeight - headH + 69 - 28, 0);
            Tool.drawImage(g2, this.img_xiegang_w, drawX + i2 * (iw + headW) + hpW / 2 + 2, gameHeight - headH + 77 - 28, 0);
            hpLegth = ("" + hp).length() * 6 - (("" + hp).length() - 1);
            GameMenu.drawImageNum(g2, this.img_num_w, hp, drawX + i2 * (iw + headW) + hpW / 2 + 2 - hpLegth, gameHeight - headH + 62 - 28);
            GameMenu.drawImageNum(g2, this.img_num_w, hpMax, drawX + i2 * (iw + headW) + hpW / 2 + 7, gameHeight - headH + 62 - 28);
            mpLegth = ("" + mp).length() * 6 - (("" + mp).length() - 1);
            GameMenu.drawImageNum(g2, this.img_num_w, mp, drawX + i2 * (iw + headW) + hpW / 2 + 2 - mpLegth, gameHeight - headH + 69 - 28);
            GameMenu.drawImageNum(g2, this.img_num_w, mpMax, drawX + i2 * (iw + headW) + hpW / 2 + 7, gameHeight - headH + 69 - 28);
        }
    }

    public void drawUiRectSmall(Graphics g2, int x2, int y2, int w2, int[] colour) {
        g2.setColor(colour[0]);
        g2.fillRect(x2 + 1, y2, w2 - 2, 1);
        g2.setColor(colour[1]);
        g2.fillRect(x2, y2 + 1, w2, 1);
    }

    private void drawSelectTarget(Graphics g2) {
        if (this.aimSprite == null) {
            return;
        }
        int[] arr = new int[]{0, 0, 1, 1};
        Common.setUIClip(g2);
        int fw = 14;
        int fh = 27;
        for (int i2 = 0; i2 < this.aimSprite.length; ++i2) {
            if (!this.aimSprite[i2].bOptfor) continue;
            Tool.drawTile(g2, this.img_targetIcon, arr[Tool.countTimes % 4], fw, fh, 0, this.aimSprite[i2].finalPosX, this.aimSprite[i2].finalPosY - (this.aimSprite[i2].actionSet.frameDatas[0].bodyRect.height + 25));
        }
    }

    private void drawSkill(Graphics g2, int x2, int y2) {
        Common.setUIClip(g2);
        g2.setColor(4270867);
        g2.fillRect(x2, y2, uiWidth, uiHeight);
        int ih = 122;
        GameMenu.drawBlueRect(g2, x2 + 1, y2 + 16, uiWidth - 2, ih);
        GameMenu.drawBlueRect(g2, x2 + 1, y2 + 16 + ih, uiWidth - 2, uiHeight - ih - 16);
        int skH = 116;
        GameMenu.drawBlueBlackRect(g2, x2 + 3, y2 + 16 + 2, uiWidth - 6, skH);
        this.itemDescribe.draw(g2, x2 + 3, y2 + 16 + ih + 3);
        int hpBackW = 91;
        int hpw = 89;
        int mpw = 89;
        Common.setUIClip(g2);
        g2.setColor(398111);
        g2.fillRect(x2 + 43, y2 + 16 + 13, hpBackW, 5);
        if (this.subState == 3) {
            GameMenu.drawMpRect(g2, x2 + 44, y2 + 16 + 14, Fight2.activateRole.mp * mpw / Fight2.activateRole.mpMax);
            int mpLenght = ("" + Fight2.activateRole.mp).length() * 5;
            GameMenu.drawImageNum(g2, this.img_num_w, Fight2.activateRole.mp, x2 + 43 + mpw / 2 - mpLenght - 1, y2 + 16 + 9);
            Tool.drawImage(g2, this.img_xiegang_w, x2 + 43 + mpw / 2 + 1, y2 + 16 + 9, 0);
            GameMenu.drawImageNum(g2, this.img_num_w, Fight2.activateRole.mpMax, x2 + 43 + mpw / 2 + 2 + this.img_xiegang_w.getWidth(), y2 + 16 + 9);
        } else {
            int spw = Game.bag.yuanShen * mpw / 20000;
            if (spw > mpw) {
                spw = mpw;
            }
            GameMenu.drawSpRect(g2, x2 + 44, y2 + 16 + 14, spw);
            int mpLenght = ("" + Game.bag.yuanShen).length() * 5;
            GameMenu.drawImageNum(g2, this.img_num_w, Game.bag.yuanShen, x2 + (uiWidth - mpLenght) / 2, y2 + 16 + 9);
        }
        Common.setUIClip(g2);
        int iw = 150;
        ih = 15;
        for (int i2 = 0; i2 < 5; ++i2) {
            GameMenu.drawBlackRect(g2, x2 + 6, y2 + 16 + 27 + i2 * (ih + 1), iw, ih);
        }
        if (this.skillList != null) {
            Vector<SkillData> skills = null;
            if (this.subState == 3) {
                skills = Fight2.activateRole.player.mp_skill;
            } else if (this.subState == 4) {
                if (Fight2.activateRole.type == 0) {
                    skills = Fight2.activateRole.player.sp_skill;
                } else if (Fight2.activateRole.type == 2) {
                    skills = new Vector<SkillData>();
                    short angerID = Fight2.activateRole.rEquip.angerID;
                    skills.addElement(Game.skillDatas[angerID]);
                }
            }
            for (int i3 = 0; i3 < this.skillList.getItemNumShown(); ++i3) {
                int index = i3 + this.skillList.getFirstIndexShown();
                SkillData skData = (SkillData)skills.elementAt(index);
                Tool.drawTile(g2, this.img_skillIcon, skData.iconID, 12, 12, 0, x2 + 8, y2 + 16 + 29 + i3 * (ih + 1));
            }
            int[] fomat = new int[]{16711500, 0, 1};
            int[] focusFomat = new int[]{0xFF0000, 0, 1};
            this.skillList.draw(g2, x2 + 35, y2 + 16 + 27, fomat, focusFomat, (byte)1);
            int barH = 79;
            int skillRow = 0;
            skillRow = this.skillList.getItemNum() - 1;
            if (skillRow == 0) {
                skillRow = 1;
            }
            this.drawScrollBar(g2, x2 + 160, y2 + 16 + 27, barH, skillRow, this.skillList.getFocusIndex());
        }
        Common.setUIClip(g2);
        if (this.subState == 4) {
            Tool.drawImage(g2, this.img_menuNameBack, x2 + (uiWidth - this.img_menuNameBack.getWidth()) / 2, y2 - 8, 0);
            this.titleAs.drawFrame(g2, 15, x2 + uiWidth / 2 + 5, y2 + 5, false);
        } else {
            Tool.drawImage(g2, this.img_menuNameBack, x2 + (uiWidth - this.img_menuNameBack.getWidth()) / 2, y2 - 8, 0);
            this.titleAs.drawFrame(g2, 15, x2 + uiWidth / 2 + 5, y2 + 5, false);
        }
    }

    public void drawItem(Graphics g2, int x2, int y2) {
        Common.setUIClip(g2);
        g2.setColor(4270867);
        g2.fillRect(x2, y2, uiWidth, uiHeight);
        int ih = 135;
        GameMenu.drawBlueRect(g2, x2 + 1, y2 + 16, uiWidth - 2, ih);
        GameMenu.drawBlueRect(g2, x2 + 1, y2 + 16 + ih, uiWidth - 2, uiHeight - ih - 16);
        ih = 127;
        GameMenu.drawBlueBlackRect(g2, x2 + 3, y2 + 16 + 3, uiWidth - 6, ih);
        ih = 26;
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int j2 = 0; j2 < 5; ++j2) {
                Tool.drawImage(g2, this.img_itemBack, x2 + 17 + j2 * ih, y2 + 16 + 15 + i2 * ih, 0);
            }
        }
        int backW = this.img_itemBack.getWidth() + 2;
        for (int i3 = 0; i3 < this.items.size(); ++i3) {
            Item it = (Item)this.items.elementAt(i3);
            int cow = i3 % 5;
            int col = i3 / 5;
            int num = it.number;
            int numW = ("" + it.number).length() * 6 - (("" + it.number).length() - 1);
            if (this.itemPack.getFocusRow() > 3) {
                if (col < this.itemPack.getFocusRow() - 3 || col > this.itemPack.getFocusRow()) continue;
                this.drawItemIcon(g2, x2 + 18 + cow * backW, y2 - (this.itemPack.getFocusRow() - 3) * backW + 32 + col * backW, it.data.iconID, it.data.quality);
                Fight2.drawImageNum(g2, this.img_num_w, num, x2 + 18 + cow * backW + 22 - numW, y2 - (this.itemPack.getFocusRow() - 3) * backW + 32 + col * backW + 15);
                continue;
            }
            if (col >= 4) continue;
            this.drawItemIcon(g2, x2 + 18 + cow * backW, y2 + 32 + col * backW, it.data.iconID, it.data.quality);
            Fight2.drawImageNum(g2, this.img_num_w, num, x2 + 18 + cow * backW + 22 - numW, y2 + 32 + col * backW + 15);
        }
        int barH = 102;
        int skillRow = 0;
        skillRow = this.itemPack.getRow() + 1;
        if (skillRow == 0) {
            skillRow = 1;
        }
        this.drawScrollBar(g2, x2 + 153, y2 + 16 + 15, barH, skillRow, this.itemPack.getFocusRow());
        Common.setUIClip(g2);
        if (this.itemPack.getFocusRow() > 3) {
            this.drawSelectIcon(g2, x2 + 15 + this.itemPack.getFocusRank() * backW, y2 + 29 + 3 * backW, 28, 28);
        } else {
            this.drawSelectIcon(g2, x2 + 15 + this.itemPack.getFocusRank() * backW, y2 + 29 + this.itemPack.getFocusRow() * backW, 28, 28);
        }
        this.itemDescribe.draw(g2, x2 + 5, y2 + 16 + 136);
        Common.setUIClip(g2);
        Tool.drawImage(g2, this.img_menuNameBack, x2 + (uiWidth - this.img_menuNameBack.getWidth()) / 2, y2 - 8, 0);
        this.titleAs.drawFrame(g2, 17, x2 + uiWidth / 2, y2 + 5, false);
    }

    private void drawAgileBar(Graphics g2, int x2, int y2) {
        Common.setUIClip(g2);
        this.drawAgileBarBack(g2, x2, y2, 260);
        int fightIconW = this.img_fightIcon.getWidth() / 5;
        int fightIconH = this.img_fightIcon.getHeight();
        for (int i2 = 0; i2 < this.sprites.size(); ++i2) {
            FightSprite2 sprite = (FightSprite2)this.sprites.elementAt(this.hd_index[i2]);
            if (sprite.bDie) continue;
            if (sprite.headPosX > 224) {
                sprite.headPosX = 224;
            }
            Tool.drawTile(g2, this.img_fightIcon, sprite.headID, fightIconW, fightIconH, 0, x2 + sprite.headPosX - fightIconW / 2 + 14, y2 - fightIconH + 18);
        }
    }

    private void drawFightMenu(Graphics g2, int x2, int y2) {
        Common.setUIClip(g2);
        Tool.drawImage(g2, this.img_fightMenu, x2, y2, 0);
        int fw = 21;
        int fh = 11;
        int[] fightMenuX = new int[]{0, 0, 0, 0, 6, 6, 10};
        int[] fightMenuY = new int[]{-5, 0, 0, 0, 3, 3, 8};
        Tool.drawTile(g2, this.img_fightOption, Tool.countTimes % 3, fw, fh, 0, x2 + fightMenuX[Fight2.activateRole.order], y2 + 48 + Fight2.activateRole.order * 18 + fightMenuY[Fight2.activateRole.order]);
        Tool.drawTile(g2, this.img_fightOption, Tool.countTimes % 3, fw, fh, 2, x2 + 70 + fightMenuX[Fight2.activateRole.order], y2 + 48 + Fight2.activateRole.order * 18 + fightMenuY[Fight2.activateRole.order]);
    }

    private void drawAgileBarBack(Graphics g2, int x2, int y2, int w2) {
        g2.setColor(143976);
        g2.fillRect(x2 + 22, y2 + 5, w2 - 44, 1);
        g2.fillRect(x2 + 22, y2 + 12, w2 - 44, 1);
        g2.setColor(1039838);
        g2.fillRect(x2 + 22, y2 + 6, w2 - 44, 1);
        g2.fillRect(x2 + 22, y2 + 11, w2 - 44, 1);
        g2.setColor(96956);
        g2.fillRect(x2 + 22, y2 + 7, w2 - 44, 1);
        g2.fillRect(x2 + 22, y2 + 10, w2 - 44, 1);
        g2.setColor(143976);
        g2.fillRect(x2 + 22, y2 + 8, w2 - 44, 2);
        Tool.drawImage(g2, this.img_agileBack, x2, y2, 0);
        Tool.drawImage(g2, this.img_agileBack, x2 + w2 - 22, y2, 2);
    }

    public void drawDrop(Graphics g2, int x2, int y2) {
        Common.setUIClip(g2);
        Game.drawBgRect(g2, x2, y2, uiWidth, this.dropH + 12, true);
        this.dropList.draw(g2, x2 + 10, y2 + 10);
    }

    private void drawProcessBuff(Graphics g2) {
        for (int i2 = 0; i2 < this.sprites.size(); ++i2) {
            FightSprite2 sprite = (FightSprite2)this.sprites.elementAt(i2);
            if (sprite.bDie) continue;
            sprite.drawBuff(g2);
        }
    }

    public void drawItemIcon(Graphics g2, int x2, int y2, int equipId, int quality) {
        int width = this.img_itemIcon.getWidth() / 10;
        int height = this.img_itemIcon.getHeight();
        g2.setClip(x2, y2, width, height);
        Tool.drawTile(g2, this.img_itemIcon, equipId, width, height, 0, x2, y2);
        g2.setColor(QUALITY_COLOUR[quality]);
        g2.drawRoundRect(x2, y2, width - 1, height - 1, 2, 2);
    }

    public void drawSelectIcon(Graphics g2, int x2, int y2, int w2, int h2) {
        g2.setColor(16745472);
        g2.drawRect(x2, y2, w2 - 1, h2 - 1);
        g2.drawRect(x2 + 1, y2 + 1, w2 - 3, h2 - 3);
        Tool.drawImage(g2, this.img_selectIcon, x2 + w2 - 6, y2 + h2 - 6, 0);
    }

    private void setState(byte st) {
        this.state = st;
        System.out.println("\u3013\u3013 State= " + this.state + " \u3013\u3013");
    }

    private void setSubState(byte st) {
        this.subState = st;
        System.out.println("\u3013\u3013 SubState= " + this.subState + " \u3013\u3013");
    }

    private void cycleRoleSet() {
        switch (this.subState) {
            case 0: {
                if (!this.bPoison) {
                    this.poisonTime = 10;
                    if (Fight2.activateRole.poisonRound > 0) {
                        activateRole.poisonCycle();
                        this.poisonTime = 0;
                        this.bPoison = true;
                    }
                }
                ++this.poisonTime;
                activateRole.sleepCycle();
                if (this.poisonTime <= 10) break;
                Fight2.activateRole.poison_min = 0;
                Fight2.activateRole.poison_max = 0;
                this.upDataRoleDie();
                if (activateRole.isActivity()) {
                    this.setSubState((byte)1);
                    break;
                }
                if (activateRole.isAstrictBuffCycle() || activateRole.isDeformationCycle()) {
                    activateRole.initActivate();
                    this.setState((byte)2);
                    break;
                }
                if (Fight2.activateRole.disorderRound > 0) {
                    this.setRoleDisorder();
                    break;
                }
                if (Fight2.activateRole.bDie) {
                    if (this.isFightLose()) {
                        this.setFightLose();
                        break;
                    }
                    if (this.roleTeam.length <= 1 || this.isFightLose()) break;
                    this.setState((byte)2);
                    break;
                }
                this.setSubState((byte)1);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                this.itemDescribe.cycle();
                break;
            }
            case 5: {
                this.itemPack.cycle();
                this.itemDescribe.cycle();
                break;
            }
            case 6: {
                this.cycleRoleExeCuteOrder();
            }
        }
    }

    private void cyclePetSet() {
        switch (this.subState) {
            case 1: {
                this.rareEquipPet.act(5);
                this.setSubState((byte)2);
                break;
            }
            case 2: {
                this.petAI();
                break;
            }
            case 6: {
                if (!this.rareEquipPet.bAttackOver()) break;
                this.rareEquipPet.initActivate();
                this.upDataRoleDie();
                this.upDataEnemyDie();
                if (this.isFightWin()) {
                    this.setFightWin();
                    this.setState((byte)6);
                    break;
                }
                this.setState((byte)2);
            }
        }
    }

    private void setRoleDisorder() {
        int disorID = 0;
        for (int i2 = 0; i2 < this.roleTeam.length; ++i2) {
            if (activateRole != this.roleTeam[i2]) continue;
            disorID = i2;
            break;
        }
        if (this.roleTeam.length == 1 || this.getRoleTeamActive() == 1) {
            activateRole.initActivate();
            this.setState((byte)2);
        } else {
            this.aimSprite = new FightSprite2[1];
            while (true) {
                int tarID;
                if (disorID == (tarID = Tool.getNextRnd(0, this.roleTeam.length))) {
                    continue;
                }
                this.aimSprite[0] = this.roleTeam[tarID];
                if (!this.aimSprite[0].bDie) break;
            }
            activateRole.setTarget(this.aimSprite);
            activateRole.act(2);
            this.setSubState((byte)6);
        }
    }

    private void cycleEnemySet() {
        switch (this.subState) {
            case 0: {
                if (!this.bPoison) {
                    this.poisonTime = 10;
                    if (Fight2.activateEnemy.poisonRound > 0) {
                        activateEnemy.poisonCycle();
                        this.poisonTime = 0;
                        this.bPoison = true;
                    }
                }
                ++this.poisonTime;
                this.upDataEnemyDie();
                if (this.poisonTime <= 10) break;
                if (activateEnemy.isActivity()) {
                    this.setSubState((byte)1);
                    break;
                }
                if (activateEnemy.isAstrictBuffCycle() || activateEnemy.isDeformationCycle()) {
                    activateEnemy.initActivate();
                    this.setState((byte)2);
                    break;
                }
                if (Fight2.activateEnemy.disorderRound > 0) {
                    this.setEnemyDisorder();
                    break;
                }
                if (this.isFightWin()) {
                    this.setFightWin();
                    this.setState((byte)6);
                    break;
                }
                if (Fight2.activateEnemy.bDie) {
                    this.setState((byte)2);
                    break;
                }
                this.setSubState((byte)1);
                break;
            }
            case 1: {
                this.processEnemyAI(activateEnemy);
                break;
            }
            case 6: {
                this.cycleEnemyExeCuteOrder();
            }
        }
    }

    private void setEnemyDisorder() {
        int disorID = 0;
        for (int i2 = 0; i2 < this.enemyTeam.length; ++i2) {
            if (activateEnemy != this.enemyTeam[i2]) continue;
            disorID = i2;
            break;
        }
        if (this.enemyTeam.length == 1 || Fight2.activateEnemy.bDie || this.getEnemyTeamActive() <= 1) {
            activateEnemy.initActivate();
            this.setState((byte)2);
        } else {
            this.aimSprite = new FightSprite2[1];
            while (true) {
                int tarID;
                if (disorID == (tarID = Tool.getNextRnd(0, this.enemyTeam.length))) {
                    continue;
                }
                this.aimSprite[0] = this.enemyTeam[tarID];
                if (!this.aimSprite[0].bDie) break;
            }
            Fight2.activateEnemy.order = 1;
            activateEnemy.setTarget(this.aimSprite);
            activateEnemy.act(2);
            this.setSubState((byte)6);
        }
    }

    private FightSprite2[] getAimRoleSet(int param, int num) {
        if (num < 1) {
            num = 1;
        }
        FightSprite2[] enemy = null;
        System.err.println("num:" + num);
        switch (param) {
            case 1: {
                if (num >= this.enemyTeam.length) {
                    for (int i2 = 0; i2 < this.enemyTeam.length; ++i2) {
                        this.enemyTeam[i2].setOptfor();
                    }
                    return this.enemyTeam;
                }
                if (num == 1) {
                    this.enemyTeam[this.selectTarIndex].setOptfor();
                    enemy = new FightSprite2[num];
                    enemy[0] = this.enemyTeam[this.selectTarIndex];
                } else {
                    enemy = new FightSprite2[num];
                    for (int i3 = 0; i3 < this.selectTarList.length; ++i3) {
                        this.enemyTeam[this.selectTarList[i3]].setOptfor();
                        enemy[i3] = this.enemyTeam[this.selectTarList[i3]];
                    }
                }
                return enemy;
            }
            case 0: 
            case 2: {
                if (this.fightSkill.type == 0 || this.fightSkill.type == 2) {
                    if (num >= this.enemyTeam.length) {
                        for (int i4 = 0; i4 < this.enemyTeam.length; ++i4) {
                            this.enemyTeam[i4].setOptfor();
                        }
                        return this.enemyTeam;
                    }
                    if (num == 1) {
                        this.enemyTeam[this.selectTarIndex].setOptfor();
                        enemy = new FightSprite2[num];
                        enemy[0] = this.enemyTeam[this.selectTarIndex];
                    } else {
                        enemy = new FightSprite2[num];
                        for (int i5 = 0; i5 < this.selectTarList.length; ++i5) {
                            this.enemyTeam[this.selectTarList[i5]].setOptfor();
                            enemy[i5] = this.enemyTeam[this.selectTarList[i5]];
                        }
                    }
                    return enemy;
                }
                if (num >= this.roleTeam.length) {
                    for (int i6 = 0; i6 < this.roleTeam.length; ++i6) {
                        this.roleTeam[i6].setOptfor();
                    }
                    return this.roleTeam;
                }
                if (num == 1) {
                    this.roleTeam[this.selectTarIndex].setOptfor();
                    enemy = new FightSprite2[num];
                    enemy[0] = this.roleTeam[this.selectTarIndex];
                } else {
                    enemy = new FightSprite2[num];
                    for (int i7 = 0; i7 < this.selectTarList.length; ++i7) {
                        this.roleTeam[this.selectTarList[i7]].setOptfor();
                        enemy[i7] = this.roleTeam[this.selectTarList[i7]];
                    }
                }
                return enemy;
            }
            case 3: {
                this.roleTeam[this.selectTarIndex].setOptfor();
                enemy = new FightSprite2[num];
                enemy[0] = this.roleTeam[this.selectTarIndex];
                return enemy;
            }
        }
        return null;
    }

    private FightSprite2[] getAimEnemySet(int param) {
        FightSprite2[] enemy = null;
        switch (param) {
            case 1: {
                enemy = new FightSprite2[1];
                do {
                    int getRoleID = Tool.getNextRnd(0, this.roleTeam.length);
                    enemy[0] = this.roleTeam[getRoleID];
                } while (enemy[0].bDie);
                return enemy;
            }
        }
        return null;
    }

    private void detectionEnemyIndex(boolean bUp) {
        if (activateRole == null) {
            return;
        }
        if (bUp) {
            while (true) {
                if (this.selectTarIndex < 0) {
                    this.selectTarIndex = this.enemyTeam.length - 1;
                }
                if (this.enemyTeam[this.selectTarIndex].bDie) {
                    --this.selectTarIndex;
                    continue;
                }
                break;
            }
        } else {
            while (true) {
                if (this.selectTarIndex >= this.enemyTeam.length) {
                    this.selectTarIndex = 0;
                }
                if (!this.enemyTeam[this.selectTarIndex].bDie) break;
                ++this.selectTarIndex;
            }
        }
    }

    private void detectionRoleIndex(boolean bUp) {
        if (activateRole == null) {
            return;
        }
        if (bUp) {
            while (true) {
                if (this.selectTarIndex < 0) {
                    this.selectTarIndex = this.roleTeam.length - 1;
                }
                if (this.roleTeam[this.selectTarIndex].bDie) {
                    --this.selectTarIndex;
                    continue;
                }
                break;
            }
        } else {
            while (true) {
                if (this.selectTarIndex >= this.roleTeam.length) {
                    this.selectTarIndex = 0;
                }
                if (!this.roleTeam[this.selectTarIndex].bDie) break;
                ++this.selectTarIndex;
            }
        }
    }

    private void detectionEnemyList(boolean bUp) {
        int counter;
        if (bUp) {
            int counter2;
            do {
                int i2;
                counter2 = 0;
                for (i2 = 0; i2 < this.selectTarList.length; ++i2) {
                    if (this.selectTarList[i2] < 0) {
                        this.selectTarList[i2] = this.enemyTeam.length - 1;
                    }
                    if (this.enemyTeam[this.selectTarList[i2]].bDie) {
                        int n2 = i2;
                        this.selectTarList[n2] = this.selectTarList[n2] - 1;
                    }
                    for (int j2 = 0; j2 < this.selectTarList.length - 1; ++j2) {
                        if (this.selectTarList[j2 + 1] != this.selectTarList[j2]) continue;
                        int n3 = j2;
                        this.selectTarList[n3] = this.selectTarList[n3] - 1;
                    }
                }
                for (i2 = 0; i2 < this.selectTarList.length; ++i2) {
                    if (this.selectTarList[i2] < 0 || this.enemyTeam[this.selectTarList[i2]].bDie) continue;
                    ++counter2;
                }
            } while (counter2 < this.selectTarList.length);
            return;
        }
        do {
            int i3;
            counter = 0;
            for (i3 = 0; i3 < this.selectTarList.length; ++i3) {
                if (this.selectTarList[i3] >= this.enemyTeam.length) {
                    this.selectTarList[i3] = 0;
                }
                if (this.enemyTeam[this.selectTarList[i3]].bDie) {
                    int n4 = i3;
                    this.selectTarList[n4] = this.selectTarList[n4] + 1;
                }
                for (int j3 = 0; j3 < this.selectTarList.length - 1; ++j3) {
                    if (this.selectTarList[j3 + 1] != this.selectTarList[j3]) continue;
                    int n5 = j3 + 1;
                    this.selectTarList[n5] = this.selectTarList[n5] + 1;
                }
            }
            for (i3 = 0; i3 < this.selectTarList.length; ++i3) {
                if (this.selectTarList[i3] >= this.enemyTeam.length || this.enemyTeam[this.selectTarList[i3]].bDie) continue;
                ++counter;
            }
        } while (counter < this.selectTarList.length);
    }

    private void detectionRoleList(boolean bUp) {
        int counter;
        if (bUp) {
            int counter2;
            do {
                int i2;
                counter2 = 0;
                for (i2 = 0; i2 < this.selectTarList.length; ++i2) {
                    if (this.selectTarList[i2] < 0) {
                        this.selectTarList[i2] = this.roleTeam.length - 1;
                    }
                    if (this.roleTeam[this.selectTarList[i2]].bDie) {
                        int n2 = i2;
                        this.selectTarList[n2] = this.selectTarList[n2] - 1;
                    }
                    for (int j2 = 0; j2 < this.selectTarList.length - 1; ++j2) {
                        if (this.selectTarList[j2 + 1] != this.selectTarList[j2]) continue;
                        int n3 = j2;
                        this.selectTarList[n3] = this.selectTarList[n3] - 1;
                    }
                }
                for (i2 = 0; i2 < this.selectTarList.length; ++i2) {
                    if (this.selectTarList[i2] < 0 || this.roleTeam[this.selectTarList[i2]].bDie) continue;
                    ++counter2;
                }
            } while (counter2 < this.selectTarList.length);
            return;
        }
        do {
            int i3;
            counter = 0;
            for (i3 = 0; i3 < this.selectTarList.length; ++i3) {
                if (this.selectTarList[i3] >= this.roleTeam.length) {
                    this.selectTarList[i3] = 0;
                }
                if (this.roleTeam[this.selectTarList[i3]].bDie) {
                    int n4 = i3;
                    this.selectTarList[n4] = this.selectTarList[n4] + 1;
                }
                for (int j3 = 0; j3 < this.selectTarList.length - 1; ++j3) {
                    if (this.selectTarList[j3 + 1] != this.selectTarList[j3]) continue;
                    int n5 = j3 + 1;
                    this.selectTarList[n5] = this.selectTarList[n5] + 1;
                }
            }
            for (i3 = 0; i3 < this.selectTarList.length; ++i3) {
                if (this.selectTarList[i3] >= this.roleTeam.length || this.roleTeam[this.selectTarList[i3]].bDie) continue;
                ++counter;
            }
        } while (counter < this.selectTarList.length);
    }

    private void setheadRand() {
        int i2;
        int[] enemyHeadRand = new int[5];
        int[] roleHeadRand = new int[5];
        for (int i3 = 0; i3 < enemyHeadRand.length; ++i3) {
            enemyHeadRand[i3] = i3 * 10;
            roleHeadRand[i3] = i3 * 10 + 50;
        }
        int enemyTime = 0;
        for (int i4 = 0; i4 < enemyHeadRand.length; ++i4) {
            int id = Tool.getNextRnd(0, enemyHeadRand.length - 1 - enemyTime);
            int temp = enemyHeadRand[id];
            enemyHeadRand[id] = enemyHeadRand[i4];
            enemyHeadRand[i4] = temp;
            ++enemyTime;
        }
        int roleTime = 0;
        for (i2 = 0; i2 < roleHeadRand.length; ++i2) {
            int id = Tool.getNextRnd(0, roleHeadRand.length - 1 - roleTime);
            int temp = roleHeadRand[id];
            roleHeadRand[id] = roleHeadRand[i2];
            roleHeadRand[i2] = temp;
            ++roleTime;
        }
        for (i2 = 0; i2 < this.enemyTeam.length; ++i2) {
            this.enemyTeam[i2].curAttackTime = enemyHeadRand[i2];
        }
        for (i2 = 0; i2 < this.roleTeam.length; ++i2) {
            this.roleTeam[i2].curAttackTime = roleHeadRand[i2];
        }
    }

    private void setTarList(int val) {
        int i2 = 0;
        while (i2 < this.selectTarList.length) {
            int n2 = i2++;
            this.selectTarList[n2] = this.selectTarList[n2] + val;
        }
    }

    private void getFocusSkill(int index) {
        this.fightSkill = (SkillData)Fight2.activateRole.player.mp_skill.elementAt(index);
    }

    private void getFocusSp(int index) {
        if (Fight2.activateRole.type == 0) {
            this.fightSkill = (SkillData)Fight2.activateRole.player.sp_skill.elementAt(index);
        } else if (Fight2.activateRole.type == 2) {
            short angerID = Fight2.activateRole.rEquip.angerID;
            this.fightSkill = Game.skillDatas[angerID];
        }
    }

    public void fightOver() {
        this.noFlee = false;
        this.fleeTime = 0;
        this.useItemTime = 0;
        this.screenPrompt = null;
        this.bFightOver = true;
        this.fightSkill = null;
        this.skillList = null;
        Game.bdrawFight = false;
        FightSprite2.tortoiseAs = null;
        shakeX = 0;
        shakeY = 0;
        for (int i2 = 0; i2 < this.roleTeam.length; ++i2) {
            FightSprite2 sprite = this.roleTeam[i2];
            if (sprite.type == 2) continue;
            sprite.player.sp_skill.removeAllElements();
            sprite.player.mp_skill.removeAllElements();
        }
        this.roleTeam = null;
        this.enemyTeam = null;
        this.aimSprite = null;
        this.roleSet = null;
        this.enemySet = null;
        activateRole = null;
        activateEnemy = null;
        this.rareEquipPet = null;
        this.petCoord = null;
        this.roleCoord = null;
        this.enemyCoord = null;
        this.sp_PosY = null;
        this.sp_index = null;
        this.hd_PosX = null;
        this.hd_index = null;
        this.sprites.removeAllElements();
        this.dropItem.removeAllElements();
        this.dropEquip.removeAllElements();
        this.dropList = null;
        Fight2.clearnShowNum();
        resCacheFight.clear();
        this.clearRes();
    }

    public static void setShowNum(byte type, int num, FightSprite2 sprite) {
        Fight2.smType[Fight2.smID] = type;
        Fight2.smDps[Fight2.smID] = num;
        switch (smType[smID]) {
            case 1: {
                Fight2.smCounter[Fight2.smID] = 17;
                Fight2.smVX[Fight2.smID] = Tool.getNextRnd(-4, 4);
                Fight2.smVY[Fight2.smID] = 12;
                Fight2.smGravity[Fight2.smID] = 1;
                Fight2.smX[Fight2.smID] = sprite.finalPosX;
                Fight2.smY[Fight2.smID] = sprite.finalPosY;
                Fight2.smAlpha[Fight2.smID] = 255;
                break;
            }
            case 2: {
                Fight2.smCounter[Fight2.smID] = 10;
                Fight2.smVX[Fight2.smID] = 0;
                Fight2.smVY[Fight2.smID] = 20;
                Fight2.smGravity[Fight2.smID] = 3;
                Fight2.smX[Fight2.smID] = sprite.finalPosX;
                Fight2.smY[Fight2.smID] = sprite.finalPosY;
                Fight2.smAlpha[Fight2.smID] = 255;
                break;
            }
            case 3: {
                Fight2.smCounter[Fight2.smID] = 10;
                Fight2.smVX[Fight2.smID] = 0;
                Fight2.smVY[Fight2.smID] = 20;
                Fight2.smGravity[Fight2.smID] = 3;
                Fight2.smX[Fight2.smID] = sprite.finalPosX;
                Fight2.smY[Fight2.smID] = sprite.finalPosY - 15;
                Fight2.smAlpha[Fight2.smID] = 255;
                break;
            }
            case 4: {
                Fight2.smCounter[Fight2.smID] = 10;
                Fight2.smVX[Fight2.smID] = 0;
                Fight2.smVY[Fight2.smID] = 20;
                Fight2.smGravity[Fight2.smID] = 3;
                Fight2.smX[Fight2.smID] = sprite.finalPosX;
                Fight2.smY[Fight2.smID] = sprite.finalPosY - 15;
            }
        }
        smDir = sprite.faceDir;
        if (smID < smType.length - 1) {
            smID = (byte)(smID + 1);
        }
    }

    public static void cycleShowNum() {
        for (int i2 = 0; i2 < smCounter.length; ++i2) {
            if (smCounter[i2] > 0) {
                int n2 = i2;
                smCounter[n2] = smCounter[n2] - 1;
                if (smDir == 1) {
                    int n3 = i2;
                    smX[n3] = smX[n3] + smVX[i2];
                } else {
                    int n4 = i2;
                    smX[n4] = smX[n4] - smVX[i2];
                }
                int n5 = i2;
                smVY[n5] = smVY[n5] - smGravity[i2];
                int n6 = i2;
                smY[n6] = smY[n6] - smVY[i2];
                if (smAlpha[i2] > 0) {
                    int n7 = i2;
                    smAlpha[n7] = smAlpha[n7] - 10;
                    continue;
                }
                Fight2.smAlpha[i2] = 0;
                continue;
            }
            Fight2.smCounter[i2] = 0;
            Fight2.smType[i2] = 0;
        }
        if (smID > 0 && smCounter[smID - 1] <= 0) {
            smID = 0;
        }
    }

    public static void clearnShowNum() {
        for (int i2 = 0; i2 < smType.length; ++i2) {
            Fight2.smType[i2] = 0;
            Fight2.smCounter[i2] = 0;
            Fight2.smX[i2] = 0;
            Fight2.smY[i2] = 0;
            Fight2.smVX[i2] = 0;
            Fight2.smVY[i2] = 0;
            Fight2.smGravity[i2] = 0;
            Fight2.smAlpha[i2] = 0;
            Fight2.smDps[i2] = 0;
            smDir = 0;
            smID = 0;
        }
    }

    public static void drawShowNum(Graphics g2) {
        block6: for (int i2 = 0; i2 < smCounter.length; ++i2) {
            if (smCounter[i2] <= 0) continue;
            switch (smType[i2]) {
                case 1: {
                    Tool.drawImageNum(g2, img_bloodNum, "" + smDps[i2], smX[i2], smY[i2], img_bloodNum.getWidth() / 10, 0, smAlpha[i2]);
                    continue block6;
                }
                case 2: {
                    Tool.drawImageNum(g2, img_hpNum, "" + smDps[i2], smX[i2], smY[i2], img_bloodNum.getWidth() / 10, 0, smAlpha[i2]);
                    continue block6;
                }
                case 3: {
                    Tool.drawImageNum(g2, img_mpNum, "" + smDps[i2], smX[i2], smY[i2], img_bloodNum.getWidth() / 10, 0, smAlpha[i2]);
                    continue block6;
                }
                case 4: {
                    Common.setUIClip(g2);
                    Tool.drawImage(g2, img_critFont, smX[i2], smY[i2], 0);
                    Tool.drawImageNum(g2, img_critNum, "" + smDps[i2], smX[i2] + img_critFont.getWidth() + 5, smY[i2], img_critNum.getWidth() / 10, 0);
                }
            }
        }
    }

    public void drawScrollBarBack(Graphics g2, int x2, int y2, int h2) {
        Common.setUIClip(g2);
        int iw = this.img_scrollBar.getWidth();
        int ih = this.img_scrollBar.getHeight();
        g2.setColor(6455);
        g2.fillRect(x2, y2, iw, h2);
        g2.setColor(866922);
        g2.fillRect(x2 + 1, y2 + ih + 1, iw - 2, h2 - 2 - ih * 2);
        Tool.drawImage(g2, this.img_scrollBar, x2, y2, 0);
        Tool.drawImage(g2, this.img_scrollBar, x2, y2 + h2 - ih, 1);
    }

    private void drawScrollBar(Graphics g2, int x2, int y2, int height, int allRow, int focus) {
        this.drawScrollBarBack(g2, x2, y2, height);
        int ih = (height - 16) / allRow;
        int drawY = y2 + 7 + focus * ih;
        if (drawY > y2 + height - 13) {
            drawY = y2 + height - 13;
        }
        Common.setUIClip(g2);
        int rectH = 6;
        this.drawStrokeRect(g2, x2 + 1, drawY, 4, rectH, RECT_STYLR_YELLOW);
    }

    public void drawStrokeRect(Graphics g2, int x2, int y2, int width, int height, int[] style) {
        g2.setColor(style[0]);
        g2.fillRect(x2, y2, width, height);
        g2.setColor(style[1]);
        g2.fillRect(x2 + 1, y2 + 1, width - 2, height - 2);
    }

    public static void setFillScreen(byte type, int colour) {
        switch (type) {
            case 0: {
                topFillType = 0;
                downFillType = 0;
                break;
            }
            case 1: 
            case 2: {
                topFillType = type;
                downFillType = type;
                screenColour = colour;
                break;
            }
            case 3: {
                shakeX = 0;
                shakeY = 0;
                shakeTime = (byte)4;
                break;
            }
            case 4: {
                shineType = type;
                shineTime = (byte)4;
            }
        }
    }

    public static void cycleFillScreen() {
        if (shakeTime > 0) {
            shakeY += shakeVale[Tool.countTimes % 3];
            shakeTime = (byte)(shakeTime - 1);
        } else {
            shakeY = 0;
        }
        if (shineTime > 0) {
            shineTime = (byte)(shineTime - 1);
        }
    }

    public void drawFillScreenDown(Graphics g2) {
        if (downFillType == 1) {
            Common.setUIClip(g2);
            g2.setColor(screenColour);
            g2.fillRect(0, 0, gameWidth, gameHeight);
        }
    }

    public void drawFillScreenTop(Graphics g2) {
        if (topFillType == 2) {
            Common.setUIClip(g2);
            g2.setColor(screenColour);
            g2.fillRect(0, 0, gameWidth, gameHeight);
        }
        if (shineType == 4) {
            int width = this.img_screenShine.getWidth();
            int height = this.img_screenShine.getHeight();
            if (shineTime % 4 == 2) {
                Tool.drawRegion(g2, this.img_screenShine, 0, 0, width, height, 0, 0, 0);
                Tool.drawRegion(g2, this.img_screenShine, 0, 0, width, height, 2, gameWidth - width, 0);
                Tool.drawRegion(g2, this.img_screenShine, 0, 0, width, height, 3, gameWidth - width, gameHeight - height);
                Tool.drawRegion(g2, this.img_screenShine, 0, 0, width, height, 1, 0, gameHeight - height);
            }
        }
    }

    public static void drawImageNum(Graphics g2, Image img, int num, int x2, int y2) {
        int numW = img.getWidth() / 10;
        Tool.drawImageNum(g2, img, "" + num, x2, y2, numW, -1);
    }

    private byte select(byte poiVaule, int max, int offset) {
        poiVaule = (byte)(poiVaule + offset);
        if (offset < 0) {
            if (poiVaule < 0) {
                poiVaule = (byte)max;
            }
        } else if (poiVaule > max) {
            poiVaule = 0;
        }
        return poiVaule;
    }

    private void quickSort(int[] data, int[] index) {
        for (int i2 = 0; i2 < data.length; ++i2) {
            for (int j2 = 0; j2 < data.length - 1; ++j2) {
                if (data[j2] <= data[j2 + 1]) continue;
                data[j2] = data[j2] + data[j2 + 1];
                data[j2 + 1] = data[j2] - data[j2 + 1];
                data[j2] = data[j2] - data[j2 + 1];
                index[j2] = index[j2] + index[j2 + 1];
                index[j2 + 1] = index[j2] - index[j2 + 1];
                index[j2] = index[j2] - index[j2 + 1];
            }
        }
        this.sp_index = index;
    }

    private void quickSortHead(int[] data, int[] index) {
        for (int i2 = 0; i2 < data.length; ++i2) {
            for (int j2 = 0; j2 < data.length - 1; ++j2) {
                if (data[j2] <= data[j2 + 1]) continue;
                data[j2] = data[j2] + data[j2 + 1];
                data[j2 + 1] = data[j2] - data[j2 + 1];
                data[j2] = data[j2] - data[j2 + 1];
                index[j2] = index[j2] + index[j2 + 1];
                index[j2 + 1] = index[j2] - index[j2 + 1];
                index[j2] = index[j2] - index[j2 + 1];
            }
        }
        this.hd_index = index;
    }

    static {
        resCacheFight = new Hashtable();
        skill = new FightSkill2();
        shakeVale = new int[]{2, -2, 2, -2};
        smType = new int[20];
        smCounter = new int[20];
        smX = new int[20];
        smY = new int[20];
        smVX = new int[20];
        smVY = new int[20];
        smGravity = new int[20];
        smAlpha = new int[20];
        smDps = new int[20];
        smDir = 0;
        smID = 0;
    }
}

