/*
 * Decompiled with CFR 0.152.
 */
package com.game5a.fight2;

import com.game5a.action.ActionData;
import com.game5a.action.ActionSet;
import com.game5a.action.FrameData;
import com.game5a.client.Enemy;
import com.game5a.client.Game;
import com.game5a.client.Pet;
import com.game5a.client.RareEquip;
import com.game5a.client.Role;
import com.game5a.client.data.EnemyData;
import com.game5a.client.data.PetData;
import com.game5a.client.data.RareEquipData;
import com.game5a.client.data.RoleData;
import com.game5a.client.data.SkillData;
import com.game5a.common.Common;
import com.game5a.common.Rectangle;
import com.game5a.common.Tool;
import com.game5a.fight2.Fight2;
import com.game5a.fight2.Particle;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FightSprite2 {
    public RoleData roleData;
    public Role player;
    public EnemyData enemyData;
    public Enemy emeny;
    RareEquip rEquip;
    public RareEquipData rEquipData;
    public PetData petData;
    public static final byte ENEMY_HP_WIDTH = 50;
    public boolean bShowRole;
    String name;
    public byte type;
    public static final byte TYPE_ROLE = 0;
    public static final byte TYPE_ENEMY = 1;
    public static final byte TYPE_RAEQUIP = 2;
    public static final byte TYPE_RAEQUIP_PET = 3;
    public byte kind;
    public static final byte TYPE_ATK = 0;
    public static final byte TYPE_MAGIC = 1;
    public ActionSet actionSet;
    public ActionData curAction;
    public FrameData curFrame;
    public boolean bKeepAction;
    public int curActionID;
    public int curFrameIndex;
    public int saveFrameIndex;
    public boolean bMirror;
    public int footWidth;
    public int footHeight;
    public int mapX;
    public int mapY;
    public int curVx;
    public int curVy;
    public int finalPosX;
    public int finalPosY;
    public byte faceDir;
    public byte curDir;
    public static final byte DIR_LEFT = 0;
    public static final byte DIR_RIGHT = 1;
    public byte[] petMoveY = new byte[]{0, 1, 2, 1, 0, -1, -2, -1};
    FightSprite2[] target;
    int targetX;
    int targetY;
    public int actID;
    public static final byte ACT_STAND = 0;
    public static final byte ACT_FLY = 1;
    public static final byte ACT_ATTACK = 2;
    public static final byte ACT_HURTED = 3;
    public static final byte ACT_ASHENIA = 4;
    public static final byte ACT_SKILL = 5;
    public static final byte ACT_CRIT = 6;
    public static final byte ACT_ONE_KILL = 7;
    public static final byte ACT_DIE = 8;
    public static final byte ACT_ATTACK2 = 9;
    public int skillIndex;
    byte order;
    public static final byte ORDER_GOD = 6;
    public static final byte ORDER_ATT = 1;
    public static final byte ORDER_MAGIC = 2;
    public static final byte ORDER_PROP = 3;
    public static final byte ORDER_SHOP = 4;
    public static final byte ORDER_FLEE = 5;
    public static final byte ORDER_ANGER = 0;
    public byte[] orderList;
    public static final byte LIGHT_ROUND = 2;
    public static ActionSet fightLightAs;
    public static ActionSet fightBuffAs;
    public static ActionSet sheepAs;
    public static ActionSet pigAs;
    public static ActionSet tortoiseAs;
    public static final byte LIGHT_BLOOD = 0;
    public static final byte LIGHT_POISON = 1;
    public static final byte LIGHT_SWIM = 2;
    public static final byte LIGHT_SLEEP = 3;
    public static final byte LIGHT_DISORDER = 4;
    public static final byte LIGHT_DEFORMATION = 5;
    public static final byte LIGHT_ONEKILL = 6;
    public static final byte LIGHT_CRIT = 7;
    public static final byte LIGHT_SPEED = 8;
    public static final byte LIGHT_MISS = 9;
    public static final byte LIGHT_REGAIN = 10;
    public static final byte LIGHT_IMMUNE = 11;
    public static final byte LIGHT_ATT = 12;
    public static final byte LIGHT_DEF = 13;
    public static final byte LIGHT_UPCRIT = 14;
    public int poison_min;
    public int poison_max;
    byte immuneType;
    public static Rectangle petColRect;
    byte petXDir = 0;
    byte petYDir = 0;
    public static int fightLimtResist;
    public static int fightLimtSkillDam;
    public static int fightLimtSpeed;
    public static final int ATTACK_INTERVAL_INIT = 100;
    int curAttackTime;
    public static final byte TARGET_NONE = 1;
    int targetNum;
    int agile;
    int upAgile;
    int upAtt;
    int upDef;
    int upCrit;
    Vector stealItem;
    int level;
    int hp;
    int hpMax;
    int mp;
    int mpMax;
    int sp;
    int attack;
    int attackMax;
    int def;
    int crit;
    int miss;
    int onceKill;
    int swim;
    int poison;
    int sleep;
    int disorder;
    int ratio;
    int deformation;
    int headPosX;
    int headID;
    public int setHurt;
    int finalLoseHp;
    boolean bAttackOver;
    boolean bHurtOver;
    boolean bOptfor;
    boolean bDie;
    boolean bShow;
    boolean bCrit;
    boolean bOneKill;
    boolean bUpDataPoison;
    boolean bBoss;
    int bloodTime;
    int bloodTotalTime;
    int missTime;
    int missTotalTime;
    int regainTime;
    int regainTotalTime;
    int oneKillTime;
    int oneKillTotalTime;
    byte demActID;
    public static final byte DEFORMATION_CHANGE = 0;
    public static final byte DEFORMATION_STAND = 1;
    public static final byte DEFORMATION_HURT = 2;
    int deformationRound;
    public int demActionID;
    public ActionSet demActionSet;
    public ActionData demCurAction;
    public FrameData demCurFrame;
    public int demFrameIndex;
    boolean bDeformation;
    boolean dropSign;
    Particle dropPars;
    int immuneTime;
    int immuneTotalTime;
    int critTime;
    int critTotalTime;
    int poisonRound;
    int swimRound;
    int sleepRound;
    int disorderRound;
    int speedRound;
    int attRound;
    int defRound;
    int critRound;
    int mmx;
    int mmy;

    public FightSprite2(Role role, int mx, int my) {
        this.roleData = role.data;
        this.player = role;
        this.loadRes(this.roleData.fightActionFile, this.roleData.fightImageFiles);
        this.finalPosX = this.mapX = mx;
        this.finalPosY = this.mapY = my;
        this.mmx = mx;
        this.mmy = my;
        this.type = 0;
        if (role.data.sortID == 1) {
            this.kind = 1;
        }
        this.initOrder();
        this.initRoleData();
        this.initActProperty();
        this.initbHurtOver();
        this.bDie = false;
        this.orderList = new byte[]{0, 1, 2, 3, 4, 5};
        this.faceDir = 0;
        this.curDir = 0;
        if (this.hp <= 0) {
            this.bDie = true;
            this.act(8);
        } else {
            this.act(0);
        }
    }

    public void initRoleData() {
        this.name = this.roleData.name;
        this.immuneType = this.player.immuneType;
        this.bDeformation = false;
        this.bBoss = false;
        this.bShow = true;
        this.bDie = false;
        this.setHurt = 0;
        this.bShowRole = true;
        this.headID = this.roleData.fightHeadID;
        this.level = this.player.level;
        this.hp = this.player.hp;
        this.hpMax = this.player.hpMaxFinal;
        this.mp = this.player.mp;
        this.mpMax = this.player.mpMaxFinal;
        this.attack = this.player.attackFinal;
        this.attackMax = this.player.attackMaxFinal;
        this.def = this.player.defFinal;
        this.crit = this.player.critFinal;
        this.miss = this.player.missFinal;
        this.swim = this.player.swimFinal;
        this.poison = this.player.poisonFinal;
        this.onceKill = this.player.onceKillFinal;
        this.ratio = this.roleData.fightRate;
        this.targetNum = 1;
        this.agile = this.player.agileFinal + fightLimtSpeed + Game.DQLTagile;
    }

    public FightSprite2(Enemy enemy, int mx, int my, int lv) {
        this.emeny = enemy;
        this.enemyData = enemy.enemyData;
        this.loadRes(this.enemyData.actionFile, this.enemyData.imageFiles);
        this.finalPosX = this.mapX = mx;
        this.finalPosY = this.mapY = my;
        this.type = 1;
        if (this.enemyData.sortID == 52 || this.enemyData.sortID == 53 || this.enemyData.sortID == 54) {
            this.kind = 1;
        }
        this.initActProperty();
        this.initbHurtOver();
        this.initEnemyData(lv);
        this.setEnemyLevel(lv);
        this.faceDir = 1;
        this.curDir = 1;
        this.act(0);
    }

    public void initEnemyData(int lv) {
        this.bDie = false;
        this.bOptfor = false;
        this.bDeformation = false;
        this.bShow = true;
        this.headID = 3;
        this.targetNum = 1;
        this.setHurt = 0;
        this.bBoss = this.enemyData.bBoss;
        this.name = this.enemyData.name;
        this.immuneType = this.enemyData.immuneType;
        this.agile = this.enemyData.agile;
        this.level = lv;
        this.hp = this.enemyData.hp;
        this.hpMax = this.enemyData.hp;
        this.attack = this.enemyData.attack;
        this.attackMax = this.enemyData.attackMax;
        this.def = this.enemyData.defend;
        this.crit = this.enemyData.doubleHurt;
        this.miss = this.enemyData.miss;
        this.onceKill = this.enemyData.onceKill;
        this.swim = this.enemyData.dizzy;
        this.poison = this.enemyData.poison;
        this.sleep = this.enemyData.sleep;
        this.disorder = this.enemyData.disorder;
        this.ratio = this.enemyData.ratio;
        this.stealItem = new Vector();
        short[] itemIDs = this.emeny.dropData.itemIDs;
        if (itemIDs != null) {
            for (int j2 = 0; j2 < itemIDs.length; ++j2) {
                int odds = Tool.getNextRnd(0, 100);
                if (odds > this.emeny.dropData.itemOdds[j2]) continue;
                this.stealItem.addElement(Game.getItemData(itemIDs[j2]));
            }
        }
    }

    public void setEnemyLevel(int lv) {
        if (!this.bBoss) {
            int minLv = lv - 1;
            int maxLv = lv + 1;
            this.level = Tool.getNextRnd(minLv, maxLv);
            this.level = this.level > 1 ? this.level : 1;
            for (int i2 = 0; i2 < this.level; ++i2) {
                this.hpMax = this.hp += this.enemyData.hpGrowUp;
                this.attack += this.enemyData.attackGrowUp;
                this.attackMax += this.enemyData.attackGrowUp;
                this.def += this.enemyData.defendGrowUp;
            }
        } else {
            this.level = lv;
            this.hpMax = this.hp;
        }
    }

    public FightSprite2(RareEquip rareEquip, int mx, int my) {
        this.rEquip = rareEquip;
        this.rEquipData = rareEquip.data;
        this.loadRes(this.rEquipData.fightActionFile, this.rEquipData.fightImageFiles);
        this.finalPosX = this.mapX = mx;
        this.finalPosY = this.mapY = my;
        this.type = (byte)2;
        this.initOrder();
        this.initRareEquipData(rareEquip.level);
        this.initActProperty();
        this.initbHurtOver();
        this.orderList = new byte[]{0, 1, 2, 3, 4, 5};
        this.faceDir = 0;
        this.curDir = 0;
        this.act(0);
    }

    public void initRareEquipData(int lv) {
        this.level = lv;
        this.bDeformation = false;
        this.bDie = false;
        this.bShow = true;
        this.bShowRole = true;
        this.setHurt = 0;
        this.hp = this.rEquip.hp;
        this.hpMax = this.rEquip.hpMax;
        this.attack = this.rEquip.attack;
        this.attackMax = this.rEquip.attackMax;
        this.def = this.rEquip.def;
        this.crit = this.rEquip.crit;
        this.miss = this.rEquip.miss;
        this.targetNum = this.rEquip.targetNum;
        this.agile = this.rEquip.agile;
        this.ratio = this.rEquipData.fightRate;
        this.name = this.rEquipData.name;
        this.headID = this.rEquipData.fightHeadID;
        this.immuneType = 0;
    }

    public FightSprite2(Pet pet, int mx, int my) {
        this.petData = pet.data;
        this.loadRes(this.petData.fightActionFile, this.petData.fightImageFiles);
        this.finalPosX = this.mapX = mx;
        this.finalPosY = this.mapY = my;
        this.type = (byte)3;
        this.initPetData(pet);
        this.initActProperty();
        this.faceDir = 0;
        this.curDir = 0;
        this.act(0);
    }

    public void initPetData(Pet pet) {
        this.bShow = true;
        this.bShowRole = true;
        this.bDie = false;
        this.name = this.petData.name;
        this.headID = this.petData.fightHeadID;
        this.immuneType = 0;
        this.agile = pet.data.agile;
        this.targetNum = 1;
        this.level = pet.data.level + 1;
        this.attackMax = this.petData.attackMax;
        this.attack = this.attackMax + Tool.getNextRnd(-20, 20);
        this.ratio = 1;
        int bigReX = this.finalPosX - this.footWidth / 2 - 10;
        int bigReY = this.finalPosY - this.footHeight / 2 - 10;
        int bigReW = this.footWidth + 20;
        int bigReH = this.footHeight + 20;
        petColRect = new Rectangle(bigReX, bigReY, bigReW, bigReH);
        this.petXDir = Tool.getNextRnd(0, 2) == 0 ? (byte)1 : (byte)-1;
    }

    public void loadRoleSkill() {
        if (this.player.skills.isEmpty()) {
            return;
        }
        for (int i2 = 0; i2 < this.player.skills.size(); ++i2) {
            SkillData data = (SkillData)this.player.skills.elementAt(i2);
            Fight2.skill.loadRes(data);
        }
    }

    public void loadEnemySkill() {
        for (int i2 = 0; i2 < this.enemyData.skillIDs.length; ++i2) {
            for (int j2 = 0; j2 < this.enemyData.skillIDs[i2].length; ++j2) {
                byte id = this.enemyData.skillIDs[i2][j2];
                Fight2.skill.loadRes(Game.skillDatas[id]);
            }
        }
    }

    public void loadPetSkill() {
        SkillData data = Game.skillDatas[this.petData.attackID];
        Fight2.skill.loadRes(data);
    }

    public void initActProperty() {
        this.curAttackTime = 0;
        this.headPosX = 0;
        this.bAttackOver = false;
    }

    public void initOrder() {
        this.order = 1;
    }

    public void initPos() {
        this.finalPosX = this.mapX;
        this.finalPosY = this.mapY;
    }

    public void initOptfor() {
        this.bOptfor = false;
    }

    public void setOptfor() {
        this.bOptfor = true;
    }

    public void initbHurtOver() {
        this.bHurtOver = false;
    }

    public void setNature() {
        this.player.hp = this.hp;
        this.player.mp = this.mp;
    }

    public void setRareEquipNature() {
    }

    public void setPos() {
        if (this.disorderRound > 0) {
            this.bMirror = true;
            if (this.target.length > 1) {
                if (this.faceDir == 1) {
                    this.finalPosX = this.targetX + (this.target[0].footWidth >> 1);
                    this.finalPosY = this.targetY;
                } else {
                    this.finalPosX = this.targetX - (this.target[0].footWidth >> 1);
                    this.finalPosY = this.targetY;
                }
            } else if (this.faceDir == 1) {
                this.finalPosX = this.target[0].mapX + (this.target[0].footWidth >> 1);
                this.finalPosY = this.target[0].mapY + 1;
            } else {
                this.finalPosX = this.target[0].mapX - (this.target[0].footWidth >> 1);
                this.finalPosY = this.target[0].mapY + 1;
            }
        } else {
            this.bMirror = false;
            if (this.target.length > 1) {
                if (this.faceDir == 1) {
                    this.finalPosX = this.targetX;
                    this.finalPosY = this.targetY;
                } else {
                    this.finalPosX = this.targetX;
                    this.finalPosY = this.targetY;
                }
            } else if (this.faceDir == 1) {
                this.finalPosX = this.target[0].mapX - (this.target[0].footWidth >> 1);
                this.finalPosY = this.target[0].mapY + 1;
            } else {
                this.finalPosX = this.target[0].mapX + (this.target[0].footWidth >> 1) + 20;
                this.finalPosY = this.target[0].mapY + 1;
            }
        }
    }

    public void setPetPos(int x2, int y2) {
        this.finalPosX = x2;
        this.finalPosY = y2;
    }

    public void move() {
        this.finalPosX -= this.curVx;
        this.finalPosY -= this.curVy;
    }

    public boolean actOver() {
        return this.curFrameIndex >= this.curAction.frameNum;
    }

    public void setTarget(FightSprite2[] tarSprite) {
        this.target = tarSprite;
    }

    public void initActivate() {
        this.targetX = 0;
        this.targetY = 0;
        this.target = null;
        this.bCrit = false;
        this.bOneKill = false;
        Fight2.setFillScreen((byte)0, -1);
        this.initActProperty();
    }

    public void upData() {
        if (this.type == 0 || this.type == 2) {
            if (this.hp <= 0 && this.actID != 8 && this.actOver()) {
                this.hp = 0;
                this.act(8);
                return;
            }
            switch (this.actID) {
                case 0: {
                    this.curVy = 0;
                    this.curVx = 0;
                    break;
                }
                case 1: {
                    this.move();
                    if (!this.actOver()) break;
                    this.act(2);
                    break;
                }
                case 2: {
                    this.setPos();
                    if (!this.actOver()) break;
                    this.disorderCycle();
                    this.bAttackOver = true;
                    this.initPos();
                    if (this.isAshenia()) {
                        this.act(4);
                        break;
                    }
                    this.act(0);
                    break;
                }
                case 9: {
                    if (!this.actOver()) break;
                    this.finalPosX -= 27;
                    this.finalPosY -= 15;
                    this.act(1);
                    break;
                }
                case 3: {
                    if (!this.actOver()) break;
                    this.bHurtOver = true;
                    if (this.isAshenia()) {
                        this.act(4);
                        break;
                    }
                    this.act(0);
                    break;
                }
                case 4: {
                    break;
                }
                case 6: 
                case 7: {
                    if (!this.actOver()) break;
                    this.act(1);
                    break;
                }
                case 5: {
                    if (!this.actOver()) break;
                    if (this.isAshenia()) {
                        this.act(4);
                        break;
                    }
                    this.act(0);
                    break;
                }
                case 8: {
                    if (!this.actOver()) break;
                    this.bHurtOver = true;
                }
            }
            this.disorderCycle();
        } else if (this.type == 1) {
            switch (this.actID) {
                case 0: {
                    break;
                }
                case 2: {
                    if (this.kind != 1) {
                        this.setPos();
                    }
                    if (!this.actOver()) break;
                    this.disorderCycle();
                    this.bAttackOver = true;
                    this.initPos();
                    this.act(0);
                    break;
                }
                case 3: {
                    if (!this.actOver()) break;
                    this.bHurtOver = true;
                    this.act(0);
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                case 8: {
                    this.act(8);
                    break;
                }
                case 9: {
                    if (this.actOver()) {
                        this.disorderCycle();
                        this.setPos();
                        this.act(1);
                    }
                }
                case 1: {
                    this.move();
                    if (!this.actOver()) break;
                    this.act(2);
                }
            }
        } else if (this.type == 3) {
            switch (this.actID) {
                case 0: {
                    break;
                }
                case 1: {
                    if (!this.actOver()) break;
                    this.act(5);
                    break;
                }
                case 5: {
                    if (!this.actOver()) break;
                    this.bAttackOver = true;
                    this.act(0);
                }
            }
        }
        this.cycleAction();
        if (this.dropPars != null) {
            this.dropPars.cycle();
        }
    }

    public void upDataScreen() {
        if (this.bOneKill) {
            if (this.actID == 7) {
                Fight2.setFillScreen((byte)1, 0);
            } else if (this.actID == 2) {
                if (this.isHit()) {
                    Fight2.setFillScreen((byte)3, -1);
                    Fight2.setFillScreen((byte)1, 0xFF0000);
                } else {
                    Fight2.setFillScreen((byte)1, 0);
                }
            }
        } else if (this.bCrit) {
            if (this.actID == 6) {
                Fight2.setFillScreen((byte)1, 0);
            } else if (this.actID == 2) {
                if (this.isHit()) {
                    Fight2.setFillScreen((byte)3, -1);
                    Fight2.setFillScreen((byte)1, 0xFFFFFF);
                } else {
                    Fight2.setFillScreen((byte)1, 0);
                }
            }
        }
    }

    public void upDataDeformation() {
        if (this.demActionSet == null) {
            return;
        }
        switch (this.demActID) {
            case 0: {
                if (this.demFrameIndex < this.demCurAction.frameNum) break;
                if (this.deformationRound == 0) {
                    this.bDeformation = false;
                }
                this.actDeformation((byte)1);
                break;
            }
            case 2: {
                if (this.demFrameIndex < this.demCurAction.frameNum) break;
                this.actDeformation((byte)1);
                break;
            }
        }
    }

    public boolean isAshenia() {
        return this.hp <= this.hpMax * 20 / 100;
    }

    public boolean isOneKill(FightSprite2 tgSprite) {
        int onceKillOdds;
        int oneKillOdd;
        boolean bTrigger;
        if (this.onceKill == 0) {
            return false;
        }
        boolean bl = bTrigger = Tool.getNextRnd(0, 99) < this.onceKill;
        if (bTrigger && !tgSprite.bBoss && (oneKillOdd = Tool.getNextRnd(0, 100)) < (onceKillOdds = (this.hpMax - this.hp) / (this.level * 99) + this.onceKill)) {
            this.bOneKill = true;
        }
        return this.bOneKill;
    }

    public boolean isCrit() {
        int critOdds;
        if (this.crit == 0) {
            this.bCrit = false;
        }
        if ((critOdds = Tool.getNextRnd(0, 100)) < this.crit) {
            this.bCrit = true;
        }
        return this.bCrit;
    }

    public boolean isMiss() {
        if (this.miss == 0) {
            return false;
        }
        int missOdds = Tool.getNextRnd(0, 100);
        return missOdds < this.miss;
    }

    public boolean isSwim() {
        int swimOdd;
        boolean bTrigger;
        if (this.swim == 0) {
            return false;
        }
        System.out.println("\u7729\u6655" + this.swim);
        boolean bl = bTrigger = Tool.getNextRnd(0, 99) < this.swim;
        return bTrigger && fightLimtResist < (swimOdd = Tool.getNextRnd(0, 100 - this.swim)) + this.swim;
    }

    public boolean isSleep() {
        int sleepOdd;
        boolean bTrigger;
        if (this.sleep == 0) {
            return false;
        }
        boolean bl = bTrigger = Tool.getNextRnd(0, 99) < this.sleep;
        return bTrigger && fightLimtResist < (sleepOdd = Tool.getNextRnd(0, 100 - this.sleep)) + this.sleep;
    }

    public boolean isDeformation() {
        int deformationOdd;
        boolean bTrigger;
        if (this.deformation == 0) {
            return false;
        }
        boolean bl = bTrigger = Tool.getNextRnd(0, 99) < this.deformation;
        return bTrigger && fightLimtResist < (deformationOdd = Tool.getNextRnd(0, 100 - this.deformation)) + this.deformation;
    }

    public boolean isDisorder() {
        int disorderOdd;
        boolean bTrigger;
        if (this.disorder == 0) {
            return false;
        }
        boolean bl = bTrigger = Tool.getNextRnd(0, 99) < this.disorder;
        return bTrigger && fightLimtResist < (disorderOdd = Tool.getNextRnd(0, 100 - this.disorder)) + this.disorder;
    }

    public boolean isActivity() {
        return this.swimRound <= 0 && this.sleepRound <= 0 && this.deformationRound <= 0 && this.disorderRound <= 0 && !this.bDie;
    }

    public boolean isPoison() {
        int poisonOdd;
        boolean bTrigger;
        if (this.poison == 0) {
            return false;
        }
        boolean bl = bTrigger = Tool.getNextRnd(0, 99) < this.poison;
        return bTrigger && fightLimtResist < (poisonOdd = Tool.getNextRnd(0, 100 - this.poison)) + this.poison;
    }

    public void cycleForceAttack() {
        if (this.target == null) {
            return;
        }
        for (int i2 = 0; i2 < this.target.length; ++i2) {
            if (!this.isHit()) continue;
            this.forceAttack(this.target[i2]);
        }
    }

    public boolean isHit() {
        if (this.curAction == null) {
            return false;
        }
        return this.actID == 2 ? this.curAction.bAttackFrame[this.saveFrameIndex] : this.actID == 9 && this.curAction.bAttackFrame[this.saveFrameIndex];
    }

    public void forceAttack(FightSprite2 tgSprite) {
        tgSprite.bHurtOver = false;
        if (this.isMiss()) {
            tgSprite.bHurtOver = true;
            tgSprite.setDeBuff((byte)9, (byte)0);
            return;
        }
        if (this.bOneKill) {
            int oneKillDam = tgSprite.bBoss ? this.getAttackDam(tgSprite) : tgSprite.hpMax;
            Fight2.setShowNum((byte)1, oneKillDam, tgSprite);
            tgSprite.finalLoseHp = oneKillDam;
        } else if (this.bCrit) {
            int critDam = this.getAttackDam(tgSprite) * 2;
            Fight2.setShowNum((byte)4, critDam, tgSprite);
            tgSprite.finalLoseHp += critDam;
        } else {
            int attackDam = this.getAttackDam(tgSprite);
            Fight2.setShowNum((byte)1, attackDam, tgSprite);
            tgSprite.finalLoseHp += attackDam;
        }
        if (tgSprite.sleepRound > 0) {
            tgSprite.sleepRound = 0;
        }
        if (tgSprite.deformationRound > 0) {
            tgSprite.actDeformation((byte)2);
        }
        this.addSp(1);
        tgSprite.setDeBuff((byte)0, (byte)0);
        tgSprite.loseHp();
        tgSprite.act(3);
    }

    public void loseHp() {
        this.hp -= this.finalLoseHp;
        int sp = 0;
        if (this.finalLoseHp >= 100) {
            sp = this.finalLoseHp / 100;
        }
        this.addSp(sp);
        this.finalLoseHp = 0;
        this.setHurt = 0;
        if (this.hp < 0) {
            this.hp = 0;
        }
    }

    public void addHp(int value) {
        this.hp += value;
        if (this.hp > this.hpMax) {
            this.hp = this.hpMax;
        }
    }

    public void addMp(int value) {
        this.mp += value;
        if (this.mp > this.mpMax) {
            this.mp = this.mpMax;
        }
    }

    public void addSp(int value) {
    }

    public void loseMp(int value) {
        this.mp -= value;
        if (this.mp <= 0) {
            this.mp = 0;
        }
    }

    public void loseSp(int value) {
        Game.bag.yuanShen -= value;
        if (Game.bag.yuanShen <= 0) {
            Game.bag.yuanShen = 0;
        }
    }

    public void revive() {
        this.hp = this.hpMax;
        this.mp = this.mpMax;
        this.bDie = false;
        this.bShow = true;
        this.act(0);
    }

    public boolean isReleaseSkill() {
        return this.actID == 5 && this.curAction.bAttackFrame[this.saveFrameIndex];
    }

    public boolean bAttackOver() {
        int i2;
        int num = 0;
        for (i2 = 0; i2 < this.target.length; ++i2) {
            if (!this.target[i2].bHurtOver && !this.target[i2].bDie) continue;
            ++num;
        }
        if (this.bAttackOver && num >= this.target.length) {
            for (i2 = 0; i2 < this.target.length; ++i2) {
                this.target[i2].initbHurtOver();
            }
            return true;
        }
        return false;
    }

    public void cycle() {
        this.upData();
        this.cycleForceAttack();
        this.cycleBuff();
        this.upDataDeformation();
        this.upDataScreen();
    }

    public void draw(Graphics g2) {
        int drawX = this.finalPosX - (this.footWidth >> 1) + Fight2.shakeX;
        int drawY = this.finalPosY + (this.footHeight >> 1) + Fight2.shakeY;
        if (this.bShow) {
            if (this.type == 1) {
                if (this.bDeformation) {
                    boolean bm = false;
                    this.demActionSet.drawFrame(g2, this.demCurFrame, drawX, drawY, bm);
                } else {
                    this.actionSet.drawFrame(g2, this.curFrame, drawX, drawY, this.bMirror);
                    if (this.kind == 1 && (this.actID == 1 || this.actID == 2)) {
                        this.actionSet.drawFrameCycle(g2, 1, Tool.countTimes, this.mmx, this.mmy, false);
                    }
                }
            } else if (this.bShowRole) {
                if (this.bDeformation) {
                    boolean bm = false;
                    if (this.type == 0 || this.type == 2) {
                        bm = true;
                    }
                    this.demActionSet.drawFrame(g2, this.demCurFrame, drawX, drawY, bm);
                } else {
                    this.actionSet.drawFrame(g2, this.curFrame, drawX, drawY, this.bMirror);
                    if (this.kind == 1 && (this.actID == 1 || this.actID == 2)) {
                        this.actionSet.drawFrameCycle(g2, 0, Tool.countTimes, this.mmx, this.mmy, false);
                    }
                }
            }
            if (this.type == 1) {
                Common.setUIClip(g2);
                if (!this.bDie) {
                    this.drawEnemyHp(g2, drawX - (this.footWidth - 50) / 2, drawY - this.getBodyRect().height);
                }
            }
        } else if (this.type == 1) {
            this.dropPars.draw(g2);
        }
    }

    public void drawBuff(Graphics g2) {
        int drawX = this.finalPosX - (this.footWidth >> 1) + Fight2.shakeX;
        int drawY = this.finalPosY + (this.footHeight >> 1) + Fight2.shakeY;
        if (this.bloodTime < this.bloodTotalTime) {
            fightLightAs.drawFrameCycle(g2, 0, this.bloodTime, drawX, drawY - 25, false);
        }
        if (this.poisonRound > 0) {
            fightLightAs.drawFrameCycle(g2, 1, Tool.countTimes, drawX, drawY, false);
        }
        if (this.swimRound > 0) {
            fightLightAs.drawFrameCycle(g2, 2, Tool.countTimes, drawX, drawY - this.getBodyRect().height, false);
        }
        if (this.sleepRound > 0) {
            fightLightAs.drawFrameCycle(g2, 3, Tool.countTimes, drawX, drawY - this.getBodyRect().height + 10, false);
        }
        if (this.disorderRound > 0) {
            fightLightAs.drawFrameCycle(g2, 4, Tool.countTimes, drawX + 20, drawY - 20, false);
        }
        if (this.oneKillTime < this.oneKillTotalTime) {
            fightLightAs.drawFrameCycle(g2, 6, this.oneKillTime, drawX, drawY, false);
        }
        if (this.critTime < this.critTotalTime) {
            fightLightAs.drawFrameCycle(g2, 7, this.critTime, drawX, drawY, false);
        }
        if (this.missTime < this.missTotalTime) {
            fightLightAs.drawFrameCycle(g2, 9, this.missTime, drawX, drawY, false);
        }
        if (this.regainTime < this.regainTotalTime) {
            fightLightAs.drawFrameCycle(g2, 10, this.regainTime, drawX, drawY, false);
        }
        if (this.immuneTime < this.immuneTotalTime) {
            fightLightAs.drawFrameCycle(g2, 11, this.immuneTime, drawX, drawY, false);
        }
    }

    public void drawHpRect(Graphics g2, int x2, int y2, int w2) {
        g2.setColor(16065356);
        g2.fillRect(x2, y2, w2, 1);
        g2.setColor(9634597);
        g2.fillRect(x2, y2 + 1, w2, 1);
        g2.setColor(6428952);
        g2.fillRect(x2, y2 + 2, w2, 1);
    }

    public void drawEnemyHp(Graphics g2, int x2, int y2) {
        int hpH = 5;
        g2.setColor(398111);
        g2.fillRect(x2, y2, 50, hpH);
        int dw = this.hp * 48 / this.hpMax;
        if (dw == 0 && this.hp > 0) {
            dw = 1;
        }
        this.drawHpRect(g2, x2 + 1, y2 + 1, dw);
    }

    public void cycleBuff() {
        if (this.bloodTime < this.bloodTotalTime) {
            ++this.bloodTime;
        }
        if (this.missTime < this.missTotalTime) {
            ++this.missTime;
        }
        if (this.regainTime < this.regainTotalTime) {
            ++this.regainTime;
        }
        if (this.oneKillTime < this.oneKillTotalTime) {
            ++this.oneKillTime;
        }
        if (this.critTime < this.critTotalTime) {
            ++this.critTime;
        }
        if (this.immuneTime < this.immuneTotalTime) {
            ++this.immuneTime;
        }
        this.cycleDeformationAction();
    }

    public void clearDeBuff() {
        this.poisonRound = 0;
        this.swimRound = 0;
        this.sleepRound = 0;
        this.disorderRound = 0;
        this.deformationRound = 0;
        this.critRound = 0;
        this.bDeformation = false;
    }

    public void cycleAction() {
        if (this.curFrameIndex >= this.curAction.frameNum) {
            this.initAct();
        } else {
            this.getCurData();
        }
        ++this.curFrameIndex;
    }

    public void initAct() {
        if (!this.bKeepAction) {
            this.curFrameIndex = 0;
            if (this.type == 0 || this.type == 2) {
                if (this.isAshenia()) {
                    if (this.actID != 8) {
                        this.act(4);
                    }
                } else if (this.actID != 8) {
                    this.act(0);
                }
            } else if (this.actID != 8) {
                this.act(0);
            }
            this.getCurData();
        } else {
            this.curFrameIndex = this.curAction.frameNum - 1;
        }
    }

    public void act(int act) {
        this.curFrameIndex = 0;
        this.actID = act;
        this.getCurData();
    }

    public void getCurData() {
        this.curActionID = (this.actID << 1) + this.curDir;
        this.curAction = this.actionSet.actionDatas[this.curActionID];
        this.curFrame = this.actionSet.frameDatas[this.curAction.frameID[this.curFrameIndex]];
        this.saveFrameIndex = this.curFrameIndex;
    }

    public void setActionDir(int dir) {
        this.curDir = (byte)dir;
        this.curFrameIndex = 0;
        this.getCurData();
    }

    public Rectangle getBodyRect() {
        return this.actionSet.getBodyRect(this.curFrame, false);
    }

    public void spriteAttMove(int tarX, int tarY) {
        this.targetX = tarX;
        this.targetY = tarY;
        int tempSqrt = (this.finalPosX - tarX) * (this.finalPosX - tarX) + (this.finalPosY - tarY) * (this.finalPosY - tarY);
        int[] xy = new int[2];
        int l2 = Tool.sqrt(tempSqrt);
        if (l2 != 0) {
            xy[0] = (this.finalPosX - tarX << 10) / l2;
            xy[1] = (this.finalPosY - tarY << 10) / l2;
        }
        int xSpeed = 16;
        int ySpeed = 16;
        if (this.kind == 1) {
            xSpeed = 8;
            ySpeed = 12;
        }
        if (this.type != 3) {
            this.curVx = xSpeed * xy[0] >> 10;
            this.curVy = ySpeed * xy[1] >> 10;
        }
    }

    public void loadRes(String actionFile, String[] imageFiles) {
        Image[] imgs = new Image[imageFiles.length];
        try {
            for (int i2 = 0; i2 < imageFiles.length; ++i2) {
                String tempfile = "/action/" + imageFiles[i2] + Game.IMG_TYPE;
                imgs[i2] = FightSprite2.getImageFromCacheFight(tempfile);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        actionFile = "/action/" + actionFile + ".a2";
        if (Fight2.resCacheFight.containsKey(actionFile)) {
            this.actionSet = (ActionSet)Fight2.resCacheFight.get(actionFile);
        } else {
            this.actionSet = ActionSet.createActionSet(actionFile, imgs);
            Fight2.resCacheFight.put(actionFile, this.actionSet);
        }
        this.curAction = this.actionSet.actionDatas[0];
        this.footWidth = this.actionSet.footWidth;
        this.footHeight = this.actionSet.footHeight;
    }

    public static Image getImageFromCacheFight(String file) {
        if (Fight2.resCacheFight.containsKey(file)) {
            return (Image)Fight2.resCacheFight.get(file);
        }
        Image img = Tool.createImage(file);
        Fight2.resCacheFight.put(file, img);
        return img;
    }

    public void setDeBuff(byte type, byte round) {
        switch (type) {
            case 0: {
                this.bloodTime = 0;
                this.bloodTotalTime = FightSprite2.fightLightAs.actionDatas[0].frameNum;
                break;
            }
            case 1: {
                this.poisonRound = round;
                break;
            }
            case 2: {
                this.swimRound = round;
                break;
            }
            case 3: {
                this.sleepRound = round;
                break;
            }
            case 8: {
                this.speedRound = round;
                break;
            }
            case 4: {
                this.disorderRound = round;
                break;
            }
            case 12: {
                this.attRound = round;
                break;
            }
            case 13: {
                this.defRound = round;
                break;
            }
            case 14: {
                this.critRound = round;
                break;
            }
            case 9: {
                this.missTime = 0;
                this.missTotalTime = FightSprite2.fightLightAs.actionDatas[9].frameNum;
                break;
            }
            case 10: {
                this.regainTime = 0;
                this.regainTotalTime = FightSprite2.fightLightAs.actionDatas[10].frameNum;
                break;
            }
            case 11: {
                this.immuneTime = 0;
                this.immuneTotalTime = FightSprite2.fightLightAs.actionDatas[11].frameNum;
                break;
            }
            case 7: {
                this.critTime = 0;
                this.critTotalTime = FightSprite2.fightLightAs.actionDatas[7].frameNum;
                break;
            }
            case 6: {
                this.oneKillTime = 0;
                this.oneKillTotalTime = FightSprite2.fightLightAs.actionDatas[6].frameNum;
                break;
            }
            case 5: {
                this.demActionSet = Tool.getNextRnd(0, 3) == 0 ? sheepAs : (Tool.getNextRnd(0, 3) == 1 ? pigAs : tortoiseAs);
                this.bDeformation = true;
                this.actDeformation((byte)0);
                this.deformationRound = round;
                break;
            }
        }
    }

    public void upDataTargetBuff() {
        block7: for (int i2 = 0; i2 < this.target.length; ++i2) {
            FightSprite2 targetSp = this.target[i2];
            if (this.isDeformation()) {
                targetSp.sleepRound = 0;
                targetSp.swimRound = 0;
                targetSp.setDeBuff((byte)5, (byte)2);
            } else if (this.isSwim()) {
                targetSp.sleepRound = 0;
                targetSp.deformationRound = 0;
                targetSp.setDeBuff((byte)2, (byte)2);
            } else if (this.isSleep()) {
                targetSp.deformationRound = 0;
                targetSp.swimRound = 0;
                targetSp.setDeBuff((byte)3, (byte)2);
            }
            if (this.isPoison()) {
                targetSp.poison_min = targetSp.attack;
                targetSp.poison_max = targetSp.attackMax;
                targetSp.setDeBuff((byte)1, (byte)2);
            }
            if (this.isDisorder()) {
                targetSp.setDeBuff((byte)4, (byte)2);
            }
            switch (targetSp.immuneType) {
                case 1: {
                    targetSp.poisonRound = 0;
                    targetSp.setDeBuff((byte)11, (byte)0);
                    continue block7;
                }
                case 2: {
                    targetSp.swimRound = 0;
                    targetSp.setDeBuff((byte)11, (byte)0);
                    continue block7;
                }
                case 3: {
                    targetSp.sleepRound = 0;
                    targetSp.setDeBuff((byte)11, (byte)0);
                    continue block7;
                }
                case 4: {
                    targetSp.disorderRound = 0;
                    targetSp.setDeBuff((byte)11, (byte)0);
                    continue block7;
                }
                case 5: {
                    targetSp.deformationRound = 0;
                    targetSp.setDeBuff((byte)11, (byte)0);
                    continue block7;
                }
            }
        }
    }

    public boolean isAstrictBuffCycle() {
        if (this.swimRound > 0) {
            --this.swimRound;
        }
        if (this.sleepRound > 0) {
            --this.sleepRound;
        }
        return this.swimRound > 0 || this.sleepRound > 0;
    }

    public void poisonCycle() {
        --this.poisonRound;
        this.act(3);
        int firstDps = Tool.getNextRnd(this.poison_min, this.poison_max);
        int secondDps = Tool.getNextRnd(this.poison_min, this.poison_max);
        int overDps = (firstDps / this.level + secondDps) * this.ratio - this.def;
        this.finalLoseHp = overDps = overDps > 1 ? overDps : 1;
        this.loseHp();
        Fight2.setShowNum((byte)1, overDps, this);
    }

    public boolean isDeformationCycle() {
        if (this.deformationRound > 0) {
            --this.deformationRound;
            if (this.demActionID != 0 && this.deformationRound == 0) {
                this.actDeformation((byte)0);
            }
            return true;
        }
        return false;
    }

    public void disorderCycle() {
        this.bMirror = false;
        if (this.disorderRound > 0) {
            --this.disorderRound;
        }
    }

    public void sleepCycle() {
        if (this.speedRound > 0) {
            --this.speedRound;
            if (this.speedRound <= 0) {
                this.agile -= this.upAgile;
                this.upAgile = 0;
            }
        }
    }

    public void critCycle() {
        if (this.critRound > 0) {
            --this.critRound;
            if (this.critRound <= 0) {
                this.crit -= this.upCrit;
                this.upCrit = 0;
            }
        }
    }

    public void attCycle() {
        if (this.attRound > 0 && this.attRound <= 0) {
            this.attack -= this.upAtt;
            this.upAtt = 0;
        }
    }

    public void defCycle() {
        if (this.defRound > 0 && this.defRound <= 0) {
            this.def -= this.upDef;
            this.upDef = 0;
        }
    }

    public void getDeformationData() {
        this.demActionID = this.demActID;
        this.demCurAction = this.demActionSet.actionDatas[this.demActionID];
        this.demCurFrame = this.demActionSet.frameDatas[this.demCurAction.frameID[this.demFrameIndex]];
    }

    public void cycleDeformationAction() {
        if (this.demActionSet == null) {
            return;
        }
        if (this.demFrameIndex >= this.demCurAction.frameNum) {
            this.initDeformationAct();
        } else {
            this.getDeformationData();
        }
        ++this.demFrameIndex;
    }

    public void initDeformationAct() {
        this.demFrameIndex = 0;
        this.getDeformationData();
    }

    public void actDeformation(byte act) {
        this.demFrameIndex = 0;
        this.demActID = act;
        this.getDeformationData();
    }

    public int getAttackDam(FightSprite2 tgSprite) {
        int secondDps;
        int firstDps = Tool.getNextRnd(this.attack, this.attackMax);
        int overDps = (firstDps / this.level + (secondDps = Tool.getNextRnd(this.attack, this.attackMax))) * this.ratio - tgSprite.def;
        overDps = overDps > 1 ? overDps : 1;
        return overDps;
    }

    public static void setFightBuff(Pet pet) {
        fightLimtResist = 0;
        fightLimtSkillDam = 0;
        fightLimtSpeed = 0;
        fightLimtResist = pet.data.upBuffResist;
        fightLimtSkillDam = pet.data.upSkillDam;
        fightLimtSpeed = pet.data.upSpeed;
    }

    static {
        fightLimtResist = 0;
        fightLimtSkillDam = 0;
        fightLimtSpeed = 0;
    }
}

