/*
 * Decompiled with CFR 0.152.
 */
package com.game5a.fight2;

import com.game5a.action.ActionData;
import com.game5a.action.ActionSet;
import com.game5a.action.FrameData;
import javax.microedition.lcdui.Graphics;

public class Particle {
    public ActionSet actionSet;
    public ActionData actionData;
    public FrameData curFrame;
    public int curActionID;
    public int curFrameIndex;
    public int saveFrameIndex;
    public int actID;
    public int moveID;
    public static final byte ACT_GROW = 0;
    public static final byte ACT_MOVE = 1;
    public static final byte ACT_DIE = 2;
    public int life;
    public int aliveTimes;
    public int mapX;
    public int mapY;
    public int Vx;
    public int Vy;
    public boolean bMirror;
    public boolean bDisappear;

    public Particle(ActionSet set, int actid, int mx, int my, int vx, int vy) {
        this.moveID = actid;
        this.actionSet = set;
        System.out.println(" actid" + actid);
        this.actionData = this.actionSet.actionDatas[actid];
        this.aliveTimes = 0;
        this.life = this.actionSet.actionDatas[actid].frameNum;
        this.setAct(actid);
        this.mapX = mx - this.actionSet.footWidth / 2;
        this.mapY = my;
        this.Vx = vx;
        this.Vy = vy;
    }

    public Particle(ActionSet set, int actid, int mx, int my, int vx, int vy, boolean bMirror) {
        this(set, actid, mx, my, vx, vy);
        this.bMirror = bMirror;
    }

    public Particle(ActionSet set, int actid, int mx, int my, int vx, int vy, boolean bMirror, boolean bShow) {
        this(set, actid, mx, my, vx, vy, bMirror);
        this.bDisappear = bShow;
    }

    public void setLife(int lf) {
        this.life = lf;
    }

    public void cycle() {
        if (this.life > 0) {
            ++this.aliveTimes;
            if (this.aliveTimes > this.life) {
                this.bDisappear = true;
            }
        }
        this.mapX -= this.Vx;
        this.mapY -= this.Vy;
        this.cycleAction();
    }

    public void cycleAction() {
        if (this.curFrameIndex >= this.actionData.frameNum) {
            this.curFrameIndex = this.actionData.frameNum - 1;
        } else {
            this.getCurData();
        }
        ++this.curFrameIndex;
    }

    public void setAct(int act) {
        this.curFrameIndex = 0;
        this.actID = act;
        this.getCurData();
    }

    public void getCurData() {
        this.curActionID = this.actID;
        this.actionData = this.actionSet.actionDatas[this.curActionID];
        this.curFrame = this.actionSet.frameDatas[this.actionData.frameID[this.curFrameIndex]];
        this.saveFrameIndex = this.curFrameIndex;
    }

    public boolean actOver() {
        return this.curFrameIndex >= this.actionData.frameNum;
    }

    public boolean isHit() {
        return this.actionData.bAttackFrame[this.saveFrameIndex];
    }

    public void draw(Graphics g2) {
        if (this.bDisappear) {
            return;
        }
        this.actionSet.drawFrame(g2, this.curFrame, this.mapX, this.mapY, this.bMirror);
    }

    public boolean bHigh() {
        return this.curFrameIndex > this.actionSet.frameDatas.length / 2;
    }
}

