/*
 * Decompiled with CFR 0.152.
 */
package com.game5a.map;

import com.game5a.common.GZIP;
import com.game5a.common.Tool;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DoMap {
    public static final String STR_MAP_PATH = "/map/";
    public static final String STR_MAP_FILE = ".m";
    public byte mapType;
    public static final byte TILE_MAP = 0;
    public static final byte IMAGE_MAP = 1;
    public static final byte LAYER_0 = 0;
    public static final byte LAYER_1 = 1;
    public short cellWidth;
    public short cellHeight;
    public short cellXCount;
    public short cellYCount;
    public short mapWidth;
    public short mapHeight;
    int backgroundColor;
    Image[] mapImages;
    private byte[][] cellImageID;
    private byte[][] layer0TileID;
    private byte[][] layer1TileID;
    private byte[][] cellData;
    private byte[] layer0PartData;
    private short[] layer0PartPosX;
    private short[] layer0PartPosY;
    private byte[] layer1PartData;
    private short[] layer1PartPosX;
    private short[] layer1PartPosY;
    private int[] scriptCellID;
    private String[] scriptFileName;
    private short viewWidth;
    private short viewHeight;
    private short viewMapX;
    private short viewMapY;
    private boolean bUseBuffer = true;
    private boolean bFirstBgImage = true;
    private Image bgImg;
    private Graphics gg;
    private int bgCellXCount;
    private int bgCellYCount;
    private int bgWidth;
    private int bgHeight;
    private int oldStartX;
    private int oldStartY;
    private int oldEndX;
    private int oldEndY;
    private int vibrateX;
    private int vibrateY;

    public DoMap(int vWidth, int vHeight) {
        this.viewWidth = (short)vWidth;
        this.viewHeight = (short)vHeight;
    }

    public void loadData(String mFile, boolean bBuf) {
        mFile = STR_MAP_PATH + mFile + STR_MAP_FILE;
        System.out.println("Load Map = " + mFile);
        try {
            byte[] data = GZIP.inflate(Tool.getBytesFromInput(this.getClass().getResourceAsStream(mFile)));
            this.loadData(data, bBuf);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadData(byte[] data, boolean bBuf) {
        this.bUseBuffer = bBuf;
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        DataInputStream din = new DataInputStream(bin);
        try {
            int i2;
            int j2;
            int i3;
            this.mapType = din.readByte();
            int imageCount = din.readByte();
            this.mapImages = new Image[imageCount];
            for (i3 = 0; i3 < imageCount; ++i3) {
                this.mapImages[i3] = this.loadImage(din.readUTF());
            }
            this.cellWidth = din.readShort();
            this.cellHeight = din.readShort();
            this.cellXCount = din.readShort();
            this.cellYCount = din.readShort();
            this.backgroundColor = din.readInt();
            if (this.mapType == 0) {
                this.cellImageID = new byte[this.cellXCount][this.cellYCount];
                this.layer0TileID = new byte[this.cellXCount][this.cellYCount];
                this.layer1TileID = new byte[this.cellXCount][this.cellYCount];
                this.cellData = new byte[this.cellXCount][this.cellYCount];
                for (i3 = 0; i3 < this.cellXCount; ++i3) {
                    for (j2 = 0; j2 < this.cellYCount; ++j2) {
                        this.cellImageID[i3][j2] = din.readByte();
                        this.layer0TileID[i3][j2] = din.readByte();
                        this.layer1TileID[i3][j2] = din.readByte();
                        this.cellData[i3][j2] = din.readByte();
                    }
                }
            } else if (this.mapType == 1) {
                this.cellData = new byte[this.cellXCount][this.cellYCount];
                for (i3 = 0; i3 < this.cellXCount; ++i3) {
                    for (j2 = 0; j2 < this.cellYCount; ++j2) {
                        this.cellData[i3][j2] = din.readByte();
                    }
                }
                int partN = din.readByte() & 0xFF;
                this.layer0PartData = new byte[partN];
                this.layer0PartPosX = new short[partN];
                this.layer0PartPosY = new short[partN];
                for (i2 = 0; i2 < partN; ++i2) {
                    this.layer0PartData[i2] = din.readByte();
                    this.layer0PartPosX[i2] = din.readShort();
                    this.layer0PartPosY[i2] = din.readShort();
                }
                partN = din.readByte() & 0xFF;
                this.layer1PartData = new byte[partN];
                this.layer1PartPosX = new short[partN];
                this.layer1PartPosY = new short[partN];
                for (i2 = 0; i2 < partN; ++i2) {
                    this.layer1PartData[i2] = din.readByte();
                    this.layer1PartPosX[i2] = din.readShort();
                    this.layer1PartPosY[i2] = din.readShort();
                }
            }
            int scriptN = din.readByte();
            this.scriptCellID = new int[scriptN];
            this.scriptFileName = new String[scriptN];
            for (i2 = 0; i2 < scriptN; ++i2) {
                this.scriptCellID[i2] = din.readInt();
                this.scriptFileName[i2] = din.readUTF();
            }
            this.mapWidth = (short)(this.cellWidth * this.cellXCount);
            this.mapHeight = (short)(this.cellHeight * this.cellYCount);
            this.createMapBuffer();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        finally {
            try {
                if (bin != null) {
                    bin.close();
                }
                if (din != null) {
                    din.close();
                }
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
    }

    private void createMapBuffer() {
        if (this.bUseBuffer && this.mapType == 0) {
            if (this.bgImg == null) {
                this.bgCellXCount = this.viewWidth / this.cellWidth + 1;
                this.bgCellYCount = this.viewHeight / this.cellHeight + 1;
                if (this.viewWidth % this.cellWidth != 0) {
                    ++this.bgCellXCount;
                }
                if (this.viewHeight % this.cellHeight != 0) {
                    ++this.bgCellYCount;
                }
                this.bgWidth = this.bgCellXCount * this.cellWidth;
                this.bgHeight = this.bgCellYCount * this.cellHeight;
                this.bgImg = Image.createImage((int)this.bgWidth, (int)this.bgHeight);
                this.gg = this.bgImg.getGraphics();
            }
            this.bFirstBgImage = true;
        }
    }

    public void setViewPosInMap(int px, int py) {
        this.viewMapX = (short)px;
        this.viewMapY = (short)py;
    }

    public short getCellX(short x2) {
        return (short)(x2 / this.cellWidth);
    }

    public short getCellY(short y2) {
        return (short)(y2 / this.cellHeight);
    }

    private int getPartImageID(byte partData) {
        return (partData & 0xFF) >> 4;
    }

    private int getPartTransType(byte partData) {
        return partData & 0xF;
    }

    public String getScriptAt(int x2, int y2) {
        if (x2 >= this.cellXCount || y2 >= this.cellYCount) {
            return null;
        }
        int num = y2 * this.cellXCount + x2;
        for (int i2 = 0; i2 < this.scriptCellID.length; ++i2) {
            if (this.scriptCellID[i2] != num) continue;
            return this.scriptFileName[i2];
        }
        return null;
    }

    public void drawLayerFloor(Graphics g2, int dx, int dy) {
        g2.setClip(dx, dy, (int)this.viewWidth, (int)this.viewHeight);
        int curViewMapX = this.viewMapX;
        int curViewMapY = this.viewMapY;
        int curVibrateX = 0;
        int curVibrateY = 0;
        curViewMapX += this.vibrateX;
        curViewMapY += this.vibrateY;
        if (this.mapType == 1) {
            for (int i2 = 0; i2 < this.layer0PartData.length; ++i2) {
                Image img = this.mapImages[this.getPartImageID(this.layer0PartData[i2])];
                if (!Tool.isRectIntersected(curViewMapX, curViewMapY, this.viewWidth, this.viewHeight, this.layer0PartPosX[i2], this.layer0PartPosY[i2], img.getWidth(), img.getHeight())) continue;
                Tool.drawImage(g2, img, dx + (this.layer0PartPosX[i2] - curViewMapX) + curVibrateX, dy + (this.layer0PartPosY[i2] - curViewMapY) + curVibrateY, this.getPartTransType(this.layer0PartData[i2]));
            }
            return;
        }
        if (this.bUseBuffer && this.bgImg != null) {
            int startX = curViewMapX / this.cellWidth;
            int endX = startX + this.bgCellXCount - 1;
            int startY = curViewMapY / this.cellHeight;
            int endY = startY + this.bgCellYCount - 1;
            if (this.bFirstBgImage) {
                this.bFirstBgImage = false;
                this.gg.setColor(this.backgroundColor);
                this.gg.fillRect(0, 0, this.bgWidth, this.bgHeight);
                this.drawBufferCell(startX, startY, endX, endY);
                this.oldStartX = startX;
                this.oldEndX = endX;
                this.oldStartY = startY;
                this.oldEndY = endY;
            }
            if (this.oldStartX != startX) {
                int ex;
                int sx;
                if (startX < this.oldStartX) {
                    sx = startX;
                    ex = this.oldStartX - 1;
                    if (ex > endX) {
                        ex = endX;
                    }
                } else {
                    sx = this.oldEndX + 1;
                    ex = endX;
                    if (sx < startX) {
                        sx = startX;
                    }
                }
                this.drawBufferCell(sx, this.oldStartY, ex, this.oldEndY);
                this.oldStartX = startX;
                this.oldEndX = endX;
            }
            if (this.oldStartY != startY) {
                int ey;
                int sy;
                if (startY < this.oldStartY) {
                    sy = startY;
                    ey = this.oldStartY - 1;
                    if (ey > endY) {
                        ey = endY;
                    }
                } else {
                    sy = this.oldEndY + 1;
                    ey = endY;
                    if (sy < startY) {
                        sy = startY;
                    }
                }
                this.drawBufferCell(this.oldStartX, sy, this.oldEndX, ey);
                this.oldStartY = startY;
                this.oldEndY = endY;
            }
            int sMapX = curViewMapX % this.bgWidth;
            int eMapX = (curViewMapX + this.viewWidth) % this.bgWidth;
            int sMapY = curViewMapY % this.bgHeight;
            int eMapY = (curViewMapY + this.viewHeight) % this.bgHeight;
            g2.setColor(this.backgroundColor);
            g2.fillRect(dx, dy, (int)this.viewWidth, (int)this.viewHeight);
            if (eMapX > sMapX) {
                if (eMapY > sMapY) {
                    g2.drawImage(this.bgImg, -sMapX + dx + curVibrateX, -sMapY + dy + curVibrateY, 0);
                } else {
                    g2.setClip(curVibrateX + dx, curVibrateY + dy, (int)this.viewWidth, this.bgHeight - sMapY);
                    g2.drawImage(this.bgImg, -sMapX + dx + curVibrateX, -sMapY + dy + curVibrateY, 0);
                    g2.setClip(curVibrateX + dx, this.bgHeight - sMapY + dy + curVibrateY, (int)this.viewWidth, eMapY);
                    g2.drawImage(this.bgImg, -sMapX + dx + curVibrateX, this.bgHeight - sMapY + dy + curVibrateY, 0);
                }
            } else if (eMapY > sMapY) {
                g2.setClip(curVibrateX + dx, curVibrateY + dy, this.bgWidth - sMapX, (int)this.viewHeight);
                g2.drawImage(this.bgImg, -sMapX + dx + curVibrateX, -sMapY + dy + curVibrateY, 0);
                g2.setClip(this.bgWidth - sMapX + dx + curVibrateX, curVibrateY + dy, eMapX, (int)this.viewHeight);
                g2.drawImage(this.bgImg, this.bgWidth - sMapX + dx + curVibrateX, -sMapY + dy + curVibrateY, 0);
            } else {
                g2.setClip(curVibrateX + dx, curVibrateY + dy, this.bgWidth - sMapX, this.bgHeight - sMapY);
                g2.drawImage(this.bgImg, -sMapX + dx + curVibrateX, -sMapY + dy + curVibrateY, 0);
                g2.setClip(this.bgWidth - sMapX + dx + curVibrateX, curVibrateY + dy, eMapX, this.bgHeight - sMapY);
                g2.drawImage(this.bgImg, this.bgWidth - sMapX + dx + curVibrateX, -sMapY + dy + curVibrateY, 0);
                g2.setClip(curVibrateX + dx, this.bgHeight - sMapY + dy + curVibrateY, this.bgWidth - sMapX, eMapY);
                g2.drawImage(this.bgImg, -sMapX + dx + curVibrateX, this.bgHeight - sMapY + dy + curVibrateY, 0);
                g2.setClip(this.bgWidth - sMapX + dx + curVibrateX, this.bgHeight - sMapY + dy + curVibrateY, eMapX, eMapY);
                g2.drawImage(this.bgImg, this.bgWidth - sMapX + dx + curVibrateX, this.bgHeight - sMapY + dy + curVibrateY, 0);
            }
        } else {
            g2.setColor(this.backgroundColor);
            g2.fillRect(dx, dy, (int)this.viewWidth, (int)this.viewHeight);
            this.drawMapNoBuffer(g2, dx, dy, false);
        }
    }

    public void drawLayerTop(Graphics g2, int dx, int dy) {
        if (this.mapType == 1) {
            for (int i2 = 0; i2 < this.layer1PartData.length; ++i2) {
                Image img = this.mapImages[this.getPartImageID(this.layer1PartData[i2])];
                if (!Tool.isRectIntersected(this.viewMapX, this.viewMapY, this.viewWidth, this.viewHeight, this.layer1PartPosX[i2], this.layer1PartPosY[i2], img.getWidth(), img.getHeight())) continue;
                Tool.drawImage(g2, img, dx + (this.layer1PartPosX[i2] - this.viewMapX) + this.vibrateX, dy + (this.layer1PartPosY[i2] - this.viewMapY) + this.vibrateY, this.getPartTransType(this.layer1PartData[i2]));
            }
            return;
        }
        this.drawMapNoBuffer(g2, dx, dy, true);
    }

    public void drawMapNoBuffer(Graphics g2, int dx, int dy, boolean topLayer) {
        int startX = this.getCellX(this.viewMapX);
        int startY = this.getCellY(this.viewMapY);
        if (startX < 0) {
            startX = 0;
        }
        if (startY < 0) {
            startY = 0;
        }
        int endX = Math.min(this.cellXCount, this.getCellX((short)(this.viewMapX + this.viewWidth)) + 1);
        int endY = Math.min(this.cellYCount, this.getCellY((short)(this.viewMapY + this.viewHeight)) + 1);
        for (int i2 = startX; i2 < endX; ++i2) {
            for (int j2 = startY; j2 < endY; ++j2) {
                int id;
                if (i2 < 0 || j2 < 0 || i2 >= this.cellXCount || j2 >= this.cellYCount) continue;
                int x2 = i2 * this.cellWidth - this.viewMapX + this.vibrateX + dx;
                int y2 = j2 * this.cellHeight - this.viewMapY + this.vibrateY + dy;
                if (topLayer) {
                    id = (this.layer1TileID[i2][j2] & 0xFF) - 1;
                    if (id < 0 || !this.getCellFlag(this.cellData[i2][j2], (byte)1)) continue;
                    Tool.drawTile(g2, this.mapImages[(this.cellImageID[i2][j2] & 0xFF) >> 4], id, this.cellWidth, this.cellHeight, this.getCellTransType(this.cellData[i2][j2], (byte)1), x2, y2);
                    continue;
                }
                id = (this.layer0TileID[i2][j2] & 0xFF) - 1;
                if (id >= 0) {
                    Tool.drawTile(g2, this.mapImages[this.cellImageID[i2][j2] & 0xF], id, this.cellWidth, this.cellHeight, this.getCellTransType(this.cellData[i2][j2], (byte)0), x2, y2);
                }
                if ((id = (this.layer1TileID[i2][j2] & 0xFF) - 1) < 0 || this.getCellFlag(this.cellData[i2][j2], (byte)1)) continue;
                Tool.drawTile(g2, this.mapImages[(this.cellImageID[i2][j2] & 0xFF) >> 4], id, this.cellWidth, this.cellHeight, this.getCellTransType(this.cellData[i2][j2], (byte)1), x2, y2);
            }
        }
    }

    public void drawBufferCell(int startX, int startY, int endX, int endY) {
        this.gg.setColor(this.backgroundColor);
        for (int i2 = startX; i2 <= endX; ++i2) {
            int sx = i2 % this.bgCellXCount * this.cellWidth;
            for (int j2 = startY; j2 <= endY; ++j2) {
                int sy = j2 % this.bgCellYCount * this.cellHeight;
                this.gg.setClip(sx, sy, (int)this.cellWidth, (int)this.cellHeight);
                this.gg.fillRect(sx, sy, (int)this.cellWidth, (int)this.cellHeight);
                if (i2 < 0 || i2 >= this.cellXCount || j2 < 0 || j2 >= this.cellYCount) continue;
                int id = (this.layer0TileID[i2][j2] & 0xFF) - 1;
                if (id >= 0) {
                    Tool.drawTile(this.gg, this.mapImages[this.cellImageID[i2][j2] & 0xF], id, this.cellWidth, this.cellHeight, this.getCellTransType(this.cellData[i2][j2], (byte)0), sx, sy);
                }
                if ((id = (this.layer1TileID[i2][j2] & 0xFF) - 1) < 0 || this.getCellFlag(this.cellData[i2][j2], (byte)1)) continue;
                Tool.drawTile(this.gg, this.mapImages[(this.cellImageID[i2][j2] & 0xFF) >> 4], id, this.cellWidth, this.cellHeight, this.getCellTransType(this.cellData[i2][j2], (byte)1), sx, sy);
            }
        }
    }

    private boolean getCellFlag(byte data, byte layer) {
        if (layer == 0) {
            return ((data & 0xFF) >> 3 & 1) == 1;
        }
        return ((data & 0xFF) >> 7 & 1) == 1;
    }

    private int getCellTransType(byte data, byte layer) {
        if (layer == 0) {
            return data & 7;
        }
        return (data & 0xFF) >> 4 & 7;
    }

    public boolean canPosPass(int mapX, int mapY) {
        return this.canCellPass(mapX / this.cellWidth, mapY / this.cellHeight);
    }

    public boolean canCellPass(int x2, int y2) {
        return !this.getCellFlag(this.cellData[x2][y2], (byte)0);
    }

    public void setMapPass(int x2, int y2, boolean bPass) {
        this.cellData[x2][y2] = bPass ? (byte)(this.cellData[x2][y2] & 0xFFFFFFF7) : (byte)(this.cellData[x2][y2] | 8);
    }

    public void setMapCell(int layer, int mx, int my, int realid, int type) {
        if (layer == 0) {
            this.layer0TileID[mx][my] = (byte)realid;
            this.cellData[mx][my] = (byte)(this.cellData[mx][my] & 0xF8 | type);
        } else if (layer == 1) {
            this.layer1TileID[mx][my] = (byte)realid;
            this.cellData[mx][my] = (byte)(this.cellData[mx][my] & 0x8F | type << 4);
        }
        this.bFirstBgImage = true;
    }

    private Image loadImage(String str) {
        str = "/map" + str;
        System.out.println("Load Map Image = " + str);
        return Tool.createImage(str);
    }
}

