/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.event;

import de.enough.polish.util.ArrayList;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;

public class AsynchronousCommandListener
implements Runnable,
CommandListener {
    private final CommandListener parent;
    private final ArrayList commands;
    private final ArrayList displays;
    private boolean isStopRequested;
    private boolean isWorking;

    public AsynchronousCommandListener(CommandListener parent) {
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        this.parent = parent;
        this.commands = new ArrayList();
        this.displays = new ArrayList();
        Thread thread = new Thread(this);
        thread.start();
    }

    public void requestStop() {
        this.isStopRequested = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.isStopRequested) {
            AsynchronousCommandListener asynchronousCommandListener = this;
            synchronized (asynchronousCommandListener) {
                if (this.commands.size() == 0) {
                    this.isWorking = false;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                }
                this.isWorking = true;
            }
            while (this.commands.size() > 0) {
                Command cmd = null;
                Displayable disp = null;
                AsynchronousCommandListener asynchronousCommandListener2 = this;
                synchronized (asynchronousCommandListener2) {
                    cmd = (Command)this.commands.remove(0);
                    disp = (Displayable)this.displays.remove(0);
                }
                try {
                    this.parent.commandAction(cmd, disp);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commandAction(Command cmd, Displayable disp) {
        AsynchronousCommandListener asynchronousCommandListener = this;
        synchronized (asynchronousCommandListener) {
            if (this.isWorking) {
                WorkerThread thread = new WorkerThread(cmd, disp);
                thread.start();
            } else {
                this.commands.add(cmd);
                this.displays.add(disp);
                this.notify();
            }
        }
    }

    class WorkerThread
    extends Thread {
        private Command command;
        private Displayable displayable;

        public WorkerThread(Command command, Displayable displayable) {
            this.command = command;
            this.displayable = displayable;
        }

        public void run() {
            AsynchronousCommandListener.this.parent.commandAction(this.command, this.displayable);
        }
    }
}

