/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.splash;

import de.enough.polish.ui.AccessibleCanvas;
import de.enough.polish.ui.splash.ApplicationInitializer;
import de.enough.polish.util.TextUtil;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class InitializerSplashScreen
extends Canvas
implements Runnable,
AccessibleCanvas {
    private final ApplicationInitializer initializer;
    private boolean isInitialized;
    private Displayable nextScreen;
    private final Display display;
    private final Image image;
    private String readyMessage;
    private final int messageColor;
    private final int backgroundColor;
    private String message;
    private boolean isStarted;

    public InitializerSplashScreen(Display display, Image image, int backgroundColor, String readyMessage, int messageColor, ApplicationInitializer initializer) {
        this.display = display;
        this.image = image;
        this.backgroundColor = backgroundColor;
        this.readyMessage = readyMessage;
        this.messageColor = messageColor;
        this.initializer = initializer;
    }

    public void setMessage(String message) {
        this.message = message;
        this.repaint();
    }

    public void paint(Graphics g2) {
        block3: {
            int width;
            int height;
            block2: {
                height = this.getHeight();
                width = this.getWidth();
                g2.setColor(this.backgroundColor);
                g2.fillRect(0, 0, width, height);
                g2.drawImage(this.image, width / 2, height / 2, 3);
                if (!this.isInitialized) break block2;
                g2.setColor(this.messageColor);
                Font font = Font.getDefaultFont();
                String[] lines = TextUtil.wrap(this.readyMessage, font, width - 10, width - 10);
                int y2 = height - lines.length * (font.getHeight() + 1);
                for (int i2 = 0; i2 < lines.length; ++i2) {
                    String line = lines[i2];
                    g2.drawString(line, width / 2, y2, 17);
                    y2 += font.getHeight() + 1;
                }
                break block3;
            }
            if (this.message == null) break block3;
            g2.setColor(this.messageColor);
            Font font = Font.getDefaultFont();
            String[] lines = TextUtil.wrap(this.message, font, width - 10, width - 10);
            int y3 = height - lines.length * (font.getHeight() + 1);
            for (int i3 = 0; i3 < lines.length; ++i3) {
                String line = lines[i3];
                g2.drawString(line, width / 2, y3, 17);
                y3 += font.getHeight() + 1;
            }
        }
    }

    public void run() {
        try {
            this.nextScreen = this.initializer.initApp();
            if (this.readyMessage == null && this.nextScreen != null) {
                this.display.setCurrent(this.nextScreen);
                return;
            }
            this.isInitialized = true;
            this.repaint();
        }
        catch (Exception e2) {
            this.message = "Error: " + e2.toString();
            this.repaint();
        }
    }

    public void keyPressed(int keyCode) {
        if (this.isInitialized && this.nextScreen != null) {
            this.display.setCurrent(this.nextScreen);
        }
    }

    public void keyReleased(int keyCode) {
    }

    public void keyRepeated(int keyCode) {
    }

    public void pointerPressed(int x2, int y2) {
        this.keyPressed(0);
    }

    public void pointerReleased(int x2, int y2) {
        this.keyReleased(0);
    }

    public void pointerDragged(int x2, int y2) {
    }

    public void sizeChanged(int width, int height) {
        this.repaint();
    }

    public void showNotify() {
        super.setFullScreenMode(true);
        if (this.isStarted) {
            return;
        }
        this.isStarted = true;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void hideNotify() {
    }
}

