/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.util.BitMapFontViewer;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Image;

public final class BitMapFont {
    private static Hashtable fontsByUrl = new Hashtable();
    private String fontUrl;
    private Image fontImage;
    private boolean hasMixedCase;
    private byte[] characterWidths;
    private short[] xPositions;
    private String characterMap;
    private int fontHeight;
    private int spaceIndex;

    private BitMapFont(String fontUrl) {
        this.fontUrl = fontUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFont() {
        InputStream in = null;
        try {
            String map;
            in = this.getClass().getResourceAsStream(this.fontUrl);
            if (in == null) {
                return;
            }
            DataInputStream dataIn = new DataInputStream(in);
            this.hasMixedCase = dataIn.readBoolean();
            this.characterMap = map = dataIn.readUTF();
            this.spaceIndex = map.indexOf(32);
            int length = map.length();
            this.characterWidths = new byte[length];
            this.xPositions = new short[length];
            short xPos = 0;
            for (int i2 = 0; i2 < length; ++i2) {
                byte width;
                this.characterWidths[i2] = width = dataIn.readByte();
                this.xPositions[i2] = xPos;
                xPos = (short)(xPos + width);
            }
            this.fontImage = Image.createImage((InputStream)in);
            this.fontHeight = this.fontImage.getHeight();
            this.fontUrl = null;
        }
        catch (IOException e2) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e3) {}
            }
        }
    }

    public BitMapFontViewer getViewer(String input) {
        if (this.fontImage == null) {
            this.initFont();
            if (this.fontImage == null) {
                return null;
            }
        }
        if (!this.hasMixedCase) {
            input = input.toLowerCase();
        }
        int length = input.length();
        int[] indeces = new int[length];
        for (int i2 = length - 1; i2 >= 0; --i2) {
            char inputCharacter = input.charAt(i2);
            indeces[i2] = inputCharacter == '\n' ? -2 : this.characterMap.indexOf(inputCharacter);
        }
        return new BitMapFontViewer(this.fontImage, indeces, this.xPositions, this.characterWidths, this.fontHeight, this.spaceIndex, 1);
    }

    public static BitMapFont getInstance(String url) {
        BitMapFont font = (BitMapFont)fontsByUrl.get(url);
        if (font == null) {
            font = new BitMapFont(url);
            fontsByUrl.put(url, font);
        }
        return font;
    }

    public static void removeInstance(String url) {
        fontsByUrl.remove(url);
    }

    public int charWidth(char c2) {
        if (this.fontImage == null) {
            this.initFont();
            if (this.fontImage == null) {
                return -1;
            }
        }
        for (int i2 = 0; i2 < this.characterMap.length(); ++i2) {
            char cm = this.characterMap.charAt(i2);
            if (cm != c2) continue;
            return this.characterWidths[i2];
        }
        return -1;
    }

    public int stringWidth(String str) {
        if (this.fontImage == null) {
            this.initFont();
            if (this.fontImage == null) {
                return -1;
            }
        }
        int width = 0;
        block0: for (int i2 = 0; i2 < str.length(); ++i2) {
            char c2 = str.charAt(i2);
            for (int j2 = 0; j2 < this.characterMap.length(); ++j2) {
                char cm = this.characterMap.charAt(j2);
                if (cm != c2) continue;
                width += this.characterWidths[j2];
                continue block0;
            }
        }
        return width;
    }

    public int getFontHeight() {
        if (this.fontImage == null) {
            this.initFont();
            if (this.fontImage == null) {
                return -1;
            }
        }
        return this.fontHeight;
    }
}

