/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import javax.microedition.lcdui.Graphics;

public final class DrawUtil {
    static int COLOR_BIT_MASK = 255;
    public static byte[][] FILTER_GAUSSIAN_2 = new byte[][]{{1, 2, 1}, {2, 4, 2}, {1, 2, 1}};
    public static byte[][] FILTER_GAUSSIAN_3 = new byte[][]{{0, 1, 2, 1, 0}, {1, 3, 5, 3, 1}, {2, 5, 9, 5, 2}, {1, 3, 5, 3, 1}, {0, 1, 2, 1, 0}};

    public static final void fillRect(int x2, int y2, int width, int height, int color, Graphics g2) {
        if ((color & 0xFF000000) == 0) {
            g2.setColor(color);
            g2.fillRect(x2, y2, width, height);
            return;
        }
        int[] buffer = new int[width];
        for (int i2 = buffer.length - 1; i2 >= 0; --i2) {
            buffer[i2] = color;
        }
        if (x2 < 0) {
            width += x2;
            x2 = 0;
        }
        if (width <= 0) {
            return;
        }
        if (y2 < 0) {
            height += y2;
            y2 = 0;
        }
        if (height <= 0) {
            return;
        }
        g2.drawRGB(buffer, 0, 0, x2, y2, width, height, true);
    }

    public static void drawPolygon(int[] xPoints, int[] yPoints, int color, Graphics g2) {
        int length = xPoints.length - 1;
        g2.setColor(color);
        for (int i2 = 0; i2 < length; ++i2) {
            g2.drawLine(xPoints[i2], yPoints[i2], xPoints[i2 + 1], yPoints[i2 + 1]);
        }
        g2.drawLine(xPoints[length], yPoints[length], xPoints[0], yPoints[0]);
    }

    public static final void fillPolygon(int[] xPoints, int[] yPoints, int color, Graphics g2) {
        while (xPoints.length > 2) {
            int a2 = DrawUtil.indexOfLeast(xPoints);
            int b2 = (a2 + 1) % xPoints.length;
            int c2 = a2 > 0 ? a2 - 1 : xPoints.length - 1;
            int leastInternalIndex = -1;
            boolean leastInternalSet = false;
            if (xPoints.length > 3) {
                for (int i2 = 0; i2 < xPoints.length; ++i2) {
                    if (i2 == a2 || i2 == b2 || i2 == c2 || !DrawUtil.withinBounds(xPoints[i2], yPoints[i2], xPoints[a2], yPoints[a2], xPoints[b2], yPoints[b2], xPoints[c2], yPoints[c2]) || leastInternalSet && xPoints[i2] >= xPoints[leastInternalIndex]) continue;
                    leastInternalIndex = i2;
                    leastInternalSet = true;
                }
            }
            if (!leastInternalSet) {
                g2.setColor(color);
                g2.fillTriangle(xPoints[a2], yPoints[a2], xPoints[b2], yPoints[b2], xPoints[c2], yPoints[c2]);
                int[][] trimmed = DrawUtil.trimEar(xPoints, yPoints, a2);
                xPoints = trimmed[0];
                yPoints = trimmed[1];
                continue;
            }
            int[][][] split = DrawUtil.split(xPoints, yPoints, a2, leastInternalIndex);
            int[][] poly1 = split[0];
            int[][] poly2 = split[1];
            DrawUtil.fillPolygon(poly1[0], poly1[1], color, g2);
            DrawUtil.fillPolygon(poly2[0], poly2[1], color, g2);
            break;
        }
    }

    public static void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3, Graphics g2) {
        g2.fillTriangle(x1, y1, x2, y2, x3, y3);
    }

    public static int getCenter(int n1, int n2, int n3) {
        int max = Math.max(n1, Math.max(n2, n3));
        int min = Math.min(n1, Math.min(n2, n3));
        return min + (max - min) / 2;
    }

    public static void drawTriangle(int x1, int y1, int x2, int y2, int x3, int y3, Graphics g2) {
        g2.drawLine(x1, y1, x2, y2);
        g2.drawLine(x2, y2, x3, y3);
        g2.drawLine(x3, y3, x1, y1);
    }

    static int indexOfLeast(int[] elements) {
        int index = 0;
        int least = elements[0];
        for (int i2 = 1; i2 < elements.length; ++i2) {
            if (elements[i2] >= least) continue;
            index = i2;
            least = elements[i2];
        }
        return index;
    }

    private static boolean withinBounds(int px, int py, int ax, int ay, int bx, int by, int cx, int cy) {
        if (px < Math.min(ax, Math.min(bx, cx)) || px > Math.max(ax, Math.max(bx, cx)) || py < Math.min(ay, Math.min(by, cy)) || py > Math.max(ay, Math.max(by, cy))) {
            return false;
        }
        boolean sameabc = DrawUtil.sameSide(px, py, ax, ay, bx, by, cx, cy);
        boolean samebac = DrawUtil.sameSide(px, py, bx, by, ax, ay, cx, cy);
        boolean samecab = DrawUtil.sameSide(px, py, cx, cy, ax, ay, bx, by);
        return sameabc && samebac && samecab;
    }

    private static boolean sameSide(int p1x, int p1y, int p2x, int p2y, int l1x, int l1y, int l2x, int l2y) {
        long lhs = (p1x - l1x) * (l2y - l1y) - (l2x - l1x) * (p1y - l1y);
        long rhs = (p2x - l1x) * (l2y - l1y) - (l2x - l1x) * (p2y - l1y);
        long product = lhs * rhs;
        boolean result = product >= 0L;
        return result;
    }

    private static int[][] trimEar(int[] xPoints, int[] yPoints, int earIndex) {
        int[] newXPoints = new int[xPoints.length - 1];
        int[] newYPoints = new int[yPoints.length - 1];
        int[][] newPoly = new int[][]{newXPoints, newYPoints};
        int p2 = 0;
        for (int i2 = 0; i2 < xPoints.length; ++i2) {
            if (i2 == earIndex) continue;
            newXPoints[p2] = xPoints[i2];
            newYPoints[p2] = yPoints[i2];
            ++p2;
        }
        return newPoly;
    }

    private static int[][][] split(int[] xPoints, int[] yPoints, int aIndex, int bIndex) {
        int index;
        int i2;
        int firstLen = bIndex < aIndex ? xPoints.length - aIndex + bIndex + 1 : bIndex - aIndex + 1;
        int secondLen = xPoints.length - firstLen + 2;
        int[][] first = new int[2][firstLen];
        int[][] second = new int[2][secondLen];
        for (i2 = 0; i2 < firstLen; ++i2) {
            index = (aIndex + i2) % xPoints.length;
            first[0][i2] = xPoints[index];
            first[1][i2] = yPoints[index];
        }
        for (i2 = 0; i2 < secondLen; ++i2) {
            index = (bIndex + i2) % xPoints.length;
            second[0][i2] = xPoints[index];
            second[1][i2] = yPoints[index];
        }
        int[][][] result = new int[][][]{first, second};
        return result;
    }

    public static final int[] getGradient(int startColor, int endColor, int steps) {
        int[] gradient = new int[steps];
        DrawUtil.getGradient(startColor, endColor, gradient);
        return gradient;
    }

    public static final void getGradient(int startColor, int endColor, int[] gradient) {
        int steps = gradient.length;
        if (steps == 0) {
            return;
        }
        if (steps == 1) {
            gradient[0] = startColor;
            return;
        }
        int startAlpha = startColor >>> 24;
        int startRed = startColor >>> 16 & 0xFF;
        int startGreen = startColor >>> 8 & 0xFF;
        int startBlue = startColor & 0xFF;
        int endAlpha = endColor >>> 24;
        int endRed = endColor >>> 16 & 0xFF;
        int endGreen = endColor >>> 8 & 0xFF;
        int endBlue = endColor & 0xFF;
        int stepAlpha = (endAlpha - startAlpha << 8) / (steps - 1);
        int stepRed = (endRed - startRed << 8) / (steps - 1);
        int stepGreen = (endGreen - startGreen << 8) / (steps - 1);
        int stepBlue = (endBlue - startBlue << 8) / (steps - 1);
        startAlpha <<= 8;
        startRed <<= 8;
        startGreen <<= 8;
        startBlue <<= 8;
        gradient[0] = startColor;
        for (int i2 = 1; i2 < steps; ++i2) {
            gradient[i2] = (startAlpha += stepAlpha) << 16 & 0xFF000000 | (startRed += stepRed) << 8 & 0xFF0000 | (startGreen += stepGreen) & 0xFF00 | (startBlue += stepBlue) >>> 8;
        }
    }

    public static final int getGradientColor(int startColor, int endColor, int permille) {
        int alpha = startColor >>> 24;
        int red = startColor >>> 16 & 0xFF;
        int green = startColor >>> 8 & 0xFF;
        int blue = startColor & 0xFF;
        int diffAlpha = (endColor >>> 24) - alpha;
        int diffRed = (endColor >>> 16 & 0xFF) - red;
        int diffGreen = (endColor >>> 8 & 0xFF) - green;
        int diffBlue = (endColor & 0xFF) - blue;
        return (alpha += diffAlpha * permille / 1000) << 24 | (red += diffRed * permille / 1000) << 16 | (green += diffGreen * permille / 1000) << 8 | (blue += diffBlue * permille / 1000);
    }

    public static final int getGradientColor(int startColor, int endColor, int step, int numberOfSteps) {
        int permille = step * 1000 / numberOfSteps;
        return DrawUtil.getGradientColor(startColor, endColor, permille);
    }

    public static int getComplementaryColor(int color) {
        return 0xFF000000 & color | 255 - ((0xFF0000 & color) >> 16) << 16 | 255 - ((0xFF00 & color) >> 8) << 8 | 255 - (0xFF & color);
    }

    public static final void dropShadow(int[] argbData, int width, int height, int xOffset, int yOffset, int size, int innerColor, int outerColor) {
        int iLeft = size - xOffset < 0 ? 0 : size - xOffset;
        int iRight = size + xOffset < 0 ? 0 : size + xOffset;
        int iTop = size - yOffset < 0 ? 0 : size - yOffset;
        int iBottom = size + yOffset < 0 ? 0 : size + yOffset;
        int[] gradient = DrawUtil.getGradient(innerColor, outerColor, size);
        for (int ix = -size + 1; ix < size; ++ix) {
            for (int iy = -size + 1; iy < size; ++iy) {
                int r2 = (int)Math.sqrt(ix * ix + iy * iy);
                if (r2 >= size) continue;
                int gColor = gradient[r2];
                for (int col = iLeft; col < width - iRight; ++col) {
                    for (int row = iTop; row < height - iBottom - 1; ++row) {
                        if (argbData[row * width + col] >>> 24 != 255 || argbData[(row + yOffset + iy) * width + col + xOffset + ix] >>> 24 >= gColor >>> 24) continue;
                        argbData[(row + yOffset + iy) * width + col + xOffset + ix] = gColor;
                    }
                }
            }
        }
    }

    public static final void applyFilter(byte[][] filterMatrix, int brightness, int[] argbData, int width, int height) {
        if (filterMatrix.length % 2 != 1 || filterMatrix[0].length % 2 != 1) {
            throw new IllegalArgumentException();
        }
        int fhRadius = filterMatrix.length / 2 + 1;
        int fwRadius = filterMatrix[0].length / 2 + 1;
        int currentPixel = 0;
        int divisor = 0;
        for (int fRow = 0; fRow < filterMatrix.length; ++fRow) {
            for (int fCol = 0; fCol < filterMatrix[0].length; ++fCol) {
                divisor += filterMatrix[fRow][fCol];
            }
        }
        if (divisor == 0) {
            return;
        }
        int[] tmpRect = new int[width * filterMatrix.length];
        System.arraycopy(argbData, 0, tmpRect, 0, width * filterMatrix.length);
        int row = fhRadius - 1;
        while (row + fhRadius < height + 1) {
            int col = fwRadius - 1;
            while (col + fwRadius < width + 1) {
                int newTran = 0;
                int newRed = 0;
                int newGreen = 0;
                int newBlue = 0;
                for (int fRow = 0; fRow < filterMatrix.length; ++fRow) {
                    for (int fCol = 0; fCol < filterMatrix[0].length; ++fCol) {
                        currentPixel = tmpRect[fRow * width + col + fCol - fwRadius + 1];
                        if ((currentPixel >>> 24 & COLOR_BIT_MASK) == 0) continue;
                        newTran += filterMatrix[fRow][fCol] * (currentPixel >>> 24 & COLOR_BIT_MASK);
                        newRed += filterMatrix[fRow][fCol] * (currentPixel >>> 16 & COLOR_BIT_MASK);
                        newGreen += filterMatrix[fRow][fCol] * (currentPixel >>> 8 & COLOR_BIT_MASK);
                        newBlue += filterMatrix[fRow][fCol] * (currentPixel & COLOR_BIT_MASK);
                    }
                }
                newTran = newTran * brightness / 100 / divisor;
                newRed = newRed * brightness / 100 / divisor;
                newGreen = newGreen * brightness / 100 / divisor;
                newBlue = newBlue * brightness / 100 / divisor;
                newTran = Math.max(0, Math.min(255, newTran));
                newRed = Math.max(0, Math.min(255, newRed));
                newGreen = Math.max(0, Math.min(255, newGreen));
                newBlue = Math.max(0, Math.min(255, newBlue));
                argbData[row * width + col] = newTran << 24 | newRed << 16 | newGreen << 8 | newBlue;
                ++col;
            }
            if (row + fhRadius != height) {
                System.arraycopy(tmpRect, width, tmpRect, 0, width * (filterMatrix.length - 1));
                System.arraycopy(argbData, width * (row + fhRadius), tmpRect, width * (filterMatrix.length - 1), width);
            }
            ++row;
        }
    }

    public static void drawLine(int color, int x1, int y1, int x2, int y2, Graphics g2) {
        if (y2 < y1) {
            int top = y2;
            y2 = y1;
            y1 = top;
        }
        if (x2 < x1) {
            int left = x2;
            x2 = x1 = x2;
            x1 = left;
        }
        if (x1 == x2 || y1 == y2) {
            int height;
            int width = x2 - x1;
            if (width == 0) {
                width = 1;
            }
            if ((height = y2 - y1) == 0) {
                height = 1;
            }
            int[] rgb = new int[Math.max(width, height)];
            for (int i2 = 0; i2 < rgb.length; ++i2) {
                rgb[i2] = color;
            }
            g2.drawRGB(rgb, 0, 0, x1, y1, width, height, true);
        }
    }

    public static void drawRgb(int[] rgb, int x2, int y2, int width, int height, boolean processAlpha, Graphics g2) {
        DrawUtil.drawRgb(rgb, x2, y2, width, height, processAlpha, g2.getClipX(), g2.getClipY(), g2.getClipWidth(), g2.getClipHeight(), g2);
    }

    public static void drawRgb(int[] rgb, int x2, int y2, int width, int height, boolean processAlpha, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g2) {
        if (x2 + width < clipX || x2 > clipX + clipWidth || y2 + height < clipY || y2 > clipY + clipHeight) {
            return;
        }
        int offset = 0;
        if (x2 < clipX) {
            offset = clipX - x2;
            x2 = clipX;
        }
        int scanlength = width;
        if (x2 + (width -= offset) > clipX + clipWidth) {
            width = clipX + clipWidth - x2;
        }
        if (width <= 0) {
            return;
        }
        if (y2 < clipY) {
            offset += (clipY - y2) * scanlength;
            height -= clipY - y2;
            y2 = clipY;
        }
        if (y2 + height > clipY + clipHeight) {
            height = clipY + clipHeight - y2;
        }
        if (height <= 0) {
            return;
        }
        g2.drawRGB(rgb, offset, scanlength, x2, y2, width, height, processAlpha);
    }

    public static class FadeUtil {
        public static final int FADE_IN = 1;
        public static final int FADE_OUT = 2;
        public static final int FADE_LOOP = 3;
        public static final int FADE_BREAK = 0;
        public int[] gradient;
        public boolean changed;
        public int startColor = -16744193;
        public int endColor = -8323328;
        public int steps;
        public int delay = 0;
        public int stepsIn = 5;
        public int stepsOut = 5;
        public int sWaitTimeIn = 10;
        public int sWaitTimeOut = 0;
        public int mode = 3;
        public int cColor;
        public int cStep;

        private void initialize() {
            this.cStep = 0;
            switch (this.mode) {
                case 2: {
                    this.stepsIn = 0;
                    this.sWaitTimeIn = 0;
                    this.cColor = this.endColor;
                    break;
                }
                case 1: {
                    this.stepsOut = 0;
                    this.sWaitTimeOut = 0;
                    this.cColor = this.startColor;
                    break;
                }
                default: {
                    this.cColor = this.startColor;
                }
            }
            this.cStep -= this.delay;
            this.steps = this.stepsIn + this.stepsOut + this.sWaitTimeIn + this.sWaitTimeOut;
            this.gradient = DrawUtil.getGradient(this.startColor, this.endColor, Math.max(this.stepsIn, this.stepsOut));
        }

        public boolean step() {
            ++this.cStep;
            if (this.gradient == null | this.changed) {
                this.initialize();
            }
            this.changed = false;
            if (this.mode == 0) {
                return false;
            }
            if (this.cStep < 0) {
                return true;
            }
            if (this.cStep == this.steps) {
                this.cStep = 0;
                if (this.mode != 3) {
                    this.mode = 0;
                    return true;
                }
            }
            if (this.cStep < this.stepsIn) {
                this.cColor = this.gradient[this.cStep];
                return true;
            }
            if (this.cStep < this.stepsIn + this.sWaitTimeIn) {
                if (this.cColor != this.endColor) {
                    this.cColor = this.endColor;
                    return true;
                }
            } else {
                if (this.cStep < this.stepsIn + this.sWaitTimeIn + this.stepsOut) {
                    this.cColor = this.gradient[this.stepsIn + this.sWaitTimeIn + this.stepsOut - this.cStep - 1];
                    return true;
                }
                if (this.cColor != this.startColor) {
                    this.cColor = this.startColor;
                    return true;
                }
            }
            return false;
        }
    }
}

