/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.io.Externalizable;
import de.enough.polish.util.HashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Properties
extends HashMap
implements Externalizable {
    private boolean isIntegerValues;

    public Properties() {
    }

    public Properties(String url) throws IOException {
        this(url, null);
    }

    public Properties(String url, String encoding) throws IOException {
        this.load(this.getClass().getResourceAsStream(url), encoding, false);
    }

    public String getProperty(String key) {
        return (String)this.get(key);
    }

    public void setProperty(String key, String value) {
        this.put(key, value);
    }

    public void load(InputStream in) throws IOException {
        this.load(in, null, false);
    }

    public void load(InputStream in, String encoding, boolean generateIntegerValues) throws IOException {
        int read;
        this.isIntegerValues = generateIntegerValues;
        int bufferLength = 2048;
        byte[] buffer = new byte[bufferLength];
        int start = 0;
        int end = 0;
        while ((read = in.read(buffer, start, bufferLength - start)) != -1) {
            String line = encoding != null ? new String(buffer, 0, read + start, encoding) : new String(buffer, 0, read + start);
            start = 0;
            boolean newLineFound = true;
            while (newLineFound) {
                newLineFound = false;
                int c2 = 10;
                for (int i2 = start; i2 < line.length(); ++i2) {
                    c2 = line.charAt(i2);
                    if (c2 != 13 && c2 != 10) continue;
                    end = i2;
                    newLineFound = true;
                    break;
                }
                if (!newLineFound) continue;
                int splitPos = line.indexOf(61, start);
                if (splitPos == -1) {
                    throw new IOException("no = separator: " + line.substring(start, end));
                }
                String key = line.substring(start, splitPos);
                String value = line.substring(splitPos + 1, end);
                if (generateIntegerValues) {
                    try {
                        this.put(key, Integer.valueOf(value));
                    }
                    catch (NumberFormatException ex) {
                        throw new IOException(ex.toString());
                    }
                } else {
                    this.put(key, value);
                }
                if (c2 == 13) {
                    start = end + 2;
                    continue;
                }
                start = end + 1;
            }
            if (start < read) {
                System.arraycopy(buffer, start, buffer, 0, read - start);
                start = read - start;
                continue;
            }
            start = 0;
        }
    }

    public Object[] propertyNames() {
        return this.keys();
    }

    public void read(DataInputStream in) throws IOException {
        int size = in.readInt();
        this.isIntegerValues = in.readBoolean();
        for (int i2 = 0; i2 < size; ++i2) {
            String key = in.readUTF();
            Object value = this.isIntegerValues ? new Integer(in.readInt()) : in.readUTF();
            this.put(key, value);
        }
    }

    public void write(DataOutputStream out) throws IOException {
        int size = this.size();
        out.writeInt(size);
        out.writeBoolean(this.isIntegerValues);
        Object[] keys = this.keys();
        for (int i2 = 0; i2 < keys.length; ++i2) {
            String key = (String)keys[i2];
            out.writeUTF(key);
            if (this.isIntegerValues) {
                Integer value = (Integer)this.get(key);
                out.writeInt(value);
                continue;
            }
            out.writeUTF((String)this.get(key));
        }
    }
}

