/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.util.DrawUtil;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class RgbImage {
    private int[] rgbData;
    private int width;
    private int height;
    private boolean processTransparency;

    public RgbImage(int width, int height, int color) {
        this(width, height, color, true);
    }

    public RgbImage(int width, int height, int color, boolean processTransparency) {
        int[] data = new int[width * height];
        this.width = width;
        this.height = height;
        if ((color & 0xFF000000) != 0) {
            for (int i2 = 0; i2 < width * height; ++i2) {
                data[i2] = color;
            }
        }
        this.rgbData = data;
        this.processTransparency = processTransparency;
    }

    public RgbImage(int[] rgbData, int width) {
        this(rgbData, width, true);
    }

    public RgbImage(int[] rgbData, int width, boolean processTransparency) {
        this.setRgbData(rgbData, width, processTransparency);
    }

    public RgbImage(Image image, boolean processTransparency) {
        int w2 = image.getWidth();
        int h2 = image.getHeight();
        int[] data = new int[w2 * h2];
        this.setRgbData(data, w2, processTransparency);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isProcessTransparency() {
        return this.processTransparency;
    }

    public void setProcessTransparency(boolean processTransparency) {
        this.processTransparency = processTransparency;
    }

    public int[] getRgbData() {
        return this.rgbData;
    }

    public void setRgbData(int[] rgbData, int width) {
        this.setRgbData(rgbData, width, this.processTransparency);
    }

    public void setRgbData(int[] rgbData, int width, boolean processTransparency) {
        this.rgbData = rgbData;
        this.width = width;
        this.height = rgbData.length / width;
        this.processTransparency = processTransparency;
    }

    public void paint(int x2, int y2, Graphics g2) {
        DrawUtil.drawRgb(this.rgbData, x2, y2, this.width, this.height, this.processTransparency, g2);
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void fill(int color) {
        for (int i2 = 0; i2 < this.rgbData.length; ++i2) {
            this.rgbData[i2] = color;
        }
    }
}

