/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util.zip;

import java.io.IOException;
import java.io.InputStream;

public final class ZipHelper {
    public static final int[] LENGTH_CODE = new int[]{0, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 1, 11, 1, 13, 1, 15, 1, 17, 2, 19, 2, 23, 2, 27, 2, 31, 3, 35, 3, 43, 3, 51, 3, 59, 4, 67, 4, 83, 4, 99, 4, 115, 5, 131, 5, 163, 5, 195, 5, 227, 0, 258};
    public static final int[] DISTANCE_CODE = new int[]{0, 1, 0, 2, 0, 3, 0, 4, 1, 5, 1, 7, 2, 9, 2, 13, 3, 17, 3, 25, 4, 33, 4, 49, 5, 65, 5, 97, 6, 129, 6, 193, 7, 257, 7, 385, 8, 513, 8, 769, 9, 1025, 9, 1537, 10, 2049, 10, 3073, 11, 4097, 11, 6145, 12, 8193, 12, 12289, 13, 16385, 13, 24577};

    public static final int encodeCode(int[] Code, int distance) {
        int i2;
        for (i2 = 0; i2 < Code.length >> 1 && distance >= Code[(i2 << 1) + 1]; ++i2) {
        }
        return i2 - 1;
    }

    public static final void genHuffTree(int[] huffmanCode, byte[] huffmanCodeLength) {
        int maxbits = 0;
        for (int i2 = 0; i2 < huffmanCodeLength.length; ++i2) {
            int length = huffmanCodeLength[i2];
            maxbits = maxbits > length ? maxbits : length;
        }
        short[] bitlen_count = new short[++maxbits];
        for (int i3 = 0; i3 < huffmanCodeLength.length; ++i3) {
            byte by = huffmanCodeLength[i3];
            bitlen_count[by] = (short)(bitlen_count[by] + 1);
        }
        int code = 0;
        int[] next_code = new int[maxbits];
        bitlen_count[0] = 0;
        for (int bits = 1; bits < maxbits; ++bits) {
            next_code[bits] = code = code + bitlen_count[bits - 1] << 1;
        }
        for (int i4 = 0; i4 < huffmanCode.length; ++i4) {
            byte length = huffmanCodeLength[i4];
            if (length == 0) continue;
            huffmanCode[i4] = next_code[length];
            byte by = length;
            next_code[by] = next_code[by] + 1;
        }
    }

    public static final void revHuffTree(int[] huffmanCode, byte[] huffmanCodeLength) {
        for (int i2 = 0; i2 < huffmanCode.length; ++i2) {
            int tmp = huffmanCode[i2];
            int reversed = 0;
            for (int j2 = 0; j2 < huffmanCodeLength[i2]; ++j2) {
                reversed |= tmp >>> j2 & 1;
                reversed <<= 1;
            }
            huffmanCode[i2] = reversed >>> 1;
        }
    }

    public static final void genFixedTree(int[] huffmanCode, byte[] huffmanCodeLength, int[] distHuffCode, byte[] distHuffCodeLength) {
        int i2;
        for (i2 = 0; i2 <= 143; ++i2) {
            huffmanCode[i2] = 48 + i2;
            huffmanCodeLength[i2] = 8;
        }
        for (i2 = 144; i2 <= 255; ++i2) {
            huffmanCode[i2] = 400 + i2 - 144;
            huffmanCodeLength[i2] = 9;
        }
        for (i2 = 256; i2 <= 279; ++i2) {
            huffmanCode[i2] = i2 - 256;
            huffmanCodeLength[i2] = 7;
        }
        for (i2 = 280; i2 < 286; ++i2) {
            huffmanCode[i2] = 192 + i2 - 280;
            huffmanCodeLength[i2] = 8;
        }
        ZipHelper.revHuffTree(huffmanCode, huffmanCodeLength);
        for (int j2 = 0; j2 < distHuffCode.length; ++j2) {
            distHuffCode[j2] = j2;
            distHuffCodeLength[j2] = 5;
        }
        ZipHelper.revHuffTree(distHuffCode, distHuffCodeLength);
    }

    public static final void genTreeLength(int[] count, byte[] huffmanCodeLength, int max_len) {
        int i2;
        int[] knotCount = new int[count.length];
        int[] knotPointer = new int[count.length];
        for (int i3 = 0; i3 < count.length; i3 = (int)((short)(i3 + 1))) {
            knotCount[i3] = count[i3] != 0 ? count[i3] : Integer.MAX_VALUE;
            knotPointer[i3] = i3;
        }
        int s1 = 0;
        int s2 = 0;
        block1: while (true) {
            if (knotCount[0] < knotCount[1]) {
                s1 = 0;
                s2 = 1;
            } else {
                s1 = 1;
                s2 = 0;
            }
            for (int i4 = 2; i4 < count.length; ++i4) {
                if (knotCount[i4] < knotCount[s1]) {
                    s2 = s1;
                    s1 = i4;
                    continue;
                }
                if (knotCount[i4] >= knotCount[s2]) continue;
                s2 = i4;
            }
            if (knotCount[s2] == Integer.MAX_VALUE) break;
            int n2 = s1;
            knotCount[n2] = knotCount[n2] + knotCount[s2];
            int tmp = knotPointer[s2];
            knotCount[s2] = Integer.MAX_VALUE;
            i2 = 0;
            while (true) {
                if (i2 >= count.length) continue block1;
                if (knotPointer[i2] == tmp) {
                    knotPointer[i2] = knotPointer[s1];
                    int n3 = i2;
                    huffmanCodeLength[n3] = (byte)(huffmanCodeLength[n3] + 1);
                } else if (knotPointer[i2] == knotPointer[s1]) {
                    int n4 = i2;
                    huffmanCodeLength[n4] = (byte)(huffmanCodeLength[n4] + 1);
                }
                ++i2;
            }
            break;
        }
        int overflowCount = 0;
        for (i2 = 0; i2 < huffmanCodeLength.length; ++i2) {
            if (huffmanCodeLength[i2] <= max_len) continue;
            ++overflowCount;
        }
        if (overflowCount != 0) {
            System.out.println(" fixing " + overflowCount + " overflows  because of max=" + max_len);
            short[] overflows = new short[overflowCount];
            overflowCount = 0;
            for (int i5 = 0; i5 < huffmanCodeLength.length; i5 = (int)((short)(i5 + 1))) {
                if (huffmanCodeLength[i5] <= max_len) continue;
                overflows[overflowCount++] = i5;
            }
            int minNode = 0;
            for (int i6 = 0; i6 < huffmanCodeLength.length; ++i6) {
                if (huffmanCodeLength[i6] == 0 || huffmanCodeLength[minNode] <= huffmanCodeLength[i6]) continue;
                minNode = i6;
            }
            while (overflowCount != 0) {
                int i7;
                int exendableNode = minNode;
                for (i7 = 0; i7 < huffmanCodeLength.length; ++i7) {
                    if (huffmanCodeLength[i7] >= max_len || huffmanCodeLength[exendableNode] >= huffmanCodeLength[i7]) continue;
                    exendableNode = i7;
                }
                int overflow1 = 0;
                int overflow2 = 0;
                for (i7 = 0; i7 < overflows.length; ++i7) {
                    if (huffmanCodeLength[overflows[i7]] > huffmanCodeLength[overflow1]) {
                        overflow1 = overflows[i7];
                        continue;
                    }
                    if (huffmanCodeLength[overflows[i7]] != huffmanCodeLength[overflow1]) continue;
                    overflow2 = overflows[i7];
                }
                int n5 = exendableNode;
                huffmanCodeLength[n5] = (byte)(huffmanCodeLength[n5] + 1);
                huffmanCodeLength[overflow1] = huffmanCodeLength[exendableNode];
                int n6 = overflow2;
                huffmanCodeLength[n6] = (byte)(huffmanCodeLength[n6] - 1);
                --overflowCount;
                if (huffmanCodeLength[overflow2] != max_len) continue;
                --overflowCount;
            }
        }
    }

    public static final void convertTable2Tree(int[] huffmanCode, byte[] huffmanCodeLength, int[] huffmanData, short[] huffmanTree) {
        for (int i2 = 0; i2 < huffmanTree.length; ++i2) {
            huffmanTree[i2] = 0;
        }
        int nextNode = 1;
        for (int i3 = 0; i3 < huffmanCode.length; i3 = (int)((short)(i3 + 1))) {
            if (huffmanCodeLength[i3] == 0) continue;
            int pointer = 0;
            for (short j2 = 0; j2 < huffmanCodeLength[i3]; j2 = (short)(j2 + 1)) {
                if (huffmanTree[pointer * 2] == 0) {
                    int n2 = nextNode;
                    nextNode = (short)(nextNode + 1);
                    huffmanTree[pointer * 2] = n2;
                    int n3 = nextNode;
                    nextNode = (short)(nextNode + 1);
                    huffmanTree[pointer * 2 + 1] = n3;
                }
                pointer = huffmanTree[pointer * 2 + (huffmanCode[i3] >>> j2 & 1)];
            }
            if (pointer < 0) {
                // empty if block
            }
            huffmanTree[pointer * 2] = -1;
            huffmanTree[pointer * 2 + 1] = (short)huffmanData[i3];
        }
    }

    public static final int deHuffNext(long[] smallCodeBuffer, short[] huffmanTree) throws IOException {
        if (smallCodeBuffer[1] < 15L) {
            // empty if block
        }
        int pointer = 0;
        while (huffmanTree[pointer * 2] != -1) {
            pointer = huffmanTree[pointer * 2 + (int)(smallCodeBuffer[0] & 1L)];
            smallCodeBuffer[0] = smallCodeBuffer[0] >>> 1;
            smallCodeBuffer[1] = smallCodeBuffer[1] - 1L;
            if (pointer != 0) continue;
            throw new IOException("5");
        }
        return huffmanTree[pointer * 2 + 1];
    }

    public static final void skipheader(InputStream in) throws IOException {
        if (in.read() != 31 || in.read() != 139 || in.read() != 8) {
            throw new IOException("0");
        }
        int flag = in.read();
        in.skip(6L);
        if ((flag & 4) == 4) {
            in.skip(in.read() | in.read() << 8);
        }
        if ((flag & 8) == 8) {
            while (in.read() != 0) {
            }
        }
        if ((flag & 0x10) == 16) {
            while (in.read() != 0) {
            }
        }
        if ((flag & 2) == 2) {
            in.skip(2L);
        }
    }

    private static final void initCrc32Table(int[] table) {
        for (int n2 = 0; n2 < 256; ++n2) {
            int c2 = n2;
            for (int k2 = 0; k2 < 8; ++k2) {
                if ((c2 & 1) == 1) {
                    c2 = 0xEDB88320 ^ c2 >>> 1;
                    continue;
                }
                c2 >>>= 1;
            }
            table[n2] = c2;
        }
    }

    public static final int crc32(int[] table, int crc, byte[] buffer, int off, int len) {
        if (table[2] == 0) {
            ZipHelper.initCrc32Table(table);
        }
        crc ^= 0xFFFFFFFF;
        for (int n2 = 0; n2 < len; ++n2) {
            crc = table[(crc ^ buffer[n2 + off]) & 0xFF] ^ crc >>> 8;
        }
        return 0xFFFFFFFF ^ crc;
    }
}

