/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util.zip;

public class ZipIntMultShortHashMap {
    public static final int DEFAULT_LOAD_FACTOR = 75;
    public static final int SUB_ELEMENT_SIZE = 3;
    private final int loadFactor;
    private Element[] buckets;
    private final boolean isPowerOfTwo;
    private int size;

    public ZipIntMultShortHashMap(int initialCapacity) {
        this(initialCapacity, 75);
    }

    public ZipIntMultShortHashMap(int initialCapacity, int loadFactor) {
        int capacity;
        initialCapacity = initialCapacity * 100 / loadFactor;
        for (capacity = 1; initialCapacity > capacity; capacity <<= 1) {
        }
        this.isPowerOfTwo = capacity == initialCapacity;
        this.buckets = new Element[initialCapacity];
        this.loadFactor = loadFactor;
    }

    public boolean put(int key, short value) {
        int index;
        Element element;
        if (this.size * 100 / this.buckets.length > this.loadFactor) {
            this.increaseSize();
        }
        if ((element = this.buckets[index = this.isPowerOfTwo ? key & Integer.MAX_VALUE & this.buckets.length - 1 : (key & Integer.MAX_VALUE) % this.buckets.length]) == null) {
            element = new Element(key, new short[3]);
            element.values[0] = value;
            element.size = (short)(element.size + 1);
            this.buckets[index] = element;
            ++this.size;
            return true;
        }
        Element lastElement = element;
        do {
            if (element.key == key) {
                element.size = (short)(element.size + 1);
                if (element.size == element.values.length) {
                    short[] newValues = new short[element.values.length * 2];
                    System.arraycopy(element.values, 0, newValues, 0, element.values.length);
                    element.values = newValues;
                }
                element.values[element.size - 1] = value;
                return true;
            }
            lastElement = element;
        } while ((element = element.next) != null);
        element = new Element(key, new short[3]);
        element.values[0] = value;
        element.size = (short)(element.size + 1);
        this.buckets[index] = element;
        ++this.size;
        lastElement.next = element;
        return true;
    }

    public Element get(int key) {
        int index = this.isPowerOfTwo ? key & Integer.MAX_VALUE & this.buckets.length - 1 : (key & Integer.MAX_VALUE) % this.buckets.length;
        Element element = this.buckets[index];
        if (element == null) {
            return null;
        }
        do {
            if (element.key != key) continue;
            return element;
        } while ((element = element.next) != null);
        return null;
    }

    public short remove(int key) {
        int index = this.isPowerOfTwo ? key & Integer.MAX_VALUE & this.buckets.length - 1 : (key & Integer.MAX_VALUE) % this.buckets.length;
        Element element = this.buckets[index];
        if (element == null) {
            return -1;
        }
        Element lastElement = null;
        do {
            if (element.key == key) {
                if (lastElement == null) {
                    this.buckets[index] = element.next;
                } else {
                    lastElement.next = element.next;
                }
                --this.size;
                return 1;
            }
            lastElement = element;
        } while ((element = element.next) != null);
        return -1;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public boolean containsKey(int key) {
        return this.get(key) != null;
    }

    public void clear() {
        for (int i2 = 0; i2 < this.buckets.length; ++i2) {
            this.buckets[i2] = null;
        }
        this.size = 0;
    }

    public int[] keys() {
        int[] keys = new int[this.size];
        int index = 0;
        for (int i2 = 0; i2 < this.buckets.length; ++i2) {
            Element element = this.buckets[i2];
            while (element != null) {
                keys[index] = element.key;
                ++index;
                element = element.next;
            }
        }
        return keys;
    }

    private void increaseSize() {
        int newCapacity = this.isPowerOfTwo ? this.buckets.length << 1 : (this.buckets.length << 1) - 1;
        Element[] newBuckets = new Element[newCapacity];
        for (int i2 = 0; i2 < this.buckets.length; ++i2) {
            Element element = this.buckets[i2];
            while (element != null) {
                int index = this.isPowerOfTwo ? element.key & Integer.MAX_VALUE & newCapacity - 1 : (element.key & Integer.MAX_VALUE) % newCapacity;
                Element newElement = newBuckets[index];
                if (newElement == null) {
                    newBuckets[index] = element;
                } else {
                    while (newElement.next != null) {
                        newElement = newElement.next;
                    }
                    newElement.next = element;
                }
                Element lastElement = element;
                element = element.next;
                lastElement.next = null;
            }
        }
        this.buckets = newBuckets;
    }

    public static final class Element {
        public final int key;
        public short[] values;
        public short size;
        public Element next;

        public Element(int key, short[] value) {
            this.key = key;
            this.values = value;
        }
    }
}

