/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.xml;

import de.enough.polish.xml.SimplePullParser;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;

public class XmlPullParser
implements SimplePullParser {
    private static final String UNEXPECTED_EOF = "Unexpected EOF";
    public boolean relaxed;
    private Hashtable entityMap;
    private int depth;
    private String[] elementStack = new String[4];
    private Reader reader;
    private boolean allowEntitiesInAttributes;
    private char[] srcBuf = new char[Runtime.getRuntime().freeMemory() >= 0x100000L ? 8192 : 128];
    private int srcPos;
    private int srcCount;
    private boolean eof;
    private int line;
    private int column;
    private int peek0;
    private int peek1;
    private char[] txtBuf = new char[128];
    private int txtPos;
    private int type;
    private String text;
    private boolean isWhitespace;
    private String name;
    private boolean degenerated;
    private int attributeCount;
    private String[] attributes = new String[16];
    private String[] TYPES = new String[]{"Start Document", "End Document", "Start Tag", "End Tag", "Text"};

    private final int read() throws IOException {
        int r2 = this.peek0;
        this.peek0 = this.peek1;
        if (this.peek0 == -1) {
            this.eof = true;
            return r2;
        }
        if (r2 == 10 || r2 == 13) {
            ++this.line;
            this.column = 0;
            if (r2 == 13 && this.peek0 == 10) {
                this.peek0 = 0;
            }
        }
        ++this.column;
        if (this.srcPos >= this.srcCount) {
            this.srcCount = this.reader.read(this.srcBuf, 0, this.srcBuf.length);
            if (this.srcCount <= 0) {
                this.peek1 = -1;
                return r2;
            }
            this.srcPos = 0;
        }
        this.peek1 = this.srcBuf[this.srcPos++];
        return r2;
    }

    private final void exception(String desc) throws IOException {
        throw new IOException(desc + " pos: " + this.getPositionDescription());
    }

    private final void push(int c2) {
        if (c2 == 0) {
            return;
        }
        if (this.txtPos == this.txtBuf.length) {
            char[] bigger = new char[this.txtPos * 4 / 3 + 4];
            System.arraycopy(this.txtBuf, 0, bigger, 0, this.txtPos);
            this.txtBuf = bigger;
        }
        this.txtBuf[this.txtPos++] = (char)c2;
    }

    private final void read(char c2) throws IOException {
        if (this.read() != c2) {
            if (this.relaxed) {
                if (c2 <= ' ') {
                    this.skip();
                    this.read();
                }
            } else {
                this.exception("expected: '" + c2 + "'");
            }
        }
    }

    private final void skip() throws IOException {
        while (!this.eof && this.peek0 <= 32) {
            this.read();
        }
    }

    private final String pop(int pos) {
        String result = new String(this.txtBuf, pos, this.txtPos - pos);
        this.txtPos = pos;
        return result;
    }

    private final String readName() throws IOException {
        int pos = this.txtPos;
        int c2 = this.peek0;
        if (!(c2 >= 97 && c2 <= 122 || c2 >= 65 && c2 <= 90 || c2 == 95 || c2 == 58 || this.relaxed)) {
            this.exception("name expected");
        }
        do {
            this.push(this.read());
        } while ((c2 = this.peek0) >= 97 && c2 <= 122 || c2 >= 65 && c2 <= 90 || c2 >= 48 && c2 <= 57 || c2 == 95 || c2 == 45 || c2 == 58 || c2 == 46);
        return this.pop(pos);
    }

    private final void parseLegacy(boolean push) throws IOException {
        int term;
        String req = "";
        this.read();
        int c2 = this.read();
        if (c2 == 63) {
            term = 63;
        } else if (c2 == 33) {
            if (this.peek0 == 45) {
                req = "--";
                term = 45;
            } else {
                req = "DOCTYPE";
                term = -1;
            }
        } else {
            if (c2 != 91) {
                this.exception("cantreachme: " + c2);
            }
            req = "CDATA[";
            term = 93;
        }
        for (int i2 = 0; i2 < req.length(); ++i2) {
            this.read(req.charAt(i2));
        }
        if (term == -1) {
            this.parseDoctype();
        } else {
            do {
                if (this.eof) {
                    this.exception(UNEXPECTED_EOF);
                }
                c2 = this.read();
                if (!push) continue;
                this.push(c2);
            } while (term != 63 && c2 != term || this.peek0 != term || this.peek1 != 62);
            this.read();
            this.read();
            if (push && term != 63) {
                this.pop(this.txtPos - 1);
            }
        }
    }

    private final void parseDoctype() throws IOException {
        int nesting = 1;
        while (true) {
            int i2 = this.read();
            switch (i2) {
                case -1: {
                    this.exception(UNEXPECTED_EOF);
                    break;
                }
                case 60: {
                    ++nesting;
                    break;
                }
                case 62: {
                    if (--nesting != 0) break;
                    return;
                }
            }
        }
    }

    private final void parseEndTag() throws IOException {
        this.read();
        this.read();
        this.name = this.readName();
        if (this.depth == 0 && !this.relaxed) {
            this.exception("element stack empty");
        }
        if (this.name.equals(this.elementStack[this.depth - 1])) {
            --this.depth;
        } else if (!this.relaxed) {
            this.exception("expected: " + this.elementStack[this.depth]);
        }
        this.skip();
        this.read('>');
    }

    private final int peekType() {
        switch (this.peek0) {
            case -1: {
                return 1;
            }
            case 38: {
                return 6;
            }
            case 60: {
                switch (this.peek1) {
                    case 47: {
                        return 3;
                    }
                    case 91: {
                        return 5;
                    }
                    case 33: 
                    case 63: {
                        return 999;
                    }
                }
                return 2;
            }
        }
        return 4;
    }

    private static final String[] ensureCapacity(String[] arr, int required) {
        if (arr.length >= required) {
            return arr;
        }
        String[] bigger = new String[required + 16];
        System.arraycopy(arr, 0, bigger, 0, arr.length);
        return bigger;
    }

    private final void parseStartTag() throws IOException {
        this.read();
        this.name = this.readName();
        this.elementStack = XmlPullParser.ensureCapacity(this.elementStack, this.depth + 1);
        this.elementStack[this.depth++] = this.name;
        while (true) {
            String attrName;
            this.skip();
            int c2 = this.peek0;
            if (c2 == 47) {
                this.degenerated = true;
                this.read();
                this.skip();
                this.read('>');
                break;
            }
            if (c2 == 62) {
                this.read();
                break;
            }
            if (c2 == -1) {
                this.exception(UNEXPECTED_EOF);
            }
            if ((attrName = this.readName()).length() == 0) {
                this.exception("attr name expected");
            }
            this.skip();
            this.read('=');
            this.skip();
            int delimiter = this.read();
            if (delimiter != 39 && delimiter != 34) {
                if (!this.relaxed) {
                    this.exception("<" + this.name + ">: invalid delimiter: " + (char)delimiter);
                }
                delimiter = 32;
            }
            int i2 = this.attributeCount++ << 1;
            this.attributes = XmlPullParser.ensureCapacity(this.attributes, i2 + 4);
            this.attributes[i2++] = attrName;
            int p2 = this.txtPos;
            if (this.allowEntitiesInAttributes) {
                this.pushText(delimiter);
            } else {
                this.pushTextAttribute(delimiter);
            }
            this.attributes[i2] = this.pop(p2);
            if (delimiter == 32) continue;
            this.read();
        }
    }

    public final boolean pushEntity() throws IOException {
        this.read();
        int pos = this.txtPos;
        while (!this.eof && this.peek0 != 59) {
            this.push(this.read());
        }
        String code = this.pop(pos);
        this.read();
        if (code.length() > 0 && code.charAt(0) == '#') {
            int c2 = code.charAt(1) == 'x' ? Integer.parseInt(code.substring(2), 16) : Integer.parseInt(code.substring(1));
            this.push(c2);
            return c2 <= 32;
        }
        String result = (String)this.entityMap.get(code);
        boolean whitespace = true;
        if (result == null) {
            result = "&" + code + ";";
        }
        for (int i2 = 0; i2 < result.length(); ++i2) {
            char c3 = result.charAt(i2);
            if (c3 > ' ') {
                whitespace = false;
            }
            this.push(c3);
        }
        return whitespace;
    }

    private final boolean pushText(int delimiter) throws IOException {
        boolean whitespace = true;
        int next = this.peek0;
        while (!this.eof && next != delimiter && (delimiter != 32 || next > 32 && next != 62)) {
            if (next == 38) {
                if (!this.pushEntity()) {
                    whitespace = false;
                }
            } else {
                if (next > 32) {
                    whitespace = false;
                }
                this.push(this.read());
            }
            next = this.peek0;
        }
        return whitespace;
    }

    private final boolean pushTextAttribute(int delimiter) throws IOException {
        boolean whitespace = true;
        int next = this.peek0;
        while (!this.eof && next != delimiter && (delimiter != 32 || next > 32 && next != 62)) {
            if (next > 32) {
                whitespace = false;
            }
            this.push(this.read());
            next = this.peek0;
        }
        return whitespace;
    }

    public XmlPullParser(Reader reader) throws IOException {
        this(reader, true);
    }

    public XmlPullParser(Reader reader, boolean allowEntitiesInAttributes) throws IOException {
        this.reader = reader;
        this.allowEntitiesInAttributes = allowEntitiesInAttributes;
        this.peek0 = reader.read();
        this.peek1 = reader.read();
        this.eof = this.peek0 == -1;
        this.entityMap = new Hashtable();
        this.entityMap.put("amp", "&");
        this.entityMap.put("apos", "'");
        this.entityMap.put("gt", ">");
        this.entityMap.put("lt", "<");
        this.entityMap.put("quot", "\"");
        this.line = 1;
        this.column = 1;
    }

    public void defineCharacterEntity(String entity, String value) {
        this.entityMap.put(entity, value);
    }

    public int getDepth() {
        return this.depth;
    }

    public String getPositionDescription() {
        StringBuffer buf = new StringBuffer(this.type < this.TYPES.length ? this.TYPES[this.type] : "Other");
        buf.append(" @" + this.line + ":" + this.column + ": ");
        if (this.type == 2 || this.type == 3) {
            buf.append('<');
            if (this.type == 3) {
                buf.append('/');
            }
            buf.append(this.name);
            buf.append('>');
        } else if (this.isWhitespace) {
            buf.append("[whitespace]");
        } else {
            buf.append(this.getText());
        }
        return buf.toString();
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.column;
    }

    public boolean isWhitespace() {
        return this.isWhitespace;
    }

    public String getText() {
        if (this.text == null) {
            this.text = this.pop(0);
        }
        return this.text;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEmptyElementTag() {
        return this.degenerated;
    }

    public int getAttributeCount() {
        return this.attributeCount;
    }

    public String getAttributeName(int index) {
        if (index >= this.attributeCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.attributes[index << 1];
    }

    public String getAttributeValue(int index) {
        if (index >= this.attributeCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.attributes[(index << 1) + 1];
    }

    public String getAttributeValue(String name) {
        for (int i2 = (this.attributeCount << 1) - 2; i2 >= 0; i2 -= 2) {
            if (!this.attributes[i2].equals(name)) continue;
            return this.attributes[i2 + 1];
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    public int next() {
        try {
            if (this.degenerated) {
                this.type = 3;
                this.degenerated = false;
                --this.depth;
                return this.type;
            }
            this.txtPos = 0;
            this.isWhitespace = true;
            do {
                this.attributeCount = 0;
                this.name = null;
                this.text = null;
                this.type = this.peekType();
                switch (this.type) {
                    case 6: {
                        this.isWhitespace &= this.pushEntity();
                        this.type = 4;
                        break;
                    }
                    case 2: {
                        this.parseStartTag();
                        break;
                    }
                    case 3: {
                        this.parseEndTag();
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 4: {
                        this.isWhitespace &= this.pushText(60);
                        break;
                    }
                    case 5: {
                        this.parseLegacy(true);
                        this.isWhitespace = false;
                        this.type = 4;
                        break;
                    }
                    default: {
                        this.parseLegacy(false);
                    }
                }
            } while (this.type > 4 || this.type == 4 && this.peekType() >= 4);
            this.isWhitespace &= this.type == 4;
        }
        catch (IOException e2) {
            this.type = 1;
        }
        return this.type;
    }

    public void require(int type, String name) throws IOException {
        if (this.type == 4 && type != 4 && this.isWhitespace()) {
            this.next();
        }
        if (type != this.type || name != null && !name.equals(this.getName())) {
            this.exception("expected: " + this.TYPES[type] + "/" + name);
        }
    }

    public String readText() throws IOException {
        if (this.type != 4) {
            return "";
        }
        String result = this.getText();
        this.next();
        return result;
    }
}

