/*
 * Decompiled with CFR 0.152.
 */
package com.game.mission;

import com.game.attribute.Attribute;
import com.game.monster.BearMonster;
import com.game.monster.DogMonster;
import com.game.monster.FireBossMoster;
import com.game.monster.FrogMonster;
import com.game.monster.HowletMonster;
import com.game.monster.LionMonster;
import com.game.monster.MonkeyMonster;
import com.game.monster.Monster;
import com.game.monster.OrangMonster;
import com.game.monster.OstrichMonster;
import com.game.monster.PigMonster;
import com.game.monster.SheepMonster;
import com.game.monster.SnakeMonster;
import com.game.monster.SpookMonster;
import com.game.monster.SquirreMonster;
import com.game.monster.WitchKingMonster;
import com.game.rms.GameRms;
import com.game.script.ScriptParse;
import com.game.util.ArrayList;
import com.game.util.Tools;
import com.game.xrole.Role;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class Mission {
    private ScriptParse scriptParse = new ScriptParse();
    private Role player = null;
    private String[] missionFile = null;
    private Image imgMonster1 = null;
    private byte[] byteLion1 = null;
    private byte[] byteLion2 = null;
    private Image imgMonster2 = null;
    private Image bossImage = null;
    private Image imgShiZi = null;
    private byte[] byteShiZi = null;
    private byte[] bossByte = null;
    public static boolean isBoss = false;
    private String[][] monsterInfo = new String[0][];

    public Mission(Role player) throws IOException {
        this.player = player;
        switch (GameRms.rmsCurModel) {
            case 0: {
                this.monsterInfo = this.readMonsterInfo("/res/monster/monsterInfo1.txt");
                break;
            }
            case 1: {
                this.monsterInfo = this.readMonsterInfo("/res/monster/monsterInfo2.txt");
                break;
            }
            case 2: {
                this.monsterInfo = this.readMonsterInfo("/res/monster/monsterInfo3.txt");
            }
        }
    }

    public int getAllCount() {
        return Integer.parseInt(this.missionFile[0].substring(9, this.missionFile[0].length()));
    }

    public ScriptParse getScriptParse() {
        return this.scriptParse;
    }

    public void setScriptParse(ScriptParse scriptParse) {
        this.scriptParse = scriptParse;
    }

    public String[] readMissionFile(String file) {
        this.scriptParse.loadScriptFile(file);
        try {
            String string = this.scriptParse.readFile();
            this.missionFile = this.scriptParse.splitStr(string, "\r\n");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return this.missionFile;
    }

    public ArrayList getMonsterArray(int count) {
        String[] str1 = this.scriptParse.splitStr(this.missionFile[count], ":");
        if (str1[0].equals("boss")) {
            isBoss = true;
        }
        String[] str2 = this.scriptParse.splitStr(str1[1], "|");
        ArrayList list = new ArrayList();
        for (int i = 0; i < str2.length; ++i) {
            String[] countWave = this.scriptParse.splitStr(str2[i], ",");
            int id = Integer.parseInt(countWave[0]);
            int proProbility = Integer.parseInt(countWave[2]);
            int countMonster = Integer.parseInt(countWave[1]);
            Monster littlemoster = null;
            for (int j = 0; j < countMonster; ++j) {
                littlemoster = this.getMonsterForId(id);
                littlemoster.setProbability(proProbility);
                list.add(littlemoster);
            }
        }
        return list;
    }

    private Monster getMonsterForId(int id) {
        Monster littlemoster = null;
        switch (id) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                if (this.imgMonster1 != null) break;
                this.imgMonster1 = Tools.loadImage("/res/monster/monster1.png");
                this.byteLion1 = Tools.loadFile("/res/monster/monster1.sprite");
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                if (this.imgMonster2 != null) break;
                this.imgMonster2 = Tools.loadImage("/res/monster/monster2.png");
                this.byteLion2 = Tools.loadFile("/res/monster/monster2.sprite");
                break;
            }
            case 13: 
            case 14: {
                if (this.bossImage != null) break;
                this.bossImage = Tools.loadImage("/res/monster/boss.png");
                this.bossByte = Tools.loadFile("/res/monster/boss.sprite");
                break;
            }
            case 15: {
                if (this.imgShiZi != null) break;
                this.imgShiZi = Tools.loadImage("/res/monster/lion.png");
                this.byteShiZi = Tools.loadFile("/res/monster/lion.sprite");
            }
        }
        switch (id) {
            case 1: {
                littlemoster = new MonkeyMonster(this.byteLion1, this.imgMonster1, id);
                break;
            }
            case 2: {
                littlemoster = new HowletMonster(this.byteLion1, this.imgMonster1, id);
                break;
            }
            case 3: {
                littlemoster = new DogMonster(this.byteLion1, this.imgMonster1, id);
                break;
            }
            case 4: {
                littlemoster = new BearMonster(this.byteLion1, this.imgMonster1, id);
                break;
            }
            case 5: {
                littlemoster = new OrangMonster(this.byteLion1, this.imgMonster1, id);
                break;
            }
            case 6: {
                littlemoster = new SnakeMonster(this.byteLion1, this.imgMonster1, id);
                break;
            }
            case 7: {
                littlemoster = new PigMonster(this.byteLion2, this.imgMonster2, id);
                break;
            }
            case 8: {
                littlemoster = new FrogMonster(this.byteLion2, this.imgMonster2, id);
                break;
            }
            case 9: {
                littlemoster = new OstrichMonster(this.byteLion2, this.imgMonster2, id);
                break;
            }
            case 10: {
                littlemoster = new SpookMonster(this.byteLion2, this.imgMonster2, id);
                break;
            }
            case 11: {
                littlemoster = new SquirreMonster(this.byteLion2, this.imgMonster2, id);
                break;
            }
            case 12: {
                littlemoster = new SheepMonster(this.byteLion2, this.imgMonster2, id);
                break;
            }
            case 13: {
                littlemoster = new FireBossMoster(this.bossByte, this.bossImage, id);
                break;
            }
            case 14: {
                littlemoster = new WitchKingMonster(this.bossByte, this.bossImage, id);
                break;
            }
            case 15: {
                littlemoster = new LionMonster(this.byteShiZi, this.imgShiZi, id);
            }
        }
        littlemoster.player = this.player;
        Attribute arr = new Attribute();
        arr.setCurHp(Integer.parseInt(this.monsterInfo[id - 1][1]));
        arr.setSpeed(Integer.parseInt(this.monsterInfo[id - 1][4]));
        arr.setDefenceVal(Integer.parseInt(this.monsterInfo[id - 1][3]));
        littlemoster.setName(this.monsterInfo[id - 1][0]);
        littlemoster.setWorthMoney(Integer.parseInt(this.monsterInfo[id - 1][2]));
        littlemoster.setFenShu(Integer.parseInt(this.monsterInfo[id - 1][5]));
        littlemoster.setAttribute(arr);
        return littlemoster;
    }

    public String[][] readMonsterInfo(String file) throws IOException {
        InputStream in = this.getClass().getResourceAsStream(file);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String str = null;
        byte[] bData = new byte[1024];
        while (in.read(bData) != -1) {
            out.write(bData);
        }
        byte[] monster = out.toByteArray();
        str = new String(monster, "UTF-8");
        String[] info = this.scriptParse.splitStr(str.trim(), "\r\n");
        String[][] infoTemp = new String[info.length][6];
        String[] temp = null;
        for (int i = 0; i < info.length; ++i) {
            temp = this.scriptParse.splitStr(info[i].trim(), ",");
            System.out.println("\u4fe1\u606f\uff1a" + info[i]);
            for (int j = 0; j < temp.length; ++j) {
                infoTemp[i][j] = temp[j];
            }
        }
        return infoTemp;
    }
}

