/*
 * Decompiled with CFR 0.152.
 */
package com.game.monster;

import com.game.ManagerConture;
import com.game.attribute.Attribute;
import com.game.cannonball.RectCoordinate;
import com.game.monster.IMonster;
import com.game.rms.GameRms;
import com.game.sprite.SpriteX;
import com.game.util.Graphics2D;
import com.game.util.Tools;
import com.game.xrole.ActXiaoGuo;
import com.game.xrole.Role;
import javax.microedition.lcdui.Image;

public class Monster
extends SpriteX
implements IMonster {
    public Role player = null;
    private int id;
    private String name;
    private int state = 1;
    public Attribute attribute = null;
    private int worthMoney;
    private int fenShu;
    public RectCoordinate rect = null;
    private int probability = 0;
    private ManagerConture conture = null;

    public ManagerConture getConture() {
        return this.conture;
    }

    public void setConture(ManagerConture conture) {
        this.conture = conture;
    }

    public Monster(byte[] array, Image img, int id) {
        super(array, img);
        this.setAction(1);
        this.state = 3;
        this.id = id;
        this.rect = new RectCoordinate();
        this.rect.setHeight(30);
        this.rect.setWidth(this.getWidth());
    }

    public int getFenShu() {
        return this.fenShu;
    }

    public void setFenShu(int fenShu) {
        this.fenShu = fenShu;
    }

    public int getProbability() {
        return this.probability;
    }

    public void setProbability(int probability) {
        this.probability = probability;
    }

    public RectCoordinate getRect() {
        this.rect.setX(this.getX() - this.getWidth() / 2);
        this.rect.setY(this.getY() - this.getHeight());
        return this.rect;
    }

    public void setRect(RectCoordinate rect) {
        this.rect = rect;
    }

    public int getMonsterX() {
        return this.getX();
    }

    public int getMonsterY() {
        return this.getY();
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public void setAttribute(Attribute attribute) {
        this.attribute = attribute;
    }

    public int getWorthMoney() {
        return this.worthMoney;
    }

    public void setWorthMoney(int worthMoney) {
        this.worthMoney = worthMoney;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void logic() {
        switch (this.state) {
            case 1: {
                this.move(0, this.attribute.curSpeed);
                break;
            }
            case 2: {
                this.setVisible(false);
                break;
            }
            case 3: {
                if (Tools.getRand(100) > this.probability) break;
                this.astrictXY();
                this.state = 1;
            }
        }
    }

    public void paint(Graphics2D g) {
        super.paint(g);
        g.setColor(0xFF0000);
        this.attribute.backSpeed(this.getY());
    }

    public void setCurState(int state) {
        this.state = state;
    }

    public void astrictXY() {
        int finalX = Tools.getRand(40, 290);
        int finalY = -Tools.getRand(60, 300);
        this.setPosition(finalX, finalY);
    }

    public boolean collisionWithMonster(Monster monster) {
        if (Math.abs(this.getX() - monster.getX()) >= monster.getWidth()) {
            return false;
        }
        return Math.abs(this.getY() - monster.getY()) < monster.getHeight();
    }

    public int getCurState() {
        return this.state;
    }

    public boolean isDeath(int quxue) {
        this.attribute.beHurt(quxue, false, this.getY(), GameRms.rmsIce);
        if (this.attribute.isDeath()) {
            this.changeState(5);
        }
        return false;
    }

    public void isDeath() {
        this.attribute.setCurHp(this.attribute.getCurHp() - 1000);
        if (this.attribute.isDeath()) {
            this.changeState(5);
        }
    }

    public void changeState(int state) {
        switch (state) {
            case 4: {
                if (this.getState() == 5) {
                    return;
                }
                if (this.getState() == 4) {
                    return;
                }
                ActXiaoGuo xiaoguo = new ActXiaoGuo(Role.byteActXiaoGuo, Role.imgActXiaoGuo);
                xiaoguo.setX(this.getX());
                xiaoguo.setY(this.getY() - 20);
                ManagerConture.actList.add(xiaoguo);
                this.setAction(this.getAction() + 1);
                this.setState(4);
                break;
            }
            case 5: {
                this.rect.setHeight(0);
                this.rect.setWidth(0);
                this.setRect(this.rect);
                if (this.getState() == 5) {
                    return;
                }
                if (this.getAction() % 4 == 0) {
                    this.setAction(this.getAction() + 3);
                } else {
                    this.setAction(this.getAction() + 2);
                }
                this.setState(5);
            }
        }
    }

    public void changeStateWalk(int action) {
        this.move(0, -2);
        if (this.getFrame() >= this.getSequenceLength() - 1) {
            this.setAction(action);
            this.setState(1);
        }
    }

    public void drawdeath() {
        if (this.getFrame() >= this.getSequenceLength() - 1) {
            this.visible = false;
            this.setState(2);
            GameRms.rmsMoney += this.worthMoney;
            GameRms.rmsFenShu += this.fenShu;
            ManagerConture.fenShu += this.fenShu;
        }
    }

    public void init(Attribute att) {
    }
}

