/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public final class Script {
    static final int SCRIPTVARMAX = 400;
    static byte[] scriptVar = new byte[400];
    static short[][] scriptPosVar = new short[5][3];
    static byte[] taskItem = new byte[30];
    static int temp;
    static Event[] commonEvents;
    static Event[] battleEvents;
    static boolean isUserCtrl;
    static Event[] initEvent;
    public static int[] curBattleEvent;
    static int curEvent;
    static int buffMax;
    static byte[] buff;
    static int start;
    static boolean isEnd;
    static int len;

    public static void free() {
        commonEvents = null;
        battleEvents = null;
    }

    public static void initScriptVar() {
        int i = 0;
        while (i < scriptVar.length) {
            Script.scriptVar[i] = 0;
            ++i;
        }
        int i2 = 0;
        while (i2 < scriptPosVar.length) {
            int j = 0;
            while (j < scriptPosVar[i2].length) {
                Script.scriptPosVar[i2][j] = 0;
                ++j;
            }
            ++i2;
        }
    }

    public static void runScript() {
        if (Event.waitTime > 0) {
            --Event.waitTime;
            return;
        }
        curEvent = -1;
        int i = 0;
        while (i < commonEvents.length) {
            if (Script.commonEvents[i].eventIsAlive) {
                curEvent = i;
                break;
            }
            ++i;
        }
        if (curEvent == -1) {
            int i2 = 0;
            while (i2 < commonEvents.length) {
                commonEvents[i2].run();
                ++i2;
            }
        } else {
            commonEvents[curEvent].run();
        }
        System.out.println("curEvent  " + curEvent);
    }

    public static void runBattleScript() {
        if (Event.waitTime > 0) {
            --Event.waitTime;
            return;
        }
        if (battleEvents == null || curBattleEvent == null) {
            return;
        }
        int i = 0;
        while (i < battleEvents.length) {
            if (Script.isCurEnent(i)) {
                battleEvents[i].runBattle();
            }
            ++i;
        }
    }

    public static boolean isCurEnent(int id) {
        int i = 0;
        while (i < curBattleEvent.length) {
            if (id == curBattleEvent[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void initBattleEvent(String[] s) {
        if (s == null) {
            curBattleEvent = null;
        }
        curBattleEvent = new int[s.length];
        int i = 0;
        while (i < s.length) {
            Script.curBattleEvent[i] = Event.sToi(s[i]);
            ++i;
        }
    }

    public static boolean runInitEvent() {
        if (initEvent == null) {
            return true;
        }
        return initEvent[0].runInitEvent();
    }

    public static void loadScript(int gameRank) {
        isUserCtrl = true;
        Object tmp = null;
        String str = null;
        boolean sceneInit = false;
        boolean npcInit = false;
        boolean eventInit = false;
        Vector<GameSprite> vNpc = new Vector<GameSprite>();
        Vector<Event> vEvent = new Vector<Event>();
        Vector<Event> vBattleEvent = new Vector<Event>();
        Vector<Event> vInitEvent = new Vector<Event>();
        GameSprite npc = null;
        Event event = null;
        int npcId = 0;
        String[] lines = Event.splitString(Script.loadTxt("/scene/" + gameRank + ".txt"), "\n");
        int i = 0;
        while (i < lines.length) {
            str = lines[i].trim();
            if (str.equals("scene")) {
                sceneInit = true;
            } else if (sceneInit) {
                if (str.equals("endScene")) {
                    sceneInit = false;
                } else {
                    GameEngine.map.init(str);
                }
            } else if (str.equals("npc")) {
                npcInit = true;
                npc = new GameSprite(GameEngine.me, npcId);
            } else if (npcInit) {
                if (str.equals("endNpc")) {
                    npcInit = false;
                    npc.endInit();
                    vNpc.addElement(npc);
                    ++npcId;
                } else {
                    npc.init(str);
                }
            } else if (str.equals("event")) {
                eventInit = true;
                event = new Event();
            } else if (eventInit) {
                if (str.equals("endEvent")) {
                    eventInit = false;
                    event.endInit();
                    if (event.typeName.equals("commonEvent")) {
                        vEvent.addElement(event);
                    } else if (event.typeName.equals("battleEvent")) {
                        vBattleEvent.addElement(event);
                    } else if (event.typeName.equals("initEvent")) {
                        vInitEvent.addElement(event);
                    }
                } else {
                    event.init(str);
                }
            }
            ++i;
        }
        buff = null;
        commonEvents = new Event[vEvent.size()];
        vEvent.copyInto(commonEvents);
        vEvent.removeAllElements();
        vEvent = null;
        if (vBattleEvent.size() > 0) {
            battleEvents = new Event[vBattleEvent.size()];
            vBattleEvent.copyInto(battleEvents);
            vBattleEvent.removeAllElements();
        }
        vBattleEvent = null;
        if (vInitEvent.size() > 0) {
            initEvent = new Event[vInitEvent.size()];
            vInitEvent.copyInto(initEvent);
            vInitEvent.removeAllElements();
        }
        vInitEvent = null;
        GameEngine.initSprite(vNpc);
        System.out.println("load complete");
    }

    public static String readLine(InputStream is) {
        if (is == null) {
            return null;
        }
        try {
            if (buff == null) {
                isEnd = false;
                start = 0;
                buff = new byte[buffMax];
                len = is.read(buff);
            }
            int i = start;
            while (i < len) {
                if (buff[i] == 10) {
                    String temp = new String(buff, start, i - start, "UTF-8");
                    start = i + 1;
                    if (!isEnd && i >= buffMax / 2) {
                        System.arraycopy(buff, buffMax / 2, buff, 0, buffMax / 2);
                        start -= buffMax / 2;
                        len = is.read(buff, buffMax / 2, buffMax / 2) + buffMax / 2;
                        if (len < buffMax) {
                            isEnd = true;
                        }
                    }
                    return temp;
                }
                ++i;
            }
        }
        catch (IOException ex) {}
        return null;
    }

    /*
     * WARNING - void declaration
     */
    static String loadTxt(String name) {
        InputStream is = "".getClass().getResourceAsStream(name);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        String strReturn = null;
        byte[] buffer = new byte[2048];
        try {
            int len;
            while ((len = is.read(buffer)) > 0) {
                void var6_6;
                dos.write(buffer, 0, (int)var6_6);
            }
            strReturn = new String(baos.toByteArray(), "UTF-8");
            is.close();
            dos.close();
            baos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strReturn;
    }

    static {
        isUserCtrl = true;
        curEvent = -1;
        buffMax = 2048;
        len = 0;
    }
}

