/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Ripple {
    public static short[] lut = null;

    public Ripple() {
        int amplitude = 1024;
        lut = new short[360];
        int factor = 57;
        int a = amplitude * factor;
        int c = 0;
        int cnt = 0;
        while (cnt < 360) {
            int d = c / factor;
            Ripple.lut[cnt] = (short)d;
            c += (a -= d) / factor;
            ++cnt;
        }
        Ripple.lut[180] = 0;
        Ripple.lut[270] = -1024;
    }

    public static short sin(int value) {
        return lut[value %= 360];
    }

    public void paintImageFade(Graphics g, int curStep, int numSteps, int type, Image fadeImage, int imageX, int imageY, int numWaves) {
        int fadeImageHeight;
        int fadeImageWidth;
        if (curStep >= numSteps) {
            g.drawImage(fadeImage, imageX, imageY, 0);
            return;
        }
        if (type == 0) {
            fadeImageWidth = fadeImage.getWidth();
            fadeImageHeight = fadeImage.getHeight();
        } else {
            fadeImageWidth = fadeImage.getHeight();
            fadeImageHeight = fadeImage.getWidth();
        }
        int halfFadeImageWidth = fadeImageWidth / 2;
        int numSegments = fadeImageHeight;
        int curWidth = fadeImageWidth * curStep / numSteps;
        int amp = fadeImageWidth * (numSteps - curStep) / (numSteps * 4);
        int curAngle = 360 * curStep / numSteps;
        int angleStep = 360 * numWaves / numSegments;
        int i = 0;
        while (i < numSegments) {
            int curOffset = amp * Ripple.sin(curAngle) >> 10;
            if (type == 0) {
                g.setClip(imageX + halfFadeImageWidth - curWidth / 2 + curOffset, imageY + i, curWidth, 1);
                g.drawImage(fadeImage, imageX + curOffset, imageY, 0);
            } else {
                g.setClip(imageX + i, imageY + halfFadeImageWidth - curWidth / 2 + curOffset, 1, curWidth);
                g.drawImage(fadeImage, imageX, imageY + curOffset, 0);
            }
            curAngle += angleStep;
            ++i;
        }
    }
}

