/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class MusicPlayer
implements PlayerListener {
    public static final int IMMENSITY = -1;
    public static final int UNREALIZED = 1;
    public static final int REALIZED = 2;
    public static final int PREFETCHED = 3;
    public static final int STARTED = 4;
    public static final int CLOSED = 5;
    Player MusicPlayer;
    VolumeControl control;
    boolean notActive = true;

    public void load(String fileName) {
        try {
            InputStream inputstream = this.getClass().getResourceAsStream(fileName);
            if (inputstream == null) {
                System.out.println("Error happens: InputStream not found " + fileName);
            }
            if (this.MusicPlayer == null) {
                this.MusicPlayer = Manager.createPlayer((InputStream)inputstream, (String)"audio/midi");
            } else {
                this.MusicPlayer.stop();
                this.MusicPlayer.close();
                this.MusicPlayer = null;
                this.MusicPlayer = Manager.createPlayer((InputStream)inputstream, (String)"audio/midi");
            }
            if (this.MusicPlayer == null) {
                System.out.println("Error handler happens: InputStream " + fileName);
            } else {
                this.MusicPlayer.addPlayerListener((PlayerListener)this);
                this.MusicPlayer.realize();
                this.MusicPlayer.prefetch();
                this.MusicPlayer.setLoopCount(-1);
                System.out.println("Realized Player: " + fileName);
            }
            this.control = (VolumeControl)this.MusicPlayer.getControl("VolumeControl");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println(e);
        }
        catch (MediaException e) {
            e.printStackTrace();
            System.out.println((Object)e);
        }
    }

    public void destroyAt() {
        if (this.MusicPlayer != null) {
            this.MusicPlayer.close();
            this.MusicPlayer = null;
        }
    }

    public void destroyAll() {
        if (this.MusicPlayer != null) {
            this.MusicPlayer.close();
            this.MusicPlayer = null;
        }
    }

    public void play(int times) {
        if (this.MusicPlayer != null) {
            try {
                this.MusicPlayer.stop();
                this.MusicPlayer.setLoopCount(times);
                this.MusicPlayer.start();
            }
            catch (MediaException e) {
                e.printStackTrace();
                System.out.println((Object)e);
            }
        }
    }

    public int getPlayState() {
        switch (this.MusicPlayer.getState()) {
            case 100: {
                return 1;
            }
            case 200: {
                return 2;
            }
            case 300: {
                return 3;
            }
            case 400: {
                return 4;
            }
            case 0: {
                return 5;
            }
        }
        return -1;
    }

    public void stop() {
        if (this.MusicPlayer != null && this.MusicPlayer.getState() == 400) {
            try {
                this.MusicPlayer.stop();
                System.out.println("The Player stoped here:" + this.MusicPlayer.getMediaTime());
            }
            catch (MediaException e) {
                e.printStackTrace();
                System.out.println((Object)e);
            }
        }
    }

    public void playerUpdate(Player musicplayer, String event, Object eventData) {
    }
}

