/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class Rms {
    private RecordStore rs;
    private String RMSname;
    boolean open = false;

    public Rms(String RMSname) {
        this.RMSname = RMSname;
        if (!this.open) {
            this.openRMS();
        }
    }

    public void openRMS() {
        try {
            this.rs = RecordStore.openRecordStore((String)this.RMSname, (boolean)true);
        }
        catch (RecordStoreFullException e) {
            e.printStackTrace();
        }
        catch (RecordStoreNotFoundException e) {
            e.printStackTrace();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
        this.open = true;
    }

    public void closeRMS() {
        try {
            this.rs.closeRecordStore();
        }
        catch (RecordStoreNotOpenException e) {
            e.printStackTrace();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
        this.open = true;
    }

    public void deleteRMS() {
        try {
            RecordStore.deleteRecordStore((String)this.RMSname);
        }
        catch (RecordStoreNotFoundException e) {
            e.printStackTrace();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        String buffer = null;
        try {
            buffer = this.rs.getName();
        }
        catch (RecordStoreNotOpenException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    public long getLastModified() {
        long buffer = 0L;
        try {
            buffer = this.rs.getLastModified();
        }
        catch (RecordStoreNotOpenException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    public int getVersion() {
        int buffer = 0;
        try {
            buffer = this.rs.getVersion();
        }
        catch (RecordStoreNotOpenException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    public int getSize() {
        int buffer = 0;
        try {
            buffer = this.rs.getSize();
        }
        catch (RecordStoreNotOpenException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    public int getAvailable() {
        int buffer = 0;
        try {
            buffer = this.rs.getSizeAvailable();
        }
        catch (RecordStoreNotOpenException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    public int getNum() {
        int num = 0;
        try {
            num = this.rs.getNumRecords();
        }
        catch (RecordStoreNotOpenException e) {
            e.printStackTrace();
        }
        return num;
    }

    public void addRecord(Record record) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeByte(record.getlevel());
            dos.writeBoolean(record.getmomojineng1());
            dos.writeBoolean(record.getxiaoxiangjineng1());
            dos.writeBoolean(record.getmomojineng2());
            dos.writeBoolean(record.getxiaoxiangjineng2());
            dos.writeBoolean(record.getmomojineng3());
            dos.writeBoolean(record.getxiaoxiangjineng3());
            dos.writeBoolean(record.getOncePlay());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] arr = baos.toByteArray();
        try {
            this.rs.addRecord(arr, 0, arr.length);
        }
        catch (RecordStoreNotOpenException e) {
            e.printStackTrace();
        }
        catch (RecordStoreFullException e) {
            e.printStackTrace();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
    }

    public Record getRecord(int recordID) {
        Record record = null;
        try {
            byte[] arr = this.rs.getRecord(recordID);
            ByteArrayInputStream bais = new ByteArrayInputStream(arr);
            DataInputStream dis = new DataInputStream(bais);
            record = new Record(dis.readByte(), dis.readBoolean(), dis.readBoolean(), dis.readBoolean(), dis.readBoolean(), dis.readBoolean(), dis.readBoolean(), dis.readBoolean());
            bais.close();
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return record;
    }

    public void setRecord(Record record, int recordID) {
        byte[] arr = null;
        try {
            if (recordID <= this.rs.getNumRecords()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                dos.writeByte(record.getlevel());
                dos.writeBoolean(record.getmomojineng1());
                dos.writeBoolean(record.getmomojineng2());
                dos.writeBoolean(record.getmomojineng3());
                dos.writeBoolean(record.getxiaoxiangjineng1());
                dos.writeBoolean(record.getxiaoxiangjineng2());
                dos.writeBoolean(record.getxiaoxiangjineng3());
                dos.writeBoolean(record.getOncePlay());
                arr = baos.toByteArray();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            this.rs.setRecord(recordID, arr, 0, arr.length);
        }
        catch (RecordStoreNotOpenException e) {
            e.printStackTrace();
        }
        catch (InvalidRecordIDException e) {
            e.printStackTrace();
        }
        catch (RecordStoreFullException e) {
            e.printStackTrace();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
    }
}

