/*
 * Decompiled with CFR 0.152.
 */
package Main;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class Languages {
    private StringBuffer langs;
    private Hashtable langList;
    private int index = 0;

    public Languages() {
        this.loadText("/langs.txt");
        this.langList = new Hashtable();
        this.loadList();
    }

    private void loadText(String path) {
        this.langs = new StringBuffer();
        DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream(path));
        int ch = 0;
        try {
            while ((ch = dis.read()) != -1) {
                this.langs.append((char)(ch >= 192 && ch <= 255 ? ch + 848 : ch));
            }
            dis.close();
        }
        catch (IOException e) {
            System.out.println("Error loading langs" + e);
        }
    }

    private void loadList() {
        while (this.index <= this.langs.length()) {
            char tmp;
            int i;
            String line = this.nextLine();
            StringBuffer key = new StringBuffer();
            StringBuffer value = new StringBuffer();
            for (i = 0; i < line.length() && (tmp = line.charAt(i)) != ' '; ++i) {
                value.append(tmp);
            }
            ++i;
            while (i < line.length()) {
                key.append(line.charAt(i));
                ++i;
            }
            this.langList.put(key.toString(), value.toString());
        }
    }

    private String nextLine() {
        char tmp;
        StringBuffer line = new StringBuffer();
        while (this.index < this.langs.length() && (tmp = this.langs.charAt(this.index)) != '\n') {
            line.append(tmp);
            ++this.index;
        }
        ++this.index;
        return line.toString();
    }

    protected Hashtable getList() {
        return this.langList;
    }

    private String[] getKeys() {
        Enumeration keys = this.langList.keys();
        String[] keyz = new String[this.langList.size()];
        int i = 0;
        while (keys.hasMoreElements()) {
            keyz[i] = (String)keys.nextElement();
            ++i;
        }
        return keyz;
    }

    protected final String[] getSortedKeys() {
        String[] sorted = this.getKeys();
        for (int k = sorted.length / 2; k > 0; k >>= 1) {
            for (int i = k; i < sorted.length; ++i) {
                int j;
                String v = sorted[j];
                for (j = i; j >= k && sorted[j - k].compareTo(v) > 0; j -= k) {
                    sorted[j] = sorted[j - k];
                }
                sorted[j] = v;
            }
        }
        return sorted;
    }

    protected String[] getValues() {
        Enumeration keys = this.langList.keys();
        String[] values = new String[this.langList.size()];
        int i = 0;
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            values[i] = (String)this.langList.get(key);
            ++i;
        }
        return values;
    }
}

