/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Gradient;
import gui.Window;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public final class TextWindow
extends Window {
    private String[] texts;
    private int y0;
    private int fh;
    private String title;
    private Vector StringLines;
    private int textheight;

    public TextWindow(int x, int y, int w, int h, String title, String text, Graphics gr) {
        super(x, y, w, h, text, gr);
        this.fh = gr.getFont().getHeight();
        if (this.fh < 3) {
            this.fh = 10;
        }
        this.StringLines = new Vector(1);
        this.textheight = 0;
        this.y0 = 0;
        this.title = title;
        this.StringLines.addElement(title);
        if (text != null && text.length() > 0) {
            this.texts = this.getTexts(text);
        } else {
            this.texts = new String[1];
            this.texts[0] = "";
        }
        for (int i = 0; i < this.texts.length; ++i) {
            this.addText(this.texts[i]);
        }
    }

    private String[] getTexts(String text) {
        int k = 1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '\n') continue;
            ++k;
        }
        String[] strings = new String[k];
        k = 0;
        StringBuffer tmps = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char tmp = text.charAt(i);
            if (tmp != '\n') {
                tmps.append(tmp);
            } else {
                strings[k] = tmps.toString();
                tmps = new StringBuffer();
                ++k;
            }
            if (i != text.length() - 1) continue;
            strings[k] = tmps.toString();
            tmps = null;
            k = 0;
        }
        return strings;
    }

    public String getText() {
        StringBuffer builder = new StringBuffer();
        String tmp = "";
        for (int i = 1; i < this.StringLines.size(); ++i) {
            tmp = (String)this.StringLines.elementAt(i);
            if (tmp == null || tmp.length() <= 0) continue;
            if (this.isNumber(tmp.charAt(0))) {
                builder.append('\n');
            } else if (tmp.endsWith(":")) {
                builder.append('\n');
            }
            builder.append(tmp).append(' ');
        }
        return builder.toString().trim();
    }

    private boolean isNumber(char c) {
        switch (c) {
            case '1': {
                return true;
            }
            case '2': {
                return true;
            }
            case '3': {
                return true;
            }
            case '4': {
                return true;
            }
            case '5': {
                return true;
            }
            case '6': {
                return true;
            }
            case '7': {
                return true;
            }
            case '8': {
                return true;
            }
            case '9': {
                return true;
            }
        }
        return false;
    }

    public void setText(String text) {
        if (text != null && text.length() > 0) {
            this.texts = this.getTexts(text);
        } else {
            this.texts = new String[1];
            this.texts[0] = "";
        }
        this.StringLines = new Vector(1);
        this.StringLines.addElement(this.title);
        for (int i = 0; i < this.texts.length; ++i) {
            this.addText(this.texts[i]);
        }
        this.textheight = this.StringLines.size() * this.fh;
    }

    public void addText(String text) {
        int i0 = 0;
        int i = 0;
        int in = 0;
        int jw = 0;
        int imax = text.length();
        boolean isexit = true;
        this.y0 = 0;
        while (isexit) {
            int j;
            i = text.indexOf(" ", i0 + 1);
            if (i <= i0) {
                i = imax;
                isexit = false;
            }
            if (jw + (j = this.gr.getFont().stringWidth(text.substring(i0, i))) < this.w) {
                jw += j;
                i0 = i;
                continue;
            }
            this.StringLines.addElement(text.substring(in, i0).trim());
            in = i0;
            if (j > this.w) {
                i = i0;
                for (jw = j; i < text.length() && jw > this.w; jw -= j) {
                    j = 0;
                    while (i < text.length() && j < this.w) {
                        j = this.gr.getFont().stringWidth(text.substring(in, ++i));
                    }
                    j = this.gr.getFont().stringWidth(text.substring(in, --i));
                    this.StringLines.addElement(text.substring(in, i).trim());
                    i0 = i;
                    in = i;
                }
                jw = 0;
                continue;
            }
            i0 = i;
        }
        this.StringLines.addElement(text.substring(in, imax).trim());
    }

    private void draw_text() {
        int y1 = this.y0;
        this.gr.setColor(0);
        for (int i = 0; i < this.StringLines.size(); ++i) {
            if (y1 + this.fh > 0) {
                this.gr.drawString(this.StringLines.elementAt(i).toString(), this.x + 2, this.y + 2 + y1, 20);
            }
            if ((y1 += this.fh) > this.h) break;
        }
    }

    public final void draw() {
        Gradient.gradientBox(this.gr, 0xFFFFFF, 0xAAAAAA, this.x, this.y, this.w, this.h, 0, 'c');
        if (this.active) {
            this.gr.setColor(0x1111FF);
            this.gr.drawRoundRect(this.x, this.y, this.w - 1, this.h - 1, 6, 6);
            this.gr.drawRoundRect(this.x + 1, this.y + 1, this.w - 1, this.h - 1, 6, 6);
        }
        this.draw_text();
    }

    protected final void moveDown() {
        if (this.textheight > this.h) {
            this.y0 -= this.fh;
            if (this.h - this.y0 > this.textheight) {
                this.y0 = this.h - this.textheight;
            }
        }
    }

    protected final void moveUp() {
        if (this.textheight > this.h) {
            this.y0 += this.fh;
            if (this.y0 > 0) {
                this.y0 = 0;
            }
        }
    }

    protected final boolean Released() {
        return this.y0 == 0;
    }
}

