/*
 * Decompiled with CFR 0.152.
 */
package com.bf.ctrl;

import com.allinone.bf.tool.T;
import com.bf.canvas.GameCanvas;
import javax.microedition.lcdui.Graphics;

public class A_Star {
    long ttime;
    private int begin_x = 0;
    private int begin_y = 0;
    private int mWidth;
    private int mHeight;
    private int[][] moveSpace;
    private int openListLength = 0;
    private int closeListLength = 0;
    private boolean[][] closeList;
    private int[][][] openList;

    public void initData() {
        this.moveSpace = GameCanvas.mc.moveSpaceTemp;
        this.mWidth = this.moveSpace.length;
        this.mHeight = this.moveSpace[0].length;
    }

    private void addInCloseList(int x, int y) {
        this.closeList[y][x] = true;
        ++this.closeListLength;
    }

    private void addInOpenList(int x, int y) {
        this.openList[y][x][0] = 1;
        ++this.openListLength;
    }

    private void removeFromOpenList(int x, int y) {
        this.openList[y][x][0] = 0;
        --this.openListLength;
    }

    private boolean isBalk(int x, int y) {
        if (x < 0 || x >= this.mWidth || y < 0 || y >= this.mHeight) {
            return true;
        }
        if (this.closeList[y][x]) {
            return true;
        }
        return this.moveSpace[y][x] == 9;
    }

    private void setFather(int x, int y, int f) {
        this.openList[y][x][4] = f;
    }

    private void getGHF(int x, int y, int tx, int ty) {
        this.openList[y][x][1] = this.getG(x, y);
        this.openList[y][x][2] = this.getH(x, y, tx, ty);
        this.openList[y][x][3] = this.openList[y][x][1] + this.openList[y][x][3];
    }

    private int getG(int x, int y) {
        switch (this.openList[y][x][4]) {
            default: {
                return this.moveSpace[y][x];
            }
            case 1: {
                return this.openList[y - 1][x][1] + this.moveSpace[y][x];
            }
            case 2: {
                return this.openList[y + 1][x][1] + this.moveSpace[y][x];
            }
            case 3: {
                return this.openList[y][x - 1][1] + this.moveSpace[y][x];
            }
            case 4: 
        }
        return this.openList[y][x + 1][1] + this.moveSpace[y][x];
    }

    private int getH(int x, int y, int tx, int ty) {
        return Math.abs(x - tx) + Math.abs(y - ty);
    }

    private void AAsterisk_t(int ttx, int tty, int tx, int ty) {
        if (ttx == tx && tty == ty || this.openListLength == 0) {
            return;
        }
        this.removeFromOpenList(ttx, tty);
        this.addInCloseList(ttx, tty);
        if (!this.isBalk(ttx + 1, tty)) {
            if (this.openList[tty][ttx + 1][0] == 0) {
                this.addInOpenList(ttx + 1, tty);
                this.setFather(ttx + 1, tty, 3);
                this.getGHF(ttx + 1, tty, tx, ty);
            } else if (this.openList[tty][ttx + 1][0] == 1 && this.openList[tty][ttx][1] + this.moveSpace[tty][ttx + 1] < this.openList[tty][ttx + 1][1]) {
                this.setFather(ttx + 1, tty, 3);
                this.getGHF(ttx + 1, tty, tx, ty);
            }
        }
        if (!this.isBalk(ttx - 1, tty)) {
            if (this.openList[tty][ttx - 1][0] == 0) {
                this.addInOpenList(ttx - 1, tty);
                this.setFather(ttx - 1, tty, 4);
                this.getGHF(ttx - 1, tty, tx, ty);
            } else if (this.openList[tty][ttx - 1][0] == 1 && this.openList[tty][ttx][1] + this.moveSpace[tty][ttx - 1] < this.openList[tty][ttx - 1][1]) {
                this.setFather(ttx - 1, tty, 4);
                this.getGHF(ttx - 1, tty, tx, ty);
            }
        }
        if (!this.isBalk(ttx, tty + 1)) {
            if (this.openList[tty + 1][ttx][0] == 0) {
                this.addInOpenList(ttx, tty + 1);
                this.setFather(ttx, tty + 1, 1);
                this.getGHF(ttx, tty + 1, tx, ty);
            } else if (this.openList[tty + 1][ttx][0] == 1 && this.openList[tty][ttx][1] + this.moveSpace[tty + 1][ttx] < this.openList[tty + 1][ttx][1]) {
                this.setFather(ttx, tty + 1, 1);
                this.getGHF(ttx, tty + 1, tx, ty);
            }
        }
        if (!this.isBalk(ttx, tty - 1)) {
            if (this.openList[tty - 1][ttx][0] == 0) {
                this.addInOpenList(ttx, tty - 1);
                this.setFather(ttx, tty - 1, 2);
                this.getGHF(ttx, tty - 1, tx, ty);
            } else if (this.openList[tty - 1][ttx][0] == 1 && this.openList[tty][ttx][1] + this.moveSpace[tty - 1][ttx] < this.openList[tty - 1][ttx][1]) {
                this.setFather(ttx, tty - 1, 2);
                this.getGHF(ttx, tty - 1, tx, ty);
            }
        }
        int bx = ttx;
        int by = tty;
        int minf = 255;
        int i = 0;
        while (i < this.mHeight) {
            int j = 0;
            while (j < this.mWidth) {
                if (this.openList[i][j][0] == 1 && minf > this.openList[i][j][3]) {
                    minf = this.openList[i][j][3];
                    bx = j;
                    by = i;
                }
                ++j;
            }
            ++i;
        }
        this.AAsterisk_t(bx, by, tx, ty);
    }

    public void AAsterisk(int bx, int by, int tx, int ty) {
        this.begin_x = bx;
        this.begin_y = by;
        this.ttime = System.currentTimeMillis();
        this.closeList = null;
        this.openList = null;
        this.closeList = new boolean[this.mHeight][this.mWidth];
        this.openList = new int[this.mHeight][this.mWidth][5];
        this.closeListLength = 0;
        this.openListLength = 0;
        int i = 0;
        while (i < this.mHeight) {
            int j = 0;
            while (j < this.mWidth) {
                this.openList[i][j][0] = 0;
                this.openList[i][j][1] = this.moveSpace[i][j];
                this.openList[i][j][2] = Math.abs(i - ty) + Math.abs(j - tx);
                this.openList[i][j][3] = this.openList[i][j][1] + this.openList[i][j][2];
                this.openList[i][j][4] = 0;
                ++j;
            }
            ++i;
        }
        this.addInOpenList(bx, by);
        if (!this.isBalk(bx + 1, by)) {
            this.addInOpenList(bx + 1, by);
            this.setFather(bx + 1, by, 3);
            this.getGHF(bx + 1, by, tx, ty);
        }
        if (!this.isBalk(bx - 1, by)) {
            this.addInOpenList(bx - 1, by);
            this.setFather(bx - 1, by, 4);
            this.getGHF(bx - 1, by, tx, ty);
        }
        if (!this.isBalk(bx, by + 1)) {
            this.addInOpenList(bx, by + 1);
            this.setFather(bx, by + 1, 1);
            this.getGHF(bx, by + 1, tx, ty);
        }
        if (!this.isBalk(bx, by - 1)) {
            this.addInOpenList(bx, by - 1);
            this.setFather(bx, by - 1, 2);
            this.getGHF(bx, by - 1, tx, ty);
        }
        this.removeFromOpenList(bx, by);
        this.addInCloseList(bx, by);
        int ttx = bx;
        int tty = by;
        int minf = 255;
        int i2 = 0;
        while (i2 < this.mHeight) {
            int j = 0;
            while (j < this.mWidth) {
                if (this.openList[i2][j][0] == 1 && minf > this.openList[i2][j][3]) {
                    minf = this.openList[i2][j][3];
                    ttx = j;
                    tty = i2;
                }
                ++j;
            }
            ++i2;
        }
        this.AAsterisk_t(ttx, tty, tx, ty);
        this.ttime = System.currentTimeMillis() - this.ttime;
        T.log("A* TIME: " + this.ttime);
    }

    public int[] getFather(int x, int y) {
        int[] father = new int[2];
        if (this.openList == null) {
            father[0] = -1;
            father[1] = -1;
            return father;
        }
        if (x == this.begin_x && y == this.begin_y) {
            father[0] = -1;
            father[1] = -1;
            return father;
        }
        switch (this.openList[y][x][4]) {
            case 1: {
                father[0] = x;
                father[1] = y - 1;
                break;
            }
            case 2: {
                father[0] = x;
                father[1] = y + 1;
                break;
            }
            case 3: {
                father[0] = x - 1;
                father[1] = y;
                break;
            }
            case 4: {
                father[0] = x + 1;
                father[1] = y;
                break;
            }
            default: {
                father[0] = -1;
                father[1] = -1;
            }
        }
        return father;
    }

    public void showfather(Graphics g, int x, int y) {
        if (x == this.begin_x && y == this.begin_y) {
            return;
        }
        if (x == -1 || y == -1) {
            return;
        }
        g.setColor(0xFFFF00);
        g.fillArc(x * 42 - GameCanvas.mc.camera_x(), y * 42 - GameCanvas.mc.camera_y(), 5, 5, 0, 360);
        g.setColor(0xFF0000);
        g.fillArc(x * 42 - GameCanvas.mc.camera_x(), y * 42 - GameCanvas.mc.camera_y(), 42, 42, 0, 360);
        if (this.openList != null) {
            switch (this.openList[y][x][4]) {
                case 1: {
                    this.showfather(g, x, y - 1);
                    break;
                }
                case 2: {
                    this.showfather(g, x, y + 1);
                    break;
                }
                case 3: {
                    this.showfather(g, x - 1, y);
                    break;
                }
                case 4: {
                    this.showfather(g, x + 1, y);
                    break;
                }
            }
        }
    }
}

