/*
 * Decompiled with CFR 0.152.
 */
package com.bf.sprite.other;

import com.allinone.bf.tool.T;
import com.bf.canvas.GameCanvas;
import com.bf.ctrl.MapCtrl;
import com.bf.i.ICanvas;
import com.bf.sprite.aggressor.BulletDataAgg;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AggBossBullet {
    private String path = "/pic/bullet/agg/";
    private boolean isLive = false;
    private int actDirStatus;
    private final int ACTION_FLY;
    private final int ACTION_END;
    private int actStatus;
    public int b_final_x;
    public int b_final_y;
    public int b_map_x;
    public int b_map_y;
    public int b_map_x_temp;
    public int b_map_y_temp;
    private short[] imageFrames;
    private int imageFramec;
    public int b_scr_x;
    public int b_scr_y;
    private static Image imageSrc;
    private static Image imageSta;
    private static Image imageEnd;
    private String imagePath;
    private int imagePathWH;
    private int BULLET_FLY;
    private int BULLET_STA;
    private int BULLET_END;
    public int attack;
    public int speed;
    public short[] collisionsBs;
    private int frameStaCnum;
    private int frameFlyCnum;
    private int frameEndCnum;
    private static short[][][] buttletPoints;
    private static short[] buttletPointsSpeed;
    private int bstartNum;
    int bulletType;
    private int mathSinCosNum;
    private int[] mathSin;
    private int[] mathCos;

    static {
        buttletPoints = new short[36][][];
        buttletPointsSpeed = new short[36];
    }

    public AggBossBullet() {
        this.ACTION_FLY = 1;
        this.ACTION_END = 2;
        short[] sArray = new short[4];
        sArray[2] = 1;
        sArray[3] = 1;
        this.imageFrames = sArray;
        this.imageFramec = 0;
        this.imagePath = "bossbullet.png";
        this.imagePathWH = 8;
        this.BULLET_FLY = 0;
        this.BULLET_STA = 0;
        this.BULLET_END = 0;
        this.attack = 0;
        this.speed = 0;
        this.collisionsBs = new short[4];
        this.frameStaCnum = 0;
        this.frameFlyCnum = 0;
        this.frameEndCnum = 0;
        this.bstartNum = 0;
        this.mathSinCosNum = 1000000;
        int[] nArray = new int[36];
        nArray[1] = -544021;
        nArray[2] = 912945;
        nArray[3] = -988031;
        nArray[4] = 745113;
        nArray[5] = -262374;
        nArray[6] = -304810;
        nArray[7] = 773890;
        nArray[8] = -993888;
        nArray[9] = 893996;
        nArray[10] = -506365;
        nArray[11] = -18594;
        nArray[12] = 580611;
        nArray[13] = -930105;
        nArray[14] = 980239;
        nArray[15] = -714876;
        nArray[16] = 219425;
        nArray[17] = 346649;
        nArray[18] = -801152;
        nArray[19] = 997799;
        nArray[20] = -873297;
        nArray[21] = 467718;
        nArray[22] = 88398;
        nArray[23] = -616064;
        nArray[24] = 945445;
        nArray[25] = -970528;
        nArray[26] = 683239;
        nArray[27] = -176045;
        nArray[28] = -387809;
        nArray[29] = 826845;
        nArray[30] = -999755;
        nArray[31] = 850887;
        nArray[32] = -428155;
        nArray[33] = -132381;
        nArray[34] = 650310;
        nArray[35] = -958932;
        this.mathSin = nArray;
        this.mathCos = new int[]{1000000, -839071, 408082, 154251, -666938, 964966, -952412, 633319, -110387, -448073, 862318, -999020, 814180, -367291, -197813, 699250, -975629, 937994, -598460, 66306, 487187, -883877, 996085, -787695, 325781, 240988, -730194, 984381, -921739, 562428, -22096, -525347, 903705, -991198, 759668, -283633};
        this.BULLET_FLY = 1;
        this.BULLET_STA = 1;
        this.BULLET_END = 1;
        this.attack = 1;
        this.speed = 220;
        this.loadingImage();
        this.initData();
    }

    private void initData() {
        if (buttletPoints[0] == null) {
            int i = 0;
            while (i < buttletPoints.length) {
                AggBossBullet.buttletPoints[i] = T.TM.getLine(0, 0, ICanvas.sWidth / 2 + (ICanvas.sWidth + ICanvas.sHeight) * this.mathSin[i] / this.mathSinCosNum + 0, ICanvas.sHeight / 2 + (ICanvas.sWidth + ICanvas.sHeight) * this.mathCos[i] / this.mathSinCosNum + 0);
                AggBossBullet.buttletPointsSpeed[i] = (short)(buttletPoints[i].length / this.speed);
                ++i;
            }
        }
    }

    private void loadingImage() {
        if (imageSrc == null) {
            imageSrc = T.TP.createImg(this.path, this.imagePath);
        }
        if (imageSta == null) {
            imageSta = T.TP.createImg(this.path, "aggbullet_sta_1.png");
        }
        if (imageEnd == null) {
            imageEnd = T.TP.createImg(this.path, "aggbullet_end_1.png");
        }
    }

    public void fire(int actDirStatus, int bulletType, int x, int y) {
        if (!this.isLive) {
            this.isLive = true;
            this.bulletType = bulletType;
            this.actDirStatus = actDirStatus;
            this.actStatus = 1;
            this.b_map_x = x;
            this.b_map_y = y;
            this.b_final_x = x;
            this.b_final_y = y;
            this.collisionsBs[0] = 0;
            this.collisionsBs[1] = 0;
            this.collisionsBs[2] = 0;
            this.collisionsBs[3] = 0;
            this.frameStaCnum = 0;
            this.frameFlyCnum = 0;
            this.frameEndCnum = 0;
            this.bstartNum = 0;
        }
    }

    public void paint(Graphics g) {
        try {
            if (this.isLive) {
                switch (this.actStatus) {
                    case 1: {
                        this.actionFly(g);
                        this.actionSta(g);
                        break;
                    }
                    case 2: {
                        this.actionSta(g);
                        this.actionEnd(g);
                    }
                }
                this.paintDebug(g);
            }
        }
        catch (Exception e) {
            T.log("Bullet.java paint() : " + e.getMessage());
        }
    }

    private void actionSta(Graphics g) {
        if (this.BULLET_STA == 0) {
            this.actStatus = 1;
        } else if (this.frameStaCnum != -1) {
            MapCtrl.paintImageX(g, imageSta, this.b_final_x - GameCanvas.mc.camera_x(), this.b_final_y - GameCanvas.mc.camera_y(), BulletDataAgg.imgPathSta1_Frames[this.frameStaCnum], 30, 30);
            g.setClip(0, 0, ICanvas.sWidth, ICanvas.sHeight);
            ++this.frameStaCnum;
            if (this.frameStaCnum >= BulletDataAgg.imgPathSta1_Frames.length) {
                this.frameStaCnum = -1;
            }
        }
    }

    private void actionFly(Graphics g) {
        if (this.BULLET_FLY == 0) {
            this.actStatus = 2;
        } else {
            this.bstartNum += buttletPointsSpeed[this.actDirStatus];
            if (buttletPoints[this.actDirStatus].length > this.bstartNum) {
                this.b_map_x_temp = this.b_map_x + buttletPoints[this.actDirStatus][this.bstartNum][0];
                this.b_map_y_temp = this.b_map_y + buttletPoints[this.actDirStatus][this.bstartNum][1];
            } else {
                this.actStatus = 2;
            }
            switch (this.bulletType) {
                case 0: {
                    MapCtrl.paintImageX(g, imageSrc, this.b_map_x_temp - GameCanvas.mc.camera_x(), this.b_map_y_temp - GameCanvas.mc.camera_y(), 0, this.imagePathWH, this.imagePathWH);
                    break;
                }
                case 1: {
                    MapCtrl.paintImageX(g, imageSrc, this.b_map_x_temp - GameCanvas.mc.camera_x(), this.b_map_y_temp - GameCanvas.mc.camera_y(), 1, this.imagePathWH, this.imagePathWH);
                    break;
                }
                case 2: {
                    MapCtrl.paintImageX(g, imageSrc, this.b_map_x_temp - GameCanvas.mc.camera_x(), this.b_map_y_temp - GameCanvas.mc.camera_y(), this.imageFrames[this.imageFramec], this.imagePathWH, this.imagePathWH);
                    ++this.imageFramec;
                    if (this.imageFramec < this.imageFrames.length) break;
                    this.imageFramec = 0;
                }
            }
            this.collisionsBs[0] = (short)(this.b_map_x_temp - this.imagePathWH / 2);
            this.collisionsBs[1] = (short)(this.b_map_y_temp - this.imagePathWH / 2);
            this.collisionsBs[2] = (short)this.imagePathWH;
            this.collisionsBs[3] = (short)this.imagePathWH;
            ++this.frameFlyCnum;
            if (this.frameFlyCnum >= BulletDataAgg.imgPath1_Frames.length) {
                this.frameFlyCnum = 0;
            }
            this.collideLogic_Sprite();
        }
    }

    private void collideLogic_Sprite() {
        if (GameCanvas.xman.isLive() && !GameCanvas.xman.invincible && T.TM.intersectRect(this.collisionsBs[0], this.collisionsBs[1], this.collisionsBs[2], this.collisionsBs[3], GameCanvas.xman.xs.getCollidesX(0) + GameCanvas.mc.camera_x(), GameCanvas.xman.xs.getCollidesY(0) + GameCanvas.mc.camera_y(), GameCanvas.xman.xs.getCollidesWidth(0), GameCanvas.xman.xs.getCollidesHeight(0))) {
            this.actStatus = 2;
            if (T.getRandom(5) == 0) {
                GameCanvas.xman.goHurt(this.attack);
            }
        }
    }

    private void actionEnd(Graphics g) {
        if (this.BULLET_END == 0) {
            this.isLive = false;
        } else {
            MapCtrl.paintImageX(g, imageEnd, this.b_map_x_temp - GameCanvas.mc.camera_x(), this.b_map_y_temp - GameCanvas.mc.camera_y(), BulletDataAgg.imgPathEnd1_Frames[this.frameEndCnum], 42, 42);
            g.setClip(0, 0, ICanvas.sWidth, ICanvas.sHeight);
            ++this.frameEndCnum;
            if (this.frameEndCnum >= BulletDataAgg.imgPathEnd1_Frames.length) {
                this.isLive = false;
                this.frameEndCnum = 0;
            }
        }
    }

    private void paintDebug(Graphics g) {
    }

    public boolean isLive() {
        return this.isLive;
    }
}

