/*
 * Decompiled with CFR 0.152.
 */
package com.allinone.rain.tool;

import com.allinone.bf.tool.T;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PicTool {
    private int encryptionStatus = 0;
    private final String urlSrc;
    private String urlTemp = "/icons/";
    private String[] encryptionData;
    private InputStream is = null;
    private ByteArrayInputStream bsArrayInputStream = null;
    private Image images = null;
    private String imagesStr = "";
    private final int fileHeader;
    private Image imageTemp;
    private int[] imageTempBuffer;
    private boolean isBlack = false;

    public PicTool() {
        this.urlSrc = "/icons/";
        this.fileHeader = 12;
    }

    public void setEncryption(int encryptionStatus, String[] encryptionData) {
        this.encryptionStatus = encryptionStatus;
        this.encryptionData = encryptionData;
    }

    public Image createImg(String url, String pngPath) {
        try {
            this.imageTemp = this.createImage(url, pngPath);
            this.imageTempBuffer = new int[this.imageTemp.getWidth() * this.imageTemp.getHeight()];
            this.imageTemp.getRGB(this.imageTempBuffer, 0, this.imageTemp.getWidth(), 0, 0, this.imageTemp.getWidth(), this.imageTemp.getHeight());
            return Image.createRGBImage((int[])this.imageTempBuffer, (int)this.imageTemp.getWidth(), (int)this.imageTemp.getHeight(), (boolean)true);
        }
        catch (Exception e) {
            T.log("T RGBIMAGE ERROR : \n" + e.getMessage());
            return null;
        }
    }

    private Image createImage(String url, String pngPath) {
        block48: {
            if (this.isBlack) break block48;
            switch (this.encryptionStatus) {
                case 0: {
                    this.urlTemp = url;
                    try {
                        T.log("|  |" + this.urlTemp + pngPath);
                        return Image.createImage((String)(String.valueOf(this.urlTemp) + pngPath));
                    }
                    catch (Exception e) {
                        T.log("T.java createImage() " + this.urlTemp + pngPath + " = null : \n" + e.getMessage());
                        return null;
                    }
                }
                case 1: {
                    this.urlTemp = url;
                    T.log("|* |" + this.urlTemp + pngPath);
                    try {
                        int i = 0;
                        while (i < this.encryptionData.length) {
                            if (this.encryptionData[i].equals(pngPath.trim())) {
                                this.is = Thread.currentThread().getClass().getResourceAsStream(String.valueOf(this.urlTemp) + pngPath);
                                int fileLengthc = this.is.available();
                                if (!String.valueOf(fileLengthc).equals(this.encryptionData[i + 1])) {
                                    this.isBlack = true;
                                }
                            }
                            i += 2;
                        }
                        Image image = Image.createImage((String)(String.valueOf(this.urlTemp) + pngPath));
                        return image;
                    }
                    catch (Exception e) {
                        T.log("T.java createImage catch " + pngPath + " = null : \n" + e.getMessage());
                    }
                    finally {
                        try {
                            if (this.bsArrayInputStream != null) {
                                this.bsArrayInputStream.close();
                            }
                            if (this.is != null) {
                                this.is.close();
                            }
                        }
                        catch (IOException e) {
                            T.log("T.java createImage finally \n" + e.getMessage());
                        }
                    }
                }
                case 2: {
                    this.urlTemp = "/icons/";
                    T.log("|**|" + this.urlTemp + pngPath);
                    if (this.imagesStr.equals(pngPath)) {
                        if (this.images != null) {
                            return this.images;
                        }
                    } else {
                        this.imagesStr = pngPath.trim();
                        this.images = null;
                        System.gc();
                    }
                    String fileName = pngPath.substring(0, pngPath.indexOf("."));
                    try {
                        int i = 0;
                        while (i < this.encryptionData.length) {
                            if (this.encryptionData[i].equals(pngPath.trim())) {
                                this.is = Thread.currentThread().getClass().getResourceAsStream(String.valueOf(this.urlTemp) + fileName + ".bf");
                                int fileLengthc = this.is.available() - 12;
                                if (String.valueOf(fileLengthc).equals(this.encryptionData[i + 1])) {
                                    byte[] bs = new byte[fileLengthc];
                                    this.is.skip(12L);
                                    this.is.read(bs);
                                    this.bsArrayInputStream = new ByteArrayInputStream(bs);
                                    Image image = this.images = Image.createImage((InputStream)this.bsArrayInputStream);
                                    return image;
                                }
                                this.isBlack = true;
                                return null;
                            }
                            i += 2;
                        }
                        return null;
                    }
                    catch (Exception e) {
                        T.log("T.java createImage catch " + pngPath + " = null : \n" + e.getMessage());
                        return null;
                    }
                    finally {
                        try {
                            if (this.bsArrayInputStream != null) {
                                this.bsArrayInputStream.close();
                            }
                            if (this.is != null) {
                                this.is.close();
                            }
                        }
                        catch (IOException e) {
                            T.log("T.java createImage finally \n" + e.getMessage());
                        }
                    }
                }
            }
            return null;
        }
        return null;
    }

    public void paintImageX(Graphics g, Image img, int x, int y, int anchor) {
        g.drawImage(img, x, y, anchor);
        g.setClip(0, 0, T.sWidth, T.sHeight);
    }

    public void paintImageX(Graphics g, Image img, int x, int y, int anchor, int transform) {
        g.drawRegion(img, 0, 0, img.getWidth(), img.getHeight(), transform, x, y, anchor);
        g.setClip(0, 0, T.sWidth, T.sHeight);
    }

    public void paintImageX(Graphics g, Image image, int x, int y, int frame, int imgw, int imgh) {
        g.setClip(x - imgw / 2, y - imgh / 2, imgw, imgh);
        g.drawImage(image, x - imgw / 2, y - imgh * frame - imgh / 2, 0);
        g.setClip(0, 0, T.sWidth, T.sHeight);
    }

    public void paintImageX(Graphics g, Image image, int x, int y, int frame, int imgw, int imgh, int transform) {
        if (transform == 5 || transform == 6) {
            g.setClip(x - imgh / 2, y - imgw / 2, imgh, imgw);
            g.drawRegion(image, 0, imgh * frame, imgw, imgh, transform, x - imgh / 2, y - imgw / 2, 0);
        } else {
            g.setClip(x - imgw / 2, y - imgh / 2, imgw, imgh);
            g.drawRegion(image, 0, imgh * frame, imgw, imgh, transform, x - imgw / 2, y - imgh / 2, 0);
        }
        g.setClip(0, 0, T.sWidth, T.sHeight);
    }

    public Image ZoomImage(Image image, int desW, int desH) {
        Image desImg = null;
        int srcW = image.getWidth();
        int srcH = image.getHeight();
        int[] srcBuf = new int[srcW * srcH];
        image.getRGB(srcBuf, 0, srcW, 0, 0, srcW, srcH);
        int[] tabY = new int[desH];
        int[] tabX = new int[desW];
        int sb = 0;
        int db = 0;
        int tems = 0;
        int temd = 0;
        int distance = srcH > desH ? srcH : desH;
        int i = 0;
        while (i <= distance) {
            tabY[db] = sb++;
            temd += desH;
            if ((tems += srcH) > distance) {
                tems -= distance;
            }
            if (temd > distance) {
                temd -= distance;
                ++db;
            }
            ++i;
        }
        sb = 0;
        db = 0;
        tems = 0;
        temd = 0;
        distance = srcW > desW ? srcW : desW;
        i = 0;
        while (i <= distance) {
            tabX[db] = (short)sb;
            temd += desW;
            if ((tems += srcW) > distance) {
                tems -= distance;
                ++sb;
            }
            if (temd > distance) {
                temd -= distance;
                ++db;
            }
            ++i;
        }
        int[] desBuf = new int[desW * desH];
        int dx = 0;
        int dy = 0;
        int sy = 0;
        int oldy = -1;
        int i2 = 0;
        while (i2 < desH) {
            if (oldy == tabY[i2]) {
                System.arraycopy(desBuf, dy - desW, desBuf, dy, desW);
            } else {
                dx = 0;
                int j = 0;
                while (j < desW) {
                    desBuf[dy + dx] = srcBuf[sy + tabX[j]];
                    ++dx;
                    ++j;
                }
                sy += (tabY[i2] - oldy) * srcW;
            }
            oldy = tabY[i2];
            dy += desW;
            ++i2;
        }
        desImg = Image.createRGBImage((int[])desBuf, (int)desW, (int)desH, (boolean)true);
        return desImg;
    }

    public void paintNumberX(Graphics g, Image image, int num, int x, int y, int w_) {
        int w = image.getWidth() / 10;
        int h = image.getHeight();
        int w_w = 0;
        String tmpStr = "" + Math.abs(num);
        int i = 0;
        while (i < tmpStr.length()) {
            g.setClip(x + i * w + w_w, y, w, h);
            g.drawImage(image, x + (i - Integer.parseInt(String.valueOf(tmpStr.charAt(i)))) * w + w_w, y, 20);
            w_w += w_;
            ++i;
        }
        g.setClip(0, 0, T.sWidth, T.sHeight);
    }

    public void paintNumberX(Graphics g, Image image, int num, int x, int y, int mt, int w_) {
        int i;
        int w = image.getWidth() / 10;
        int h = image.getHeight();
        int w_w = 0;
        String tmpStr = "" + Math.abs(num);
        String tmp = "";
        if (mt < tmpStr.length()) {
            tmpStr = "";
            i = 0;
            while (i < mt) {
                tmpStr = String.valueOf(tmpStr) + "9";
                ++i;
            }
        } else if (mt > tmpStr.length()) {
            i = 0;
            while (i < mt - tmpStr.length()) {
                tmp = "0" + tmp;
                ++i;
            }
            tmpStr = String.valueOf(tmp) + tmpStr;
        }
        i = 0;
        while (i < tmpStr.length()) {
            g.setClip(x + i * w + w_w, y, w, h);
            g.drawImage(image, x + (i - Integer.parseInt(String.valueOf(tmpStr.charAt(i)))) * w + w_w, y, 20);
            w_w += w_;
            ++i;
        }
        g.setClip(0, 0, T.sWidth, T.sHeight);
    }
}

