/*
 * Decompiled with CFR 0.152.
 */
package com.bf.sound;

import com.allinone.bf.tool.T;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class AudioPlay {
    public static final int BOOM_4 = 0;
    public static final int BG_6 = 1;
    public static int m_currentPlayer = -1;
    protected static final String TYPE_WAVE = "audio/x-wav";
    protected static final String TYPE_MIDI = "audio/midi";
    protected static final String TYPE_MPEG = "audio/mpeg";
    protected static final String[] RESOURCE_MAP = new String[]{"bo.wav", "bg.mid"};
    public static Player[] m_sounds = new Player[RESOURCE_MAP.length];
    protected static final int[] v = new int[]{60, 40};
    protected static final int[] l = new int[]{1, -1};

    public synchronized InputStream getResource(int resourceId) {
        String sResource = "/sound/" + RESOURCE_MAP[resourceId];
        return Thread.currentThread().getClass().getResourceAsStream(sResource);
    }

    protected synchronized void createSound(int index) {
        T.log("AudioPlay.java createSound()");
        String type = TYPE_MIDI;
        switch (index) {
            case 0: {
                type = TYPE_WAVE;
                break;
            }
            case 1: {
                type = TYPE_MIDI;
            }
        }
        try {
            InputStream isInputMusic = this.getResource(index);
            if (isInputMusic != null) {
                AudioPlay.m_sounds[index] = Manager.createPlayer((InputStream)isInputMusic, (String)type);
                m_sounds[index].realize();
                m_sounds[index].prefetch();
                m_sounds[index].setLoopCount(l[index]);
                VolumeControl volume = (VolumeControl)m_sounds[index].getControl("VolumeControl");
                if (volume != null) {
                    volume.setLevel(v[index]);
                }
            } else {
                T.log("AudioPlay.java createSound() [ Error ] : music " + index + " is NULL");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
    }

    public synchronized void stopSound(int index) {
        if (m_sounds[index] != null) {
            try {
                m_sounds[index].stop();
            }
            catch (MediaException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void shutdown() {
        try {
            try {
                int i = 0;
                while (i < m_sounds.length) {
                    if (m_sounds[i] != null) {
                        m_sounds[i].stop();
                        m_sounds[i].deallocate();
                        AudioPlay.m_sounds[i] = null;
                    }
                    ++i;
                }
            }
            catch (MediaException e) {
                e.printStackTrace();
                System.gc();
            }
        }
        finally {
            System.gc();
        }
    }

    public synchronized void stopAllSound() {
        this.shutdown();
    }

    public synchronized void playSound(int index, int volume) {
        T.log("AudioPlay.java playSound(" + index + "," + volume + ")");
        if (volume <= 0) {
            volume = 0;
        } else {
            if (volume >= 100) {
                volume = 100;
            }
            AudioPlay.v[index] = volume;
            try {
                if (m_sounds[index] == null) {
                    this.createSound(index);
                }
                m_sounds[index].setMediaTime(0L);
                m_sounds[index].start();
                m_currentPlayer = index;
            }
            catch (MediaException e) {
                T.log("AudioPlay.java playSound() [ Error ] : " + e.getMessage());
            }
        }
    }

    public int getStatus(int index) {
        if (m_sounds[index] != null) {
            return m_sounds[index].getState();
        }
        return -1;
    }
}

