/*
 * Decompiled with CFR 0.152.
 */
package com.bf.sprite;

import com.allinone.bf.tool.T;
import com.bf.canvas.GameCanvas;
import com.bf.ctrl.MapCtrl;
import com.bf.i.ICanvas;
import com.bf.sprite.BulletData;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Bullet {
    private String path = "/pic/bullet/";
    private boolean isLive = false;
    private boolean isMy = true;
    private int actDirStatus;
    private final int ACTION_FLY;
    private int actStatus;
    public int b_final_x;
    public int b_final_y;
    public int b_map_x;
    public int b_map_y;
    public int b_scr_x;
    public int b_scr_y;
    private static Image imageSrc;
    public int attack = 0;
    public int speed = 0;
    public int[] collisionsBs = new int[4];
    private int frameFlyCnum = 0;
    private int i_;
    private int j_;
    private short[][][] fireCollidesCheck;

    public Bullet(boolean isMy) {
        this.ACTION_FLY = 1;
        this.isMy = isMy;
        this.initData();
        this.loadingImage();
    }

    private void initData() {
        this.fireCollidesCheck = new short[GameCanvas.mc.COLLIDES_Buffer][GameCanvas.mc.COLLIDES_Buffer][8];
        this.speed = BulletData.speed;
    }

    private void loadingImage() {
        if (imageSrc == null) {
            imageSrc = T.TP.createImg(this.path, "bullet.png");
        }
    }

    public void fire(int actDirStatus, int x, int y, int attack) {
        if (!this.isLive) {
            this.isLive = true;
            this.actDirStatus = actDirStatus;
            this.actStatus = 1;
            this.b_map_x = x;
            this.b_map_y = y;
            this.b_final_x = x;
            this.b_final_y = y;
            this.attack = attack;
            this.collisionsBs[0] = 0;
            this.collisionsBs[1] = 0;
            this.collisionsBs[2] = 0;
            this.collisionsBs[3] = 0;
            this.frameFlyCnum = 0;
        }
    }

    public void paint(Graphics g) {
        try {
            if (this.isLive) {
                if (this.b_map_x > GameCanvas.mc.mapW || this.b_map_x < 0 || this.b_map_y > GameCanvas.mc.mapH || this.b_map_y < 0) {
                    this.isLive = false;
                } else {
                    switch (this.actStatus) {
                        case 1: {
                            this.actionFly(g);
                        }
                    }
                }
                this.paintDebug(g);
            }
        }
        catch (Exception e) {
            T.log("Bullet.java paint() : " + e.getMessage());
        }
    }

    private void actionFly(Graphics g) {
        int trans = 0;
        switch (this.actDirStatus) {
            case 0: {
                trans = 3;
                this.b_map_y -= this.speed;
                break;
            }
            case 1: {
                trans = 0;
                this.b_map_y += this.speed;
                break;
            }
            case 2: {
                trans = 5;
                this.b_map_x -= this.speed;
                break;
            }
            case 3: {
                trans = 6;
                this.b_map_x += this.speed;
            }
        }
        MapCtrl.paintImageX(g, imageSrc, this.b_map_x - GameCanvas.mc.camera_x(), this.b_map_y - GameCanvas.mc.camera_y(), BulletData.imgPath1_Frames[this.frameFlyCnum], 20, 47, trans);
        if (trans == 5 || trans == 6) {
            this.collisionsBs[0] = this.b_map_x - 10;
            this.collisionsBs[1] = this.b_map_y - 5;
            this.collisionsBs[2] = 20;
            this.collisionsBs[3] = 10;
        } else {
            this.collisionsBs[0] = this.b_map_x - 5;
            this.collisionsBs[1] = this.b_map_y - 10;
            this.collisionsBs[2] = 10;
            this.collisionsBs[3] = 20;
        }
        g.setClip(0, 0, ICanvas.sWidth, ICanvas.sHeight);
        ++this.frameFlyCnum;
        if (this.frameFlyCnum >= BulletData.imgPath1_Frames.length) {
            this.frameFlyCnum = 0;
        }
        this.collideLogic_Sprite();
        this.collideLogic_Map();
    }

    private void collideLogic_Sprite() {
        if (this.isMy) {
            int i = 0;
            while (i < GameCanvas.aggs.length) {
                if (GameCanvas.aggs[i].isLive() && T.TM.intersectRect(this.collisionsBs[0], this.collisionsBs[1], this.collisionsBs[2], this.collisionsBs[3], GameCanvas.aggs[i].as.getCollidesX(0) + GameCanvas.mc.camera_x(), GameCanvas.aggs[i].as.getCollidesY(0) + GameCanvas.mc.camera_y(), GameCanvas.aggs[i].as.getCollidesWidth(0), GameCanvas.aggs[i].as.getCollidesHeight(0))) {
                    this.isLive = false;
                    GameCanvas.show_bts(this.b_map_x, this.b_map_y);
                    GameCanvas.aggs[i].goHurt(this.attack);
                }
                ++i;
            }
        } else if (GameCanvas.xman.isLive() && !GameCanvas.xman.invincible && T.TM.intersectRect(this.collisionsBs[0], this.collisionsBs[1], this.collisionsBs[2], this.collisionsBs[3], GameCanvas.xman.xs.getCollidesX(0) + GameCanvas.mc.camera_x(), GameCanvas.xman.xs.getCollidesY(0) + GameCanvas.mc.camera_y(), GameCanvas.xman.xs.getCollidesWidth(0), GameCanvas.xman.xs.getCollidesHeight(0))) {
            this.isLive = false;
            GameCanvas.show_bts(this.b_map_x, this.b_map_y);
            GameCanvas.xman.goHurt(this.attack);
        }
    }

    private void collideLogic_Map() {
        int ii = this.b_map_x / GameCanvas.mc.unit;
        int jj = this.b_map_y / GameCanvas.mc.unit;
        int xx = ii - (GameCanvas.mc.COLLIDES_Buffer - 1) / 2;
        int yy = jj - (GameCanvas.mc.COLLIDES_Buffer - 1) / 2;
        if (xx < 0) {
            xx = 0;
        } else if (xx > GameCanvas.mc.mapWNum - GameCanvas.mc.COLLIDES_Buffer) {
            xx = GameCanvas.mc.mapWNum - GameCanvas.mc.COLLIDES_Buffer;
        }
        if (yy < 0) {
            yy = 0;
        } else if (yy > GameCanvas.mc.mapHNum - GameCanvas.mc.COLLIDES_Buffer) {
            yy = GameCanvas.mc.mapHNum - GameCanvas.mc.COLLIDES_Buffer;
        }
        this.i_ = xx;
        this.j_ = yy;
        int i = 0;
        while (i < GameCanvas.mc.COLLIDES_Buffer) {
            int j = 0;
            while (j < GameCanvas.mc.COLLIDES_Buffer) {
                if (GameCanvas.mc.moveCollides[this.i_ + i][this.j_ + j][4] == GameCanvas.mc.COLLIDES_LIVE) {
                    this.fireCollidesCheck[i][j][0] = GameCanvas.mc.moveCollides[this.i_ + i][this.j_ + j][0];
                    this.fireCollidesCheck[i][j][1] = GameCanvas.mc.moveCollides[this.i_ + i][this.j_ + j][1];
                    this.fireCollidesCheck[i][j][2] = GameCanvas.mc.moveCollides[this.i_ + i][this.j_ + j][2];
                    this.fireCollidesCheck[i][j][3] = GameCanvas.mc.moveCollides[this.i_ + i][this.j_ + j][3];
                    this.fireCollidesCheck[i][j][4] = (short)(this.i_ + i);
                    this.fireCollidesCheck[i][j][5] = (short)(this.j_ + j);
                    this.fireCollidesCheck[i][j][6] = GameCanvas.mc.COLLIDES_LIVE;
                    this.fireCollidesCheck[i][j][7] = GameCanvas.mc.moveCollides[this.i_ + i][this.j_ + j][5];
                    if (this.fireCollidesCheck[i][j][7] != -1 && T.TM.intersectRect(this.collisionsBs[0], this.collisionsBs[1], this.collisionsBs[2], this.collisionsBs[3], this.fireCollidesCheck[i][j][0], this.fireCollidesCheck[i][j][1], this.fireCollidesCheck[i][j][2], this.fireCollidesCheck[i][j][3])) {
                        this.isLive = false;
                        GameCanvas.show_bts(this.b_map_x, this.b_map_y);
                        GameCanvas.mc.goHurt(this.attack, this.fireCollidesCheck[i][j][4], this.fireCollidesCheck[i][j][5]);
                    }
                } else {
                    this.fireCollidesCheck[i][j][6] = GameCanvas.mc.COLLIDES_DEAD;
                }
                ++j;
            }
            ++i;
        }
    }

    private void paintDebug(Graphics g) {
    }

    public boolean isLive() {
        return this.isLive;
    }

    public boolean isMy() {
        return this.isMy;
    }
}

