/*
 * Decompiled with CFR 0.152.
 */
package com.downjoy.j2me.smspack.util;

import com.downjoy.j2me.smspack.util.SMSPackInfoVO;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class SMSPackInfoReader {
    private static final String DJ_SMS_CODE1 = "DJSMSCode1";
    private static final String DJ_SMS_DEST1 = "DJSMSDest1";
    private static final String DJ_SMS_DESC1 = "DJSMSDesc1";
    private static final String DJ_SMS_CODE2 = "DJSMSCode2";
    private static final String DJ_SMS_DEST2 = "DJSMSDest2";
    private static final String DJ_SMS_DESC2 = "DJSMSDesc2";
    private static final String DJ_SMS_FREE_CODE = "DJFreeCode";
    private static final String DJ_SMS_FREE_DEST = "DJFreeDest";
    private static final String DJ_SMS_SHORT_CODE1 = "DJSMSShortCode1";
    private static final String DJ_SMS_SHORT_CODE2 = "DJSMSShortCode2";
    private static final int MAX_CODE_INTEGER = 916132831;

    private static String[] getFreeSMSInfo(String cpId, String gameId, String actionId, String eqpId, String feeCode) {
        try {
            String info = SMSPackInfoReader.readBinRaw();
            String freecode = SMSPackInfoReader.decodeInfo(SMSPackInfoReader.getFieldValue(info, DJ_SMS_FREE_CODE));
            String freedest = SMSPackInfoReader.decodeInfo(SMSPackInfoReader.getFieldValue(info, DJ_SMS_FREE_DEST));
            if (freecode.indexOf(59) > 0) {
                String[] codeArray = SMSPackInfoReader.split(freecode, ";");
                String[] destArray = SMSPackInfoReader.split(freedest, ";");
                int index = (int)(System.currentTimeMillis() % (long)codeArray.length);
                freecode = codeArray[index];
                freedest = destArray[index];
            }
            int pos = freecode.indexOf(124);
            String content = freecode.substring(0, pos) + cpId + gameId + actionId + eqpId + freecode.substring(pos + 1) + "-" + feeCode;
            return new String[]{freedest, content};
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u514d\u8d39\u4ee3\u7801\uff01");
        }
    }

    private static String[] getFeeSMSInfo(String cpId, String gameId, String actionId, String eqpId) {
        try {
            String packInfo = SMSPackInfoReader.readBinRaw();
            String code1 = SMSPackInfoReader.getFieldValue(packInfo, DJ_SMS_CODE1);
            String code2 = SMSPackInfoReader.getFieldValue(packInfo, DJ_SMS_CODE2);
            if (!(code1 != null && code1.length() != 0 || code2 != null && code2.length() != 0)) {
                throw new IllegalArgumentException("\u5fc5\u987b\u63d0\u4f9b\u81f3\u5c11\u4e00\u4e2a\u6536\u8d39\u4ee3\u7801\uff01");
            }
            if (code2 != null && code2.length() > 0 && System.currentTimeMillis() % 10L < 7L || code1 == null || code1.length() == 0) {
                code2 = SMSPackInfoReader.decodeInfo(code2);
                String dest2 = SMSPackInfoReader.decodeInfo(SMSPackInfoReader.getFieldValue(packInfo, DJ_SMS_DEST2));
                String desc2 = SMSPackInfoReader.getFieldValue(packInfo, DJ_SMS_DESC2);
                String shortCode2Str = SMSPackInfoReader.getFieldValue(packInfo, DJ_SMS_SHORT_CODE2);
                boolean isShortCode2 = "1".equals(shortCode2Str);
                if (code2.indexOf(59) > 0) {
                    String[] code2Array = SMSPackInfoReader.split(code2, ";");
                    String[] dest2Array = SMSPackInfoReader.split(dest2, ";");
                    String[] desc2Array = SMSPackInfoReader.split(desc2, ";");
                    int index = (int)(System.currentTimeMillis() % (long)code2Array.length);
                    if (shortCode2Str != null && shortCode2Str.length() > 0) {
                        String[] shortCode2Array = SMSPackInfoReader.split(shortCode2Str, ";");
                        isShortCode2 = "1".equals(shortCode2Array[index]);
                    }
                    code2 = code2Array[index];
                    dest2 = dest2Array[index];
                    desc2 = desc2Array[index];
                }
                int pos2 = code2.indexOf(124);
                boolean isExact = dest2.toUpperCase().startsWith("X");
                String content = isExact ? code2.substring(0, pos2) : (isShortCode2 ? code2.substring(0, pos2) + SMSPackInfoReader.getWordsFromNumber(cpId, gameId, code2.substring(pos2 + 1)) : code2.substring(0, pos2) + cpId + gameId + actionId + eqpId + code2.substring(pos2 + 1));
                return new String[]{isExact ? dest2.substring(1) : dest2, content, "2", desc2, isExact ? "true" : "false"};
            }
            code1 = SMSPackInfoReader.decodeInfo(code1);
            String dest1 = SMSPackInfoReader.decodeInfo(SMSPackInfoReader.getFieldValue(packInfo, DJ_SMS_DEST1));
            String desc1 = SMSPackInfoReader.getFieldValue(packInfo, DJ_SMS_DESC1);
            String shortCode1Str = SMSPackInfoReader.getFieldValue(packInfo, DJ_SMS_SHORT_CODE1);
            boolean isShortCode1 = "1".equals(shortCode1Str);
            if (code1.indexOf(59) > 0) {
                String[] code1Array = SMSPackInfoReader.split(code1, ";");
                String[] dest1Array = SMSPackInfoReader.split(dest1, ";");
                String[] desc1Array = SMSPackInfoReader.split(desc1, ";");
                int index = (int)(System.currentTimeMillis() % (long)code1Array.length);
                if (shortCode1Str != null && shortCode1Str.length() > 0) {
                    String[] shortCode1Array = SMSPackInfoReader.split(shortCode1Str, ";");
                    isShortCode1 = "1".equals(shortCode1Array[index]);
                }
                code1 = code1Array[index];
                dest1 = dest1Array[index];
                desc1 = desc1Array[index];
            }
            boolean isExact = dest1.toUpperCase().startsWith("X");
            int pos1 = code1.indexOf(124);
            String content = isExact ? code1.substring(0, pos1) : (isShortCode1 ? code1.substring(0, pos1) + SMSPackInfoReader.getWordsFromNumber(cpId, gameId, code1.substring(pos1 + 1)) : code1.substring(0, pos1) + cpId + gameId + actionId + eqpId + code1.substring(pos1 + 1));
            return new String[]{isExact ? dest1.substring(1) : dest1, content, "1", desc1, isExact ? "true" : "false"};
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException("\u672a\u627e\u5230\u6536\u8d39\u4ee3\u7801\uff01");
        }
    }

    public static SMSPackInfoVO getSMSPackInfo(String cpId, String gameId, String actionId, String eqpId, String feeCode) throws IllegalArgumentException {
        SMSPackInfoReader.verifyParams(cpId, gameId, actionId, eqpId, feeCode);
        SMSPackInfoVO smsPackInfo = new SMSPackInfoVO();
        eqpId = eqpId == null ? "000" : eqpId;
        actionId = actionId == null ? "00" : actionId;
        int amount = Integer.parseInt(feeCode);
        String[] feeNumInfo = SMSPackInfoReader.getFeeSMSInfo(cpId, gameId, actionId, eqpId);
        int price = Integer.parseInt(feeNumInfo[2]);
        smsPackInfo.setFeeSMSNum(feeNumInfo[0]);
        smsPackInfo.setFeeSMSContent(feeNumInfo[1]);
        smsPackInfo.setFeeSMSUnitPrice(price);
        smsPackInfo.setFeeSMSTitle(feeNumInfo[3]);
        smsPackInfo.setFeeSMSCnt(amount / price);
        if (feeNumInfo[4].equals("true")) {
            String[] freeNumInfo = SMSPackInfoReader.getFreeSMSInfo(cpId, gameId, actionId, eqpId, feeCode);
            smsPackInfo.setFreeSMSNum(freeNumInfo[0]);
            smsPackInfo.setFreeSMSContent(freeNumInfo[1]);
        }
        return smsPackInfo;
    }

    private static boolean isNumeric(String str) {
        try {
            int i = Integer.parseInt(str);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private static void verifyParams(String cpId, String gameId, String actionId, String eqpId, String feeCode) throws IllegalArgumentException {
        if (cpId == null || gameId == null || cpId.length() != 3 || gameId.length() != 3 || !SMSPackInfoReader.isNumeric(cpId) || !SMSPackInfoReader.isNumeric(gameId)) {
            throw new IllegalArgumentException("\u65e0\u6548\u5382\u5546\u3001\u6e38\u620fID\uff01");
        }
        if (!(actionId == null || actionId.length() == 2 && SMSPackInfoReader.isNumeric(actionId))) {
            throw new IllegalArgumentException("\u65e0\u6548\u52a8\u4f5cID\uff01");
        }
        if (!(eqpId == null || eqpId.length() == 3 && SMSPackInfoReader.isNumeric(eqpId))) {
            throw new IllegalArgumentException("\u65e0\u6548\u673a\u578bID\uff01");
        }
        if (feeCode == null || feeCode.length() > 2 || !SMSPackInfoReader.isNumeric(feeCode)) {
            throw new IllegalArgumentException("\u65e0\u6548\u8ba1\u8d39\u91d1\u989d\uff01");
        }
        int fee = Integer.parseInt(feeCode);
        if (fee % 2 != 0) {
            throw new IllegalArgumentException("\u65e0\u6548\u8ba1\u8d39\u91d1\u989d\uff01");
        }
    }

    private static String readBinRaw() throws IOException {
        StringBuffer sb = new StringBuffer();
        InputStream is = null;
        try {
            is = new Object().getClass().getResourceAsStream("/dcn.bin");
            byte[] bytes = new byte[512];
            int len = 0;
            while ((len = is.read(bytes)) > 0) {
                sb.append(new String(bytes, 0, len, "UTF-8"));
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return sb.toString().replace('\r', ' ');
    }

    private static String getFieldValue(String src, String key) {
        int pos = src.indexOf("\n");
        int prevPos = 0;
        String line = null;
        while (pos > 0) {
            line = src.substring(prevPos, pos).trim();
            if (line.startsWith(key)) {
                return line.substring(line.indexOf(58) + 1);
            }
            prevPos = pos + 1;
            pos = src.indexOf("\n", prevPos);
        }
        return null;
    }

    private static String[] split(String s, String token) {
        Vector<String> chips = new Vector<String>();
        int len = token.length();
        int form = 0;
        while (s.indexOf(token, form) >= form) {
            int start = s.indexOf(token, form);
            if (start == form) {
                chips.addElement("");
            } else {
                chips.addElement(s.substring(form, start));
            }
            form = start + len;
        }
        if (form < s.length()) {
            chips.addElement(s.substring(form));
        } else {
            chips.addElement("");
        }
        Object[] strs = new String[chips.size()];
        chips.copyInto(strs);
        return strs;
    }

    private static String decodeInfo(String info) {
        String nStr = info.substring(0, info.length() - 1);
        byte[] bytes = nStr.getBytes();
        byte[] nbytes = new byte[bytes.length];
        int i = 0;
        while (i < bytes.length) {
            byte b = bytes[i];
            if (b >= 48 && b <= 57) {
                b = (byte)(b + (b <= 50 ? 7 : -3));
            } else if (b >= 65 && b <= 90) {
                b = (byte)(b + (b <= 67 ? 23 : -3));
            }
            nbytes[i] = b;
            ++i;
        }
        return new String(nbytes);
    }

    private static String getWordsFromNumber(String cpId, String gameId, String channelId) {
        int number = Integer.parseInt(cpId + gameId + channelId);
        if (number > 916132831) {
            throw new IllegalArgumentException("cpId:" + cpId + "gameId:" + gameId + "channelId:" + channelId + ", too large! unsupports!@_@");
        }
        byte[] bytes = new byte[200];
        int i = 0;
        while (true) {
            int x;
            byte b = (x = number % 62) >= 10 && x < 36 ? (byte)(x - 10 + 65) : (x >= 36 && x < 62 ? (byte)(x - 36 + 97) : (byte)(x - 0 + 48));
            bytes[i++] = b;
            if (number < 62) break;
            number = (number - x) / 62;
        }
        String retVal = new String(SMSPackInfoReader.reverseAndTrim(bytes));
        int diff = 5 - retVal.length();
        if (diff == 0) {
            return retVal;
        }
        StringBuffer sb = new StringBuffer();
        int n = 0;
        while (n < diff) {
            sb.append('0');
            ++n;
        }
        sb.append(retVal);
        return sb.toString();
    }

    private static byte[] reverseAndTrim(byte[] bytes) {
        byte[] bytes2 = new byte[bytes.length];
        int length = 0;
        int i = 0;
        while (i < bytes.length) {
            byte b = bytes[i];
            if (b > 0) {
                ++length;
            }
            bytes2[bytes.length - i - 1] = b;
            ++i;
        }
        byte[] bytes3 = new byte[length];
        int i2 = 0;
        while (i2 < length) {
            bytes3[i2] = bytes2[bytes2.length - length + i2];
            ++i2;
        }
        return bytes3;
    }
}

