/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MAP {
    public byte[] mapData = null;
    public byte[] temp = null;
    public int dataIndex = 0;
    public int width = 0;
    public int height = 0;
    public int cellWidth = 0;
    public int cellHeight = 0;
    public byte[][] mapbData;
    public byte[][] mapfData;
    public int x = 0;
    public int y = 0;
    public Image mapTile = null;
    public int mapNum;
    public String[] scriptFile;
    public int[] scriptIndex;
    public boolean haveScript = false;
    public int IIII = 0;
    public boolean QQQQ = true;
    public int WH = 12;
    public int showCellW;
    public int showCellH;
    public int SCREEN_W;
    public int SCREEN_H;
    public int offMapY = 0;

    public MAP(String spxName, String image, int k, int g, int kc) {
        this.SCREEN_W = k;
        this.SCREEN_H = g;
        this.WH = kc;
        this.loadMap(spxName, image);
    }

    public void Speed(int xx, int yy, int oo) {
        this.x = xx;
        this.y = yy;
        this.offMapY = oo;
    }

    public void loadMap(String map, String image) {
        int num;
        this.loadMapSrc(image);
        int[] aT = new int[1];
        int[] bT = new int[1];
        try {
            InputStream is = this.getClass().getResourceAsStream(map);
            this.QQQQ = true;
            this.IIII = 0;
            while (this.QQQQ) {
                aT[this.IIII] = is.read();
                if (aT[this.IIII] != -1) {
                    System.arraycopy(aT, 0, bT, 0, aT.length);
                    aT = null;
                    ++this.IIII;
                    aT = new int[this.IIII + 1];
                    System.arraycopy(bT, 0, aT, 0, bT.length);
                    bT = null;
                    bT = new int[this.IIII + 1];
                    continue;
                }
                this.QQQQ = false;
            }
            bT = null;
            is.close();
            is = null;
            InputStream iss = this.getClass().getResourceAsStream(map);
            this.temp = new byte[aT.length - 1];
            iss.read(this.temp);
            iss.close();
            iss = null;
        }
        catch (Exception is) {
            // empty catch block
        }
        this.mapData = this.getBytes(this.temp);
        this.dataIndex = 0;
        this.width = this.mapData[this.dataIndex++];
        this.height = this.mapData[this.dataIndex++];
        this.cellWidth = this.mapData[this.dataIndex++];
        this.cellHeight = this.mapData[this.dataIndex++];
        this.mapbData = new byte[this.width][this.height];
        this.mapfData = new byte[this.width][this.height];
        int i = 0;
        while (i < this.height) {
            int j = 0;
            while (j < this.width) {
                this.mapbData[j][i] = this.mapData[this.dataIndex++];
                this.mapfData[j][i] = this.mapData[this.dataIndex++];
                ++j;
            }
            ++i;
        }
        if ((num = this.mapData[this.dataIndex++]) > 0) {
            this.haveScript = true;
            this.scriptFile = new String[num];
            this.scriptIndex = new int[num];
            int i2 = 0;
            while (i2 < num) {
                byte aa = this.mapData[this.dataIndex++];
                byte b = this.mapData[this.dataIndex++];
                int fn = aa << 8 | b & 0xFF;
                byte ln = this.mapData[this.dataIndex++];
                this.scriptIndex[i2] = fn;
                this.scriptFile[i2] = new String(this.mapData, this.dataIndex, (int)ln);
                this.dataIndex += ln;
                ++i2;
            }
        } else {
            this.haveScript = false;
        }
        this.mapData = null;
        this.temp = null;
        aT = null;
        this.x = 0;
        this.y = 0;
        this.showCellW = this.SCREEN_W / this.cellWidth == 0 ? this.SCREEN_W / this.cellWidth : this.SCREEN_W / this.cellWidth + 1;
        this.showCellH = this.SCREEN_H / this.cellHeight == 0 ? this.SCREEN_H / this.cellHeight : this.SCREEN_H / this.cellHeight + 1;
    }

    public void loadMapSrc(String image) {
        this.freeMapSrc();
        this.mapTile = this.createImage(image);
        System.gc();
    }

    public Image createImage(String path) {
        Image image = null;
        try {
            image = Image.createImage((String)path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return image;
    }

    public void freeMapSrc() {
        this.mapbData = null;
        this.mapfData = null;
        this.mapTile = null;
        System.gc();
    }

    public void paint_B_Map(Graphics g) {
        int id = 0;
        int cw = this.mapTile.getWidth() / this.cellWidth;
        g.setColor(0);
        int startX = -this.x / this.cellWidth;
        int endX = (-this.x + this.SCREEN_W) / this.cellWidth + 1;
        int startY = -this.y / this.cellHeight;
        int endY = (-this.y + this.SCREEN_H) / this.cellHeight + 1;
        int screenX = -this.x / this.cellWidth * this.cellWidth + this.x;
        int screenY = -this.y / this.cellHeight * this.cellHeight + this.y;
        int i = startX;
        while (i < endX) {
            if (i >= 0 && i < this.width) {
                int sx = screenX + (i - startX) * this.WH;
                int j = startY;
                while (j < endY) {
                    if (j >= 0 && j < this.height) {
                        int sy = screenY + (j - startY) * this.WH + this.offMapY;
                        id = this.mapbData[i][j];
                        if (id != 0) {
                            if (id < 0) {
                                id *= -1;
                            }
                            int px = (id - 1) % cw * this.WH;
                            int py = (id - 1) / cw * this.WH;
                            if (id != 0) {
                                g.setClip(sx, sy, this.cellWidth, this.cellHeight);
                                g.drawImage(this.mapTile, sx - px, sy - py, 0);
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void paint_F_Map(Graphics g) {
        int id = 0;
        int cw = this.mapTile.getWidth() / this.cellWidth;
        g.setColor(0);
        int startX = -this.x / this.cellWidth;
        int endX = (-this.x + this.SCREEN_W) / this.cellWidth + 1;
        int startY = -this.y / this.cellHeight;
        int endY = (-this.y + this.SCREEN_H) / this.cellHeight + 1;
        int screenX = -this.x / this.cellWidth * this.cellWidth + this.x;
        int screenY = -this.y / this.cellHeight * this.cellHeight + this.y;
        int i = startX;
        while (i < endX) {
            if (i >= 0 && i < this.width) {
                int sx = screenX + (i - startX) * this.WH;
                int j = startY;
                while (j < endY) {
                    if (j >= 0 && j < this.height) {
                        int sy = screenY + (j - startY) * this.WH + this.offMapY;
                        id = this.mapfData[i][j];
                        if (id != 0) {
                            if (id < 0) {
                                id *= -1;
                            }
                            int px = (id - 1) % cw * this.WH;
                            int py = (id - 1) / cw * this.WH;
                            if (id != 0 && id <= this.mapNum - 1) {
                                g.drawRegion(this.mapTile, px, py, this.cellWidth, this.cellHeight, 0, sx, sy, 0);
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public byte[] getBytes(byte[] a) {
        byte[] b = a;
        boolean bad = false;
        ByteArrayInputStream in = new ByteArrayInputStream(b);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            byte[] magic = new byte[4];
            in.read(magic);
            if (!bad) {
                this.undate(in, out, 0, 1);
                b = out.toByteArray();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return b;
    }

    public int undate(ByteArrayInputStream in, ByteArrayOutputStream out, int bufi, int s) {
        int N = 4096;
        int F = 18;
        int THRESHOLD = 2;
        int state = 0;
        int flags = 0;
        int c = 0;
        int r = 0;
        int k = 0;
        int j = 0;
        int i = 0;
        byte[] text_buf = new byte[N + F - 1];
        int size = 0;
        if (state == 0) {
            r = N - F;
            flags = 0;
        }
        while (true) {
            if (state == 2 && k <= j) {
                c = text_buf[i + k & N - 1];
                text_buf[r++] = (byte)c;
                out.write((byte)c);
                ++bufi;
                r &= N - 1;
                ++k;
                ++size;
                continue;
            }
            if (((flags >>>= 1) & 0x100) == 0) {
                c = in.read();
                if (c == -1) break;
                flags = c | 0xFF00;
            }
            if ((flags & 1) == 1) {
                c = in.read();
                if (c == -1) break;
                text_buf[r++] = (byte)c;
                r &= N - 1;
                out.write((byte)c);
                ++bufi;
                ++size;
                state = 1;
                continue;
            }
            i = in.read();
            if (i == -1 || (j = in.read()) == -1) break;
            i |= (j & 0xF0) << 4;
            j = (j & 0xF) + THRESHOLD;
            k = 0;
            state = 2;
        }
        if (size == 0) {
            return -1;
        }
        return size;
    }
}

