/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.common.bluetooth;

import de.joergjahnke.common.bluetooth.BluetoothEventListener;
import java.io.IOException;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.UUID;

public abstract class BluetoothDevice
implements Runnable {
    public static final String MSG_DISCONNECT = "Disconnect\n";
    protected final String name;
    protected final UUID uuid;
    protected final LocalDevice local;
    protected boolean isRunning = false;
    protected final Vector listeners = new Vector();

    public BluetoothDevice(String serviceName) throws BluetoothStateException {
        this.name = serviceName;
        this.uuid = new UUID((long)Math.abs(serviceName.hashCode()));
        this.local = LocalDevice.getLocalDevice();
    }

    public BluetoothDevice(long uuid, boolean isShortUUID) throws BluetoothStateException {
        this.name = null;
        this.uuid = new UUID(Long.toString(uuid, 16), isShortUUID);
        this.local = LocalDevice.getLocalDevice();
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getName() {
        return this.local.getFriendlyName() == null ? this.local.getBluetoothAddress() : this.local.getFriendlyName();
    }

    public void addBluetoothEventListener(BluetoothEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public Vector getBluetoothEventListeners() {
        return this.listeners;
    }

    public void removeBluetoothEventListener(BluetoothEventListener listener) {
        this.listeners.removeElement(listener);
    }

    protected void notifyErrorOccurred(Throwable t) {
        int to = this.listeners.size();
        for (int i = 0; i < to; ++i) {
            ((BluetoothEventListener)this.listeners.elementAt(i)).errorOccurred(t);
        }
    }

    public void start() {
        new Thread(this).start();
    }

    public void stop() {
        this.isRunning = false;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public static String getRemoteDeviceName(RemoteDevice dev) {
        try {
            return dev.getFriendlyName(false) == null ? dev.getBluetoothAddress() : dev.getFriendlyName(false);
        }
        catch (IOException e) {
            return "unknown";
        }
    }

    public void run() {
        this.isRunning = true;
    }
}

