/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.gameboy.jme;

import de.joergjahnke.common.bluetooth.BluetoothDevice;
import de.joergjahnke.common.bluetooth.BluetoothOBEXClient;
import de.joergjahnke.common.bluetooth.BluetoothOBEXEventListener;
import de.joergjahnke.common.jme.CollectionUtils;
import de.joergjahnke.common.jme.LocalizationSupport;
import de.joergjahnke.common.jme.Menu;
import de.joergjahnke.common.jme.ProgressForm;
import de.joergjahnke.gameboy.jme.MEGameboyMIDlet;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class BtMEGameboyMIDlet
extends MEGameboyMIDlet {
    protected static Image floppyImage = null;
    private final String btMenuText = LocalizationSupport.getMessage("Bluetooth");
    private final String sendFileMenuText = LocalizationSupport.getMessage("SendFile");
    private final String receiveFileMenuText = LocalizationSupport.getMessage("ReceiveFile");
    protected final Menu btMenu;

    public BtMEGameboyMIDlet() {
        if (BtMEGameboyMIDlet.doesSupportBluetooth()) {
            this.btMenu = new Menu(this.btMenuText);
            this.btMenu.addItem(this.sendFileMenuText, this.getMenuIcon("send_sm.png"));
            this.btMenu.addItem(this.receiveFileMenuText, this.getMenuIcon("receive_sm.png"));
            this.btMenu.setSelectCommandText(LocalizationSupport.getMessage("Select"));
            this.btMenu.setBackCommandText(LocalizationSupport.getMessage("Back"));
            this.btMenu.setMenuListener(this);
            this.mainMenu.insertMenu(this.btMenu, this.getMenuIcon("bt_sm.png"), this.mainMenu.getMenuPosition(this.assignKeysMenuText) + 1);
            this.mainMenu.show(Display.getDisplay((MIDlet)this));
            if (null == floppyImage) {
                try {
                    floppyImage = Image.createImage((String)"/res/drawable/floppy.png");
                }
                catch (Exception exception) {}
            }
        } else {
            this.btMenu = null;
        }
    }

    private void showSendFileForm() {
        final Display display = Display.getDisplay((MIDlet)this);
        final List fileList = new List(LocalizationSupport.getMessage("SelectFile"), 3);
        fileList.addCommand(this.okCommand);
        fileList.addCommand(this.backCommand);
        fileList.setSelectCommand(this.okCommand);
        Vector snapshots = this.getSnapshots();
        Vector programNames = new Vector();
        CollectionUtils.addAll(programNames, this.getPrograms().keys());
        for (int i = 0; i < programNames.size(); ++i) {
            String name = programNames.elementAt(i).toString();
            Vector programSnapshots = this.getSnapshots(name, snapshots);
            if (this.getSettings().exists(name)) {
                fileList.append(name + ".sav", floppyImage);
            }
            int to = programSnapshots.size();
            for (int j = 0; j < to; ++j) {
                fileList.append(programSnapshots.elementAt(j).toString(), snapshotImage);
            }
        }
        fileList.setCommandListener(new CommandListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void commandAction(Command c, Displayable d) {
                display.setCurrent((Displayable)BtMEGameboyMIDlet.this.mainMenu);
                if (c == BtMEGameboyMIDlet.this.okCommand) {
                    String name = fileList.getString(fileList.getSelectedIndex());
                    byte[] data = null;
                    if (name.endsWith(".sav")) {
                        data = BtMEGameboyMIDlet.this.getSettings().getString(name, null).getBytes();
                    } else {
                        RecordStore rs = null;
                        try {
                            rs = RecordStore.openRecordStore((String)name, (boolean)false);
                            name = name + ".snapshot";
                            data = rs.getRecord(1);
                        }
                        catch (Throwable t) {
                        }
                        finally {
                            try {
                                rs.closeRecordStore();
                            }
                            catch (Exception e) {}
                        }
                    }
                    if (null != data) {
                        BtMEGameboyMIDlet.this.showSelectDeviceForm(name, data);
                    } else {
                        display.setCurrent(new Alert(LocalizationSupport.getMessage("FileTransferFailed"), LocalizationSupport.getMessage("NoDataToSend"), null, AlertType.WARNING), BtMEGameboyMIDlet.this.previous);
                    }
                }
            }
        });
        this.previous = display.getCurrent();
        display.setCurrent((Displayable)fileList);
    }

    private void showSelectDeviceForm(final String name, final byte[] data) {
        final Display display = Display.getDisplay((MIDlet)this);
        display.setCurrent((Displayable)new Alert(LocalizationSupport.getMessage("SearchingBluetoothDevices"), LocalizationSupport.getMessage("SearchingBluetoothDevicesMsg"), null, AlertType.INFO));
        display.callSerially(new Runnable(){

            public void run() {
                try {
                    final BluetoothOBEXClient sender = new BluetoothOBEXClient();
                    final Hashtable devicesServiceMap = sender.searchOBEXDevices();
                    final Vector devices = new Vector();
                    CollectionUtils.addAll(devices, devicesServiceMap.keys());
                    CollectionUtils.sort(devices);
                    if (!devices.isEmpty()) {
                        final List devicesList = new List(LocalizationSupport.getMessage("SelectDevice"), 3);
                        Enumeration en = devices.elements();
                        while (en.hasMoreElements()) {
                            RemoteDevice device = (RemoteDevice)en.nextElement();
                            devicesList.append(BluetoothDevice.getRemoteDeviceName(device), null);
                        }
                        devicesList.addCommand(BtMEGameboyMIDlet.this.backCommand);
                        devicesList.addCommand(BtMEGameboyMIDlet.this.okCommand);
                        devicesList.setSelectCommand(BtMEGameboyMIDlet.this.okCommand);
                        devicesList.setCommandListener(new CommandListener(){

                            public void commandAction(Command c, Displayable d) {
                                if (c == (this).BtMEGameboyMIDlet.this.okCommand) {
                                    RemoteDevice device = (RemoteDevice)devices.elementAt(devicesList.getSelectedIndex());
                                    BtMEGameboyMIDlet.this.sendFile(sender, device, (ServiceRecord)devicesServiceMap.get(device), name, data);
                                } else {
                                    display.setCurrent((this).BtMEGameboyMIDlet.this.previous);
                                }
                            }
                        });
                        display.setCurrent((Displayable)devicesList);
                    } else {
                        display.setCurrent(new Alert(LocalizationSupport.getMessage("NoBluetoothDevice"), LocalizationSupport.getMessage("NoBluetoothDeviceMsg"), null, AlertType.INFO), BtMEGameboyMIDlet.this.previous);
                    }
                }
                catch (IOException e) {
                    display.setCurrent(new Alert(LocalizationSupport.getMessage("FileTransferFailed"), LocalizationSupport.getMessage("TransferringFileFailed") + e, null, AlertType.WARNING), BtMEGameboyMIDlet.this.previous);
                }
            }
        });
    }

    private void sendFile(final BluetoothOBEXClient sender, RemoteDevice device, ServiceRecord service, final String name, final byte[] data) {
        final Display display = Display.getDisplay((MIDlet)this);
        try {
            sender.connect(device, service);
            sender.addBluetoothEventListener(new BluetoothOBEXEventListener(){
                ProgressForm pForm = null;

                public void transferStarted(String name, long len) {
                    this.pForm = new ProgressForm(LocalizationSupport.getMessage("TransferringData")){

                        public void onCancelled() {
                            sender.disconnect();
                            display.setCurrent((this).BtMEGameboyMIDlet.this.previous);
                        }
                    };
                    this.pForm.insert(0, (Item)new StringItem(LocalizationSupport.getMessage("TransferringData") + ": '" + name + "'", null));
                    this.pForm.setShowCancelCommand(true);
                    display.setCurrent((Displayable)this.pForm);
                }

                public void transferProgressed(long n) {
                    this.pForm.update(sender, new Integer((int)(n * 100L / (long)data.length)));
                }

                public void fileReceived(String name, byte[] data2) {
                }

                public void errorOccurred(Throwable t) {
                    display.setCurrent(new Alert(LocalizationSupport.getMessage("FileTransferFailed"), LocalizationSupport.getMessage("TransferringFileFailed") + t, null, AlertType.WARNING), BtMEGameboyMIDlet.this.previous);
                }
            });
            new Thread(){

                public void run() {
                    try {
                        sender.sendFile(name, data);
                        sender.disconnect();
                        display.setCurrent(new Alert(LocalizationSupport.getMessage("TransferSuccessful"), LocalizationSupport.getMessage("FileWasSentTo") + " '" + name + "'", null, AlertType.INFO), BtMEGameboyMIDlet.this.previous);
                    }
                    catch (IOException e) {
                        display.setCurrent(new Alert(LocalizationSupport.getMessage("FileTransferFailed"), LocalizationSupport.getMessage("TransferringFileFailed") + e, null, AlertType.WARNING), BtMEGameboyMIDlet.this.previous);
                    }
                }
            }.start();
        }
        catch (IOException e) {
            display.setCurrent(new Alert(LocalizationSupport.getMessage("FileTransferFailed"), LocalizationSupport.getMessage("TransferringFileFailed") + e, null, AlertType.WARNING), this.previous);
        }
    }

    private void showReceiveFileForm() {
        final Display display = Display.getDisplay((MIDlet)this);
        this.previous = display.getCurrent();
        try {
            final Form form = new Form(LocalizationSupport.getMessage("Waiting"));
            form.append(LocalizationSupport.getMessage("WaitingForFile"));
            final BluetoothOBEXClient receiver = new BluetoothOBEXClient();
            receiver.addBluetoothEventListener(new BluetoothOBEXEventListener(){
                ProgressForm pForm = null;
                long len = -1L;

                public void transferStarted(String name, long len) {
                    StringItem sItem = new StringItem(LocalizationSupport.getMessage("TransferringData") + ": '" + name + "'", null);
                    this.pForm = new ProgressForm(LocalizationSupport.getMessage("TransferringData")){

                        public void onCancelled() {
                            receiver.abortFileReception();
                            display.setCurrent((this).BtMEGameboyMIDlet.this.previous);
                        }
                    };
                    this.pForm.insert(0, (Item)sItem);
                    this.pForm.setShowCancelCommand(true);
                    if (len > 0L) {
                        this.len = len;
                        display.setCurrent((Displayable)this.pForm);
                    } else {
                        form.setTitle(LocalizationSupport.getMessage("TransferringData"));
                        form.set(0, (Item)sItem);
                    }
                }

                public void transferProgressed(long n) {
                    if (this.len > 0L) {
                        this.pForm.update(receiver, new Integer((int)(n * 100L / this.len)));
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void fileReceived(String name, byte[] data) {
                    RecordStore rs = null;
                    try {
                        String prgName;
                        if (this.len > 0L && (long)data.length < this.len) {
                            throw new RuntimeException("Transfer was aborted.");
                        }
                        String string = prgName = name.endsWith(".sav") ? name.substring(0, name.length() - ".sav".length()) : name.substring(0, name.indexOf(64));
                        if (BtMEGameboyMIDlet.this.getPrograms().containsKey(prgName)) {
                            if (name.endsWith(".sav")) {
                                BtMEGameboyMIDlet.this.getSettings().setString(name, new String(data));
                            } else {
                                String rsName = name.substring(0, name.length() - ".snapshot".length());
                                rs = RecordStore.openRecordStore((String)rsName, (boolean)true);
                                rs.addRecord(data, 0, data.length);
                                Vector snapshots = BtMEGameboyMIDlet.this.getSnapshots();
                                snapshots.addElement(rsName);
                                BtMEGameboyMIDlet.this.setSnapshots(snapshots);
                            }
                            display.setCurrent(new Alert(LocalizationSupport.getMessage("TransferSuccessful"), LocalizationSupport.getMessage("ReceivedFile") + " '" + name + "', " + data.length + LocalizationSupport.getMessage("Bytes"), null, AlertType.INFO), BtMEGameboyMIDlet.this.previous);
                        } else {
                            display.setCurrent(new Alert(LocalizationSupport.getMessage("FileTransferFailed"), LocalizationSupport.getMessage("CannotAssign") + " '" + name + "'!", null, AlertType.WARNING), BtMEGameboyMIDlet.this.previous);
                        }
                    }
                    catch (Throwable t) {
                        this.errorOccurred(t);
                    }
                    finally {
                        try {
                            rs.closeRecordStore();
                        }
                        catch (Exception e) {}
                    }
                    receiver.abortFileReception();
                }

                public void errorOccurred(Throwable t) {
                    display.setCurrent(new Alert(LocalizationSupport.getMessage("FileTransferFailed"), LocalizationSupport.getMessage("TransferringFileFailed") + t, null, AlertType.WARNING), BtMEGameboyMIDlet.this.previous);
                }
            });
            form.addCommand(this.cancelCommand);
            form.setCommandListener(new CommandListener(){

                public void commandAction(Command c, Displayable d) {
                    if (c == BtMEGameboyMIDlet.this.cancelCommand) {
                        receiver.abortFileReception();
                        display.setCurrent(BtMEGameboyMIDlet.this.previous);
                    }
                }
            });
            display.setCurrent((Displayable)form);
            receiver.waitForFile();
        }
        catch (IOException e) {
            display.setCurrent((Displayable)new Alert(LocalizationSupport.getMessage("FileTransferFailed"), LocalizationSupport.getMessage("TransferringFileFailed") + e, null, AlertType.WARNING));
        }
    }

    public static boolean doesSupportBluetooth() {
        return System.getProperty("bluetooth.api.version") != null;
    }

    public void main(String[] args) {
        new BtMEGameboyMIDlet();
    }

    public void menuAction(String item) {
        if (item.equals(this.btMenuText)) {
            this.btMenu.show(Display.getDisplay((MIDlet)this));
        } else if (item.equals(this.sendFileMenuText)) {
            this.showSendFileForm();
        } else if (item.equals(this.receiveFileMenuText)) {
            this.showReceiveFileForm();
        } else {
            super.menuAction(item);
        }
    }
}

