/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.common.util;

import de.joergjahnke.common.util.Observable;
import de.joergjahnke.common.util.Observer;
import java.util.Vector;

public class DefaultObservable
implements Observable {
    private final Vector observers = new Vector();
    private boolean hasChanged = false;
    private final Object observed;

    public DefaultObservable() {
        this.observed = this;
    }

    public DefaultObservable(Object observed) {
        this.observed = observed;
    }

    public void addObserver(Observer o) {
        if (!this.observers.contains(o)) {
            this.observers.addElement(o);
        }
    }

    public void deleteObserver(Observer o) {
        this.observers.removeElement(o);
    }

    public void notifyObservers() {
        this.notifyObservers(null);
    }

    public void notifyObservers(Object arg) {
        if (this.hasChanged()) {
            int to = this.observers.size();
            for (int i = 0; i < to; ++i) {
                ((Observer)this.observers.elementAt(i)).update(this.observed, arg);
            }
            this.setChanged(false);
        }
    }

    public void deleteObservers() {
        this.observers.removeAllElements();
    }

    public void setChanged(boolean state) {
        this.hasChanged = state;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public int countObservers() {
        return this.observers.size();
    }
}

