/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.gameboy.core;

import de.joergjahnke.common.emulation.FrequencyDataProducer;
import de.joergjahnke.common.emulation.FrequencyDataProducerOwner;
import de.joergjahnke.common.emulation.WaveDataProducer;
import de.joergjahnke.common.io.Serializable;
import de.joergjahnke.common.io.SerializationUtils;
import de.joergjahnke.common.util.DefaultObservable;
import de.joergjahnke.common.util.Observer;
import de.joergjahnke.gameboy.core.Gameboy;
import de.joergjahnke.gameboy.core.SoundChannel;
import de.joergjahnke.gameboy.core.SquareWaveChannel;
import de.joergjahnke.gameboy.core.VoluntaryWaveChannel;
import de.joergjahnke.gameboy.core.WhiteNoiseChannel;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SoundChip
extends DefaultObservable
implements WaveDataProducer,
Serializable,
Observer,
FrequencyDataProducerOwner {
    public static final int UPDATES_PER_SECOND = 128;
    private final SoundChannel[] soundChannels = new SoundChannel[4];
    private final Gameboy gameboy;
    private final int sampleRate;
    private long nextUpdate;
    private long updateCycles = 32768L;
    private final byte[] buffer;

    public SoundChip(Gameboy gameboy) {
        this.gameboy = gameboy;
        this.sampleRate = gameboy.getSoundSampleRate();
        this.soundChannels[0] = new SquareWaveChannel(this);
        this.soundChannels[1] = new SquareWaveChannel(this);
        this.soundChannels[2] = new VoluntaryWaveChannel(this);
        this.soundChannels[3] = new WhiteNoiseChannel(this);
        int samples = this.getSampleRate() / 128;
        this.buffer = new byte[samples * 2];
    }

    public final SoundChannel[] getSoundChannels() {
        return this.soundChannels;
    }

    public final long getNextUpdate() {
        return this.nextUpdate;
    }

    public void update(long cycles) {
        byte[] buffer_ = this.buffer;
        int to = buffer_.length;
        for (int i = 0; i < to; ++i) {
            buffer_[i] = 0;
        }
        SoundChannel[] soundChannels_ = this.soundChannels;
        int to2 = soundChannels_.length;
        for (int c = 0; c < to2; ++c) {
            SoundChannel soundChannel = soundChannels_[c];
            if (!soundChannel.isActive()) continue;
            soundChannel.update();
            soundChannel.mix(buffer_);
        }
        this.nextUpdate = cycles + this.updateCycles;
        this.setChanged(true);
        this.notifyObservers(buffer_);
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getBitsPerSample() {
        return 8;
    }

    public int getChannels() {
        return 2;
    }

    public void serialize(DataOutputStream out) throws IOException {
        out.writeInt(this.sampleRate);
        SerializationUtils.serialize(out, this.soundChannels);
        out.writeLong(this.nextUpdate);
    }

    public void deserialize(DataInputStream in) throws IOException {
        if (this.sampleRate != in.readInt()) {
            throw new IllegalStateException("Sample rate of the emulator does not match the saved sample rate!");
        }
        SerializationUtils.deserialize(in, this.soundChannels);
        this.nextUpdate = in.readLong();
    }

    public void update(Object observed, Object arg) {
        if (observed == this.gameboy.getCPU() && arg instanceof Long) {
            long newSpeed = (Long)arg;
            this.updateCycles = newSpeed / 128L;
        }
    }

    public int getFrequencyDataProducerCount() {
        return this.soundChannels.length;
    }

    public FrequencyDataProducer getFrequencyDataProducers(int n) {
        return this.soundChannels[n];
    }
}

