/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.gameboy.jme;

import de.joergjahnke.common.jme.ButtonAssignmentCanvas;
import de.joergjahnke.common.jme.CollectionUtils;
import de.joergjahnke.common.jme.FileBrowser;
import de.joergjahnke.common.jme.FileSystemHandler;
import de.joergjahnke.common.jme.FormattedTextForm;
import de.joergjahnke.common.jme.ImageUtils;
import de.joergjahnke.common.jme.LocalizationSupport;
import de.joergjahnke.common.jme.Menu;
import de.joergjahnke.common.jme.MenuListener;
import de.joergjahnke.common.jme.OrientationSensitiveCanvasHelper;
import de.joergjahnke.common.jme.PCMtoMIDIPlayer;
import de.joergjahnke.common.jme.ProgressForm;
import de.joergjahnke.common.jme.Settings;
import de.joergjahnke.common.jme.WavePlayer;
import de.joergjahnke.gameboy.core.Cartridge;
import de.joergjahnke.gameboy.core.Gameboy;
import de.joergjahnke.gameboy.jme.GameboyCanvas;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Spacer;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class MEGameboyMIDlet
extends MIDlet
implements CommandListener,
MenuListener {
    public static final String SETTING_SCALING = "Scaling";
    public static final String SETTING_FRAMESKIP = "FrameSkip";
    public static final String SETTING_SOUNDACTIVE = "SoundActive";
    public static final String SETTING_SAMPLERATE = "SampleRate";
    public static final String SETTING_FILESEARCH_STARTDIR = "FileSearchStartDir";
    public static final String SETTING_ACCELEROMETER = "Accelerometer";
    public static final String SETTING_AUTO_ROTATE = "AutoRotateScreen";
    public static final String SETTING_LANGUAGE = "Language";
    public static final String SETTING_SHOW_BUTTONS = "ShowButtons";
    public static final String SETTING_SHOW_DPAD = "ShowDPad";
    public static final String SETTING_SNAPSHOTS = "Snapshots";
    public static final String SETTING_PREFIX_KEYS = "Key_";
    private static final String SUSPENDDATA_SUFFIX = "_SuspendData";
    private static final String ROMDATA_SUFFIX = "_ROMs";
    protected static final String SAVE_EXTENSION = ".sav";
    protected static final String SNAPSHOT_EXTENSION = ".snapshot";
    private static final char SNAPSHOT_NAME_DELIMITER = '\n';
    private static final int DEFAULT_FRAME_SKIP = 5;
    private static final String[] JOYPAD_KEYS = new String[]{"Up", "Left", "Right", "Down", "A", "B", "Select", "Start"};
    private static final String[] SUPPORTED_LOCALES = new String[]{"Device default", "de", "en", "es", "ja", "nl-NL", "pt_BR", "ru", "sv", "zh_CN"};
    private static final String PROJECT_PAGE_URL = "https://sourceforge.net/projects/javagb/";
    private static final int STATUS_LOAD_OK = 0;
    private static final int STATUS_LOAD_FAILED = 1;
    private static final int STATUS_NOTHING_LOADED = 2;
    private static final int SNAPSHOT_PROGRAMNAME_LENGTH = 18;
    private static Image cartridgeImage = null;
    protected static Image snapshotImage = null;
    private GameboyCanvas gbCanvas = null;
    private Gameboy gameboy = null;
    private FileSystemHandler fsHandler;
    private String fileSearchStartDir;
    private final Hashtable programs = new Hashtable();
    private Settings settings = null;
    private String currentImage = null;
    protected Displayable previous = null;
    protected final Command okCommand;
    protected final Command backCommand;
    private final Command pauseCommand;
    private final Command resumeCommand;
    private final String playMenuText;
    private final String searchProgramsMenuText;
    private final Command suspendCommand;
    private final Command quitPlayCommand;
    private final String editSettingsMenuText;
    protected final String assignKeysMenuText;
    private final Command showLogCommand;
    private final String aboutMenuText;
    private final String helpMenuText;
    private final String exitMenuText;
    private final Command browseCommand;
    private final Command snapshotCommand;
    private final Command removeCommand;
    private final Command menuCommand;
    private final Command closeCommand;
    protected final Command cancelCommand;
    protected final Menu mainMenu;

    public MEGameboyMIDlet() {
        try {
            this.settings = new Settings(this.getAppProperty("MIDlet-Name"));
        }
        catch (Exception e) {
            // empty catch block
        }
        String locale = this.getLocale();
        LocalizationSupport.initLocalizationSupport(locale, "/res/l10n/commonMessages.properties");
        LocalizationSupport.initLocalizationSupport(locale, "/res/l10n/gameboyEmulatorMessages.properties");
        this.okCommand = new Command(LocalizationSupport.getMessage("OK"), 4, 1);
        this.backCommand = new Command(LocalizationSupport.getMessage("Back"), 2, 99);
        this.pauseCommand = new Command(LocalizationSupport.getMessage("Pause"), 8, 2);
        this.resumeCommand = new Command(LocalizationSupport.getMessage("Resume"), 8, 3);
        this.closeCommand = new Command(LocalizationSupport.getMessage("Close"), 2, 98);
        this.cancelCommand = new Command(LocalizationSupport.getMessage("Cancel"), 2, 98);
        this.suspendCommand = new Command(LocalizationSupport.getMessage("Suspend"), LocalizationSupport.getMessage("SuspendAndExit"), 7, 98);
        this.quitPlayCommand = new Command(LocalizationSupport.getMessage("Quit"), LocalizationSupport.getMessage("QuitCurrentGame"), 7, 99);
        this.browseCommand = new Command(LocalizationSupport.getMessage("Browse"), 8, 2);
        this.snapshotCommand = new Command(LocalizationSupport.getMessage("SaveSnapshot"), 8, 4);
        this.removeCommand = new Command(LocalizationSupport.getMessage("Remove"), 8, 2);
        this.menuCommand = new Command(LocalizationSupport.getMessage("Menu"), 8, 1);
        this.showLogCommand = new Command(LocalizationSupport.getMessage("ShowLog"), 8, 96);
        this.playMenuText = LocalizationSupport.getMessage("PlayGame");
        this.searchProgramsMenuText = LocalizationSupport.getMessage("SearchPrograms");
        this.editSettingsMenuText = LocalizationSupport.getMessage("EditSettings");
        this.assignKeysMenuText = LocalizationSupport.getMessage("AssignKeys");
        this.aboutMenuText = LocalizationSupport.getMessage("About");
        this.helpMenuText = LocalizationSupport.getMessage("Help");
        this.exitMenuText = LocalizationSupport.getMessage("Exit");
        this.mainMenu = new Menu(this.getAppProperty("MIDlet-Name"));
        this.mainMenu.addItem(this.playMenuText, this.getMenuIcon("play_sm.png"));
        if (this.supportsFileConnectionAPI()) {
            this.mainMenu.addItem(this.searchProgramsMenuText, this.getMenuIcon("search_sm.png"));
        }
        this.mainMenu.addItem(this.editSettingsMenuText, this.getMenuIcon("settings_sm.png"));
        this.mainMenu.addItem(this.assignKeysMenuText, this.getMenuIcon("keyboard_sm.png"));
        this.mainMenu.addItem(this.aboutMenuText, this.getMenuIcon("about_sm.png"));
        this.mainMenu.addItem(this.helpMenuText, this.getMenuIcon("help_sm.png"));
        this.mainMenu.addItem(this.showLogCommand.getLabel(), this.getMenuIcon("log_sm.png"));
        this.mainMenu.addItem(this.exitMenuText, this.getMenuIcon("exit_sm.png"));
        this.mainMenu.setMenuListener(this);
        this.mainMenu.setSelectCommandText(LocalizationSupport.getMessage("Select"));
        this.mainMenu.setBackCommandText(null);
        this.mainMenu.show(Display.getDisplay((MIDlet)this));
        try {
            this.gameboy = new Gameboy();
            this.gbCanvas = new GameboyCanvas(this);
            this.gbCanvas.setGameboy(this.gameboy);
            this.gbCanvas.addCommand(this.pauseCommand);
            this.gbCanvas.addCommand(this.showLogCommand);
            this.gbCanvas.addCommand(this.quitPlayCommand);
            this.gbCanvas.addCommand(this.suspendCommand);
            this.gbCanvas.addCommand(this.snapshotCommand);
            this.gbCanvas.setCommandListener(this);
            this.gbCanvas.calculateScreenSize();
            this.gameboy.getVideoChip().addObserver(this.gbCanvas);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(LocalizationSupport.getMessage("CouldNotInitialize") + t);
        }
        try {
            this.gameboy.getVideoChip().setFrameSkip(this.settings.getInteger(SETTING_FRAMESKIP, 5));
            this.gbCanvas.setShowButtons(this.settings.getBoolean(SETTING_SHOW_BUTTONS, this.gbCanvas.isShowButtons()));
            this.gbCanvas.setShowDirectionButtons(this.settings.getBoolean(SETTING_SHOW_DPAD, this.gbCanvas.isShowDirectionButtons()));
            this.gbCanvas.setAutoChangeOrientation(this.settings.getBoolean(SETTING_AUTO_ROTATE, this.gbCanvas.isAutoChangeOrientation()));
            this.gbCanvas.setUseAccelerometer(this.settings.getBoolean(SETTING_ACCELEROMETER, this.gbCanvas.isUseAccelerometer()));
            if (this.settings.exists(SETTING_PREFIX_KEYS + JOYPAD_KEYS[0])) {
                Hashtable<Integer, String> assignments = new Hashtable<Integer, String>();
                for (int i = 0; i < JOYPAD_KEYS.length; ++i) {
                    assignments.put(new Integer(this.settings.getInteger(SETTING_PREFIX_KEYS + JOYPAD_KEYS[i])), JOYPAD_KEYS[i]);
                }
                this.gbCanvas.setButtonAssignments(assignments);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.programs.clear();
        try {
            CollectionUtils.putAll(this.programs, this.readProgramListFromTextFile());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Vector<String> extensions = new Vector<String>();
            CollectionUtils.addAll(extensions, Cartridge.SUPPORTED_EXTENSIONS.elements());
            extensions.addElement(SNAPSHOT_EXTENSION.substring(1));
            this.fsHandler = new FileSystemHandler(this.gameboy.getLogger(), extensions, this.settings);
            CollectionUtils.putAll(this.programs, this.fsHandler.getCachedProgramList());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (null == cartridgeImage) {
            try {
                cartridgeImage = Image.createImage((String)"/res/drawable/cartridge.png");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (null == snapshotImage) {
            try {
                snapshotImage = Image.createImage((String)"/res/drawable/snapshot.png");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.resume();
    }

    public Settings getSettings() {
        return this.settings;
    }

    private String getLocale() {
        String locale = System.getProperty("microedition.locale");
        try {
            locale = this.settings.getString(SETTING_LANGUAGE, locale);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return locale;
    }

    protected Image getMenuIcon(String filename) {
        try {
            return ImageUtils.scale(Image.createImage((String)("/res/drawable/" + filename)), 16, 16, true);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void startApp() {
        this.gameboy.resume();
    }

    public void pauseApp() {
        this.gameboy.pause();
        this.notifySoundPlayer(PCMtoMIDIPlayer.SIGNAL_PAUSE);
    }

    public void destroyApp(boolean unconditional) {
        this.quitPlay();
    }

    private void notifySoundPlayer(Object signal) {
        if (null != this.gameboy.getSoundChip() && this.gameboy.getSoundChip().countObservers() > 0) {
            this.gameboy.getSoundChip().setChanged(true);
            this.gameboy.getSoundChip().notifyObservers(signal);
        }
    }

    protected Vector getSnapshots() {
        Vector<String> result = new Vector<String>();
        String snapshots = this.getSettings().getString(SETTING_SNAPSHOTS, null);
        if (null != snapshots) {
            int index = 0;
            while (index < snapshots.length()) {
                int newIndex = snapshots.indexOf(10, index);
                result.addElement(snapshots.substring(index, newIndex));
                index = newIndex + 1;
            }
        }
        return result;
    }

    protected Vector getSnapshots(String program, Vector snapshotList) {
        int to;
        Vector<String> result = new Vector<String>();
        String search = program.substring(0, Math.min(program.length(), 18));
        int n = to = snapshotList == null ? 0 : snapshotList.size();
        for (int i = 0; i < to; ++i) {
            String name = snapshotList.elementAt(i).toString();
            if (!name.startsWith(search)) continue;
            result.addElement(name);
        }
        return result;
    }

    protected void setSnapshots(Vector snapshotList) throws RecordStoreException {
        if (null != snapshotList) {
            StringBuffer snapshots = new StringBuffer();
            int to = snapshotList.size();
            for (int i = 0; i < to; ++i) {
                snapshots.append(snapshotList.elementAt(i));
                snapshots.append('\n');
            }
            this.getSettings().setString(SETTING_SNAPSHOTS, snapshots.toString());
        } else {
            this.getSettings().remove(SETTING_SNAPSHOTS);
        }
    }

    private void saveState(String name) throws IOException, RecordStoreException {
        RecordStore rs = RecordStore.openRecordStore((String)name, (boolean)true);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(os);
        out.writeUTF(this.currentImage);
        this.gameboy.serialize(out);
        out.flush();
        rs.addRecord(os.toByteArray(), 0, os.size());
        out.close();
        os.close();
        rs.closeRecordStore();
    }

    private void saveSnapshot() {
        this.gameboy.pause();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        String name = this.currentImage.substring(0, Math.min(this.currentImage.length(), 18)) + "@" + this.formatForSnapshot(cal.get(1)) + this.formatForSnapshot(cal.get(2) + 1) + this.formatForSnapshot(cal.get(5)) + "-" + this.formatForSnapshot(cal.get(11)) + this.formatForSnapshot(cal.get(12)) + this.formatForSnapshot(cal.get(13));
        try {
            this.saveState(name);
            Vector snapshots = this.getSnapshots();
            snapshots.addElement(name);
            this.setSnapshots(snapshots);
        }
        catch (Throwable t) {
            try {
                RecordStore.deleteRecordStore((String)name);
            }
            catch (Throwable t2) {
                // empty catch block
            }
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)new Alert(LocalizationSupport.getMessage("SavingSnapshotFailed"), LocalizationSupport.getMessage("FailedToStoreState"), null, AlertType.WARNING));
            t.printStackTrace();
        }
        this.gameboy.resume();
    }

    private String formatForSnapshot(int n) {
        String s = "0" + n;
        return s.substring(s.length() - 2);
    }

    private void suspend() {
        this.gameboy.pause();
        boolean reallyExit = true;
        try {
            this.saveState(this.getAppProperty("MIDlet-Name") + SUSPENDDATA_SUFFIX);
        }
        catch (Throwable t) {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)new Alert(LocalizationSupport.getMessage("SuspendFailed"), LocalizationSupport.getMessage("FailedToStoreState"), null, AlertType.WARNING));
            t.printStackTrace();
            reallyExit = false;
            this.gameboy.resume();
        }
        if (reallyExit) {
            this.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int loadState(String name) {
        int status = 0;
        Display display = Display.getDisplay((MIDlet)this);
        ProgressForm progressForm = new ProgressForm(LocalizationSupport.getMessage("Resuming"));
        this.gameboy.getCartridge().deleteObservers();
        this.gameboy.getCartridge().addObserver(progressForm);
        boolean hasSuspendData = false;
        RecordStore rs = null;
        try {
            DataInputStream in = null;
            byte[] bytes = null;
            if (this.programs.get(name) == null) {
                rs = RecordStore.openRecordStore((String)name, (boolean)false);
                bytes = rs.getRecord(1);
                in = new DataInputStream(new ByteArrayInputStream(bytes));
                bytes = null;
            } else {
                String image = this.programs.get(name).toString();
                in = new DataInputStream(image.indexOf("://") > 0 ? Connector.openInputStream((String)image) : this.getClass().getResourceAsStream(image));
            }
            hasSuspendData = true;
            display.setCurrent((Displayable)progressForm);
            String program = in.readUTF();
            this.loadGame(program);
            this.gameboy.deserialize(in);
            in.close();
        }
        catch (Throwable t) {
            if (hasSuspendData) {
                status = 1;
                t.printStackTrace();
            } else {
                status = 2;
            }
        }
        finally {
            if (hasSuspendData) {
                try {
                    rs.closeRecordStore();
                }
                catch (Exception e) {}
            }
            display.setCurrent((Displayable)this.mainMenu);
        }
        return status;
    }

    private void runSnapshot(final String name) {
        final Display display = Display.getDisplay((MIDlet)this);
        Thread loader = new Thread(){

            public void run() {
                switch (MEGameboyMIDlet.this.loadState(name)) {
                    case 1: {
                        display.setCurrent(new Alert(LocalizationSupport.getMessage("LoadSnapshotFailed"), LocalizationSupport.getMessage("FailedToRestoreState"), null, AlertType.WARNING), (Displayable)MEGameboyMIDlet.this.gbCanvas);
                        break;
                    }
                    case 0: {
                        MEGameboyMIDlet.this.startGame();
                    }
                }
            }
        };
        loader.start();
    }

    private void resume() {
        final Display display = Display.getDisplay((MIDlet)this);
        final String name = this.getAppProperty("MIDlet-Name") + SUSPENDDATA_SUFFIX;
        Thread loader = new Thread(){

            public void run() {
                int status = MEGameboyMIDlet.this.loadState(name);
                if (status == 1 || status == 0) {
                    try {
                        RecordStore.deleteRecordStore((String)name);
                    }
                    catch (Exception e) {
                        display.setCurrent((Displayable)new Alert(LocalizationSupport.getMessage("CouldNotRemoveSuspendData"), LocalizationSupport.getMessage("FailedToRemoveSuspendData"), null, AlertType.WARNING));
                        e.printStackTrace();
                    }
                }
                switch (status) {
                    case 1: {
                        display.setCurrent(new Alert(LocalizationSupport.getMessage("ResumeFailed"), LocalizationSupport.getMessage("FailedToRestoreState"), null, AlertType.WARNING), (Displayable)MEGameboyMIDlet.this.gbCanvas);
                        break;
                    }
                    case 0: {
                        MEGameboyMIDlet.this.startGame();
                        break;
                    }
                }
            }
        };
        loader.start();
    }

    private synchronized void loadGame(String program) throws IOException {
        if (program.indexOf(47) >= 0) {
            program = program.substring(program.lastIndexOf(47) + 1);
        }
        if (program.indexOf(92) >= 0) {
            program = program.substring(program.lastIndexOf(92) + 1);
        }
        if (program.equals(this.currentImage)) {
            return;
        }
        String image = this.programs.get(program).toString();
        InputStream romStream = image.indexOf("://") > 0 ? Connector.openInputStream((String)image) : this.getClass().getResourceAsStream(image);
        this.gameboy.load(romStream);
        romStream.close();
        String save = this.getSettings().getString(program, null);
        if (save != null) {
            ByteArrayInputStream saveStream = new ByteArrayInputStream(save.getBytes());
            this.gameboy.getCartridge().loadData(saveStream);
            ((InputStream)saveStream).close();
        }
        this.setSound(this.getSettings().getBoolean(SETTING_SOUNDACTIVE, false));
        this.currentImage = program;
    }

    private void runGame(final String name) {
        final Display display = Display.getDisplay((MIDlet)this);
        ProgressForm progressForm = new ProgressForm(LocalizationSupport.getMessage("Loading"));
        this.gameboy.getCartridge().deleteObservers();
        this.gameboy.getCartridge().addObserver(progressForm);
        display.setCurrent((Displayable)progressForm);
        Thread loader = new Thread(){

            public void run() {
                try {
                    MEGameboyMIDlet.this.loadGame(name);
                    MEGameboyMIDlet.this.gameboy.getCPU().powerUp();
                    MEGameboyMIDlet.this.startGame();
                }
                catch (Throwable t) {
                    MEGameboyMIDlet.this.gameboy.stop();
                    display.setCurrent(new Alert(LocalizationSupport.getMessage("FailedToLoadImage"), LocalizationSupport.getMessage("FailedToLoadImage2") + name, null, AlertType.WARNING), MEGameboyMIDlet.this.previous);
                    t.printStackTrace();
                }
            }
        };
        loader.start();
    }

    private void exit() {
        this.gameboy.stop();
        this.destroyApp(false);
        this.notifyDestroyed();
    }

    private void quitPlay() {
        this.gameboy.stop();
        this.notifySoundPlayer(PCMtoMIDIPlayer.SIGNAL_STOP);
        if (null != this.gameboy.getCartridge() && this.gameboy.getCartridge().hasBatterySupport()) {
            try {
                ByteArrayOutputStream saveStream = new ByteArrayOutputStream();
                this.gameboy.getCartridge().saveData(saveStream);
                this.settings.setString(this.currentImage, saveStream.toString());
            }
            catch (Exception e) {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)new Alert(LocalizationSupport.getMessage("FailedToSaveGame"), LocalizationSupport.getMessage("FailedToSaveGameDataFor") + this.currentImage, null, AlertType.WARNING));
            }
        }
        this.currentImage = null;
    }

    private void showAssignButtonsCanvas() {
        Display display = Display.getDisplay((MIDlet)this);
        final Vector<String> buttons = new Vector<String>();
        for (int i = 0; i < JOYPAD_KEYS.length; ++i) {
            buttons.addElement(JOYPAD_KEYS[i]);
        }
        ButtonAssignmentCanvas buttonAssignmentCanvas = new ButtonAssignmentCanvas(display, buttons){

            public void onFinished() {
                super.onFinished();
                if (this.getState() == 4) {
                    MEGameboyMIDlet.this.gbCanvas.setButtonAssignments(this.getAssignments());
                    try {
                        for (int i = 0; i < buttons.size(); ++i) {
                            try {
                                MEGameboyMIDlet.this.settings.remove(MEGameboyMIDlet.SETTING_PREFIX_KEYS + buttons.elementAt(i).toString());
                                continue;
                            }
                            catch (IllegalArgumentException e) {
                                // empty catch block
                            }
                        }
                        Enumeration en = this.getAssignments().keys();
                        while (en.hasMoreElements()) {
                            Integer key = (Integer)en.nextElement();
                            MEGameboyMIDlet.this.settings.setInteger(MEGameboyMIDlet.SETTING_PREFIX_KEYS + this.getAssignments().get(key).toString(), key);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        display.setCurrent((Displayable)buttonAssignmentCanvas);
    }

    protected Hashtable getPrograms() {
        if (this.programs.isEmpty()) {
            this.fsHandler.readProgramListFromFileSystem(this.fileSearchStartDir, this.programs, Display.getDisplay((MIDlet)this));
        }
        return this.programs;
    }

    private void showSelectGameForm() {
        final Display display = Display.getDisplay((MIDlet)this);
        final List imageList = new List(LocalizationSupport.getMessage("SelectCartridge"), 3);
        imageList.addCommand(this.okCommand);
        imageList.addCommand(this.removeCommand);
        imageList.addCommand(this.cancelCommand);
        imageList.setSelectCommand(this.okCommand);
        Vector programNames = new Vector();
        CollectionUtils.addAll(programNames, this.getPrograms().keys());
        CollectionUtils.sort(programNames);
        Vector snapshots = this.getSnapshots();
        for (int i = 0; i < programNames.size(); ++i) {
            String name;
            imageList.append(name, (name = programNames.elementAt(i).toString()).endsWith(SNAPSHOT_EXTENSION) ? snapshotImage : cartridgeImage);
            Vector programSnapshots = this.getSnapshots(name, snapshots);
            int to = programSnapshots.size();
            for (int j = 0; j < to; ++j) {
                imageList.append(programSnapshots.elementAt(j).toString(), snapshotImage);
            }
        }
        imageList.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                display.setCurrent((Displayable)MEGameboyMIDlet.this.mainMenu);
                String name = imageList.getString(imageList.getSelectedIndex());
                if (c == MEGameboyMIDlet.this.okCommand) {
                    if (MEGameboyMIDlet.this.programs.containsKey(name) && !name.endsWith(MEGameboyMIDlet.SNAPSHOT_EXTENSION)) {
                        MEGameboyMIDlet.this.runGame(name);
                    } else {
                        MEGameboyMIDlet.this.runSnapshot(name);
                    }
                } else if (c == MEGameboyMIDlet.this.removeCommand) {
                    if (MEGameboyMIDlet.this.programs.containsKey(name)) {
                        display.setCurrent(new Alert(LocalizationSupport.getMessage("NotASnapshot"), LocalizationSupport.getMessage("OnlySnapshotsCanBeRemoved"), null, AlertType.INFO), MEGameboyMIDlet.this.previous);
                    } else {
                        try {
                            RecordStore.deleteRecordStore((String)name);
                            Vector snapshots = MEGameboyMIDlet.this.getSnapshots();
                            snapshots.removeElement(name);
                            MEGameboyMIDlet.this.setSnapshots(snapshots);
                            display.setCurrent(new Alert(LocalizationSupport.getMessage("RemovedSnapshotData"), LocalizationSupport.getMessage("RemovedSnapshotDataFor") + " " + name, null, AlertType.INFO), MEGameboyMIDlet.this.previous);
                        }
                        catch (Exception e) {
                            display.setCurrent(new Alert(LocalizationSupport.getMessage("CouldNotRemoveSnapshotData"), LocalizationSupport.getMessage("FailedToRemoveSnapshotDataFor") + " " + name, null, AlertType.WARNING), MEGameboyMIDlet.this.previous);
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
        this.previous = display.getCurrent();
        display.setCurrent((Displayable)imageList);
    }

    private void startGame() {
        if (!this.gameboy.isRunning()) {
            new Thread(this.gameboy).start();
            this.gameboy.getJoypad().deleteObserver(this.gbCanvas);
            this.gameboy.getJoypad().addObserver(this.gbCanvas);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.gbCanvas);
        }
    }

    private void showAboutForm() {
        Form about = new Form(LocalizationSupport.getMessage("About"));
        StringItem projectUrl = new StringItem(null, PROJECT_PAGE_URL, 1);
        projectUrl.addCommand(this.browseCommand);
        projectUrl.setItemCommandListener(new ItemCommandListener(){

            public void commandAction(Command c, Item item) {
                try {
                    MEGameboyMIDlet.this.platformRequest(((StringItem)item).getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        String text = LocalizationSupport.getMessage("AboutText1") + this.getAppProperty("MIDlet-Version") + LocalizationSupport.getMessage("AboutText2") + LocalizationSupport.getMessage("AboutText3");
        String pageStr = "#PROJECTPAGE#";
        int index1 = text.indexOf("#PROJECTPAGE#");
        about.append(text.substring(0, index1));
        about.append((Item)projectUrl);
        about.append(text.substring(index1 + "#PROJECTPAGE#".length(), text.length()));
        about.addCommand(this.closeCommand);
        about.setCommandListener((CommandListener)this);
        Display display = Display.getDisplay((MIDlet)this);
        this.previous = display.getCurrent();
        display.setCurrent((Displayable)about);
    }

    private void showHelpForm() {
        InputStream helpContent = LocalizationSupport.loadLocalizedFile("/docs/help.txt", this.getLocale());
        try {
            FormattedTextForm helpForm = new FormattedTextForm(this, LocalizationSupport.getMessage("Help"), helpContent);
            helpForm.addCommand(this.closeCommand);
            helpForm.setCommandListener(this);
            Display display = Display.getDisplay((MIDlet)this);
            this.previous = display.getCurrent();
            display.setCurrent((Displayable)helpForm);
        }
        catch (Exception e) {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)new Alert(LocalizationSupport.getMessage("FailedToLoadHelp"), LocalizationSupport.getMessage("FailedToLoadHelpFile"), null, AlertType.WARNING));
            e.printStackTrace();
        }
    }

    private void showLogForm() {
        Form log = new Form(LocalizationSupport.getMessage("LogMessages"));
        StringItem logItem = new StringItem("", this.gameboy.getLogger().dumpAll());
        logItem.setFont(Font.getFont((int)0, (int)0, (int)8));
        log.append((Item)logItem);
        log.addCommand(this.closeCommand);
        log.setCommandListener((CommandListener)this);
        Display display = Display.getDisplay((MIDlet)this);
        this.previous = display.getCurrent();
        display.setCurrent((Displayable)log);
    }

    private void showSelectDirectoryForm() {
        final Display display = Display.getDisplay((MIDlet)this);
        String defaultDir = this.settings.getString(SETTING_FILESEARCH_STARTDIR, "");
        Vector<String> filters = new Vector<String>();
        filters.addElement("/");
        FileBrowser fileBrowser = new FileBrowser(display, defaultDir, filters){

            public void onSelect() {
                super.onSelect();
                MEGameboyMIDlet.this.fileSearchStartDir = this.getSelectedFile();
                try {
                    MEGameboyMIDlet.this.settings.setString(MEGameboyMIDlet.SETTING_FILESEARCH_STARTDIR, MEGameboyMIDlet.this.fileSearchStartDir);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                MEGameboyMIDlet.this.fsHandler.readProgramListFromFileSystem(MEGameboyMIDlet.this.fileSearchStartDir, MEGameboyMIDlet.this.programs, display);
                display.setCurrent((Displayable)MEGameboyMIDlet.this.mainMenu);
            }

            public void onError(Throwable t) {
                super.onError(t);
                try {
                    MEGameboyMIDlet.this.settings.remove(MEGameboyMIDlet.SETTING_FILESEARCH_STARTDIR);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        fileBrowser.show();
    }

    private void showSettingsForm() {
        final Display display = Display.getDisplay((MIDlet)this);
        Form settingsForm = new Form(LocalizationSupport.getMessage("EmulatorSettings"));
        String[] sound = new String[]{LocalizationSupport.getMessage("On"), LocalizationSupport.getMessage("Off")};
        final ChoiceGroup soundChoice = new ChoiceGroup(LocalizationSupport.getMessage("Sound"), 1, sound, null);
        soundChoice.setSelectedIndex(this.settings.getBoolean(SETTING_SOUNDACTIVE, false) ? 0 : 1, true);
        settingsForm.append((Item)soundChoice);
        settingsForm.append((Item)new Spacer(0, 2));
        String[] scalingOptions = new String[]{LocalizationSupport.getMessage("FullScreen"), LocalizationSupport.getMessage("NoScaling")};
        final ChoiceGroup scalingChoice = new ChoiceGroup(LocalizationSupport.getMessage("VideoScaling"), 1, scalingOptions, null);
        scalingChoice.setSelectedIndex(this.settings.getBoolean(SETTING_SCALING, true) ? 0 : 1, true);
        settingsForm.append((Item)scalingChoice);
        settingsForm.append((Item)new Spacer(0, 2));
        String[] frameSkipOptions = new String[]{"1", "2", "3", "4", "5"};
        final ChoiceGroup frameSkipChoice = new ChoiceGroup(LocalizationSupport.getMessage("ShowEveryNthFrame"), 1, frameSkipOptions, null);
        frameSkipChoice.setSelectedIndex(this.gameboy.getVideoChip().getFrameSkip() - 1, true);
        settingsForm.append((Item)frameSkipChoice);
        String[] showButtonsOptions = new String[]{LocalizationSupport.getMessage("On"), LocalizationSupport.getMessage("Off")};
        final ChoiceGroup showButtonsChoice = new ChoiceGroup(LocalizationSupport.getMessage(SETTING_SHOW_BUTTONS), 1, showButtonsOptions, null);
        String[] showDPadOptions = new String[]{LocalizationSupport.getMessage("On"), LocalizationSupport.getMessage("Off")};
        final ChoiceGroup showDPadChoice = new ChoiceGroup(LocalizationSupport.getMessage(SETTING_SHOW_DPAD), 1, showDPadOptions, null);
        if (this.gbCanvas.hasPointerEvents()) {
            showButtonsChoice.setSelectedIndex(this.settings.getBoolean(SETTING_SHOW_BUTTONS, true) ? 0 : 1, true);
            settingsForm.append((Item)showButtonsChoice);
            showDPadChoice.setSelectedIndex(this.settings.getBoolean(SETTING_SHOW_DPAD, true) ? 0 : 1, true);
            settingsForm.append((Item)showDPadChoice);
            settingsForm.append((Item)new Spacer(0, 2));
        }
        final ChoiceGroup languageChoice = new ChoiceGroup(LocalizationSupport.getMessage(SETTING_LANGUAGE), 1, SUPPORTED_LOCALES, null);
        final String activeLanguage = this.settings.getString(SETTING_LANGUAGE, SUPPORTED_LOCALES[0]);
        int activeLanguageIndex = 0;
        for (int i = 0; i < SUPPORTED_LOCALES.length; ++i) {
            if (!activeLanguage.equals(SUPPORTED_LOCALES[i])) continue;
            activeLanguageIndex = i;
            break;
        }
        languageChoice.setSelectedIndex(activeLanguageIndex, true);
        settingsForm.append((Item)new Spacer(0, 2));
        settingsForm.append((Item)languageChoice);
        String[] accelerometerOptions = new String[]{LocalizationSupport.getMessage("ForJoystickEmulation"), LocalizationSupport.getMessage(SETTING_AUTO_ROTATE)};
        final ChoiceGroup accelerometerChoice = new ChoiceGroup(LocalizationSupport.getMessage("UseAccelerometer"), 2, accelerometerOptions, null);
        boolean isUseAccelerometer = this.gbCanvas.isUseAccelerometer();
        boolean isRotateScreen = this.gbCanvas.isAutoChangeOrientation();
        accelerometerChoice.setSelectedIndex(0, isUseAccelerometer);
        accelerometerChoice.setSelectedIndex(1, isRotateScreen);
        try {
            if (OrientationSensitiveCanvasHelper.supportsAccelerometer()) {
                settingsForm.append((Item)new Spacer(0, 2));
                settingsForm.append((Item)accelerometerChoice);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        settingsForm.addCommand(this.okCommand);
        settingsForm.addCommand(this.cancelCommand);
        settingsForm.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                boolean isRestartRequired = false;
                if (c == MEGameboyMIDlet.this.okCommand) {
                    MEGameboyMIDlet.this.gameboy.getVideoChip().setFrameSkip(frameSkipChoice.getSelectedIndex() + 1);
                    MEGameboyMIDlet.this.gbCanvas.setShowButtons(showButtonsChoice.getSelectedIndex() == 0);
                    MEGameboyMIDlet.this.gbCanvas.setShowDirectionButtons(showDPadChoice.getSelectedIndex() == 0);
                    MEGameboyMIDlet.this.gbCanvas.calculateScreenSize();
                    MEGameboyMIDlet.this.gbCanvas.setUseAccelerometer(accelerometerChoice.isSelected(0));
                    MEGameboyMIDlet.this.gbCanvas.setAutoChangeOrientation(accelerometerChoice.isSelected(1));
                    try {
                        MEGameboyMIDlet.this.settings.setBoolean(MEGameboyMIDlet.SETTING_SOUNDACTIVE, soundChoice.getSelectedIndex() == 0);
                        MEGameboyMIDlet.this.settings.setInteger(MEGameboyMIDlet.SETTING_SAMPLERATE, MEGameboyMIDlet.this.gameboy.getSoundSampleRate());
                        MEGameboyMIDlet.this.settings.setInteger(MEGameboyMIDlet.SETTING_FRAMESKIP, MEGameboyMIDlet.this.gameboy.getVideoChip().getFrameSkip());
                        isRestartRequired |= (MEGameboyMIDlet.this.settings.getBoolean(MEGameboyMIDlet.SETTING_SCALING, true) ? 0 : 1) != scalingChoice.getSelectedIndex();
                        MEGameboyMIDlet.this.settings.setBoolean(MEGameboyMIDlet.SETTING_SCALING, scalingChoice.getSelectedIndex() == 0);
                        MEGameboyMIDlet.this.settings.setBoolean(MEGameboyMIDlet.SETTING_ACCELEROMETER, MEGameboyMIDlet.this.gbCanvas.isUseAccelerometer());
                        MEGameboyMIDlet.this.settings.setBoolean(MEGameboyMIDlet.SETTING_AUTO_ROTATE, MEGameboyMIDlet.this.gbCanvas.isAutoChangeOrientation());
                        MEGameboyMIDlet.this.settings.setBoolean(MEGameboyMIDlet.SETTING_SHOW_BUTTONS, showButtonsChoice.getSelectedIndex() == 0);
                        MEGameboyMIDlet.this.settings.setBoolean(MEGameboyMIDlet.SETTING_SHOW_DPAD, showDPadChoice.getSelectedIndex() == 0);
                        String newLanguage = SUPPORTED_LOCALES[languageChoice.getSelectedIndex()];
                        isRestartRequired |= !activeLanguage.equals(newLanguage);
                        if (languageChoice.getSelectedIndex() == 0 && MEGameboyMIDlet.this.settings.exists(MEGameboyMIDlet.SETTING_LANGUAGE)) {
                            MEGameboyMIDlet.this.settings.remove(MEGameboyMIDlet.SETTING_LANGUAGE);
                        } else {
                            MEGameboyMIDlet.this.settings.setString(MEGameboyMIDlet.SETTING_LANGUAGE, newLanguage);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                display.setCurrent((Displayable)MEGameboyMIDlet.this.mainMenu);
                if (isRestartRequired) {
                    display.callSerially(new Runnable(){

                        public void run() {
                            display.setCurrent((Displayable)new Alert(LocalizationSupport.getMessage("RestartRequired"), LocalizationSupport.getMessage("SomeSettingsRequireRestart"), null, AlertType.INFO));
                        }
                    });
                }
            }
        });
        this.previous = display.getCurrent();
        display.setCurrent((Displayable)settingsForm);
    }

    protected void setSound(boolean active) {
        if (active) {
            if (this.gameboy.getSoundChip().countObservers() == 0) {
                try {
                    this.gameboy.getSoundChip().addObserver(new PCMtoMIDIPlayer(this.gameboy.getSoundChip()));
                }
                catch (Throwable t) {
                    try {
                        this.gameboy.getSoundChip().addObserver(new WavePlayer(this.gameboy.getSoundChip()));
                    }
                    catch (Throwable t2) {
                        this.gameboy.getLogger().warning(LocalizationSupport.getMessage("CouldNotCreateSoundPlayer"));
                        t2.printStackTrace();
                    }
                }
            }
        } else if (this.gameboy.getSoundChip().countObservers() > 0) {
            this.notifySoundPlayer(PCMtoMIDIPlayer.SIGNAL_STOP);
            this.gameboy.getSoundChip().deleteObservers();
        }
        try {
            this.settings.setBoolean(SETTING_SOUNDACTIVE, active);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Hashtable readProgramListFromTextFile() throws IOException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        InputStream is = this.getClass().getResourceAsStream("/programs/programs.txt");
        int c = 0;
        while (c >= 0) {
            StringBuffer line = new StringBuffer();
            while ((c = is.read()) > 0 && c != 10 && c != 13) {
                line.append((char)c);
            }
            if (line.toString().startsWith("#") || line.length() <= 0) continue;
            result.put(line.toString(), "/programs/" + line.toString());
        }
        return result;
    }

    public final boolean supportsFileConnectionAPI() {
        return null != System.getProperty("microedition.io.file.FileConnection.version");
    }

    public void commandAction(Command c, Displayable s) {
        if (c == this.okCommand || c == this.backCommand || c == this.closeCommand || c == this.cancelCommand) {
            Display.getDisplay((MIDlet)this).setCurrent(this.previous);
            this.previous = null;
        } else if (c == this.menuCommand) {
            this.mainMenu.show(Display.getDisplay((MIDlet)this));
        } else if (c == this.pauseCommand) {
            this.gameboy.pause();
            this.notifySoundPlayer(PCMtoMIDIPlayer.SIGNAL_PAUSE);
            this.gbCanvas.addCommand(this.resumeCommand);
            this.gbCanvas.removeCommand(this.pauseCommand);
        } else if (c == this.resumeCommand) {
            this.gameboy.resume();
            this.gbCanvas.addCommand(this.pauseCommand);
            this.gbCanvas.removeCommand(this.resumeCommand);
        } else if (c == this.quitPlayCommand) {
            this.quitPlay();
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.mainMenu);
        } else if (c == this.suspendCommand) {
            this.suspend();
        } else if (c == this.snapshotCommand) {
            this.saveSnapshot();
        } else if (c == this.showLogCommand) {
            this.showLogForm();
        }
    }

    public void menuAction(String item) {
        if (item.equals(this.playMenuText)) {
            this.showSelectGameForm();
        } else if (item.equals(this.aboutMenuText)) {
            this.showAboutForm();
        } else if (item.equals(this.helpMenuText)) {
            this.showHelpForm();
        } else if (item.equals(this.showLogCommand.getLabel())) {
            this.showLogForm();
        } else if (item.equals(this.editSettingsMenuText)) {
            this.showSettingsForm();
        } else if (item.equals(this.searchProgramsMenuText)) {
            CollectionUtils.removeAll(this.programs, this.fsHandler.getCachedProgramList());
            this.showSelectDirectoryForm();
        } else if (item.equals(this.exitMenuText)) {
            this.exit();
        } else if (item.equals(this.assignKeysMenuText)) {
            this.showAssignButtonsCanvas();
        }
    }

    public void menuClosed(Menu menu) {
    }
}

