/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.core;

import de.joergjahnke.c64.core.CPU6502Instruction;
import de.joergjahnke.c64.core.EmulatedDevice;
import de.joergjahnke.c64.core.IOChip;
import de.joergjahnke.common.emulation.RunnableDevice;
import de.joergjahnke.common.emulation.ThrottleableCPU;
import de.joergjahnke.common.io.Serializable;
import de.joergjahnke.common.util.Logger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public abstract class CPU6502
extends RunnableDevice
implements ThrottleableCPU,
Serializable {
    private static final boolean DEBUG_INTERRUPTS = false;
    private static final boolean DEBUG_CODE = false;
    public static final int ADC = 0;
    public static final int AND = 1;
    public static final int ASL = 2;
    public static final int BCC = 3;
    public static final int BCS = 4;
    public static final int BEQ = 5;
    public static final int BIT = 6;
    public static final int BMI = 7;
    public static final int BNE = 8;
    public static final int BPL = 9;
    public static final int BRK = 10;
    public static final int BVC = 11;
    public static final int BVS = 12;
    public static final int CLC = 13;
    public static final int CLD = 14;
    public static final int CLI = 15;
    public static final int CLV = 16;
    public static final int CMP = 17;
    public static final int CPX = 18;
    public static final int CPY = 19;
    public static final int DEC = 20;
    public static final int DEX = 21;
    public static final int DEY = 22;
    public static final int EOR = 23;
    public static final int INC = 24;
    public static final int INX = 25;
    public static final int INY = 26;
    public static final int JMP = 27;
    public static final int JSR = 28;
    public static final int LDA = 29;
    public static final int LDX = 30;
    public static final int LDY = 31;
    public static final int LSR = 32;
    public static final int NOP = 33;
    public static final int ORA = 34;
    public static final int PHA = 35;
    public static final int PHP = 36;
    public static final int PLA = 37;
    public static final int PLP = 38;
    public static final int ROL = 39;
    public static final int ROR = 40;
    public static final int RTI = 41;
    public static final int RTS = 42;
    public static final int SBC = 43;
    public static final int SEC = 44;
    public static final int SED = 45;
    public static final int SEI = 46;
    public static final int STA = 47;
    public static final int STX = 48;
    public static final int STY = 49;
    public static final int TAX = 50;
    public static final int TAY = 51;
    public static final int TSX = 52;
    public static final int TXA = 53;
    public static final int TXS = 54;
    public static final int TYA = 55;
    public static final int ANC = 100;
    public static final int ALR = 101;
    public static final int ARR = 102;
    public static final int ASO = 103;
    public static final int AXA = 104;
    public static final int AXS = 105;
    public static final int DCM = 106;
    public static final int INS = 107;
    public static final int LAS = 108;
    public static final int LAX = 109;
    public static final int LSE = 110;
    public static final int OAL = 111;
    public static final int RLA = 112;
    public static final int RRA = 113;
    public static final int SAY = 114;
    public static final int SAX = 115;
    public static final int SKB = 116;
    public static final int SKW = 117;
    public static final int TAS = 118;
    public static final int XAA = 119;
    public static final int XAS = 120;
    private static final int RESET_VECTOR = 65532;
    protected final EmulatedDevice device;
    protected final byte[] memory;
    protected Logger logger;
    protected boolean isNMILow = false;
    protected boolean lastNMIState = false;
    protected boolean isIRQLow = false;
    protected final Vector irqs = new Vector();
    protected final Vector nmis = new Vector();
    protected boolean isCheckInterrupt = false;
    protected long cycles = 0L;
    protected long throttledMillis = 0L;
    protected int pc;
    protected int currentInstructionAddress;
    protected boolean signFlag = false;
    protected boolean zeroFlag = false;
    protected boolean overflowFlag = false;
    protected boolean carryFlag = false;
    protected boolean decimalFlag = false;
    protected boolean breakFlag = false;
    protected boolean interruptFlag = false;
    protected int ac = 0;
    protected int x = 0;
    protected int y = 0;
    protected int sp = 255;
    protected int ramSize;
    protected CPU6502Instruction[] instructions = new CPU6502Instruction[256];

    public CPU6502(EmulatedDevice device, int memSize) {
        this.device = device;
        this.memory = new byte[memSize];
        this.ramSize = memSize;
        this.initializeInstructions();
    }

    protected void initializeInstructions() {
        this.addInstruction(new CPU6502Instruction("ADC", 109, 0, 3, 4));
        this.addInstruction(new CPU6502Instruction("ADC", 105, 0, 1, 2));
        this.addInstruction(new CPU6502Instruction("ADC", 97, 0, 7, 6));
        this.addInstruction(new CPU6502Instruction("ADC", 113, 0, 8, 5, true));
        this.addInstruction(new CPU6502Instruction("ADC", 125, 0, 4, 4, true));
        this.addInstruction(new CPU6502Instruction("ADC", 121, 0, 5, 4, true));
        this.addInstruction(new CPU6502Instruction("ADC", 101, 0, 9, 3));
        this.addInstruction(new CPU6502Instruction("ADC", 117, 0, 10, 4));
        this.addInstruction(new CPU6502Instruction("AND", 45, 1, 3, 4));
        this.addInstruction(new CPU6502Instruction("AND", 41, 1, 1, 2));
        this.addInstruction(new CPU6502Instruction("AND", 33, 1, 7, 6));
        this.addInstruction(new CPU6502Instruction("AND", 49, 1, 8, 5, true));
        this.addInstruction(new CPU6502Instruction("AND", 61, 1, 4, 4, true));
        this.addInstruction(new CPU6502Instruction("AND", 57, 1, 5, 4, true));
        this.addInstruction(new CPU6502Instruction("AND", 37, 1, 9, 3));
        this.addInstruction(new CPU6502Instruction("AND", 53, 1, 10, 4));
        this.addInstruction(new CPU6502Instruction("ASL", 14, 2, 3, 6));
        this.addInstruction(new CPU6502Instruction("ASL", 10, 2, 2, 2));
        this.addInstruction(new CPU6502Instruction("ASL", 30, 2, 4, 7));
        this.addInstruction(new CPU6502Instruction("ASL", 6, 2, 9, 5));
        this.addInstruction(new CPU6502Instruction("ASL", 22, 2, 10, 6));
        this.addInstruction(new CPU6502Instruction("BCC", 144, 3, 12, 2));
        this.addInstruction(new CPU6502Instruction("BCS", 176, 4, 12, 2));
        this.addInstruction(new CPU6502Instruction("BEQ", 240, 5, 12, 2));
        this.addInstruction(new CPU6502Instruction("BIT", 44, 6, 3, 4));
        this.addInstruction(new CPU6502Instruction("BIT", 36, 6, 9, 3));
        this.addInstruction(new CPU6502Instruction("BMI", 48, 7, 12, 2));
        this.addInstruction(new CPU6502Instruction("BNE", 208, 8, 12, 2));
        this.addInstruction(new CPU6502Instruction("BPL", 16, 9, 12, 2));
        this.addInstruction(new CPU6502Instruction("BRK", 0, 10, 0, 7));
        this.addInstruction(new CPU6502Instruction("BVC", 80, 11, 12, 2));
        this.addInstruction(new CPU6502Instruction("BVS", 112, 12, 12, 2));
        this.addInstruction(new CPU6502Instruction("CLC", 24, 13, 0, 2));
        this.addInstruction(new CPU6502Instruction("CLD", 216, 14, 0, 2));
        this.addInstruction(new CPU6502Instruction("CLI", 88, 15, 0, 2));
        this.addInstruction(new CPU6502Instruction("CLV", 184, 16, 0, 2));
        this.addInstruction(new CPU6502Instruction("CMP", 205, 17, 3, 4));
        this.addInstruction(new CPU6502Instruction("CMP", 201, 17, 1, 2));
        this.addInstruction(new CPU6502Instruction("CMP", 193, 17, 7, 6));
        this.addInstruction(new CPU6502Instruction("CMP", 209, 17, 8, 5, true));
        this.addInstruction(new CPU6502Instruction("CMP", 221, 17, 4, 4, true));
        this.addInstruction(new CPU6502Instruction("CMP", 217, 17, 5, 4, true));
        this.addInstruction(new CPU6502Instruction("CMP", 197, 17, 9, 3));
        this.addInstruction(new CPU6502Instruction("CMP", 213, 17, 10, 4));
        this.addInstruction(new CPU6502Instruction("CPX", 236, 18, 3, 4));
        this.addInstruction(new CPU6502Instruction("CPX", 224, 18, 1, 2));
        this.addInstruction(new CPU6502Instruction("CPX", 228, 18, 9, 3));
        this.addInstruction(new CPU6502Instruction("CPY", 204, 19, 3, 4));
        this.addInstruction(new CPU6502Instruction("CPY", 192, 19, 1, 2));
        this.addInstruction(new CPU6502Instruction("CPY", 196, 19, 9, 3));
        this.addInstruction(new CPU6502Instruction("DEC", 206, 20, 3, 6));
        this.addInstruction(new CPU6502Instruction("DEC", 222, 20, 4, 7));
        this.addInstruction(new CPU6502Instruction("DEC", 198, 20, 9, 5));
        this.addInstruction(new CPU6502Instruction("DEC", 214, 20, 10, 6));
        this.addInstruction(new CPU6502Instruction("DEX", 202, 21, 0, 2));
        this.addInstruction(new CPU6502Instruction("DEY", 136, 22, 0, 2));
        this.addInstruction(new CPU6502Instruction("EOR", 77, 23, 3, 4));
        this.addInstruction(new CPU6502Instruction("EOR", 73, 23, 1, 2));
        this.addInstruction(new CPU6502Instruction("EOR", 65, 23, 7, 6));
        this.addInstruction(new CPU6502Instruction("EOR", 81, 23, 8, 5, true));
        this.addInstruction(new CPU6502Instruction("EOR", 93, 23, 4, 4, true));
        this.addInstruction(new CPU6502Instruction("EOR", 89, 23, 5, 4, true));
        this.addInstruction(new CPU6502Instruction("EOR", 69, 23, 9, 3));
        this.addInstruction(new CPU6502Instruction("EOR", 85, 23, 10, 4));
        this.addInstruction(new CPU6502Instruction("INC", 238, 24, 3, 6));
        this.addInstruction(new CPU6502Instruction("INC", 254, 24, 4, 7));
        this.addInstruction(new CPU6502Instruction("INC", 230, 24, 9, 5));
        this.addInstruction(new CPU6502Instruction("INC", 246, 24, 10, 6));
        this.addInstruction(new CPU6502Instruction("INX", 232, 25, 0, 2));
        this.addInstruction(new CPU6502Instruction("INY", 200, 26, 0, 2));
        this.addInstruction(new CPU6502Instruction("JMP", 76, 27, 3, 3));
        this.addInstruction(new CPU6502Instruction("JMP", 108, 27, 6, 5));
        this.addInstruction(new CPU6502Instruction("JSR", 32, 28, 3, 6));
        this.addInstruction(new CPU6502Instruction("LDA", 173, 29, 3, 4));
        this.addInstruction(new CPU6502Instruction("LDA", 169, 29, 1, 2));
        this.addInstruction(new CPU6502Instruction("LDA", 161, 29, 7, 6));
        this.addInstruction(new CPU6502Instruction("LDA", 177, 29, 8, 5, true));
        this.addInstruction(new CPU6502Instruction("LDA", 189, 29, 4, 4, true));
        this.addInstruction(new CPU6502Instruction("LDA", 185, 29, 5, 4, true));
        this.addInstruction(new CPU6502Instruction("LDA", 165, 29, 9, 3));
        this.addInstruction(new CPU6502Instruction("LDA", 181, 29, 10, 4));
        this.addInstruction(new CPU6502Instruction("LDX", 174, 30, 3, 4));
        this.addInstruction(new CPU6502Instruction("LDX", 162, 30, 1, 2));
        this.addInstruction(new CPU6502Instruction("LDX", 190, 30, 5, 4, true));
        this.addInstruction(new CPU6502Instruction("LDX", 166, 30, 9, 3));
        this.addInstruction(new CPU6502Instruction("LDX", 182, 30, 11, 4));
        this.addInstruction(new CPU6502Instruction("LDY", 172, 31, 3, 4));
        this.addInstruction(new CPU6502Instruction("LDY", 160, 31, 1, 2));
        this.addInstruction(new CPU6502Instruction("LDY", 188, 31, 4, 4, true));
        this.addInstruction(new CPU6502Instruction("LDY", 164, 31, 9, 3));
        this.addInstruction(new CPU6502Instruction("LDY", 180, 31, 10, 4));
        this.addInstruction(new CPU6502Instruction("LSR", 78, 32, 3, 6));
        this.addInstruction(new CPU6502Instruction("LSR", 74, 32, 2, 2));
        this.addInstruction(new CPU6502Instruction("LSR", 94, 32, 4, 7));
        this.addInstruction(new CPU6502Instruction("LSR", 70, 32, 9, 5));
        this.addInstruction(new CPU6502Instruction("LSR", 86, 32, 10, 6));
        this.addInstruction(new CPU6502Instruction("NOP", 234, 33, 0, 2));
        this.addInstruction(new CPU6502Instruction("ORA", 13, 34, 3, 4));
        this.addInstruction(new CPU6502Instruction("ORA", 9, 34, 1, 2));
        this.addInstruction(new CPU6502Instruction("ORA", 1, 34, 7, 6));
        this.addInstruction(new CPU6502Instruction("ORA", 17, 34, 8, 5, true));
        this.addInstruction(new CPU6502Instruction("ORA", 29, 34, 4, 4, true));
        this.addInstruction(new CPU6502Instruction("ORA", 25, 34, 5, 4, true));
        this.addInstruction(new CPU6502Instruction("ORA", 5, 34, 9, 3));
        this.addInstruction(new CPU6502Instruction("ORA", 21, 34, 10, 4));
        this.addInstruction(new CPU6502Instruction("PHA", 72, 35, 0, 3));
        this.addInstruction(new CPU6502Instruction("PHP", 8, 36, 0, 3));
        this.addInstruction(new CPU6502Instruction("PLA", 104, 37, 0, 4));
        this.addInstruction(new CPU6502Instruction("PLP", 40, 38, 0, 4));
        this.addInstruction(new CPU6502Instruction("ROL", 46, 39, 3, 6));
        this.addInstruction(new CPU6502Instruction("ROL", 42, 39, 2, 2));
        this.addInstruction(new CPU6502Instruction("ROL", 62, 39, 4, 7));
        this.addInstruction(new CPU6502Instruction("ROL", 38, 39, 9, 5));
        this.addInstruction(new CPU6502Instruction("ROL", 54, 39, 10, 6));
        this.addInstruction(new CPU6502Instruction("ROR", 110, 40, 3, 6));
        this.addInstruction(new CPU6502Instruction("ROR", 106, 40, 2, 2));
        this.addInstruction(new CPU6502Instruction("ROR", 126, 40, 4, 7));
        this.addInstruction(new CPU6502Instruction("ROR", 102, 40, 9, 5));
        this.addInstruction(new CPU6502Instruction("ROR", 118, 40, 10, 6));
        this.addInstruction(new CPU6502Instruction("RTI", 64, 41, 0, 6));
        this.addInstruction(new CPU6502Instruction("RTS", 96, 42, 0, 6));
        this.addInstruction(new CPU6502Instruction("SBC", 237, 43, 3, 4));
        this.addInstruction(new CPU6502Instruction("SBC", 233, 43, 1, 2));
        this.addInstruction(new CPU6502Instruction("SBC", 225, 43, 7, 6));
        this.addInstruction(new CPU6502Instruction("SBC", 241, 43, 8, 5, true));
        this.addInstruction(new CPU6502Instruction("SBC", 253, 43, 4, 4, true));
        this.addInstruction(new CPU6502Instruction("SBC", 249, 43, 5, 4, true));
        this.addInstruction(new CPU6502Instruction("SBC", 229, 43, 9, 3));
        this.addInstruction(new CPU6502Instruction("SBC", 245, 43, 10, 4));
        this.addInstruction(new CPU6502Instruction("SEC", 56, 44, 0, 2));
        this.addInstruction(new CPU6502Instruction("SED", 248, 45, 0, 2));
        this.addInstruction(new CPU6502Instruction("SEI", 120, 46, 0, 2));
        this.addInstruction(new CPU6502Instruction("STA", 141, 47, 3, 4));
        this.addInstruction(new CPU6502Instruction("STA", 129, 47, 7, 6));
        this.addInstruction(new CPU6502Instruction("STA", 145, 47, 8, 6));
        this.addInstruction(new CPU6502Instruction("STA", 157, 47, 4, 5));
        this.addInstruction(new CPU6502Instruction("STA", 153, 47, 5, 5));
        this.addInstruction(new CPU6502Instruction("STA", 133, 47, 9, 3));
        this.addInstruction(new CPU6502Instruction("STA", 149, 47, 10, 4));
        this.addInstruction(new CPU6502Instruction("STX", 142, 48, 3, 4));
        this.addInstruction(new CPU6502Instruction("STX", 134, 48, 9, 3));
        this.addInstruction(new CPU6502Instruction("STX", 150, 48, 11, 4));
        this.addInstruction(new CPU6502Instruction("STY", 140, 49, 3, 4));
        this.addInstruction(new CPU6502Instruction("STY", 132, 49, 9, 3));
        this.addInstruction(new CPU6502Instruction("STY", 148, 49, 10, 4));
        this.addInstruction(new CPU6502Instruction("TAX", 170, 50, 0, 2));
        this.addInstruction(new CPU6502Instruction("TAY", 168, 51, 0, 2));
        this.addInstruction(new CPU6502Instruction("TSX", 186, 52, 0, 2));
        this.addInstruction(new CPU6502Instruction("TXA", 138, 53, 0, 2));
        this.addInstruction(new CPU6502Instruction("TXS", 154, 54, 0, 2));
        this.addInstruction(new CPU6502Instruction("TYA", 152, 55, 0, 2));
        this.addInstruction(new CPU6502Instruction("ALR", 75, 101, 1, 2));
        this.addInstruction(new CPU6502Instruction("ANC", 11, 100, 1, 2));
        this.addInstruction(new CPU6502Instruction(this.instructions[11], 43));
        this.addInstruction(new CPU6502Instruction("ARR", 107, 102, 1, 2));
        this.addInstruction(new CPU6502Instruction("ASO", 15, 103, 3, 6));
        this.addInstruction(new CPU6502Instruction("ASO", 3, 103, 7, 8));
        this.addInstruction(new CPU6502Instruction("ASO", 19, 103, 8, 8));
        this.addInstruction(new CPU6502Instruction("ASO", 31, 103, 4, 7));
        this.addInstruction(new CPU6502Instruction("ASO", 27, 103, 5, 7));
        this.addInstruction(new CPU6502Instruction("ASO", 7, 103, 9, 5));
        this.addInstruction(new CPU6502Instruction("ASO", 23, 103, 10, 6));
        this.addInstruction(new CPU6502Instruction("AXS", 143, 105, 3, 4));
        this.addInstruction(new CPU6502Instruction("AXS", 131, 105, 7, 6));
        this.addInstruction(new CPU6502Instruction("AXS", 135, 105, 9, 3));
        this.addInstruction(new CPU6502Instruction("AXS", 151, 105, 11, 4));
        this.addInstruction(new CPU6502Instruction("DCM", 207, 106, 3, 6));
        this.addInstruction(new CPU6502Instruction("DCM", 195, 106, 7, 8));
        this.addInstruction(new CPU6502Instruction("DCM", 211, 106, 8, 8));
        this.addInstruction(new CPU6502Instruction("DCM", 223, 106, 4, 7));
        this.addInstruction(new CPU6502Instruction("DCM", 219, 106, 5, 7));
        this.addInstruction(new CPU6502Instruction("DCM", 199, 106, 9, 5));
        this.addInstruction(new CPU6502Instruction("DCM", 215, 106, 10, 6));
        this.addInstruction(new CPU6502Instruction("INS", 239, 107, 3, 6));
        this.addInstruction(new CPU6502Instruction("INS", 227, 107, 7, 8));
        this.addInstruction(new CPU6502Instruction("INS", 243, 107, 8, 8));
        this.addInstruction(new CPU6502Instruction("INS", 255, 107, 4, 7));
        this.addInstruction(new CPU6502Instruction("INS", 251, 107, 5, 7));
        this.addInstruction(new CPU6502Instruction("INS", 231, 107, 9, 5));
        this.addInstruction(new CPU6502Instruction("INS", 247, 107, 10, 6));
        this.addInstruction(new CPU6502Instruction("LAS", 187, 108, 5, 4, true));
        this.addInstruction(new CPU6502Instruction("LAX", 175, 109, 3, 4));
        this.addInstruction(new CPU6502Instruction("LAX", 163, 109, 7, 6));
        this.addInstruction(new CPU6502Instruction("LAX", 179, 109, 8, 5, true));
        this.addInstruction(new CPU6502Instruction("LAX", 191, 109, 5, 4));
        this.addInstruction(new CPU6502Instruction("LAX", 167, 109, 9, 3));
        this.addInstruction(new CPU6502Instruction("LAX", 183, 109, 11, 4));
        this.addInstruction(new CPU6502Instruction("LSE", 79, 110, 3, 6));
        this.addInstruction(new CPU6502Instruction("LSE", 67, 110, 7, 8));
        this.addInstruction(new CPU6502Instruction("LSE", 83, 110, 8, 8));
        this.addInstruction(new CPU6502Instruction("LSE", 95, 110, 4, 7));
        this.addInstruction(new CPU6502Instruction("LSE", 91, 110, 5, 7));
        this.addInstruction(new CPU6502Instruction("LSE", 71, 110, 9, 5));
        this.addInstruction(new CPU6502Instruction("LSE", 87, 110, 10, 6));
        this.addInstruction(new CPU6502Instruction(this.instructions[234], 26));
        this.addInstruction(new CPU6502Instruction(this.instructions[234], 58));
        this.addInstruction(new CPU6502Instruction(this.instructions[234], 90));
        this.addInstruction(new CPU6502Instruction(this.instructions[234], 122));
        this.addInstruction(new CPU6502Instruction(this.instructions[234], 218));
        this.addInstruction(new CPU6502Instruction(this.instructions[234], 250));
        this.addInstruction(new CPU6502Instruction("OAL", 171, 111, 1, 2));
        this.addInstruction(new CPU6502Instruction("RLA", 47, 112, 3, 6));
        this.addInstruction(new CPU6502Instruction("RLA", 35, 112, 7, 8));
        this.addInstruction(new CPU6502Instruction("RLA", 51, 112, 8, 8));
        this.addInstruction(new CPU6502Instruction("RLA", 63, 112, 4, 7));
        this.addInstruction(new CPU6502Instruction("RLA", 59, 112, 5, 7));
        this.addInstruction(new CPU6502Instruction("RLA", 39, 112, 9, 5));
        this.addInstruction(new CPU6502Instruction("RLA", 55, 112, 10, 6));
        this.addInstruction(new CPU6502Instruction("RRA", 111, 113, 3, 6));
        this.addInstruction(new CPU6502Instruction("RRA", 99, 113, 7, 8));
        this.addInstruction(new CPU6502Instruction("RRA", 115, 113, 8, 8));
        this.addInstruction(new CPU6502Instruction("RRA", 127, 113, 4, 7));
        this.addInstruction(new CPU6502Instruction("RRA", 123, 113, 5, 7));
        this.addInstruction(new CPU6502Instruction("RRA", 103, 113, 9, 5));
        this.addInstruction(new CPU6502Instruction("RRA", 119, 113, 10, 6));
        this.addInstruction(new CPU6502Instruction("SAX", 203, 115, 1, 2));
        this.addInstruction(new CPU6502Instruction("SAY", 156, 114, 4, 5));
        this.addInstruction(new CPU6502Instruction(this.instructions[233], 235));
        this.addInstruction(new CPU6502Instruction("AXA", 147, 104, 8, 6));
        this.addInstruction(new CPU6502Instruction("AXA", 159, 104, 5, 5));
        this.addInstruction(new CPU6502Instruction("SKB", 128, 116, 1, 3));
        this.addInstruction(new CPU6502Instruction(this.instructions[128], 130));
        this.addInstruction(new CPU6502Instruction(this.instructions[128], 194));
        this.addInstruction(new CPU6502Instruction(this.instructions[128], 226));
        this.addInstruction(new CPU6502Instruction(this.instructions[128], 4));
        this.addInstruction(new CPU6502Instruction(this.instructions[128], 20));
        this.addInstruction(new CPU6502Instruction(this.instructions[128], 52));
        this.addInstruction(new CPU6502Instruction(this.instructions[128], 68));
        this.addInstruction(new CPU6502Instruction(this.instructions[128], 84));
        this.addInstruction(new CPU6502Instruction(this.instructions[128], 100));
        this.addInstruction(new CPU6502Instruction(this.instructions[128], 116));
        this.addInstruction(new CPU6502Instruction(this.instructions[128], 212));
        this.addInstruction(new CPU6502Instruction(this.instructions[128], 244));
        this.addInstruction(new CPU6502Instruction("SKB", 137, 116, 1, 2));
        this.addInstruction(new CPU6502Instruction("SKW", 12, 117, 3, 4));
        this.addInstruction(new CPU6502Instruction("SKW", 28, 117, 7, 4, true));
        this.addInstruction(new CPU6502Instruction(this.instructions[28], 60));
        this.addInstruction(new CPU6502Instruction(this.instructions[28], 92));
        this.addInstruction(new CPU6502Instruction(this.instructions[28], 124));
        this.addInstruction(new CPU6502Instruction(this.instructions[28], 220));
        this.addInstruction(new CPU6502Instruction(this.instructions[28], 252));
        this.addInstruction(new CPU6502Instruction("TAS", 155, 118, 5, 5));
        this.addInstruction(new CPU6502Instruction("XAA", 139, 119, 1, 2));
        this.addInstruction(new CPU6502Instruction("XAS", 158, 120, 5, 5));
    }

    protected void addInstruction(CPU6502Instruction instruction) {
        if (this.instructions[instruction.opCode] != null) {
            throw new RuntimeException("Instruction " + instruction.opCode + " already defined!");
        }
        this.instructions[instruction.opCode] = instruction;
    }

    public CPU6502Instruction getInstruction(int opCode) {
        return this.instructions[opCode];
    }

    public final Logger getLogger() {
        return this.logger;
    }

    public final void setLogger(Logger logger) {
        this.logger = logger;
    }

    public final byte[] getMemory() {
        return this.memory;
    }

    public final long getCycles() {
        return this.cycles;
    }

    public final void addCycles(int cycles) {
        this.cycles += (long)cycles;
    }

    public void setCycles(long cycles) {
        this.cycles = cycles;
    }

    private boolean setSignal(Vector signal, IOChip ioChip, boolean state) {
        boolean notify = false;
        if (state) {
            if (!signal.contains(ioChip)) {
                signal.addElement(ioChip);
                notify = true;
            }
        } else if (signal.contains(ioChip)) {
            signal.removeElement(ioChip);
            notify = true;
        }
        return notify;
    }

    public final void setIRQ(IOChip ioChip, boolean state) {
        if (this.setSignal(this.irqs, ioChip, state)) {
            boolean setIRQ;
            boolean bl = setIRQ = !this.irqs.isEmpty();
            if (!this.isIRQLow && setIRQ) {
                this.isCheckInterrupt = true;
            }
            this.isIRQLow = setIRQ;
        }
    }

    public final void setNMI(IOChip ioChip, boolean state) {
        if (this.setSignal(this.nmis, ioChip, state)) {
            boolean setNMI;
            boolean bl = setNMI = !this.irqs.isEmpty();
            if (!this.isNMILow && setNMI) {
                this.isCheckInterrupt = true;
            }
            this.isNMILow = setNMI;
        }
    }

    protected int getPC() {
        return this.pc;
    }

    protected void setPC(int value) {
        this.pc = value;
    }

    protected void addPC(int size) {
        this.pc += size;
    }

    protected final int getStatusByte() {
        return (this.carryFlag ? 1 : 0) + (this.zeroFlag ? 2 : 0) + (this.interruptFlag ? 4 : 0) + (this.decimalFlag ? 8 : 0) + (this.breakFlag ? 16 : 0) + 32 + (this.overflowFlag ? 64 : 0) + (this.signFlag ? 128 : 0);
    }

    protected final void setStatusByte(int status) {
        this.carryFlag = (status & 1) != 0;
        this.zeroFlag = (status & 2) != 0;
        this.interruptFlag = (status & 4) != 0;
        this.decimalFlag = (status & 8) != 0;
        this.breakFlag = (status & 0x10) != 0;
        this.overflowFlag = (status & 0x40) != 0;
        this.signFlag = (status & 0x80) != 0;
    }

    protected final int pop() {
        return this.memory[++this.sp & 0xFF | 0x100] & 0xFF;
    }

    protected final void push(int data) {
        this.memory[this.sp-- & 0xFF | 0x100] = (byte)data;
    }

    protected int readByte(int adr) {
        return this.memory[adr] & 0xFF;
    }

    protected void writeByte(int adr, int data) {
        this.memory[adr] = (byte)data;
    }

    public int copyBytesToMemory(byte[] bytes, int address) {
        int address_ = address < 1 ? (bytes[0] & 0xFF) + (bytes[1] & 0xFF) * 256 : address;
        int to = bytes.length;
        for (int i = 2; i < to; ++i) {
            this.memory[address_++] = bytes[i];
        }
        return address_;
    }

    protected final void operationADC(int data) {
        int tmp;
        int ac_ = this.ac;
        if (this.decimalFlag) {
            tmp = 10 * (ac_ & 0xF0) + (ac_ & 0xF) + (10 * (data & 0xF0) + (data & 0xF));
            tmp = (tmp / 10 << 4) + tmp % 10;
        } else {
            tmp = data + ac_ + (this.carryFlag ? 1 : 0);
            this.overflowFlag = ((ac_ ^ data) & 0x80) == 0 && ((ac_ ^ tmp) & 0x80) != 0;
        }
        this.carryFlag = tmp > 255;
        ac_ = this.ac = tmp & 0xFF;
        this.zeroFlag = ac_ == 0;
        this.signFlag = ac_ >= 128;
    }

    protected final void operationAND(int data) {
        int ac_ = this.ac &= data;
        this.zeroFlag = ac_ == 0;
        this.signFlag = ac_ >= 128;
    }

    protected final void operationASL(int adr) {
        int data = this.readByte(adr);
        this.carryFlag = data >= 128;
        data = data << 1 & 0xFF;
        this.writeByte(adr, data);
        this.zeroFlag = data == 0;
        this.signFlag = data >= 128;
    }

    protected final void operationBIT(int data) {
        this.signFlag = data >= 128;
        this.overflowFlag = (data & 0x40) > 0;
        this.zeroFlag = (this.ac & data) == 0;
    }

    protected final void operationCLI() {
        this.interruptFlag = false;
        this.isCheckInterrupt = true;
    }

    protected final void operationCMP(int data) {
        int ac_ = this.ac;
        this.carryFlag = ac_ >= data;
        this.zeroFlag = ac_ == data;
        this.signFlag = (ac_ - data & 0xFF) >= 128;
    }

    protected final void operationCPX(int data) {
        int x_ = this.x;
        this.carryFlag = x_ >= data;
        this.zeroFlag = x_ == data;
        this.signFlag = (x_ - data & 0xFF) >= 128;
    }

    protected final void operationCPY(int data) {
        int y_ = this.y;
        this.carryFlag = y_ >= data;
        this.zeroFlag = y_ == data;
        this.signFlag = (y_ - data & 0xFF) >= 128;
    }

    protected final void operationDEC(int adr) {
        int data = this.readByte(adr) - 1 & 0xFF;
        this.writeByte(adr, data);
        this.zeroFlag = data == 0;
        this.signFlag = data >= 128;
    }

    protected final void operationEOR(int data) {
        int ac_ = this.ac ^= data;
        this.zeroFlag = ac_ == 0;
        this.signFlag = ac_ >= 128;
    }

    protected final void operationINC(int adr) {
        int data = this.readByte(adr) + 1 & 0xFF;
        this.writeByte(adr, data);
        this.zeroFlag = data == 0;
        this.signFlag = data >= 128;
    }

    protected final void operationJSR(int address) {
        int pcMinus1 = this.pc - 1;
        this.push((pcMinus1 & 0xFF00) >> 8);
        this.push(pcMinus1 & 0xFF);
        this.setPC(address);
    }

    protected final void operationLDA(int data) {
        this.ac = data;
        int ac_ = this.ac;
        this.zeroFlag = ac_ == 0;
        this.signFlag = ac_ >= 128;
    }

    protected final void operationLDX(int data) {
        this.x = data;
        int x_ = this.x;
        this.zeroFlag = x_ == 0;
        this.signFlag = x_ >= 128;
    }

    protected final void operationLDY(int data) {
        this.y = data;
        int y_ = this.y;
        this.zeroFlag = y_ == 0;
        this.signFlag = y_ >= 128;
    }

    protected final void operationLSR(int adr) {
        int data = this.readByte(adr);
        this.carryFlag = (data & 1) != 0;
        this.writeByte(adr, data >>= 1);
        this.zeroFlag = data == 0;
        this.signFlag = false;
    }

    protected final void operationLSRAccumulator() {
        this.carryFlag = (this.ac & 1) != 0;
        this.ac >>= 1;
        this.zeroFlag = this.ac == 0;
        this.signFlag = false;
    }

    protected final void operationORA(int data) {
        int ac_ = this.ac |= data;
        this.zeroFlag = ac_ == 0;
        this.signFlag = ac_ >= 128;
    }

    protected final void operationROL(int adr) {
        this.writeByte(adr, this.executeROL(this.readByte(adr)));
    }

    private int executeROL(int data) {
        int data_ = data << 1;
        if (this.carryFlag) {
            ++data_;
        }
        this.carryFlag = data_ >= 256;
        this.zeroFlag = (data_ &= 0xFF) == 0;
        this.signFlag = data_ >= 128;
        return data_;
    }

    protected final void operationROR(int adr) {
        this.writeByte(adr, this.executeROR(this.readByte(adr)));
    }

    private int executeROR(int data) {
        int data_ = data;
        if (this.carryFlag) {
            data_ |= 0x100;
        }
        this.carryFlag = (data_ & 1) != 0;
        this.zeroFlag = (data_ >>= 1) == 0;
        this.signFlag = data_ >= 128;
        return (byte)data_;
    }

    protected final void operationSBC(int data) {
        int tmp;
        int ac_ = this.ac;
        if (this.decimalFlag) {
            tmp = 10 * (ac_ & 0xF0) + (ac_ & 0xF) - (10 * (data & 0xF0) + (data & 0xF));
            tmp = (tmp / 10 << 4) + tmp % 10;
        } else {
            tmp = ac_ - data - (this.carryFlag ? 0 : 1);
        }
        this.overflowFlag = ((ac_ ^ tmp) & 0x80) != 0 && ((ac_ ^ data) & 0x80) != 0;
        this.carryFlag = tmp >= 0;
        ac_ = this.ac = tmp & 0xFF;
        this.zeroFlag = ac_ == 0;
        this.signFlag = ac_ >= 128;
    }

    protected final void operationTSX() {
        this.x = this.sp & 0xFF;
        int x_ = this.x;
        this.zeroFlag = x_ == 0;
        this.signFlag = x_ >= 128;
    }

    public final void serviceIRQorNMI() {
        if (this.isNMILow && !this.lastNMIState) {
            this.cycles += 7L;
            this.serviceInterrupt(65530);
        } else if (this.isIRQLow) {
            if (!this.interruptFlag) {
                this.cycles += 7L;
                this.serviceInterrupt(65534);
            }
            this.isCheckInterrupt = false;
        }
        this.lastNMIState = this.isNMILow;
    }

    public final void serviceInterrupt(int adr) {
        this.push((this.pc & 0xFF00) >> 8);
        this.push(this.pc & 0xFF);
        this.push(this.getStatusByte());
        this.setPC((this.readByte(adr + 1) << 8) + this.readByte(adr));
        this.interruptFlag = true;
    }

    protected final int getOperand(CPU6502Instruction instruction) {
        return instruction.addressMode == 1 ? this.memory[this.currentInstructionAddress + 1] & 0xFF : this.readByte(this.getOperandAddress(instruction));
    }

    protected final int getOperandAddress(CPU6502Instruction instruction) {
        switch (instruction.addressMode) {
            case 9: {
                return this.memory[this.currentInstructionAddress + 1] & 0xFF;
            }
            case 10: {
                return (this.memory[this.currentInstructionAddress + 1] & 0xFF) + this.x & 0xFF;
            }
            case 11: {
                return (this.memory[this.currentInstructionAddress + 1] & 0xFF) + this.y & 0xFF;
            }
            case 6: {
                byte[] memory_ = this.memory;
                int currentInstructionAddress_ = this.currentInstructionAddress;
                int lowAddress = memory_[currentInstructionAddress_ + 1] & 0xFF;
                int highAddress = (memory_[currentInstructionAddress_ + 2] & 0xFF) << 8;
                return this.readByte(highAddress + lowAddress) + (this.readByte(highAddress + (lowAddress + 1 & 0xFF)) << 8);
            }
            case 7: {
                byte[] memory_ = this.memory;
                int p = (memory_[this.currentInstructionAddress + 1] & 0xFF) + this.x & 0xFF;
                return (memory_[p] & 0xFF) + ((memory_[p + 1 & 0xFF] & 0xFF) << 8);
            }
            case 8: {
                byte[] memory_ = this.memory;
                int p = memory_[this.currentInstructionAddress + 1] & 0xFF;
                int lowAddress = (memory_[p] & 0xFF) + this.y;
                if (instruction.addPageBoundaryCycle && lowAddress > 255) {
                    ++this.cycles;
                }
                return lowAddress + ((memory_[p + 1 & 0xFF] & 0xFF) << 8) & 0xFFFF;
            }
            case 12: {
                int address = this.memory[this.currentInstructionAddress + 1] + this.pc;
                this.cycles += (this.pc & 0xFF00) != (address & 0xFF00) ? 2L : 1L;
                return address;
            }
            case 3: {
                byte[] memory_ = this.memory;
                int currentInstructionAddress_ = this.currentInstructionAddress;
                return (memory_[currentInstructionAddress_ + 1] & 0xFF) + ((memory_[currentInstructionAddress_ + 2] & 0xFF) << 8);
            }
            case 4: 
            case 5: {
                byte[] memory_ = this.memory;
                int currentInstructionAddress_ = this.currentInstructionAddress;
                int lowAddress = (memory_[currentInstructionAddress_ + 1] & 0xFF) + (instruction.addressMode == 5 ? this.y : this.x);
                if (instruction.addPageBoundaryCycle && lowAddress > 255) {
                    ++this.cycles;
                }
                return lowAddress + ((memory_[currentInstructionAddress_ + 2] & 0xFF) << 8) & 0xFFFF;
            }
        }
        throw new RuntimeException("Illegal address mode for instruction " + instruction.toString() + " ($" + Integer.toHexString(instruction.opCode) + ")");
    }

    protected final String disassemble(CPU6502Instruction instruction) {
        String result = instruction.toString();
        int opStart = result.indexOf("OPERAND");
        if (opStart > 0) {
            int n;
            int address = -1;
            long oldCycles = this.cycles;
            switch (instruction.addressMode) {
                case 1: {
                    n = this.getOperand(instruction);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    address = this.getOperandAddress(instruction);
                    n = (this.memory[this.currentInstructionAddress + 1] & 0xFF) + ((this.memory[this.currentInstructionAddress + 2] & 0xFF) << 8);
                    break;
                }
                case 7: 
                case 8: 
                case 10: 
                case 11: {
                    address = this.getOperandAddress(instruction);
                    n = this.memory[this.currentInstructionAddress + 1] & 0xFF;
                    break;
                }
                case 12: {
                    n = this.getOperandAddress(instruction);
                    break;
                }
                default: {
                    n = this.getOperandAddress(instruction);
                }
            }
            this.cycles = oldCycles;
            result = result.substring(0, opStart) + Integer.toHexString(n) + result.substring(opStart + "OPERAND".length()) + (address >= 0 ? " ; $" + Integer.toHexString(address) : "");
        }
        return result;
    }

    public Vector getStackTrace() {
        int adr;
        Vector<Integer> result = new Vector<Integer>();
        for (int s = this.sp + 1 & 0xFF | 0x100; s > 256 && s < 511 && (adr = (this.memory[s] & 0xFF) + (this.memory[s + 1] & 0xFF) * 256) != 0; s += 2) {
            result.addElement(new Integer(adr - 2 & 0xFFFF));
        }
        return result;
    }

    public final void run(long toCycle) {
        super.run();
        byte[] memory_ = this.memory;
        CPU6502Instruction[] instructions_ = this.instructions;
        while (this.isRunning && this.cycles < toCycle) {
            while (!this.isPaused && this.cycles < toCycle) {
                if (this.isCheckInterrupt) {
                    this.serviceIRQorNMI();
                }
                int currentInstructionAddress_ = this.currentInstructionAddress = this.getPC();
                CPU6502Instruction instruction = instructions_[memory_[currentInstructionAddress_] & 0xFF];
                this.cycles += (long)instruction.cycles;
                this.addPC(instruction.size);
                switch (instruction.opGroup) {
                    case 0: {
                        this.operationADC(this.getOperand(instruction));
                        break;
                    }
                    case 1: {
                        this.operationAND(this.getOperand(instruction));
                        break;
                    }
                    case 2: {
                        int ac_;
                        if (instruction.addressMode == 2) {
                            this.carryFlag = this.ac >= 128;
                            ac_ = this.ac = this.ac << 1 & 0xFF;
                            this.zeroFlag = ac_ == 0;
                            this.signFlag = ac_ >= 128;
                            break;
                        }
                        this.operationASL(this.getOperandAddress(instruction));
                        break;
                    }
                    case 3: {
                        if (this.carryFlag) break;
                        this.setPC(this.getOperandAddress(instruction));
                        break;
                    }
                    case 4: {
                        if (!this.carryFlag) break;
                        this.setPC(this.getOperandAddress(instruction));
                        break;
                    }
                    case 5: {
                        if (!this.zeroFlag) break;
                        this.setPC(this.getOperandAddress(instruction));
                        break;
                    }
                    case 6: {
                        this.operationBIT(this.getOperand(instruction));
                        break;
                    }
                    case 7: {
                        if (!this.signFlag) break;
                        this.setPC(this.getOperandAddress(instruction));
                        break;
                    }
                    case 8: {
                        if (this.zeroFlag) break;
                        this.setPC(this.getOperandAddress(instruction));
                        break;
                    }
                    case 9: {
                        if (this.signFlag) break;
                        this.setPC(this.getOperandAddress(instruction));
                        break;
                    }
                    case 10: {
                        this.addPC(1);
                        this.serviceInterrupt(65534);
                        this.breakFlag = true;
                        break;
                    }
                    case 11: {
                        if (this.overflowFlag) break;
                        this.setPC(this.getOperandAddress(instruction));
                        break;
                    }
                    case 12: {
                        if (!this.overflowFlag) break;
                        this.setPC(this.getOperandAddress(instruction));
                        break;
                    }
                    case 13: {
                        this.carryFlag = false;
                        break;
                    }
                    case 16: {
                        this.overflowFlag = false;
                        break;
                    }
                    case 14: {
                        this.decimalFlag = false;
                        break;
                    }
                    case 15: {
                        this.operationCLI();
                        break;
                    }
                    case 17: {
                        this.operationCMP(this.getOperand(instruction));
                        break;
                    }
                    case 18: {
                        this.operationCPX(this.getOperand(instruction));
                        break;
                    }
                    case 19: {
                        this.operationCPY(this.getOperand(instruction));
                        break;
                    }
                    case 20: {
                        this.operationDEC(this.getOperandAddress(instruction));
                        break;
                    }
                    case 21: {
                        int x_ = this.x = this.x - 1 & 0xFF;
                        this.zeroFlag = x_ == 0;
                        this.signFlag = x_ >= 128;
                        break;
                    }
                    case 22: {
                        int y_ = this.y = this.y - 1 & 0xFF;
                        this.zeroFlag = y_ == 0;
                        this.signFlag = y_ >= 128;
                        break;
                    }
                    case 23: {
                        this.operationEOR(this.getOperand(instruction));
                        break;
                    }
                    case 24: {
                        this.operationINC(this.getOperandAddress(instruction));
                        break;
                    }
                    case 25: {
                        int x_ = this.x = this.x + 1 & 0xFF;
                        this.zeroFlag = x_ == 0;
                        this.signFlag = x_ >= 128;
                        break;
                    }
                    case 26: {
                        int y_ = this.y = this.y + 1 & 0xFF;
                        this.zeroFlag = y_ == 0;
                        this.signFlag = y_ >= 128;
                        break;
                    }
                    case 27: {
                        this.setPC(this.getOperandAddress(instruction));
                        break;
                    }
                    case 28: {
                        this.operationJSR(this.getOperandAddress(instruction));
                        break;
                    }
                    case 29: {
                        this.operationLDA(this.getOperand(instruction));
                        break;
                    }
                    case 30: {
                        this.operationLDX(this.getOperand(instruction));
                        break;
                    }
                    case 31: {
                        this.operationLDY(this.getOperand(instruction));
                        break;
                    }
                    case 32: {
                        if (instruction.addressMode == 2) {
                            this.operationLSRAccumulator();
                            break;
                        }
                        this.operationLSR(this.getOperandAddress(instruction));
                        break;
                    }
                    case 33: {
                        break;
                    }
                    case 34: {
                        this.operationORA(this.getOperand(instruction));
                        break;
                    }
                    case 35: {
                        this.push(this.ac);
                        break;
                    }
                    case 36: {
                        this.breakFlag = true;
                        this.push(this.getStatusByte());
                        this.breakFlag = false;
                        break;
                    }
                    case 37: {
                        int ac_ = this.ac = this.pop();
                        this.zeroFlag = ac_ == 0;
                        this.signFlag = ac_ >= 128;
                        break;
                    }
                    case 38: {
                        this.setStatusByte(this.pop());
                        this.breakFlag = false;
                        this.isCheckInterrupt = true;
                        break;
                    }
                    case 42: {
                        this.setPC(this.pop() + (this.pop() << 8) + 1);
                        break;
                    }
                    case 41: {
                        this.setStatusByte(this.pop());
                        this.setPC(this.pop() + (this.pop() << 8));
                        this.breakFlag = false;
                        this.isCheckInterrupt = true;
                        break;
                    }
                    case 39: {
                        if (instruction.addressMode == 2) {
                            this.ac = this.executeROL(this.ac);
                            break;
                        }
                        this.operationROL(this.getOperandAddress(instruction));
                        break;
                    }
                    case 40: {
                        if (instruction.addressMode == 2) {
                            this.ac = this.executeROR(this.ac);
                            break;
                        }
                        this.operationROR(this.getOperandAddress(instruction));
                        break;
                    }
                    case 43: {
                        this.operationSBC(this.getOperand(instruction));
                        break;
                    }
                    case 44: {
                        this.carryFlag = true;
                        break;
                    }
                    case 45: {
                        this.decimalFlag = true;
                        break;
                    }
                    case 46: {
                        this.interruptFlag = true;
                        break;
                    }
                    case 47: {
                        this.writeByte(this.getOperandAddress(instruction), this.ac);
                        break;
                    }
                    case 48: {
                        this.writeByte(this.getOperandAddress(instruction), this.x);
                        break;
                    }
                    case 49: {
                        this.writeByte(this.getOperandAddress(instruction), this.y);
                        break;
                    }
                    case 52: {
                        this.operationTSX();
                        break;
                    }
                    case 54: {
                        this.sp = this.x;
                        break;
                    }
                    case 53: {
                        int ac_ = this.ac = this.x;
                        this.zeroFlag = ac_ == 0;
                        this.signFlag = ac_ >= 128;
                        break;
                    }
                    case 50: {
                        int x_ = this.x = this.ac;
                        this.zeroFlag = x_ == 0;
                        this.signFlag = x_ >= 128;
                        break;
                    }
                    case 55: {
                        int ac_ = this.ac = this.y;
                        this.zeroFlag = ac_ == 0;
                        this.signFlag = ac_ >= 128;
                        break;
                    }
                    case 51: {
                        int y_ = this.y = this.ac;
                        this.zeroFlag = y_ == 0;
                        this.signFlag = y_ >= 128;
                        break;
                    }
                    case 101: {
                        this.operationAND(this.getOperand(instruction));
                        this.operationLSRAccumulator();
                        break;
                    }
                    case 100: {
                        this.operationAND(this.getOperand(instruction));
                        this.carryFlag = (this.ac & 0x80) != 0;
                        break;
                    }
                    case 102: {
                        this.operationAND(this.getOperand(instruction));
                        this.ac = this.executeROR(this.ac);
                        break;
                    }
                    case 103: {
                        int address = this.getOperandAddress(instruction);
                        this.operationASL(address);
                        this.operationORA(this.readByte(address));
                        break;
                    }
                    case 104: {
                        int adr2 = this.getOperandAddress(instruction);
                        this.writeByte(adr2, this.ac & this.x & (adr2 >> 8) + 1);
                        break;
                    }
                    case 105: {
                        this.writeByte(this.getOperandAddress(instruction), this.ac & this.x);
                        break;
                    }
                    case 106: {
                        int address = this.getOperandAddress(instruction);
                        this.operationDEC(address);
                        this.operationCMP(this.readByte(address));
                        break;
                    }
                    case 107: {
                        int address = this.getOperandAddress(instruction);
                        this.operationINC(address);
                        this.operationSBC(this.readByte(address));
                        break;
                    }
                    case 108: {
                        if (null == this.getLogger()) break;
                        this.getLogger().warning("Not implemented instruction at $" + Integer.toHexString(this.currentInstructionAddress) + ": $" + Integer.toHexString(this.memory[this.currentInstructionAddress] & 0xFF));
                        break;
                    }
                    case 109: {
                        this.ac = this.getOperand(instruction);
                        this.operationLDX(this.ac);
                        break;
                    }
                    case 110: {
                        int address = this.getOperandAddress(instruction);
                        this.operationLSR(address);
                        this.operationEOR(this.readByte(address));
                        break;
                    }
                    case 111: {
                        this.ac |= 0xEE;
                        this.ac &= this.getOperand(instruction);
                        this.x = this.ac;
                        this.zeroFlag = this.ac == 0;
                        this.signFlag = this.ac >= 128;
                        break;
                    }
                    case 112: {
                        int address = this.getOperandAddress(instruction);
                        this.operationROL(address);
                        this.operationAND(this.readByte(address));
                        break;
                    }
                    case 113: {
                        int address = this.getOperandAddress(instruction);
                        this.operationROR(address);
                        this.operationADC(this.readByte(address));
                        break;
                    }
                    case 115: {
                        this.x = (this.ac & this.x) - this.getOperand(instruction);
                        this.carryFlag = this.x >= 0;
                        this.x &= 0xFF;
                        this.zeroFlag = this.x == 0;
                        this.signFlag = this.x >= 128;
                        break;
                    }
                    case 114: {
                        int oldAc = this.ac;
                        this.ac = this.y;
                        this.operationAND(this.readByte(120));
                        this.writeByte(this.getOperandAddress(instruction), this.ac);
                        this.ac = oldAc;
                        break;
                    }
                    case 116: {
                        this.getOperand(instruction);
                        break;
                    }
                    case 117: {
                        this.getOperand(instruction);
                        if (instruction.addressMode != 7) break;
                        this.addPC(1);
                        break;
                    }
                    case 118: {
                        int address = this.getOperandAddress(instruction);
                        this.sp = this.ac & this.x;
                        this.writeByte(address, this.sp & (address >> 8) + 1);
                        break;
                    }
                    case 119: {
                        this.ac = this.readByte(this.pc - 1) & this.x & (this.ac | 0xEE);
                        this.zeroFlag = this.ac == 0;
                        this.signFlag = this.ac >= 128;
                        break;
                    }
                    case 120: {
                        int oldAc = this.ac;
                        this.ac = this.x;
                        this.operationAND(this.readByte(101));
                        this.writeByte(this.getOperandAddress(instruction), this.ac);
                        this.ac = oldAc;
                        break;
                    }
                    default: {
                        this.emulateExtendedInstruction(instruction);
                    }
                }
                this.checkIOChips();
            }
        }
    }

    protected void emulateExtendedInstruction(CPU6502Instruction instruction) {
        if (null != this.getLogger()) {
            this.getLogger().warning("Not implemented instruction at $" + Integer.toHexString(this.currentInstructionAddress) + ": $" + Integer.toHexString(this.memory[this.currentInstructionAddress] & 0xFF));
        }
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reset() {
        this.signFlag = false;
        this.zeroFlag = false;
        this.overflowFlag = false;
        this.carryFlag = false;
        this.decimalFlag = false;
        this.breakFlag = false;
        this.interruptFlag = false;
        this.isCheckInterrupt = false;
        this.isNMILow = false;
        this.lastNMIState = false;
        this.isIRQLow = false;
        this.irqs.removeAllElements();
        this.nmis.removeAllElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadROM(String resource, int startMem, int len) {
        if (null != this.getLogger()) {
            this.getLogger().info("Reading ROM: " + resource);
        }
        InputStream is = this.device.resourceLoader.getResource(resource);
        try {
            for (int i = 0; i < len; ++i) {
                int b = is.read();
                if (b == -1) {
                    throw new Exception("Unexpected end of ROM file!");
                }
                this.memory[startMem + i] = (byte)b;
            }
            if (null != this.getLogger()) {
                this.getLogger().info("Installed ROM at $" + Integer.toHexString(startMem) + ", " + len + " bytes read.");
            }
        }
        catch (Exception e) {
            if (null != this.getLogger()) {
                this.getLogger().warning("Problem reading ROM file " + resource + ": " + e + "!");
            }
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {}
        }
    }

    protected int getStartAddress() {
        return this.readByte(65532) + (this.readByte(65533) << 8);
    }

    protected abstract void checkIOChips();

    public final void throttle(long ms) {
        this.throttledMillis += ms;
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public final long getThrottledTime() {
        return this.throttledMillis;
    }

    public final void resetThrottleTime() {
        this.throttledMillis = 0L;
    }

    public void serialize(DataOutputStream out) throws IOException {
        out.writeInt(this.ramSize);
        for (int i = 0; i < this.ramSize; ++i) {
            out.writeByte(this.memory[i]);
        }
        out.writeBoolean(this.isNMILow);
        out.writeBoolean(this.lastNMIState);
        out.writeBoolean(this.isIRQLow);
        out.writeBoolean(this.isCheckInterrupt);
        out.writeLong(this.cycles);
        out.writeInt(this.pc);
        out.writeInt(this.currentInstructionAddress);
        out.writeBoolean(this.signFlag);
        out.writeBoolean(this.zeroFlag);
        out.writeBoolean(this.overflowFlag);
        out.writeBoolean(this.carryFlag);
        out.writeBoolean(this.decimalFlag);
        out.writeBoolean(this.breakFlag);
        out.writeBoolean(this.interruptFlag);
        out.writeInt(this.ac);
        out.writeInt(this.x);
        out.writeInt(this.y);
        out.writeInt(this.sp);
    }

    public void deserialize(DataInputStream in) throws IOException {
        this.ramSize = in.readInt();
        for (int i = 0; i < this.ramSize; ++i) {
            this.memory[i] = in.readByte();
        }
        this.isNMILow = in.readBoolean();
        this.lastNMIState = in.readBoolean();
        this.isIRQLow = in.readBoolean();
        this.isCheckInterrupt = in.readBoolean();
        this.cycles = in.readLong();
        this.pc = in.readInt();
        this.currentInstructionAddress = in.readInt();
        this.signFlag = in.readBoolean();
        this.zeroFlag = in.readBoolean();
        this.overflowFlag = in.readBoolean();
        this.carryFlag = in.readBoolean();
        this.decimalFlag = in.readBoolean();
        this.breakFlag = in.readBoolean();
        this.interruptFlag = in.readBoolean();
        this.ac = in.readInt();
        this.x = in.readInt();
        this.y = in.readInt();
        this.sp = in.readInt();
    }
}

