/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.core;

public class CPU6502Instruction {
    public static final int IMPLIED = 0;
    public static final int IMMEDIATE = 1;
    public static final int ACCUMULATOR = 2;
    public static final int ABSOLUTE = 3;
    public static final int ABSOLUTE_X = 4;
    public static final int ABSOLUTE_Y = 5;
    public static final int INDIRECT = 6;
    public static final int INDIRECT_X = 7;
    public static final int INDIRECT_Y = 8;
    public static final int ZERO = 9;
    public static final int ZERO_X = 10;
    public static final int ZERO_Y = 11;
    public static final int RELATIVE = 12;
    public static final String OPERAND_ID = "OPERAND";
    public final String name;
    public final int opCode;
    public final int opGroup;
    public final int addressMode;
    public final int cycles;
    public final int size;
    public final boolean addPageBoundaryCycle;

    public CPU6502Instruction(String name, int opCode, int opGroup, int addressMode, int cycles, boolean addPageBoundaryCycle) {
        this.name = name;
        this.opCode = opCode;
        this.opGroup = opGroup;
        this.addressMode = addressMode;
        this.cycles = cycles;
        this.size = addressMode == 0 || addressMode == 2 ? 1 : (addressMode == 3 || addressMode == 4 || addressMode == 5 || addressMode == 6 ? 3 : 2);
        this.addPageBoundaryCycle = addPageBoundaryCycle;
    }

    public CPU6502Instruction(String name, int opCode, int opGroup, int addressMode, int cycles) {
        this(name, opCode, opGroup, addressMode, cycles, false);
    }

    public CPU6502Instruction(CPU6502Instruction instruction, int opCode) {
        this.name = instruction.name;
        this.opCode = opCode;
        this.opGroup = instruction.opGroup;
        this.addressMode = instruction.addressMode;
        this.cycles = instruction.cycles;
        this.size = instruction.size;
        this.addPageBoundaryCycle = instruction.addPageBoundaryCycle;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.name);
        switch (this.addressMode) {
            case 3: 
            case 12: {
                result.append(" $OPERAND");
                break;
            }
            case 4: {
                result.append(" $OPERAND,X");
                break;
            }
            case 5: {
                result.append(" $OPERAND,Y");
                break;
            }
            case 1: {
                result.append(" #$OPERAND");
                break;
            }
            case 9: {
                result.append(" *$OPERAND");
                break;
            }
            case 10: {
                result.append(" *$OPERAND,X");
                break;
            }
            case 11: {
                result.append(" *$OPERAND,Y");
                break;
            }
            case 6: {
                result.append(" (OPERAND)");
                break;
            }
            case 7: {
                result.append(" (OPERAND,X)");
                break;
            }
            case 8: {
                result.append(" (OPERAND),Y");
                break;
            }
        }
        return result.toString();
    }
}

