/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.core;

import de.joergjahnke.c64.core.EmulatedDevice;
import de.joergjahnke.c64.core.EmulatedIECBusDevice;
import de.joergjahnke.common.io.Serializable;
import de.joergjahnke.common.util.DefaultObservable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public class IECBus
extends DefaultObservable
implements Serializable {
    private static final boolean DEBUG = false;
    public static final Integer ATN = new Integer(1);
    public static final Integer CLK = new Integer(2);
    public static final Integer DATA = new Integer(3);
    public static final Integer SIGNAL_ATN = new Integer(1);
    public static final Integer SIGNAL_CONTROLLER_FLAG_MODIFIED = new Integer(2);
    private final EmulatedDevice controller;
    private final Vector devices = new Vector();
    private final Vector deviceStates = new Vector();
    private final DeviceState controllerState = new DeviceState();

    public IECBus(EmulatedDevice controller) {
        this.controller = controller;
    }

    public void reset() {
        Integer[] signals = new Integer[]{ATN, CLK, DATA};
        for (int i = 0; i < signals.length; ++i) {
            this.controllerState.setSignal(signals[i], false);
            for (int j = 0; j < this.deviceStates.size(); ++j) {
                DeviceState deviceState = (DeviceState)this.deviceStates.elementAt(j);
                deviceState.setSignal(signals[j], false);
            }
        }
    }

    public EmulatedDevice getController() {
        return this.controller;
    }

    public void addDevice(EmulatedIECBusDevice device) {
        this.devices.addElement(device);
        this.deviceStates.addElement(new DeviceState());
    }

    public void removeDevice(EmulatedIECBusDevice device) {
        int index = this.devices.indexOf(device);
        this.devices.removeElementAt(index);
        this.deviceStates.removeElementAt(index);
    }

    public boolean getSignal(Object flag) {
        return this.getDevicesSignal(flag) | this.controllerState.getSignal(flag);
    }

    private boolean getDevicesSignal(Object flag) {
        Vector deviceStates_ = this.deviceStates;
        int to = deviceStates_.size();
        for (int i = 0; i < to; ++i) {
            if (!((DeviceState)deviceStates_.elementAt(i)).getSignal(flag)) continue;
            return true;
        }
        return false;
    }

    private DeviceState getState(EmulatedDevice device) {
        return device == this.controller ? this.controllerState : (DeviceState)this.deviceStates.elementAt(this.devices.indexOf(device));
    }

    public boolean getSignal(EmulatedDevice device, Object flag) {
        DeviceState deviceState = this.getState(device);
        return deviceState.getSignal(flag);
    }

    public boolean setSignal(EmulatedDevice device, Object flag, boolean state) {
        DeviceState deviceState = this.getState(device);
        boolean oldState = this.getSignal(device, flag);
        deviceState.setSignal(flag, state);
        if (state != oldState) {
            if (device == this.controller) {
                if (flag == ATN && state) {
                    int to = this.devices.size();
                    for (int i = 0; i < to; ++i) {
                        EmulatedIECBusDevice attachedDevice = (EmulatedIECBusDevice)this.devices.elementAt(i);
                        if (attachedDevice.getCPU().getCycles() == 0L) {
                            attachedDevice.run();
                            attachedDevice.synchronizeWithDevice(this.controller);
                            continue;
                        }
                        if (attachedDevice.isRunning()) continue;
                        attachedDevice.synchronizeWithDevice(this.controller);
                    }
                    this.setChanged(true);
                    this.notifyObservers(SIGNAL_ATN);
                } else {
                    this.setChanged(true);
                    this.notifyObservers(SIGNAL_CONTROLLER_FLAG_MODIFIED);
                }
            } else if (device instanceof EmulatedIECBusDevice) {
                ((EmulatedIECBusDevice)device).markActive();
            }
            return true;
        }
        return false;
    }

    public void serialize(DataOutputStream out) throws IOException {
        out.writeInt(this.devices.size());
        for (int i = 0; i < this.devices.size(); ++i) {
            EmulatedDevice device = (EmulatedDevice)this.devices.elementAt(i);
            DeviceState state = (DeviceState)this.deviceStates.elementAt(i);
            out.writeUTF(device.getName());
            state.serialize(out);
        }
        this.controllerState.serialize(out);
    }

    public void deserialize(DataInputStream in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String name = in.readUTF();
            boolean found = false;
            for (int j = 0; !found && j < this.devices.size(); ++j) {
                EmulatedDevice device = (EmulatedDevice)this.devices.elementAt(j);
                DeviceState state = new DeviceState();
                state.deserialize(in);
                if (!device.getName().equals(name)) continue;
                this.deviceStates.setElementAt(state, j);
                found = true;
            }
            if (found) continue;
            throw new IOException("Could not read " + this.getClass().getName() + " from stream!");
        }
        this.controllerState.deserialize(in);
    }

    class DeviceState
    implements Serializable {
        public final Vector states = new Vector();

        DeviceState() {
        }

        public boolean getSignal(Object flag) {
            return this.states.contains(flag);
        }

        public void setSignal(Object flag, boolean state) {
            if (state) {
                if (!this.getSignal(flag)) {
                    this.states.addElement(flag);
                }
            } else {
                this.states.removeElement(flag);
            }
        }

        public void serialize(DataOutputStream out) throws IOException {
            out.writeInt(this.states.size());
            for (int i = 0; i < this.states.size(); ++i) {
                out.writeInt((Integer)this.states.elementAt(i));
            }
        }

        public void deserialize(DataInputStream in) throws IOException {
            int size = in.readInt();
            this.states.removeAllElements();
            for (int i = 0; i < size; ++i) {
                int state = in.readInt();
                if (state == ATN) {
                    this.states.addElement(ATN);
                    continue;
                }
                if (state == CLK) {
                    this.states.addElement(CLK);
                    continue;
                }
                if (state == DATA) {
                    this.states.addElement(DATA);
                    continue;
                }
                throw new IOException("Could not read " + this.getClass().getName() + " from stream!");
            }
        }
    }
}

