/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.core;

import de.joergjahnke.c64.core.VIC6569;
import de.joergjahnke.common.io.Serializable;
import de.joergjahnke.common.io.SerializationUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Sprite
implements Serializable {
    private int x;
    private int y;
    private boolean isEnabled;
    private boolean isMultiColor = false;
    private boolean isExpandX = false;
    private boolean isExpandY = false;
    private boolean hasPriority = false;
    private int[] colors = new int[4];
    private boolean isPainting = false;
    private int pointer;
    private int lastPointer;
    private int lineData;
    private int bitRead;
    private int nextByte;
    private boolean isFirstYRead = true;
    protected boolean needsCharCacheRefresh = false;
    private final VIC6569 vic;

    public Sprite(VIC6569 vic) {
        this.vic = vic;
    }

    public final int getX() {
        return this.x;
    }

    public final void setX(int x) {
        if (this.isEnabled && this.x != x) {
            this.needsCharCacheRefresh = true;
        }
        this.x = x;
    }

    public final int getY() {
        return this.y;
    }

    public final void setY(int y) {
        if (this.isEnabled && this.y != y) {
            this.needsCharCacheRefresh = true;
        }
        this.y = y;
    }

    public final boolean hasPriority() {
        return this.hasPriority;
    }

    public final void setPriority(boolean hasPriority) {
        if (this.isEnabled && this.hasPriority != hasPriority) {
            this.needsCharCacheRefresh = true;
        }
        this.hasPriority = hasPriority;
    }

    public final int getColor(int n) {
        return this.colors[n];
    }

    public final void setColor(int n, int c) {
        this.colors[n] = c;
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setEnabled(boolean enabled) {
        if (this.isEnabled != enabled) {
            this.needsCharCacheRefresh = true;
        }
        this.isEnabled = enabled;
    }

    public final boolean isExpandX() {
        return this.isExpandX;
    }

    public final void setExpandX(boolean expandX) {
        if (this.isEnabled && this.isExpandX != expandX) {
            this.needsCharCacheRefresh = true;
            if (!this.isLineFinished()) {
                this.bitRead = expandX ? (this.bitRead <<= 1) : (this.bitRead >>= 1);
            }
        }
        this.isExpandX = expandX;
    }

    public final boolean isExpandY() {
        return this.isExpandY;
    }

    public final void setExpandY(boolean expandY) {
        if (this.isEnabled && this.isExpandY != expandY) {
            this.needsCharCacheRefresh = true;
        }
        this.isExpandY = expandY;
    }

    public final boolean isMulticolor() {
        return this.isMultiColor;
    }

    public final void setMulticolor(boolean multicolor) {
        this.isMultiColor = multicolor;
    }

    public final boolean isLineFinished() {
        return this.bitRead <= 0;
    }

    public final boolean isPainting() {
        return this.isPainting;
    }

    public final void setPainting(boolean painting) {
        if (!painting) {
            this.needsCharCacheRefresh = false;
        }
        this.isPainting = painting;
    }

    public final boolean isBeyondLastByte() {
        return this.nextByte >= 63;
    }

    public final void initUpdate() {
        this.nextByte = 0;
        this.isPainting = false;
        this.lineData = 0;
    }

    public final void initPainting() {
        this.nextByte = 0;
        this.isPainting = true;
        this.isFirstYRead = true;
    }

    public final void setDataPointer(int pointer) {
        this.pointer = pointer;
    }

    public final void readLineData() {
        VIC6569 vic_ = this.vic;
        int nextByte_ = this.nextByte;
        int pointer_ = this.pointer;
        this.lineData = (vic_.readByte(pointer_ + nextByte_) & 0xFF) << 16 | (vic_.readByte(pointer_ + nextByte_ + 1) & 0xFF) << 8 | vic_.readByte(pointer_ + nextByte_ + 2) & 0xFF;
        if (this.isExpandY) {
            if (!this.isFirstYRead) {
                this.nextByte += 3;
            }
            this.isFirstYRead ^= true;
        } else {
            this.nextByte += 3;
        }
        if (pointer_ != this.lastPointer) {
            this.needsCharCacheRefresh = true;
            this.lastPointer = pointer_;
        }
        this.bitRead = this.isExpandX ? 48 : 24;
    }

    public final int getNextPixel() {
        int shift;
        if (this.isLineFinished()) {
            return 0;
        }
        --this.bitRead;
        int n = shift = this.isExpandX ? this.bitRead >> 1 : this.bitRead;
        if (this.isMultiColor) {
            return this.lineData >> (shift & 0xFE) & 3;
        }
        return (this.lineData >> shift & 1) << 1;
    }

    public void serialize(DataOutputStream out) throws IOException {
        out.writeInt(this.x);
        out.writeInt(this.y);
        out.writeBoolean(this.hasPriority);
        out.writeBoolean(this.isEnabled);
        out.writeBoolean(this.isExpandX);
        out.writeBoolean(this.isExpandY);
        out.writeBoolean(this.isFirstYRead);
        out.writeBoolean(this.isMultiColor);
        out.writeBoolean(this.isPainting);
        out.writeBoolean(this.needsCharCacheRefresh);
        SerializationUtils.serialize(out, this.colors);
        out.writeInt(this.bitRead);
        out.writeInt(this.lastPointer);
        out.writeInt(this.lineData);
        out.writeInt(this.nextByte);
        out.writeInt(this.pointer);
    }

    public void deserialize(DataInputStream in) throws IOException {
        this.x = in.readInt();
        this.y = in.readInt();
        this.hasPriority = in.readBoolean();
        this.isEnabled = in.readBoolean();
        this.isExpandX = in.readBoolean();
        this.isExpandY = in.readBoolean();
        this.isFirstYRead = in.readBoolean();
        this.isMultiColor = in.readBoolean();
        this.isPainting = in.readBoolean();
        this.needsCharCacheRefresh = in.readBoolean();
        SerializationUtils.deserialize(in, this.colors);
        this.bitRead = in.readInt();
        this.lastPointer = in.readInt();
        this.lineData = in.readInt();
        this.nextByte = in.readInt();
        this.pointer = in.readInt();
    }
}

