/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.common.jme;

public class MathUtils {
    private static final int DOUBLE_MANTISSE_SIZE = 52;

    public static double ln(double x) {
        return MathUtils.log2(x) / MathUtils.log2(Math.E);
    }

    public static double log10(double x) {
        return MathUtils.log2(x) / MathUtils.log2(10.0);
    }

    public static double log2(double x) {
        if (x <= 0.0) {
            throw new IllegalArgumentException("Argument for logarithm function must be > 0!");
        }
        double result = 0.0;
        int mult = 1;
        while (x < 0.5 || x > 2.0) {
            x = Math.sqrt(x);
            mult *= 2;
        }
        while (x < 1.0) {
            x *= 2.0;
            result -= 1.0;
        }
        double add = 0.5;
        for (int i = 0; i < 52; ++i) {
            if ((x *= x) >= 2.0) {
                x /= 2.0;
                result += add;
            }
            add /= 2.0;
        }
        return result * (double)mult;
    }
}

