/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.common.jme;

import de.joergjahnke.common.jme.LocalizationSupport;
import de.joergjahnke.common.jme.OrientationSensitiveCanvasHelper;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.midlet.MIDlet;

public class OrientationSensitiveCanvas
extends GameCanvas {
    protected final Display display;
    private boolean isAutoChangeOrientation = false;
    protected int transform = 0;
    private boolean useAccelerometer = false;
    private Object sensorUtils = null;

    protected OrientationSensitiveCanvas(MIDlet midlet) {
        super(false);
        this.display = Display.getDisplay((MIDlet)midlet);
    }

    public boolean isAutoChangeOrientation() {
        return this.isAutoChangeOrientation;
    }

    public boolean isUseAccelerometer() {
        return this.useAccelerometer;
    }

    public Object getSensorUtils() {
        if (null == this.sensorUtils) {
            this.sensorUtils = new OrientationSensitiveCanvasHelper(this);
        }
        return this.sensorUtils;
    }

    public void setAutoChangeOrientation(boolean isAutoChangeOrientation) {
        if (isAutoChangeOrientation != this.isAutoChangeOrientation) {
            this.isAutoChangeOrientation = isAutoChangeOrientation;
            if (isAutoChangeOrientation && !this.useAccelerometer) {
                this.activateAccelerometer();
            } else if (!this.useAccelerometer) {
                ((OrientationSensitiveCanvasHelper)this.getSensorUtils()).deactivateAccelerometer();
            }
        }
    }

    public void setUseAccelerometer(boolean useAccelerometer) {
        if (useAccelerometer != this.useAccelerometer) {
            this.useAccelerometer = useAccelerometer;
            if (useAccelerometer && !this.isAutoChangeOrientation) {
                this.activateAccelerometer();
            } else if (!this.isAutoChangeOrientation) {
                ((OrientationSensitiveCanvasHelper)this.getSensorUtils()).deactivateAccelerometer();
            }
        }
    }

    private void activateAccelerometer() {
        try {
            ((OrientationSensitiveCanvasHelper)this.getSensorUtils()).activateAccelerometer();
        }
        catch (Exception e) {
            this.isAutoChangeOrientation = false;
            this.useAccelerometer = false;
            this.display.setCurrent((Displayable)new Alert(LocalizationSupport.getMessage("CouldNotActivateAccelerometer"), LocalizationSupport.getMessage("ErrorWas") + e.getMessage(), null, AlertType.WARNING));
        }
    }

    public void onDeviceRotated() {
    }

    public void onAccelerometerChange(double x, double y, double z) {
    }
}

