/*
 * Decompiled with CFR 0.152.
 */
import org.jpc.emulator.PC;
import org.jpc.emulator.pci.peripheral.VGACard;
import org.jpc.emulator.peripheral.Keyboard;
import org.jpc.emulator.processor.ModeSwitchException;
import org.jpc.j2se.KeyMapping;
import org.jpc.j2se.VirtualClock;

public class PCThread
extends Thread {
    private PC pc;
    private long instructionCount;
    private boolean isPaused = false;
    private boolean running = true;
    private PCScreen screen;
    private Keyboard keyboard;

    PCThread(PCScreen pCScreen) {
        this.screen = pCScreen;
        this.instructionCount = 0L;
        this.setPriority(2);
    }

    public void setPaused(boolean bl) {
        this.isPaused = false;
    }

    public void stopPC() {
        this.running = false;
    }

    public void fireArrowKeyUp() {
        this.keyboard.putKeyboardEvent((byte)-32);
        this.keyboard.putKeyboardEvent((byte)72);
        this.keyboard.putKeyboardEvent((byte)-32);
        this.keyboard.putKeyboardEvent((byte)-56);
    }

    public void fireArrowKeyDown() {
        this.keyboard.putKeyboardEvent((byte)-32);
        this.keyboard.putKeyboardEvent((byte)80);
        this.keyboard.putKeyboardEvent((byte)-32);
        this.keyboard.putKeyboardEvent((byte)-48);
    }

    public void fireArrowKeyLeft() {
        this.keyboard.putKeyboardEvent((byte)-32);
        this.keyboard.putKeyboardEvent((byte)75);
        this.keyboard.putKeyboardEvent((byte)-32);
        this.keyboard.putKeyboardEvent((byte)-53);
    }

    public void fireArrowKeyRight() {
        this.keyboard.putKeyboardEvent((byte)-32);
        this.keyboard.putKeyboardEvent((byte)77);
        this.keyboard.putKeyboardEvent((byte)-32);
        this.keyboard.putKeyboardEvent((byte)-51);
    }

    public void fireChar(char c) {
        byte[] byArray = (byte[])KeyMapping.keyTable.get(new Character(c));
        if (byArray == null) {
            System.err.println("Non Mapped Character: '" + c + "'");
        }
        for (int i = 0; i < byArray.length; ++i) {
            this.keyboard.putKeyboardEvent(byArray[i]);
        }
    }

    public void fireString(String string) {
        for (int i = 0; i < string.length(); ++i) {
            this.fireChar(string.charAt(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.screen.repaint();
            this.screen.setDiagnostic("Started");
            String[] stringArray = new String[]{"-fda", "rms:floppy.img", "-boot", "fda"};
            this.screen.setDiagnostic("Creating PC");
            this.pc = PC.createPC(stringArray, new VirtualClock());
            this.keyboard = this.pc.getKeyboard();
            this.screen.setDiagnostic("PC Created");
            Updater updater = new Updater();
            updater.setPriority(7);
            updater.start();
            this.screen.setDiagnostic("Started Updater");
            this.pc.getSystemClock().resume();
            this.screen.setDiagnostic("");
            long l = 0L;
            while (this.running) {
                try {
                    while (this.running) {
                        if ((l += (long)this.pc.executeRealMode()) < 10000L) continue;
                        this.screen.setInstructionCount(l);
                        l = 0L;
                    }
                }
                catch (ModeSwitchException modeSwitchException) {
                    // empty catch block
                }
                try {
                    while (this.running) {
                        if ((l += (long)this.pc.executeProtectedMode()) < 50000L) continue;
                        this.screen.setInstructionCount(l);
                        l = 0L;
                    }
                }
                catch (ModeSwitchException modeSwitchException) {
                }
            }
        }
        catch (Throwable throwable) {
            this.screen.setDiagnostic(throwable.toString());
            throwable.printStackTrace();
        }
        finally {
            this.stopPC();
            this.pc.getSystemClock().pause();
            this.screen.setDiagnostic("HALTED");
            System.out.println("Processor Halted - PC Thread exited");
        }
    }

    class Updater
    extends Thread {
        Updater() {
        }

        public void run() {
            VGACard vGACard = PCThread.this.pc.getGraphicsCard();
            while (PCThread.this.running) {
                try {
                    Thread.sleep(50L);
                    PCThread.this.screen.prepareUpdate();
                    vGACard.updateDisplay(PCThread.this.screen);
                    PCThread.this.screen.blitUpdatesToScreen();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Throwable throwable) {
                    System.err.println("Warning: error in video display update " + throwable);
                    throwable.printStackTrace();
                }
            }
        }
    }
}

